/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.effect;

import com.sun.javafx.effect.EffectDirtyBits;
import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.scene.BoundsAccessor;
import com.sun.javafx.tk.Toolkit;
import com.sun.scenario.effect.Flood;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.scene.Node;
import javafx.scene.effect.Effect;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class ColorInput
extends Effect {
    private ObjectProperty<Paint> paint;
    private DoubleProperty x;
    private DoubleProperty y;
    private DoubleProperty width;
    private DoubleProperty height;

    public ColorInput() {
    }

    public ColorInput(double x, double y, double width, double height, Paint paint) {
        this.setX(x);
        this.setY(y);
        this.setWidth(width);
        this.setHeight(height);
        this.setPaint(paint);
    }

    @Override
    Flood createPeer() {
        return new Flood(Toolkit.getPaintAccessor().getPlatformPaint(Color.RED));
    }

    public final void setPaint(Paint value) {
        this.paintProperty().set((Object)value);
    }

    public final Paint getPaint() {
        return this.paint == null ? Color.RED : (Paint)this.paint.get();
    }

    public final ObjectProperty<Paint> paintProperty() {
        if (this.paint == null) {
            this.paint = new ObjectPropertyBase<Paint>((Paint)Color.RED){

                public void invalidated() {
                    ColorInput.this.markDirty(EffectDirtyBits.EFFECT_DIRTY);
                }

                public Object getBean() {
                    return ColorInput.this;
                }

                public String getName() {
                    return "paint";
                }
            };
        }
        return this.paint;
    }

    public final void setX(double value) {
        this.xProperty().set(value);
    }

    public final double getX() {
        return this.x == null ? 0.0 : this.x.get();
    }

    public final DoubleProperty xProperty() {
        if (this.x == null) {
            this.x = new DoublePropertyBase(){

                public void invalidated() {
                    ColorInput.this.markDirty(EffectDirtyBits.EFFECT_DIRTY);
                    ColorInput.this.effectBoundsChanged();
                }

                public Object getBean() {
                    return ColorInput.this;
                }

                public String getName() {
                    return "x";
                }
            };
        }
        return this.x;
    }

    public final void setY(double value) {
        this.yProperty().set(value);
    }

    public final double getY() {
        return this.y == null ? 0.0 : this.y.get();
    }

    public final DoubleProperty yProperty() {
        if (this.y == null) {
            this.y = new DoublePropertyBase(){

                public void invalidated() {
                    ColorInput.this.markDirty(EffectDirtyBits.EFFECT_DIRTY);
                    ColorInput.this.effectBoundsChanged();
                }

                public Object getBean() {
                    return ColorInput.this;
                }

                public String getName() {
                    return "y";
                }
            };
        }
        return this.y;
    }

    public final void setWidth(double value) {
        this.widthProperty().set(value);
    }

    public final double getWidth() {
        return this.width == null ? 0.0 : this.width.get();
    }

    public final DoubleProperty widthProperty() {
        if (this.width == null) {
            this.width = new DoublePropertyBase(){

                public void invalidated() {
                    ColorInput.this.markDirty(EffectDirtyBits.EFFECT_DIRTY);
                    ColorInput.this.effectBoundsChanged();
                }

                public Object getBean() {
                    return ColorInput.this;
                }

                public String getName() {
                    return "width";
                }
            };
        }
        return this.width;
    }

    public final void setHeight(double value) {
        this.heightProperty().set(value);
    }

    public final double getHeight() {
        return this.height == null ? 0.0 : this.height.get();
    }

    public final DoubleProperty heightProperty() {
        if (this.height == null) {
            this.height = new DoublePropertyBase(){

                public void invalidated() {
                    ColorInput.this.markDirty(EffectDirtyBits.EFFECT_DIRTY);
                    ColorInput.this.effectBoundsChanged();
                }

                public Object getBean() {
                    return ColorInput.this;
                }

                public String getName() {
                    return "height";
                }
            };
        }
        return this.height;
    }

    private Paint getPaintInternal() {
        Paint p = this.getPaint();
        return p == null ? Color.RED : p;
    }

    @Override
    void update() {
        Flood peer = (Flood)this.getPeer();
        peer.setPaint(Toolkit.getPaintAccessor().getPlatformPaint(this.getPaintInternal()));
        peer.setFloodBounds(new RectBounds((float)this.getX(), (float)this.getY(), (float)(this.getX() + this.getWidth()), (float)(this.getY() + this.getHeight())));
    }

    @Override
    boolean checkChainContains(Effect e) {
        return false;
    }

    @Override
    BaseBounds getBounds(BaseBounds bounds, BaseTransform tx, Node node, BoundsAccessor boundsAccessor) {
        RectBounds ret = new RectBounds((float)this.getX(), (float)this.getY(), (float)(this.getX() + this.getWidth()), (float)(this.getY() + this.getHeight()));
        return ColorInput.transformBounds(tx, ret);
    }

    @Override
    Effect copy() {
        return new ColorInput(this.getX(), this.getY(), this.getWidth(), this.getHeight(), this.getPaint());
    }
}

