/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.effect;

import com.sun.javafx.effect.EffectDirtyBits;
import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.scene.BoundsAccessor;
import com.sun.scenario.effect.Blend;
import com.sun.scenario.effect.EffectHelper;
import javafx.beans.Observable;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.effect.Blend;
import javafx.scene.effect.BlendMode;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.EffectChangeListener;

public abstract class Effect {
    private com.sun.scenario.effect.Effect peer;
    private IntegerProperty effectDirty = new SimpleIntegerProperty((Object)this, "effectDirty");

    protected Effect() {
        this.markDirty(EffectDirtyBits.EFFECT_DIRTY);
    }

    void effectBoundsChanged() {
        this.toggleDirty(EffectDirtyBits.BOUNDS_CHANGED);
    }

    abstract com.sun.scenario.effect.Effect createPeer();

    com.sun.scenario.effect.Effect getPeer() {
        if (this.peer == null) {
            this.peer = this.createPeer();
        }
        return this.peer;
    }

    private void setEffectDirty(int value) {
        this.effectDirtyProperty().set(value);
    }

    private final IntegerProperty effectDirtyProperty() {
        return this.effectDirty;
    }

    private final boolean isEffectDirty() {
        return this.isEffectDirty(EffectDirtyBits.EFFECT_DIRTY);
    }

    final void markDirty(EffectDirtyBits dirtyBit) {
        this.setEffectDirty(this.effectDirty.get() | dirtyBit.getMask());
    }

    private void toggleDirty(EffectDirtyBits dirtyBit) {
        this.setEffectDirty(this.effectDirty.get() ^ dirtyBit.getMask());
    }

    private boolean isEffectDirty(EffectDirtyBits dirtyBit) {
        return (this.effectDirty.get() & dirtyBit.getMask()) != 0;
    }

    private void clearEffectDirty(EffectDirtyBits dirtyBit) {
        this.setEffectDirty(this.effectDirty.get() & ~dirtyBit.getMask());
    }

    final void sync() {
        if (this.isEffectDirty(EffectDirtyBits.EFFECT_DIRTY)) {
            this.update();
            this.clearEffectDirty(EffectDirtyBits.EFFECT_DIRTY);
        }
    }

    abstract void update();

    abstract boolean checkChainContains(Effect var1);

    boolean containsCycles(Effect value) {
        return value != null && (value == this || value.checkChainContains(this));
    }

    abstract BaseBounds getBounds(BaseBounds var1, BaseTransform var2, Node var3, BoundsAccessor var4);

    abstract Effect copy();

    static BaseBounds transformBounds(BaseTransform tx, BaseBounds r) {
        if (tx == null || tx.isIdentity()) {
            return r;
        }
        BaseBounds ret = new RectBounds();
        ret = tx.transform(r, ret);
        return ret;
    }

    static int getKernelSize(float fsize, int iterations) {
        int ksize = (int)Math.ceil(fsize);
        if (ksize < 1) {
            ksize = 1;
        }
        ksize = (ksize - 1) * iterations + 1;
        return (ksize |= 1) / 2;
    }

    static BaseBounds getShadowBounds(BaseBounds bounds, BaseTransform tx, float width, float height, BlurType blurType) {
        int hgrow = 0;
        int vgrow = 0;
        switch (blurType) {
            case GAUSSIAN: {
                float hradius = width < 1.0f ? 0.0f : (width - 1.0f) / 2.0f;
                float vradius = height < 1.0f ? 0.0f : (height - 1.0f) / 2.0f;
                hgrow = (int)Math.ceil(hradius);
                vgrow = (int)Math.ceil(vradius);
                break;
            }
            case ONE_PASS_BOX: {
                hgrow = Effect.getKernelSize(Math.round(width / 3.0f), 1);
                vgrow = Effect.getKernelSize(Math.round(height / 3.0f), 1);
                break;
            }
            case TWO_PASS_BOX: {
                hgrow = Effect.getKernelSize(Math.round(width / 3.0f), 2);
                vgrow = Effect.getKernelSize(Math.round(height / 3.0f), 2);
                break;
            }
            case THREE_PASS_BOX: {
                hgrow = Effect.getKernelSize(Math.round(width / 3.0f), 3);
                vgrow = Effect.getKernelSize(Math.round(height / 3.0f), 3);
            }
        }
        bounds = bounds.deriveWithPadding(hgrow, vgrow, 0.0f);
        return Effect.transformBounds(tx, bounds);
    }

    static BaseBounds getInputBounds(BaseBounds bounds, BaseTransform tx, Node node, BoundsAccessor boundsAccessor, Effect input) {
        bounds = input != null ? input.getBounds(bounds, tx, node, boundsAccessor) : boundsAccessor.getGeomBounds(bounds, tx, node);
        return bounds;
    }

    static {
        EffectHelper.setEffectAccessor(new EffectHelper.EffectAccessor(){

            @Override
            public com.sun.scenario.effect.Effect getPeer(Effect effect) {
                return effect.getPeer();
            }

            @Override
            public void sync(Effect effect) {
                effect.sync();
            }

            @Override
            public IntegerProperty effectDirtyProperty(Effect effect) {
                return effect.effectDirtyProperty();
            }

            @Override
            public boolean isEffectDirty(Effect effect) {
                return effect.isEffectDirty();
            }

            @Override
            public BaseBounds getBounds(Effect effect, BaseBounds bounds, BaseTransform tx, Node node, BoundsAccessor boundsAccessor) {
                return effect.getBounds(bounds, tx, node, boundsAccessor);
            }

            @Override
            public Effect copy(Effect effect) {
                return effect.copy();
            }

            @Override
            public Blend.Mode getToolkitBlendMode(BlendMode mode) {
                return Blend.getToolkitMode(mode);
            }
        });
    }

    class EffectInputProperty
    extends ObjectPropertyBase<Effect> {
        private final String propertyName;
        private Effect validInput = null;
        private final EffectInputChangeListener effectChangeListener = new EffectInputChangeListener();

        public EffectInputProperty(String propertyName) {
            this.propertyName = propertyName;
        }

        public void invalidated() {
            Effect newInput = (Effect)super.get();
            if (Effect.this.containsCycles(newInput)) {
                if (this.isBound()) {
                    this.unbind();
                    this.set(this.validInput);
                    throw new IllegalArgumentException("Cycle in effect chain detected, binding was set to incorrect value, unbinding the input property");
                }
                this.set(this.validInput);
                throw new IllegalArgumentException("Cycle in effect chain detected");
            }
            this.validInput = newInput;
            this.effectChangeListener.register(newInput);
            Effect.this.markDirty(EffectDirtyBits.EFFECT_DIRTY);
            Effect.this.effectBoundsChanged();
        }

        public Object getBean() {
            return Effect.this;
        }

        public String getName() {
            return this.propertyName;
        }
    }

    class EffectInputChangeListener
    extends EffectChangeListener {
        private int oldBits;

        EffectInputChangeListener() {
        }

        public void register(Effect value) {
            super.register((ObservableValue)(value == null ? null : value.effectDirtyProperty()));
            if (value != null) {
                this.oldBits = value.effectDirtyProperty().get();
            }
        }

        public void invalidated(Observable valueModel) {
            int newBits = ((IntegerProperty)valueModel).get();
            int dirtyBits = newBits ^ this.oldBits;
            this.oldBits = newBits;
            if (EffectDirtyBits.isSet(dirtyBits, EffectDirtyBits.EFFECT_DIRTY) && EffectDirtyBits.isSet(newBits, EffectDirtyBits.EFFECT_DIRTY)) {
                Effect.this.markDirty(EffectDirtyBits.EFFECT_DIRTY);
            }
            if (EffectDirtyBits.isSet(dirtyBits, EffectDirtyBits.BOUNDS_CHANGED)) {
                Effect.this.toggleDirty(EffectDirtyBits.BOUNDS_CHANGED);
            }
        }
    }
}

