/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.effect;

import com.sun.javafx.tk.Toolkit;
import com.sun.javafx.util.Utils;
import com.sun.scenario.effect.light.DistantLight;
import com.sun.scenario.effect.light.PointLight;
import com.sun.scenario.effect.light.SpotLight;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.scene.paint.Color;

public abstract class Light {
    private com.sun.scenario.effect.light.Light peer;
    private ObjectProperty<Color> color;
    private BooleanProperty effectDirty;

    protected Light() {
        this.markDirty();
    }

    abstract com.sun.scenario.effect.light.Light createPeer();

    com.sun.scenario.effect.light.Light getPeer() {
        if (this.peer == null) {
            this.peer = this.createPeer();
        }
        return this.peer;
    }

    public final void setColor(Color value) {
        this.colorProperty().set((Object)value);
    }

    public final Color getColor() {
        return this.color == null ? Color.WHITE : (Color)this.color.get();
    }

    public final ObjectProperty<Color> colorProperty() {
        if (this.color == null) {
            this.color = new ObjectPropertyBase<Color>(Color.WHITE){

                public void invalidated() {
                    Light.this.markDirty();
                }

                public Object getBean() {
                    return Light.this;
                }

                public String getName() {
                    return "color";
                }
            };
        }
        return this.color;
    }

    void sync() {
        if (this.isEffectDirty()) {
            this.update();
            this.clearDirty();
        }
    }

    private Color getColorInternal() {
        Color c = this.getColor();
        return c == null ? Color.WHITE : c;
    }

    void update() {
        this.getPeer().setColor(Toolkit.getToolkit().toColor4f(this.getColorInternal()));
    }

    private void setEffectDirty(boolean value) {
        this.effectDirtyProperty().set(value);
    }

    final BooleanProperty effectDirtyProperty() {
        if (this.effectDirty == null) {
            this.effectDirty = new SimpleBooleanProperty((Object)this, "effectDirty");
        }
        return this.effectDirty;
    }

    boolean isEffectDirty() {
        return this.effectDirty == null ? false : this.effectDirty.get();
    }

    final void markDirty() {
        this.setEffectDirty(true);
    }

    final void clearDirty() {
        this.setEffectDirty(false);
    }

    public static class Spot
    extends Point {
        private DoubleProperty pointsAtX;
        private DoubleProperty pointsAtY;
        private DoubleProperty pointsAtZ;
        private DoubleProperty specularExponent;

        public Spot() {
        }

        public Spot(double x, double y, double z, double specularExponent, Color color) {
            this.setX(x);
            this.setY(y);
            this.setZ(z);
            this.setSpecularExponent(specularExponent);
            this.setColor(color);
        }

        @Override
        SpotLight createPeer() {
            return new SpotLight();
        }

        public final void setPointsAtX(double value) {
            this.pointsAtXProperty().set(value);
        }

        public final double getPointsAtX() {
            return this.pointsAtX == null ? 0.0 : this.pointsAtX.get();
        }

        public final DoubleProperty pointsAtXProperty() {
            if (this.pointsAtX == null) {
                this.pointsAtX = new DoublePropertyBase(){

                    public void invalidated() {
                        this.markDirty();
                    }

                    public Object getBean() {
                        return this;
                    }

                    public String getName() {
                        return "pointsAtX";
                    }
                };
            }
            return this.pointsAtX;
        }

        public final void setPointsAtY(double value) {
            this.pointsAtYProperty().set(value);
        }

        public final double getPointsAtY() {
            return this.pointsAtY == null ? 0.0 : this.pointsAtY.get();
        }

        public final DoubleProperty pointsAtYProperty() {
            if (this.pointsAtY == null) {
                this.pointsAtY = new DoublePropertyBase(){

                    public void invalidated() {
                        this.markDirty();
                    }

                    public Object getBean() {
                        return this;
                    }

                    public String getName() {
                        return "pointsAtY";
                    }
                };
            }
            return this.pointsAtY;
        }

        public final void setPointsAtZ(double value) {
            this.pointsAtZProperty().set(value);
        }

        public final double getPointsAtZ() {
            return this.pointsAtZ == null ? 0.0 : this.pointsAtZ.get();
        }

        public final DoubleProperty pointsAtZProperty() {
            if (this.pointsAtZ == null) {
                this.pointsAtZ = new DoublePropertyBase(){

                    public void invalidated() {
                        this.markDirty();
                    }

                    public Object getBean() {
                        return this;
                    }

                    public String getName() {
                        return "pointsAtZ";
                    }
                };
            }
            return this.pointsAtZ;
        }

        public final void setSpecularExponent(double value) {
            this.specularExponentProperty().set(value);
        }

        public final double getSpecularExponent() {
            return this.specularExponent == null ? 1.0 : this.specularExponent.get();
        }

        public final DoubleProperty specularExponentProperty() {
            if (this.specularExponent == null) {
                this.specularExponent = new DoublePropertyBase(1.0){

                    public void invalidated() {
                        this.markDirty();
                    }

                    public Object getBean() {
                        return this;
                    }

                    public String getName() {
                        return "specularExponent";
                    }
                };
            }
            return this.specularExponent;
        }

        @Override
        void update() {
            super.update();
            SpotLight peer = (SpotLight)this.getPeer();
            peer.setPointsAtX((float)this.getPointsAtX());
            peer.setPointsAtY((float)this.getPointsAtY());
            peer.setPointsAtZ((float)this.getPointsAtZ());
            peer.setSpecularExponent((float)Utils.clamp(0.0, this.getSpecularExponent(), 4.0));
        }
    }

    public static class Point
    extends Light {
        private DoubleProperty x;
        private DoubleProperty y;
        private DoubleProperty z;

        public Point() {
        }

        public Point(double x, double y, double z, Color color) {
            this.setX(x);
            this.setY(y);
            this.setZ(z);
            this.setColor(color);
        }

        @Override
        PointLight createPeer() {
            return new PointLight();
        }

        public final void setX(double value) {
            this.xProperty().set(value);
        }

        public final double getX() {
            return this.x == null ? 0.0 : this.x.get();
        }

        public final DoubleProperty xProperty() {
            if (this.x == null) {
                this.x = new DoublePropertyBase(){

                    public void invalidated() {
                        this.markDirty();
                    }

                    public Object getBean() {
                        return this;
                    }

                    public String getName() {
                        return "x";
                    }
                };
            }
            return this.x;
        }

        public final void setY(double value) {
            this.yProperty().set(value);
        }

        public final double getY() {
            return this.y == null ? 0.0 : this.y.get();
        }

        public final DoubleProperty yProperty() {
            if (this.y == null) {
                this.y = new DoublePropertyBase(){

                    public void invalidated() {
                        this.markDirty();
                    }

                    public Object getBean() {
                        return this;
                    }

                    public String getName() {
                        return "y";
                    }
                };
            }
            return this.y;
        }

        public final void setZ(double value) {
            this.zProperty().set(value);
        }

        public final double getZ() {
            return this.z == null ? 0.0 : this.z.get();
        }

        public final DoubleProperty zProperty() {
            if (this.z == null) {
                this.z = new DoublePropertyBase(){

                    public void invalidated() {
                        this.markDirty();
                    }

                    public Object getBean() {
                        return this;
                    }

                    public String getName() {
                        return "z";
                    }
                };
            }
            return this.z;
        }

        @Override
        void update() {
            super.update();
            PointLight peer = (PointLight)this.getPeer();
            peer.setX((float)this.getX());
            peer.setY((float)this.getY());
            peer.setZ((float)this.getZ());
        }
    }

    public static class Distant
    extends Light {
        private DoubleProperty azimuth;
        private DoubleProperty elevation;

        public Distant() {
        }

        public Distant(double azimuth, double elevation, Color color) {
            this.setAzimuth(azimuth);
            this.setElevation(elevation);
            this.setColor(color);
        }

        @Override
        DistantLight createPeer() {
            return new DistantLight();
        }

        public final void setAzimuth(double value) {
            this.azimuthProperty().set(value);
        }

        public final double getAzimuth() {
            return this.azimuth == null ? 45.0 : this.azimuth.get();
        }

        public final DoubleProperty azimuthProperty() {
            if (this.azimuth == null) {
                this.azimuth = new DoublePropertyBase(45.0){

                    public void invalidated() {
                        this.markDirty();
                    }

                    public Object getBean() {
                        return this;
                    }

                    public String getName() {
                        return "azimuth";
                    }
                };
            }
            return this.azimuth;
        }

        public final void setElevation(double value) {
            this.elevationProperty().set(value);
        }

        public final double getElevation() {
            return this.elevation == null ? 45.0 : this.elevation.get();
        }

        public final DoubleProperty elevationProperty() {
            if (this.elevation == null) {
                this.elevation = new DoublePropertyBase(45.0){

                    public void invalidated() {
                        this.markDirty();
                    }

                    public Object getBean() {
                        return this;
                    }

                    public String getName() {
                        return "elevation";
                    }
                };
            }
            return this.elevation;
        }

        @Override
        void update() {
            super.update();
            DistantLight peer = (DistantLight)this.getPeer();
            peer.setAzimuth((float)this.getAzimuth());
            peer.setElevation((float)this.getElevation());
        }
    }
}

