/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.effect;

import com.sun.javafx.effect.EffectDirtyBits;
import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.scene.BoundsAccessor;
import com.sun.javafx.util.Utils;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.scene.Node;
import javafx.scene.effect.Effect;

public class MotionBlur
extends Effect {
    private ObjectProperty<Effect> input;
    private DoubleProperty radius;
    private DoubleProperty angle;

    public MotionBlur() {
    }

    public MotionBlur(double angle, double radius) {
        this.setAngle(angle);
        this.setRadius(radius);
    }

    @Override
    com.sun.scenario.effect.MotionBlur createPeer() {
        return new com.sun.scenario.effect.MotionBlur();
    }

    public final void setInput(Effect value) {
        this.inputProperty().set((Object)value);
    }

    public final Effect getInput() {
        return this.input == null ? null : (Effect)this.input.get();
    }

    public final ObjectProperty<Effect> inputProperty() {
        if (this.input == null) {
            this.input = new Effect.EffectInputProperty("input");
        }
        return this.input;
    }

    @Override
    boolean checkChainContains(Effect e) {
        Effect localInput = this.getInput();
        if (localInput == null) {
            return false;
        }
        if (localInput == e) {
            return true;
        }
        return localInput.checkChainContains(e);
    }

    public final void setRadius(double value) {
        this.radiusProperty().set(value);
    }

    public final double getRadius() {
        return this.radius == null ? 10.0 : this.radius.get();
    }

    public final DoubleProperty radiusProperty() {
        if (this.radius == null) {
            this.radius = new DoublePropertyBase(10.0){

                public void invalidated() {
                    MotionBlur.this.markDirty(EffectDirtyBits.EFFECT_DIRTY);
                    MotionBlur.this.effectBoundsChanged();
                }

                public Object getBean() {
                    return MotionBlur.this;
                }

                public String getName() {
                    return "radius";
                }
            };
        }
        return this.radius;
    }

    public final void setAngle(double value) {
        this.angleProperty().set(value);
    }

    public final double getAngle() {
        return this.angle == null ? 0.0 : this.angle.get();
    }

    public final DoubleProperty angleProperty() {
        if (this.angle == null) {
            this.angle = new DoublePropertyBase(){

                public void invalidated() {
                    MotionBlur.this.markDirty(EffectDirtyBits.EFFECT_DIRTY);
                    MotionBlur.this.effectBoundsChanged();
                }

                public Object getBean() {
                    return MotionBlur.this;
                }

                public String getName() {
                    return "angle";
                }
            };
        }
        return this.angle;
    }

    private float getClampedRadius() {
        return (float)Utils.clamp(0.0, this.getRadius(), 63.0);
    }

    @Override
    void update() {
        Effect localInput = this.getInput();
        if (localInput != null) {
            localInput.sync();
        }
        com.sun.scenario.effect.MotionBlur peer = (com.sun.scenario.effect.MotionBlur)this.getPeer();
        peer.setInput(localInput == null ? null : localInput.getPeer());
        peer.setRadius(this.getClampedRadius());
        peer.setAngle((float)Math.toRadians(this.getAngle()));
    }

    private int getHPad() {
        return (int)Math.ceil(Math.abs(Math.cos(Math.toRadians(this.getAngle()))) * (double)this.getClampedRadius());
    }

    private int getVPad() {
        return (int)Math.ceil(Math.abs(Math.sin(Math.toRadians(this.getAngle()))) * (double)this.getClampedRadius());
    }

    @Override
    BaseBounds getBounds(BaseBounds bounds, BaseTransform tx, Node node, BoundsAccessor boundsAccessor) {
        bounds = MotionBlur.getInputBounds(bounds, BaseTransform.IDENTITY_TRANSFORM, node, boundsAccessor, this.getInput());
        int hpad = this.getHPad();
        int vpad = this.getVPad();
        bounds = bounds.deriveWithPadding(hpad, vpad, 0.0f);
        return MotionBlur.transformBounds(tx, bounds);
    }

    @Override
    Effect copy() {
        MotionBlur mb = new MotionBlur(this.getAngle(), this.getRadius());
        mb.setInput(mb.getInput());
        return mb;
    }
}

