/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.input;

import com.sun.javafx.scene.input.InputEventUtils;
import com.sun.javafx.tk.Toolkit;
import java.io.IOException;
import java.io.ObjectInputStream;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.geometry.Point3D;
import javafx.scene.input.InputEvent;
import javafx.scene.input.PickResult;

public class GestureEvent
extends InputEvent {
    private static final long serialVersionUID = 20121107L;
    public static final EventType<GestureEvent> ANY = new EventType(InputEvent.ANY, "GESTURE");
    private transient double x;
    private transient double y;
    private transient double z;
    private final double screenX;
    private final double screenY;
    private final double sceneX;
    private final double sceneY;
    private final boolean shiftDown;
    private final boolean controlDown;
    private final boolean altDown;
    private final boolean metaDown;
    private final boolean direct;
    private final boolean inertia;
    private PickResult pickResult;

    @Deprecated(since="8")
    protected GestureEvent(EventType<? extends GestureEvent> eventType) {
        this(eventType, 0.0, 0.0, 0.0, 0.0, false, false, false, false, false, false, null);
    }

    @Deprecated(since="8")
    protected GestureEvent(Object source, EventTarget target, EventType<? extends GestureEvent> eventType) {
        super(source, target, eventType);
        this.sceneY = 0.0;
        this.sceneX = 0.0;
        this.screenY = 0.0;
        this.screenX = 0.0;
        this.y = 0.0;
        this.x = 0.0;
        this.inertia = false;
        this.direct = false;
        this.metaDown = false;
        this.altDown = false;
        this.controlDown = false;
        this.shiftDown = false;
    }

    protected GestureEvent(Object source, EventTarget target, EventType<? extends GestureEvent> eventType, double x, double y, double screenX, double screenY, boolean shiftDown, boolean controlDown, boolean altDown, boolean metaDown, boolean direct, boolean inertia, PickResult pickResult) {
        super(source, target, eventType);
        this.x = x;
        this.y = y;
        this.screenX = screenX;
        this.screenY = screenY;
        this.sceneX = x;
        this.sceneY = y;
        this.shiftDown = shiftDown;
        this.controlDown = controlDown;
        this.altDown = altDown;
        this.metaDown = metaDown;
        this.direct = direct;
        this.inertia = inertia;
        this.pickResult = pickResult != null ? pickResult : new PickResult(target, x, y);
        Point3D p = InputEventUtils.recomputeCoordinates(this.pickResult, null);
        this.x = p.getX();
        this.y = p.getY();
        this.z = p.getZ();
    }

    protected GestureEvent(EventType<? extends GestureEvent> eventType, double x, double y, double screenX, double screenY, boolean shiftDown, boolean controlDown, boolean altDown, boolean metaDown, boolean direct, boolean inertia, PickResult pickResult) {
        this(null, null, eventType, x, y, screenX, screenY, shiftDown, controlDown, altDown, metaDown, direct, inertia, pickResult);
    }

    private void recomputeCoordinatesToSource(GestureEvent newEvent, Object newSource) {
        Point3D newCoordinates = InputEventUtils.recomputeCoordinates(this.pickResult, newSource);
        newEvent.x = newCoordinates.getX();
        newEvent.y = newCoordinates.getY();
        newEvent.z = newCoordinates.getZ();
    }

    public GestureEvent copyFor(Object newSource, EventTarget newTarget) {
        GestureEvent e = (GestureEvent)super.copyFor(newSource, newTarget);
        this.recomputeCoordinatesToSource(e, newSource);
        return e;
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final double getZ() {
        return this.z;
    }

    public final double getScreenX() {
        return this.screenX;
    }

    public final double getScreenY() {
        return this.screenY;
    }

    public final double getSceneX() {
        return this.sceneX;
    }

    public final double getSceneY() {
        return this.sceneY;
    }

    public final boolean isShiftDown() {
        return this.shiftDown;
    }

    public final boolean isControlDown() {
        return this.controlDown;
    }

    public final boolean isAltDown() {
        return this.altDown;
    }

    public final boolean isMetaDown() {
        return this.metaDown;
    }

    public final boolean isDirect() {
        return this.direct;
    }

    public boolean isInertia() {
        return this.inertia;
    }

    public final PickResult getPickResult() {
        return this.pickResult;
    }

    public final boolean isShortcutDown() {
        switch (Toolkit.getToolkit().getPlatformShortcutKey()) {
            case SHIFT: {
                return this.shiftDown;
            }
            case CONTROL: {
                return this.controlDown;
            }
            case ALT: {
                return this.altDown;
            }
            case META: {
                return this.metaDown;
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("GestureEvent [");
        sb.append("source = ").append(this.getSource());
        sb.append(", target = ").append(this.getTarget());
        sb.append(", eventType = ").append(this.getEventType());
        sb.append(", consumed = ").append(this.isConsumed());
        sb.append(", x = ").append(this.getX()).append(", y = ").append(this.getY()).append(", z = ").append(this.getZ());
        sb.append(this.isDirect() ? ", direct" : ", indirect");
        if (this.isInertia()) {
            sb.append(", inertia");
        }
        if (this.isShiftDown()) {
            sb.append(", shiftDown");
        }
        if (this.isControlDown()) {
            sb.append(", controlDown");
        }
        if (this.isAltDown()) {
            sb.append(", altDown");
        }
        if (this.isMetaDown()) {
            sb.append(", metaDown");
        }
        if (this.isShortcutDown()) {
            sb.append(", shortcutDown");
        }
        sb.append(", pickResult = ").append(this.getPickResult());
        return sb.append("]").toString();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.x = this.sceneX;
        this.y = this.sceneY;
    }

    public EventType<? extends GestureEvent> getEventType() {
        return super.getEventType();
    }
}

