/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.input;

import com.sun.javafx.tk.Toolkit;
import javafx.beans.NamedArg;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;

public final class KeyCharacterCombination
extends KeyCombination {
    private String character = "";

    public final String getCharacter() {
        return this.character;
    }

    public KeyCharacterCombination(@NamedArg(value="character") String character, @NamedArg(value="shift") KeyCombination.ModifierValue shift, @NamedArg(value="control") KeyCombination.ModifierValue control, @NamedArg(value="alt") KeyCombination.ModifierValue alt, @NamedArg(value="meta") KeyCombination.ModifierValue meta, @NamedArg(value="shortcut") KeyCombination.ModifierValue shortcut) {
        super(shift, control, alt, meta, shortcut);
        KeyCharacterCombination.validateKeyCharacter(character);
        this.character = character;
    }

    public KeyCharacterCombination(@NamedArg(value="character") String character, KeyCombination.Modifier ... modifiers) {
        super(modifiers);
        KeyCharacterCombination.validateKeyCharacter(character);
        this.character = character;
    }

    @Override
    public boolean match(KeyEvent event) {
        if (event.getCode() == KeyCode.UNDEFINED) {
            return false;
        }
        return event.getCode().getCode() == Toolkit.getToolkit().getKeyCodeForChar(this.getCharacter()) && super.match(event);
    }

    @Override
    public String getName() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.getName());
        if (sb.length() > 0) {
            sb.append("+");
        }
        return sb.append('\'').append(this.character.replace("'", "\\'")).append('\'').toString();
    }

    @Override
    public String getDisplayText() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.getDisplayText());
        sb.append(this.getCharacter());
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof KeyCharacterCombination)) {
            return false;
        }
        return this.character.equals(((KeyCharacterCombination)obj).getCharacter()) && super.equals(obj);
    }

    @Override
    public int hashCode() {
        return 23 * super.hashCode() + this.character.hashCode();
    }

    private static void validateKeyCharacter(String keyCharacter) {
        if (keyCharacter == null) {
            throw new NullPointerException("Key character must not be null!");
        }
    }
}

