/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.input;

import com.sun.javafx.scene.input.InputEventUtils;
import com.sun.javafx.scene.input.TouchPointHelper;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import javafx.beans.NamedArg;
import javafx.event.EventTarget;
import javafx.geometry.Point3D;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.input.PickResult;

public final class TouchPoint
implements Serializable {
    private transient EventTarget target;
    private transient Object source;
    private EventTarget grabbed = null;
    private int id;
    private State state;
    private transient double x;
    private transient double y;
    private transient double z;
    private double screenX;
    private double screenY;
    private double sceneX;
    private double sceneY;
    private PickResult pickResult;

    public TouchPoint(@NamedArg(value="id") int id, @NamedArg(value="state") State state, @NamedArg(value="x") double x, @NamedArg(value="y") double y, @NamedArg(value="screenX") double screenX, @NamedArg(value="screenY") double screenY, @NamedArg(value="target") EventTarget target, @NamedArg(value="pickResult") PickResult pickResult) {
        this.target = target;
        this.id = id;
        this.state = state;
        this.x = x;
        this.y = y;
        this.sceneX = x;
        this.sceneY = y;
        this.screenX = screenX;
        this.screenY = screenY;
        this.pickResult = pickResult != null ? pickResult : new PickResult(target, x, y);
        Point3D p = InputEventUtils.recomputeCoordinates(this.pickResult, null);
        this.x = p.getX();
        this.y = p.getY();
        this.z = p.getZ();
    }

    void recomputeToSource(Object oldSource, Object newSource) {
        Point3D newCoordinates = InputEventUtils.recomputeCoordinates(this.pickResult, newSource);
        this.x = newCoordinates.getX();
        this.y = newCoordinates.getY();
        this.z = newCoordinates.getZ();
        this.source = newSource;
    }

    public boolean belongsTo(EventTarget target) {
        if (this.target instanceof Node) {
            Node n;
            if (target instanceof Scene) {
                return n.getScene() == target;
            }
            for (n = (Node)this.target; n != null; n = n.getParent()) {
                if (n != target) continue;
                return true;
            }
        }
        return target == this.target;
    }

    void reset() {
        Point3D p = InputEventUtils.recomputeCoordinates(this.pickResult, null);
        this.x = p.getX();
        this.y = p.getY();
        this.z = p.getZ();
    }

    public EventTarget getGrabbed() {
        return this.grabbed;
    }

    public void grab() {
        if (!(this.source instanceof EventTarget)) {
            throw new IllegalStateException("Cannot grab touch point, source is not an instance of EventTarget: " + this.source);
        }
        this.grabbed = (EventTarget)this.source;
    }

    public void grab(EventTarget target) {
        this.grabbed = target;
    }

    public void ungrab() {
        this.grabbed = null;
    }

    public final int getId() {
        return this.id;
    }

    public final State getState() {
        return this.state;
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final double getZ() {
        return this.z;
    }

    public final double getScreenX() {
        return this.screenX;
    }

    public final double getScreenY() {
        return this.screenY;
    }

    public final double getSceneX() {
        return this.sceneX;
    }

    public final double getSceneY() {
        return this.sceneY;
    }

    public final PickResult getPickResult() {
        return this.pickResult;
    }

    public EventTarget getTarget() {
        return this.target;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TouchPoint [");
        sb.append("state = ").append((Object)this.getState());
        sb.append(", id = ").append(this.getId());
        sb.append(", target = ").append(this.getTarget());
        sb.append(", x = ").append(this.getX()).append(", y = ").append(this.getY()).append(", z = ").append(this.getZ());
        sb.append(", pickResult = ").append(this.getPickResult());
        return sb.append("]").toString();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.x = this.sceneX;
        this.y = this.sceneY;
    }

    static {
        TouchPointHelper.setTouchPointAccessor(new TouchPointHelper.TouchPointAccessor(){

            @Override
            public void reset(TouchPoint touchPoint) {
                touchPoint.reset();
            }
        });
    }

    public static enum State {
        PRESSED,
        MOVED,
        STATIONARY,
        RELEASED;

    }
}

