/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.layout;

import java.util.List;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.layout.Pane;

public class AnchorPane
extends Pane {
    private static final String TOP_ANCHOR = "pane-top-anchor";
    private static final String LEFT_ANCHOR = "pane-left-anchor";
    private static final String BOTTOM_ANCHOR = "pane-bottom-anchor";
    private static final String RIGHT_ANCHOR = "pane-right-anchor";

    public static void setTopAnchor(Node child, Double value) {
        AnchorPane.setConstraint(child, TOP_ANCHOR, value);
    }

    public static Double getTopAnchor(Node child) {
        return (Double)AnchorPane.getConstraint(child, TOP_ANCHOR);
    }

    public static void setLeftAnchor(Node child, Double value) {
        AnchorPane.setConstraint(child, LEFT_ANCHOR, value);
    }

    public static Double getLeftAnchor(Node child) {
        return (Double)AnchorPane.getConstraint(child, LEFT_ANCHOR);
    }

    public static void setBottomAnchor(Node child, Double value) {
        AnchorPane.setConstraint(child, BOTTOM_ANCHOR, value);
    }

    public static Double getBottomAnchor(Node child) {
        return (Double)AnchorPane.getConstraint(child, BOTTOM_ANCHOR);
    }

    public static void setRightAnchor(Node child, Double value) {
        AnchorPane.setConstraint(child, RIGHT_ANCHOR, value);
    }

    public static Double getRightAnchor(Node child) {
        return (Double)AnchorPane.getConstraint(child, RIGHT_ANCHOR);
    }

    public static void clearConstraints(Node child) {
        AnchorPane.setTopAnchor(child, null);
        AnchorPane.setRightAnchor(child, null);
        AnchorPane.setBottomAnchor(child, null);
        AnchorPane.setLeftAnchor(child, null);
    }

    public AnchorPane() {
    }

    public AnchorPane(Node ... children) {
        this.getChildren().addAll((Object[])children);
    }

    @Override
    protected double computeMinWidth(double height) {
        return this.computeWidth(true, height);
    }

    @Override
    protected double computeMinHeight(double width) {
        return this.computeHeight(true, width);
    }

    @Override
    protected double computePrefWidth(double height) {
        return this.computeWidth(false, height);
    }

    @Override
    protected double computePrefHeight(double width) {
        return this.computeHeight(false, width);
    }

    private double computeWidth(boolean minimum, double height) {
        double max = 0.0;
        double contentHeight = height != -1.0 ? height - this.getInsets().getTop() - this.getInsets().getBottom() : -1.0;
        List children = this.getManagedChildren();
        for (Node child : children) {
            Double leftAnchor = AnchorPane.getLeftAnchor(child);
            Double rightAnchor = AnchorPane.getRightAnchor(child);
            double left = leftAnchor != null ? leftAnchor : (rightAnchor != null ? 0.0 : child.getLayoutBounds().getMinX() + child.getLayoutX());
            double right = rightAnchor != null ? rightAnchor : 0.0;
            double childHeight = -1.0;
            if (child.getContentBias() == Orientation.VERTICAL && contentHeight != -1.0) {
                childHeight = this.computeChildHeight(child, AnchorPane.getTopAnchor(child), AnchorPane.getBottomAnchor(child), contentHeight, -1.0);
            }
            max = Math.max(max, left + (minimum && leftAnchor != null && rightAnchor != null ? child.minWidth(childHeight) : this.computeChildPrefAreaWidth(child, -1.0, null, childHeight, false)) + right);
        }
        Insets insets = this.getInsets();
        return insets.getLeft() + max + insets.getRight();
    }

    private double computeHeight(boolean minimum, double width) {
        double max = 0.0;
        double contentWidth = width != -1.0 ? width - this.getInsets().getLeft() - this.getInsets().getRight() : -1.0;
        List children = this.getManagedChildren();
        for (Node child : children) {
            Double topAnchor = AnchorPane.getTopAnchor(child);
            Double bottomAnchor = AnchorPane.getBottomAnchor(child);
            double top = topAnchor != null ? topAnchor : (bottomAnchor != null ? 0.0 : child.getLayoutBounds().getMinY() + child.getLayoutY());
            double bottom = bottomAnchor != null ? bottomAnchor : 0.0;
            double childWidth = -1.0;
            if (child.getContentBias() == Orientation.HORIZONTAL && contentWidth != -1.0) {
                childWidth = this.computeChildWidth(child, AnchorPane.getLeftAnchor(child), AnchorPane.getRightAnchor(child), contentWidth, -1.0);
            }
            max = Math.max(max, top + (minimum && topAnchor != null && bottomAnchor != null ? child.minHeight(childWidth) : this.computeChildPrefAreaHeight(child, -1.0, null, childWidth)) + bottom);
        }
        Insets insets = this.getInsets();
        return insets.getTop() + max + insets.getBottom();
    }

    private double computeChildWidth(Node child, Double leftAnchor, Double rightAnchor, double areaWidth, double height) {
        if (leftAnchor != null && rightAnchor != null && child.isResizable()) {
            Insets insets = this.getInsets();
            return areaWidth - insets.getLeft() - insets.getRight() - leftAnchor - rightAnchor;
        }
        return this.computeChildPrefAreaWidth(child, -1.0, Insets.EMPTY, height, true);
    }

    private double computeChildHeight(Node child, Double topAnchor, Double bottomAnchor, double areaHeight, double width) {
        if (topAnchor != null && bottomAnchor != null && child.isResizable()) {
            Insets insets = this.getInsets();
            return areaHeight - insets.getTop() - insets.getBottom() - topAnchor - bottomAnchor;
        }
        return this.computeChildPrefAreaHeight(child, -1.0, Insets.EMPTY, width);
    }

    @Override
    protected void layoutChildren() {
        Insets insets = this.getInsets();
        List children = this.getManagedChildren();
        for (Node child : children) {
            double w;
            double h;
            Double topAnchor = AnchorPane.getTopAnchor(child);
            Double bottomAnchor = AnchorPane.getBottomAnchor(child);
            Double leftAnchor = AnchorPane.getLeftAnchor(child);
            Double rightAnchor = AnchorPane.getRightAnchor(child);
            Bounds childLayoutBounds = child.getLayoutBounds();
            Orientation bias = child.getContentBias();
            double x = child.getLayoutX() + childLayoutBounds.getMinX();
            double y = child.getLayoutY() + childLayoutBounds.getMinY();
            if (bias == Orientation.VERTICAL) {
                h = this.computeChildHeight(child, topAnchor, bottomAnchor, this.getHeight(), -1.0);
                w = this.computeChildWidth(child, leftAnchor, rightAnchor, this.getWidth(), h);
            } else if (bias == Orientation.HORIZONTAL) {
                w = this.computeChildWidth(child, leftAnchor, rightAnchor, this.getWidth(), -1.0);
                h = this.computeChildHeight(child, topAnchor, bottomAnchor, this.getHeight(), w);
            } else {
                w = this.computeChildWidth(child, leftAnchor, rightAnchor, this.getWidth(), -1.0);
                h = this.computeChildHeight(child, topAnchor, bottomAnchor, this.getHeight(), -1.0);
            }
            if (leftAnchor != null) {
                x = insets.getLeft() + leftAnchor;
            } else if (rightAnchor != null) {
                x = this.getWidth() - insets.getRight() - rightAnchor - w;
            }
            if (topAnchor != null) {
                y = insets.getTop() + topAnchor;
            } else if (bottomAnchor != null) {
                y = this.getHeight() - insets.getBottom() - bottomAnchor - h;
            }
            child.resizeRelocate(x, y, w, h);
        }
    }
}

