/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.layout;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.BooleanConverter;
import javafx.css.converter.EnumConverter;
import javafx.css.converter.SizeConverter;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.util.Callback;

public class HBox
extends Pane {
    private boolean biasDirty = true;
    private double minBaselineComplement = Double.NaN;
    private double prefBaselineComplement = Double.NaN;
    private Orientation bias;
    private double[][] tempArray;
    private static final String MARGIN_CONSTRAINT = "hbox-margin";
    private static final String HGROW_CONSTRAINT = "hbox-hgrow";
    private static final Callback<Node, Insets> marginAccessor = n -> HBox.getMargin(n);
    private DoubleProperty spacing;
    private ObjectProperty<Pos> alignment;
    private BooleanProperty fillHeight;
    private double baselineOffset = Double.NaN;

    public static void setHgrow(Node child, Priority value) {
        HBox.setConstraint(child, HGROW_CONSTRAINT, (Object)value);
    }

    public static Priority getHgrow(Node child) {
        return (Priority)((Object)HBox.getConstraint(child, HGROW_CONSTRAINT));
    }

    public static void setMargin(Node child, Insets value) {
        HBox.setConstraint(child, MARGIN_CONSTRAINT, value);
    }

    public static Insets getMargin(Node child) {
        return (Insets)HBox.getConstraint(child, MARGIN_CONSTRAINT);
    }

    public static void clearConstraints(Node child) {
        HBox.setHgrow(child, null);
        HBox.setMargin(child, null);
    }

    public HBox() {
    }

    public HBox(double spacing) {
        this();
        this.setSpacing(spacing);
    }

    public HBox(Node ... children) {
        this.getChildren().addAll((Object[])children);
    }

    public HBox(double spacing, Node ... children) {
        this();
        this.setSpacing(spacing);
        this.getChildren().addAll((Object[])children);
    }

    public final DoubleProperty spacingProperty() {
        if (this.spacing == null) {
            this.spacing = new StyleableDoubleProperty(){

                public void invalidated() {
                    HBox.this.requestLayout();
                }

                @Override
                public CssMetaData getCssMetaData() {
                    return StyleableProperties.SPACING;
                }

                public Object getBean() {
                    return HBox.this;
                }

                public String getName() {
                    return "spacing";
                }
            };
        }
        return this.spacing;
    }

    public final void setSpacing(double value) {
        this.spacingProperty().set(value);
    }

    public final double getSpacing() {
        return this.spacing == null ? 0.0 : this.spacing.get();
    }

    public final ObjectProperty<Pos> alignmentProperty() {
        if (this.alignment == null) {
            this.alignment = new StyleableObjectProperty<Pos>(Pos.TOP_LEFT){

                public void invalidated() {
                    HBox.this.requestLayout();
                }

                @Override
                public CssMetaData<HBox, Pos> getCssMetaData() {
                    return StyleableProperties.ALIGNMENT;
                }

                public Object getBean() {
                    return HBox.this;
                }

                public String getName() {
                    return "alignment";
                }
            };
        }
        return this.alignment;
    }

    public final void setAlignment(Pos value) {
        this.alignmentProperty().set((Object)value);
    }

    public final Pos getAlignment() {
        return this.alignment == null ? Pos.TOP_LEFT : (Pos)((Object)this.alignment.get());
    }

    private Pos getAlignmentInternal() {
        Pos localPos = this.getAlignment();
        return localPos == null ? Pos.TOP_LEFT : localPos;
    }

    public final BooleanProperty fillHeightProperty() {
        if (this.fillHeight == null) {
            this.fillHeight = new StyleableBooleanProperty(true){

                public void invalidated() {
                    HBox.this.requestLayout();
                }

                @Override
                public CssMetaData<HBox, Boolean> getCssMetaData() {
                    return StyleableProperties.FILL_HEIGHT;
                }

                public Object getBean() {
                    return HBox.this;
                }

                public String getName() {
                    return "fillHeight";
                }
            };
        }
        return this.fillHeight;
    }

    public final void setFillHeight(boolean value) {
        this.fillHeightProperty().set(value);
    }

    public final boolean isFillHeight() {
        return this.fillHeight == null ? true : this.fillHeight.get();
    }

    private boolean shouldFillHeight() {
        return this.isFillHeight() && this.getAlignmentInternal().getVpos() != VPos.BASELINE;
    }

    @Override
    public Orientation getContentBias() {
        if (this.biasDirty) {
            this.bias = null;
            List children = this.getManagedChildren();
            for (Node child : children) {
                Orientation contentBias = child.getContentBias();
                if (contentBias == null) continue;
                this.bias = contentBias;
                if (contentBias != Orientation.HORIZONTAL) continue;
                break;
            }
            this.biasDirty = false;
        }
        return this.bias;
    }

    @Override
    protected double computeMinWidth(double height) {
        Insets insets = this.getInsets();
        return this.snapSpaceX(insets.getLeft()) + this.computeContentWidth(this.getManagedChildren(), height, true) + this.snapSpaceX(insets.getRight());
    }

    @Override
    protected double computeMinHeight(double width) {
        Insets insets = this.getInsets();
        List<Node> managed = this.getManagedChildren();
        double contentHeight = 0.0;
        if (width != -1.0 && this.getContentBias() != null) {
            double[][] prefWidths = this.getAreaWidths(managed, -1.0, false);
            this.adjustAreaWidths(managed, prefWidths, width, -1.0);
            contentHeight = this.computeMaxMinAreaHeight(managed, marginAccessor, prefWidths[0], this.getAlignmentInternal().getVpos());
        } else {
            contentHeight = this.computeMaxMinAreaHeight(managed, marginAccessor, this.getAlignmentInternal().getVpos());
        }
        return this.snapSpaceY(insets.getTop()) + contentHeight + this.snapSpaceY(insets.getBottom());
    }

    @Override
    protected double computePrefWidth(double height) {
        Insets insets = this.getInsets();
        return this.snapSpaceX(insets.getLeft()) + this.computeContentWidth(this.getManagedChildren(), height, false) + this.snapSpaceX(insets.getRight());
    }

    @Override
    protected double computePrefHeight(double width) {
        Insets insets = this.getInsets();
        List<Node> managed = this.getManagedChildren();
        double contentHeight = 0.0;
        if (width != -1.0 && this.getContentBias() != null) {
            double[][] prefWidths = this.getAreaWidths(managed, -1.0, false);
            this.adjustAreaWidths(managed, prefWidths, width, -1.0);
            contentHeight = this.computeMaxPrefAreaHeight(managed, marginAccessor, prefWidths[0], this.getAlignmentInternal().getVpos());
        } else {
            contentHeight = this.computeMaxPrefAreaHeight(managed, marginAccessor, this.getAlignmentInternal().getVpos());
        }
        return this.snapSpaceY(insets.getTop()) + contentHeight + this.snapSpaceY(insets.getBottom());
    }

    private double[][] getAreaWidths(List<Node> managed, double height, boolean minimum) {
        double[][] temp = this.getTempArray(managed.size());
        double insideHeight = height == -1.0 ? -1.0 : height - this.snapSpaceY(this.getInsets().getTop()) - this.snapSpaceY(this.getInsets().getBottom());
        boolean shouldFillHeight = this.shouldFillHeight();
        int size = managed.size();
        for (int i = 0; i < size; ++i) {
            Node child = managed.get(i);
            Insets margin = HBox.getMargin(child);
            temp[0][i] = minimum ? this.computeChildMinAreaWidth(child, this.getMinBaselineComplement(), margin, insideHeight, shouldFillHeight) : this.computeChildPrefAreaWidth(child, this.getPrefBaselineComplement(), margin, insideHeight, shouldFillHeight);
        }
        return temp;
    }

    private double adjustAreaWidths(List<Node> managed, double[][] areaWidths, double width, double height) {
        Insets insets = this.getInsets();
        double top = this.snapSpaceY(insets.getTop());
        double bottom = this.snapSpaceY(insets.getBottom());
        double contentWidth = HBox.sum(areaWidths[0], managed.size()) + (double)(managed.size() - 1) * this.snapSpaceX(this.getSpacing());
        double extraWidth = width - this.snapSpaceX(insets.getLeft()) - this.snapSpaceX(insets.getRight()) - contentWidth;
        if (extraWidth != 0.0) {
            double refHeight = this.shouldFillHeight() && height != -1.0 ? height - top - bottom : -1.0;
            double remaining = this.growOrShrinkAreaWidths(managed, areaWidths, Priority.ALWAYS, extraWidth, refHeight);
            remaining = this.growOrShrinkAreaWidths(managed, areaWidths, Priority.SOMETIMES, remaining, refHeight);
            contentWidth += extraWidth - remaining;
        }
        return contentWidth;
    }

    private double growOrShrinkAreaWidths(List<Node> managed, double[][] areaWidths, Priority priority, double extraWidth, double height) {
        Node child;
        int i;
        int size;
        boolean shrinking = extraWidth < 0.0;
        int adjustingNumber = 0;
        double[] usedWidths = areaWidths[0];
        double[] temp = areaWidths[1];
        boolean shouldFillHeight = this.shouldFillHeight();
        if (shrinking) {
            adjustingNumber = managed.size();
            size = managed.size();
            for (i = 0; i < size; ++i) {
                child = managed.get(i);
                temp[i] = this.computeChildMinAreaWidth(child, this.getMinBaselineComplement(), HBox.getMargin(child), height, shouldFillHeight);
            }
        } else {
            size = managed.size();
            for (i = 0; i < size; ++i) {
                child = managed.get(i);
                if (HBox.getHgrow(child) == priority) {
                    temp[i] = this.computeChildMaxAreaWidth(child, this.getMinBaselineComplement(), HBox.getMargin(child), height, shouldFillHeight);
                    ++adjustingNumber;
                    continue;
                }
                temp[i] = -1.0;
            }
        }
        double available = extraWidth;
        block2: while (Math.abs(available) > 1.0 && adjustingNumber > 0) {
            double portion = this.snapPortionX(available / (double)adjustingNumber);
            int size2 = managed.size();
            for (int i2 = 0; i2 < size2; ++i2) {
                if (temp[i2] == -1.0) continue;
                double limit = temp[i2] - usedWidths[i2];
                double change = Math.abs(limit) <= Math.abs(portion) ? limit : portion;
                int n = i2;
                usedWidths[n] = usedWidths[n] + change;
                if (Math.abs(available -= change) < 1.0) break block2;
                if (!(Math.abs(change) < Math.abs(portion))) continue;
                temp[i2] = -1.0;
                --adjustingNumber;
            }
        }
        return available;
    }

    private double computeContentWidth(List<Node> managedChildren, double height, boolean minimum) {
        return HBox.sum(this.getAreaWidths(managedChildren, height, minimum)[0], managedChildren.size()) + (double)(managedChildren.size() - 1) * this.snapSpaceX(this.getSpacing());
    }

    private static double sum(double[] array, int size) {
        int i = 0;
        double res = 0.0;
        while (i != size) {
            res += array[i++];
        }
        return res;
    }

    @Override
    public void requestLayout() {
        this.biasDirty = true;
        this.bias = null;
        this.minBaselineComplement = Double.NaN;
        this.prefBaselineComplement = Double.NaN;
        this.baselineOffset = Double.NaN;
        super.requestLayout();
    }

    private double getMinBaselineComplement() {
        if (Double.isNaN(this.minBaselineComplement)) {
            this.minBaselineComplement = this.getAlignmentInternal().getVpos() == VPos.BASELINE ? HBox.getMinBaselineComplement(this.getManagedChildren()) : -1.0;
        }
        return this.minBaselineComplement;
    }

    private double getPrefBaselineComplement() {
        if (Double.isNaN(this.prefBaselineComplement)) {
            this.prefBaselineComplement = this.getAlignmentInternal().getVpos() == VPos.BASELINE ? HBox.getPrefBaselineComplement(this.getManagedChildren()) : -1.0;
        }
        return this.prefBaselineComplement;
    }

    @Override
    public double getBaselineOffset() {
        List managed = this.getManagedChildren();
        if (managed.isEmpty()) {
            return Double.NEGATIVE_INFINITY;
        }
        if (Double.isNaN(this.baselineOffset)) {
            VPos vpos = this.getAlignmentInternal().getVpos();
            if (vpos == VPos.BASELINE) {
                double max = 0.0;
                int sz = managed.size();
                for (int i = 0; i < sz; ++i) {
                    Node child = (Node)managed.get(i);
                    double offset = child.getBaselineOffset();
                    if (offset == Double.NEGATIVE_INFINITY) {
                        this.baselineOffset = Double.NEGATIVE_INFINITY;
                        break;
                    }
                    Insets margin = HBox.getMargin(child);
                    double top = margin != null ? margin.getTop() : 0.0;
                    max = Math.max(max, top + child.getLayoutBounds().getMinY() + offset);
                }
                this.baselineOffset = max + this.snappedTopInset();
            } else {
                this.baselineOffset = Double.NEGATIVE_INFINITY;
            }
        }
        return this.baselineOffset;
    }

    @Override
    protected void layoutChildren() {
        List<Node> managed = this.getManagedChildren();
        Insets insets = this.getInsets();
        Pos align = this.getAlignmentInternal();
        HPos alignHpos = align.getHpos();
        VPos alignVpos = align.getVpos();
        double width = this.getWidth();
        double height = this.getHeight();
        double top = this.snapSpaceY(insets.getTop());
        double left = this.snapSpaceX(insets.getLeft());
        double bottom = this.snapSpaceY(insets.getBottom());
        double right = this.snapSpaceX(insets.getRight());
        double space = this.snapSpaceX(this.getSpacing());
        boolean shouldFillHeight = this.shouldFillHeight();
        double[][] actualAreaWidths = this.getAreaWidths(managed, height, false);
        double contentWidth = this.adjustAreaWidths(managed, actualAreaWidths, width, height);
        double contentHeight = height - top - bottom;
        double x = left + HBox.computeXOffset(width - left - right, contentWidth, align.getHpos());
        double y = top;
        double baselineOffset = -1.0;
        if (alignVpos == VPos.BASELINE) {
            double baselineComplement = this.getMinBaselineComplement();
            baselineOffset = this.getAreaBaselineOffset(managed, marginAccessor, (Integer i) -> actualAreaWidths[0][i], contentHeight, shouldFillHeight, baselineComplement);
        }
        int size = managed.size();
        for (int i2 = 0; i2 < size; ++i2) {
            Node child = managed.get(i2);
            Insets margin = HBox.getMargin(child);
            this.layoutInArea(child, x, y, actualAreaWidths[0][i2], contentHeight, baselineOffset, margin, true, shouldFillHeight, alignHpos, alignVpos);
            x += actualAreaWidths[0][i2] + space;
        }
    }

    private double[][] getTempArray(int size) {
        if (this.tempArray == null) {
            this.tempArray = new double[2][size];
        } else if (this.tempArray[0].length < size) {
            this.tempArray = new double[2][Math.max(this.tempArray.length * 3, size)];
        }
        return this.tempArray;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return HBox.getClassCssMetaData();
    }

    private static class StyleableProperties {
        private static final CssMetaData<HBox, Pos> ALIGNMENT = new CssMetaData<HBox, Pos>("-fx-alignment", new EnumConverter<Pos>(Pos.class), Pos.TOP_LEFT){

            @Override
            public boolean isSettable(HBox node) {
                return node.alignment == null || !node.alignment.isBound();
            }

            @Override
            public StyleableProperty<Pos> getStyleableProperty(HBox node) {
                return (StyleableProperty)node.alignmentProperty();
            }
        };
        private static final CssMetaData<HBox, Boolean> FILL_HEIGHT = new CssMetaData<HBox, Boolean>("-fx-fill-height", BooleanConverter.getInstance(), Boolean.TRUE){

            @Override
            public boolean isSettable(HBox node) {
                return node.fillHeight == null || !node.fillHeight.isBound();
            }

            @Override
            public StyleableProperty<Boolean> getStyleableProperty(HBox node) {
                return (StyleableProperty)node.fillHeightProperty();
            }
        };
        private static final CssMetaData<HBox, Number> SPACING = new CssMetaData<HBox, Number>("-fx-spacing", SizeConverter.getInstance(), (Number)0.0){

            @Override
            public boolean isSettable(HBox node) {
                return node.spacing == null || !node.spacing.isBound();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(HBox node) {
                return (StyleableProperty)node.spacingProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(Pane.getClassCssMetaData());
            styleables.add(FILL_HEIGHT);
            styleables.add(ALIGNMENT);
            styleables.add(SPACING);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

