/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.layout;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.BooleanConverter;
import javafx.css.converter.EnumConverter;
import javafx.css.converter.SizeConverter;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.util.Callback;

public class VBox
extends Pane {
    private boolean biasDirty = true;
    private Orientation bias;
    private double[][] tempArray;
    private static final String MARGIN_CONSTRAINT = "vbox-margin";
    private static final String VGROW_CONSTRAINT = "vbox-vgrow";
    private static final Callback<Node, Insets> marginAccessor = n -> VBox.getMargin(n);
    private DoubleProperty spacing;
    private ObjectProperty<Pos> alignment;
    private BooleanProperty fillWidth;

    public static void setVgrow(Node child, Priority value) {
        VBox.setConstraint(child, VGROW_CONSTRAINT, (Object)value);
    }

    public static Priority getVgrow(Node child) {
        return (Priority)((Object)VBox.getConstraint(child, VGROW_CONSTRAINT));
    }

    public static void setMargin(Node child, Insets value) {
        VBox.setConstraint(child, MARGIN_CONSTRAINT, value);
    }

    public static Insets getMargin(Node child) {
        return (Insets)VBox.getConstraint(child, MARGIN_CONSTRAINT);
    }

    public static void clearConstraints(Node child) {
        VBox.setVgrow(child, null);
        VBox.setMargin(child, null);
    }

    public VBox() {
    }

    public VBox(double spacing) {
        this();
        this.setSpacing(spacing);
    }

    public VBox(Node ... children) {
        this.getChildren().addAll((Object[])children);
    }

    public VBox(double spacing, Node ... children) {
        this();
        this.setSpacing(spacing);
        this.getChildren().addAll((Object[])children);
    }

    public final DoubleProperty spacingProperty() {
        if (this.spacing == null) {
            this.spacing = new StyleableDoubleProperty(){

                public void invalidated() {
                    VBox.this.requestLayout();
                }

                public Object getBean() {
                    return VBox.this;
                }

                public String getName() {
                    return "spacing";
                }

                @Override
                public CssMetaData<VBox, Number> getCssMetaData() {
                    return StyleableProperties.SPACING;
                }
            };
        }
        return this.spacing;
    }

    public final void setSpacing(double value) {
        this.spacingProperty().set(value);
    }

    public final double getSpacing() {
        return this.spacing == null ? 0.0 : this.spacing.get();
    }

    public final ObjectProperty<Pos> alignmentProperty() {
        if (this.alignment == null) {
            this.alignment = new StyleableObjectProperty<Pos>(Pos.TOP_LEFT){

                public void invalidated() {
                    VBox.this.requestLayout();
                }

                public Object getBean() {
                    return VBox.this;
                }

                public String getName() {
                    return "alignment";
                }

                @Override
                public CssMetaData<VBox, Pos> getCssMetaData() {
                    return StyleableProperties.ALIGNMENT;
                }
            };
        }
        return this.alignment;
    }

    public final void setAlignment(Pos value) {
        this.alignmentProperty().set((Object)value);
    }

    public final Pos getAlignment() {
        return this.alignment == null ? Pos.TOP_LEFT : (Pos)((Object)this.alignment.get());
    }

    private Pos getAlignmentInternal() {
        Pos localPos = this.getAlignment();
        return localPos == null ? Pos.TOP_LEFT : localPos;
    }

    public final BooleanProperty fillWidthProperty() {
        if (this.fillWidth == null) {
            this.fillWidth = new StyleableBooleanProperty(true){

                public void invalidated() {
                    VBox.this.requestLayout();
                }

                public Object getBean() {
                    return VBox.this;
                }

                public String getName() {
                    return "fillWidth";
                }

                @Override
                public CssMetaData<VBox, Boolean> getCssMetaData() {
                    return StyleableProperties.FILL_WIDTH;
                }
            };
        }
        return this.fillWidth;
    }

    public final void setFillWidth(boolean value) {
        this.fillWidthProperty().set(value);
    }

    public final boolean isFillWidth() {
        return this.fillWidth == null ? true : this.fillWidth.get();
    }

    @Override
    public Orientation getContentBias() {
        if (this.biasDirty) {
            this.bias = null;
            List children = this.getManagedChildren();
            for (Node child : children) {
                Orientation contentBias = child.getContentBias();
                if (contentBias == null) continue;
                this.bias = contentBias;
                if (contentBias != Orientation.HORIZONTAL) continue;
                break;
            }
            this.biasDirty = false;
        }
        return this.bias;
    }

    @Override
    protected double computeMinWidth(double height) {
        Insets insets = this.getInsets();
        List<Node> managed = this.getManagedChildren();
        double contentWidth = 0.0;
        if (height != -1.0 && this.getContentBias() != null) {
            double[][] prefHeights = this.getAreaHeights(managed, -1.0, false);
            this.adjustAreaHeights(managed, prefHeights, height, -1.0);
            contentWidth = this.computeMaxMinAreaWidth(managed, marginAccessor, prefHeights[0], false);
        } else {
            contentWidth = this.computeMaxMinAreaWidth(managed, marginAccessor);
        }
        return this.snapSpaceX(insets.getLeft()) + contentWidth + this.snapSpaceX(insets.getRight());
    }

    @Override
    protected double computeMinHeight(double width) {
        Insets insets = this.getInsets();
        return this.snapSpaceY(insets.getTop()) + this.computeContentHeight(this.getManagedChildren(), width, true) + this.snapSpaceY(insets.getBottom());
    }

    @Override
    protected double computePrefWidth(double height) {
        Insets insets = this.getInsets();
        List<Node> managed = this.getManagedChildren();
        double contentWidth = 0.0;
        if (height != -1.0 && this.getContentBias() != null) {
            double[][] prefHeights = this.getAreaHeights(managed, -1.0, false);
            this.adjustAreaHeights(managed, prefHeights, height, -1.0);
            contentWidth = this.computeMaxPrefAreaWidth(managed, marginAccessor, prefHeights[0], false);
        } else {
            contentWidth = this.computeMaxPrefAreaWidth(managed, marginAccessor);
        }
        return this.snapSpaceX(insets.getLeft()) + contentWidth + this.snapSpaceX(insets.getRight());
    }

    @Override
    protected double computePrefHeight(double width) {
        Insets insets = this.getInsets();
        double d = this.snapSpaceY(insets.getTop()) + this.computeContentHeight(this.getManagedChildren(), width, false) + this.snapSpaceY(insets.getBottom());
        return d;
    }

    private double[][] getAreaHeights(List<Node> managed, double width, boolean minimum) {
        double[][] temp = this.getTempArray(managed.size());
        double insideWidth = width == -1.0 ? -1.0 : width - this.snapSpaceX(this.getInsets().getLeft()) - this.snapSpaceX(this.getInsets().getRight());
        boolean isFillWidth = this.isFillWidth();
        int size = managed.size();
        for (int i = 0; i < size; ++i) {
            Node child = managed.get(i);
            Insets margin = VBox.getMargin(child);
            if (minimum) {
                if (insideWidth != -1.0 && isFillWidth) {
                    temp[0][i] = this.computeChildMinAreaHeight(child, -1.0, margin, insideWidth);
                    continue;
                }
                temp[0][i] = this.computeChildMinAreaHeight(child, -1.0, margin, -1.0);
                continue;
            }
            temp[0][i] = insideWidth != -1.0 && isFillWidth ? this.computeChildPrefAreaHeight(child, -1.0, margin, insideWidth) : this.computeChildPrefAreaHeight(child, -1.0, margin, -1.0);
        }
        return temp;
    }

    private double adjustAreaHeights(List<Node> managed, double[][] areaHeights, double height, double width) {
        Insets insets = this.getInsets();
        double left = this.snapSpaceX(insets.getLeft());
        double right = this.snapSpaceX(insets.getRight());
        double contentHeight = VBox.sum(areaHeights[0], managed.size()) + (double)(managed.size() - 1) * this.snapSpaceY(this.getSpacing());
        double extraHeight = height - this.snapSpaceY(insets.getTop()) - this.snapSpaceY(insets.getBottom()) - contentHeight;
        if (extraHeight != 0.0) {
            double refWidth = this.isFillWidth() && width != -1.0 ? width - left - right : -1.0;
            double remaining = this.growOrShrinkAreaHeights(managed, areaHeights, Priority.ALWAYS, extraHeight, refWidth);
            remaining = this.growOrShrinkAreaHeights(managed, areaHeights, Priority.SOMETIMES, remaining, refWidth);
            contentHeight += extraHeight - remaining;
        }
        return contentHeight;
    }

    private double growOrShrinkAreaHeights(List<Node> managed, double[][] areaHeights, Priority priority, double extraHeight, double width) {
        Node child;
        int i;
        int size;
        boolean shrinking = extraHeight < 0.0;
        int adjustingNumber = 0;
        double[] usedHeights = areaHeights[0];
        double[] temp = areaHeights[1];
        if (shrinking) {
            adjustingNumber = managed.size();
            size = managed.size();
            for (i = 0; i < size; ++i) {
                child = managed.get(i);
                temp[i] = this.computeChildMinAreaHeight(child, -1.0, VBox.getMargin(child), width);
            }
        } else {
            size = managed.size();
            for (i = 0; i < size; ++i) {
                child = managed.get(i);
                if (VBox.getVgrow(child) == priority) {
                    temp[i] = this.computeChildMaxAreaHeight(child, -1.0, VBox.getMargin(child), width);
                    ++adjustingNumber;
                    continue;
                }
                temp[i] = -1.0;
            }
        }
        double available = extraHeight;
        block2: while (Math.abs(available) > 1.0 && adjustingNumber > 0) {
            double portion = this.snapPortionY(available / (double)adjustingNumber);
            int size2 = managed.size();
            for (int i2 = 0; i2 < size2; ++i2) {
                if (temp[i2] == -1.0) continue;
                double limit = temp[i2] - usedHeights[i2];
                double change = Math.abs(limit) <= Math.abs(portion) ? limit : portion;
                int n = i2;
                usedHeights[n] = usedHeights[n] + change;
                if (Math.abs(available -= change) < 1.0) break block2;
                if (!(Math.abs(change) < Math.abs(portion))) continue;
                temp[i2] = -1.0;
                --adjustingNumber;
            }
        }
        return available;
    }

    private double computeContentHeight(List<Node> managedChildren, double width, boolean minimum) {
        return VBox.sum(this.getAreaHeights(managedChildren, width, minimum)[0], managedChildren.size()) + (double)(managedChildren.size() - 1) * this.snapSpaceY(this.getSpacing());
    }

    private static double sum(double[] array, int size) {
        int i = 0;
        double res = 0.0;
        while (i != size) {
            res += array[i++];
        }
        return res;
    }

    @Override
    public void requestLayout() {
        this.biasDirty = true;
        this.bias = null;
        super.requestLayout();
    }

    @Override
    protected void layoutChildren() {
        List<Node> managed = this.getManagedChildren();
        Insets insets = this.getInsets();
        double width = this.getWidth();
        double height = this.getHeight();
        double top = this.snapSpaceY(insets.getTop());
        double left = this.snapSpaceX(insets.getLeft());
        double bottom = this.snapSpaceY(insets.getBottom());
        double right = this.snapSpaceX(insets.getRight());
        double space = this.snapSpaceY(this.getSpacing());
        HPos hpos = this.getAlignmentInternal().getHpos();
        VPos vpos = this.getAlignmentInternal().getVpos();
        boolean isFillWidth = this.isFillWidth();
        double[][] actualAreaHeights = this.getAreaHeights(managed, width, false);
        double contentWidth = width - left - right;
        double contentHeight = this.adjustAreaHeights(managed, actualAreaHeights, height, width);
        double x = left;
        double y = top + VBox.computeYOffset(height - top - bottom, contentHeight, vpos);
        int size = managed.size();
        for (int i = 0; i < size; ++i) {
            Node child = managed.get(i);
            this.layoutInArea(child, x, y, contentWidth, actualAreaHeights[0][i], actualAreaHeights[0][i], VBox.getMargin(child), isFillWidth, true, hpos, vpos);
            y += actualAreaHeights[0][i] + space;
        }
    }

    private double[][] getTempArray(int size) {
        if (this.tempArray == null) {
            this.tempArray = new double[2][size];
        } else if (this.tempArray[0].length < size) {
            this.tempArray = new double[2][Math.max(this.tempArray.length * 3, size)];
        }
        return this.tempArray;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return VBox.getClassCssMetaData();
    }

    private static class StyleableProperties {
        private static final CssMetaData<VBox, Pos> ALIGNMENT = new CssMetaData<VBox, Pos>("-fx-alignment", new EnumConverter<Pos>(Pos.class), Pos.TOP_LEFT){

            @Override
            public boolean isSettable(VBox node) {
                return node.alignment == null || !node.alignment.isBound();
            }

            @Override
            public StyleableProperty<Pos> getStyleableProperty(VBox node) {
                return (StyleableProperty)node.alignmentProperty();
            }
        };
        private static final CssMetaData<VBox, Boolean> FILL_WIDTH = new CssMetaData<VBox, Boolean>("-fx-fill-width", BooleanConverter.getInstance(), Boolean.TRUE){

            @Override
            public boolean isSettable(VBox node) {
                return node.fillWidth == null || !node.fillWidth.isBound();
            }

            @Override
            public StyleableProperty<Boolean> getStyleableProperty(VBox node) {
                return (StyleableProperty)node.fillWidthProperty();
            }
        };
        private static final CssMetaData<VBox, Number> SPACING = new CssMetaData<VBox, Number>("-fx-spacing", SizeConverter.getInstance(), (Number)0.0){

            @Override
            public boolean isSettable(VBox node) {
                return node.spacing == null || !node.spacing.isBound();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(VBox node) {
                return (StyleableProperty)node.spacingProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(Region.getClassCssMetaData());
            styleables.add(ALIGNMENT);
            styleables.add(FILL_WIDTH);
            styleables.add(SPACING);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

