/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.paint;

import com.sun.javafx.scene.paint.GradientUtils;
import com.sun.javafx.tk.Toolkit;
import java.util.List;
import javafx.beans.NamedArg;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;

public final class LinearGradient
extends Paint {
    private double startX;
    private double startY;
    private double endX;
    private double endY;
    private boolean proportional;
    private CycleMethod cycleMethod;
    private List<Stop> stops;
    private final boolean opaque;
    private Object platformPaint;
    private int hash;

    public final double getStartX() {
        return this.startX;
    }

    public final double getStartY() {
        return this.startY;
    }

    public final double getEndX() {
        return this.endX;
    }

    public final double getEndY() {
        return this.endY;
    }

    public final boolean isProportional() {
        return this.proportional;
    }

    public final CycleMethod getCycleMethod() {
        return this.cycleMethod;
    }

    public final List<Stop> getStops() {
        return this.stops;
    }

    @Override
    public final boolean isOpaque() {
        return this.opaque;
    }

    public LinearGradient(@NamedArg(value="startX") double startX, @NamedArg(value="startY") double startY, @NamedArg(value="endX", defaultValue="1") double endX, @NamedArg(value="endY", defaultValue="1") double endY, @NamedArg(value="proportional", defaultValue="true") boolean proportional, @NamedArg(value="cycleMethod") CycleMethod cycleMethod, Stop ... stops) {
        this.startX = startX;
        this.startY = startY;
        this.endX = endX;
        this.endY = endY;
        this.proportional = proportional;
        this.cycleMethod = cycleMethod == null ? CycleMethod.NO_CYCLE : cycleMethod;
        this.stops = Stop.normalize(stops);
        this.opaque = this.determineOpacity();
    }

    public LinearGradient(@NamedArg(value="startX") double startX, @NamedArg(value="startY") double startY, @NamedArg(value="endX", defaultValue="1") double endX, @NamedArg(value="endY", defaultValue="1") double endY, @NamedArg(value="proportional", defaultValue="true") boolean proportional, @NamedArg(value="cycleMethod") CycleMethod cycleMethod, @NamedArg(value="stops") List<Stop> stops) {
        this.startX = startX;
        this.startY = startY;
        this.endX = endX;
        this.endY = endY;
        this.proportional = proportional;
        this.cycleMethod = cycleMethod == null ? CycleMethod.NO_CYCLE : cycleMethod;
        this.stops = Stop.normalize(stops);
        this.opaque = this.determineOpacity();
    }

    private boolean determineOpacity() {
        int numStops = this.stops.size();
        for (int i = 0; i < numStops; ++i) {
            if (this.stops.get(i).getColor().isOpaque()) continue;
            return false;
        }
        return true;
    }

    @Override
    Object acc_getPlatformPaint() {
        if (this.platformPaint == null) {
            this.platformPaint = Toolkit.getToolkit().getPaint((Paint)this);
        }
        return this.platformPaint;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof LinearGradient) {
            LinearGradient other = (LinearGradient)obj;
            if (this.startX != other.startX || this.startY != other.startY || this.endX != other.endX || this.endY != other.endY || this.proportional != other.proportional || this.cycleMethod != other.cycleMethod) {
                return false;
            }
            return this.stops.equals(other.stops);
        }
        return false;
    }

    public int hashCode() {
        if (this.hash == 0) {
            long bits = 17L;
            bits = 37L * bits + Double.doubleToLongBits(this.startX);
            bits = 37L * bits + Double.doubleToLongBits(this.startY);
            bits = 37L * bits + Double.doubleToLongBits(this.endX);
            bits = 37L * bits + Double.doubleToLongBits(this.endY);
            bits = 37L * bits + (this.proportional ? 1231L : 1237L);
            bits = 37L * bits + (long)this.cycleMethod.hashCode();
            for (Stop stop : this.stops) {
                bits = 37L * bits + (long)stop.hashCode();
            }
            this.hash = (int)(bits ^ bits >> 32);
        }
        return this.hash;
    }

    public String toString() {
        StringBuilder s = new StringBuilder("linear-gradient(from ").append(GradientUtils.lengthToString(this.startX, this.proportional)).append(" ").append(GradientUtils.lengthToString(this.startY, this.proportional)).append(" to ").append(GradientUtils.lengthToString(this.endX, this.proportional)).append(" ").append(GradientUtils.lengthToString(this.endY, this.proportional)).append(", ");
        switch (this.cycleMethod) {
            case REFLECT: {
                s.append("reflect").append(", ");
                break;
            }
            case REPEAT: {
                s.append("repeat").append(", ");
            }
        }
        for (Stop stop : this.stops) {
            s.append(stop).append(", ");
        }
        s.delete(s.length() - 2, s.length());
        s.append(")");
        return s.toString();
    }

    public static LinearGradient valueOf(String value) {
        GradientUtils.Parser parser;
        if (value == null) {
            throw new NullPointerException("gradient must be specified");
        }
        String start = "linear-gradient(";
        String end = ")";
        if (value.startsWith(start)) {
            if (!value.endsWith(end)) {
                throw new IllegalArgumentException("Invalid gradient specification, must end with \"" + end + "\"");
            }
            value = value.substring(start.length(), value.length() - end.length());
        }
        if ((parser = new GradientUtils.Parser(value)).getSize() < 2) {
            throw new IllegalArgumentException("Invalid gradient specification");
        }
        GradientUtils.Point startX = GradientUtils.Point.MIN;
        GradientUtils.Point startY = GradientUtils.Point.MIN;
        GradientUtils.Point endX = GradientUtils.Point.MIN;
        GradientUtils.Point endY = GradientUtils.Point.MIN;
        String[] tokens = parser.splitCurrentToken();
        if ("from".equals(tokens[0])) {
            GradientUtils.Parser.checkNumberOfArguments(tokens, 5);
            startX = parser.parsePoint(tokens[1]);
            startY = parser.parsePoint(tokens[2]);
            if (!"to".equals(tokens[3])) {
                throw new IllegalArgumentException("Invalid gradient specification, \"to\" expected");
            }
            endX = parser.parsePoint(tokens[4]);
            endY = parser.parsePoint(tokens[5]);
            parser.shift();
        } else if ("to".equals(tokens[0])) {
            int horizontalSet = 0;
            int verticalSet = 0;
            for (int i = 1; i < 3 && i < tokens.length; ++i) {
                if ("left".equals(tokens[i])) {
                    startX = GradientUtils.Point.MAX;
                    endX = GradientUtils.Point.MIN;
                    ++horizontalSet;
                    continue;
                }
                if ("right".equals(tokens[i])) {
                    startX = GradientUtils.Point.MIN;
                    endX = GradientUtils.Point.MAX;
                    ++horizontalSet;
                    continue;
                }
                if ("top".equals(tokens[i])) {
                    startY = GradientUtils.Point.MAX;
                    endY = GradientUtils.Point.MIN;
                    ++verticalSet;
                    continue;
                }
                if ("bottom".equals(tokens[i])) {
                    startY = GradientUtils.Point.MIN;
                    endY = GradientUtils.Point.MAX;
                    ++verticalSet;
                    continue;
                }
                throw new IllegalArgumentException("Invalid gradient specification, unknown value after 'to'");
            }
            if (verticalSet > 1) {
                throw new IllegalArgumentException("Invalid gradient specification, vertical direction set twice after 'to'");
            }
            if (horizontalSet > 1) {
                throw new IllegalArgumentException("Invalid gradient specification, horizontal direction set twice after 'to'");
            }
            parser.shift();
        } else {
            startY = GradientUtils.Point.MIN;
            endY = GradientUtils.Point.MAX;
        }
        CycleMethod method = CycleMethod.NO_CYCLE;
        String currentToken = parser.getCurrentToken();
        if ("repeat".equals(currentToken)) {
            method = CycleMethod.REPEAT;
            parser.shift();
        } else if ("reflect".equals(currentToken)) {
            method = CycleMethod.REFLECT;
            parser.shift();
        }
        double dist = 0.0;
        if (!startX.proportional) {
            double dx = endX.value - startX.value;
            double dy = endY.value - startY.value;
            dist = Math.sqrt(dx * dx + dy * dy);
        }
        Stop[] stops = parser.parseStops(startX.proportional, dist);
        return new LinearGradient(startX.value, startY.value, endX.value, endY.value, startX.proportional, method, stops);
    }
}

