/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.paint;

import com.sun.javafx.scene.paint.GradientUtils;
import com.sun.javafx.tk.Toolkit;
import java.util.List;
import javafx.beans.NamedArg;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;

public final class RadialGradient
extends Paint {
    private double focusAngle;
    private double focusDistance;
    private double centerX;
    private double centerY;
    private double radius;
    private boolean proportional;
    private CycleMethod cycleMethod;
    private List<Stop> stops;
    private final boolean opaque;
    private Object platformPaint;
    private int hash;

    public final double getFocusAngle() {
        return this.focusAngle;
    }

    public final double getFocusDistance() {
        return this.focusDistance;
    }

    public final double getCenterX() {
        return this.centerX;
    }

    public final double getCenterY() {
        return this.centerY;
    }

    public final double getRadius() {
        return this.radius;
    }

    public final boolean isProportional() {
        return this.proportional;
    }

    public final CycleMethod getCycleMethod() {
        return this.cycleMethod;
    }

    public final List<Stop> getStops() {
        return this.stops;
    }

    @Override
    public final boolean isOpaque() {
        return this.opaque;
    }

    public RadialGradient(@NamedArg(value="focusAngle") double focusAngle, @NamedArg(value="focusDistance") double focusDistance, @NamedArg(value="centerX") double centerX, @NamedArg(value="centerY") double centerY, @NamedArg(value="radius", defaultValue="1") double radius, @NamedArg(value="proportional", defaultValue="true") boolean proportional, @NamedArg(value="cycleMethod") CycleMethod cycleMethod, Stop ... stops) {
        this.focusAngle = focusAngle;
        this.focusDistance = focusDistance;
        this.centerX = centerX;
        this.centerY = centerY;
        this.radius = radius;
        this.proportional = proportional;
        this.cycleMethod = cycleMethod == null ? CycleMethod.NO_CYCLE : cycleMethod;
        this.stops = Stop.normalize(stops);
        this.opaque = this.determineOpacity();
    }

    public RadialGradient(@NamedArg(value="focusAngle") double focusAngle, @NamedArg(value="focusDistance") double focusDistance, @NamedArg(value="centerX") double centerX, @NamedArg(value="centerY") double centerY, @NamedArg(value="radius", defaultValue="1") double radius, @NamedArg(value="proportional", defaultValue="true") boolean proportional, @NamedArg(value="cycleMethod") CycleMethod cycleMethod, @NamedArg(value="stops") List<Stop> stops) {
        this.focusAngle = focusAngle;
        this.focusDistance = focusDistance;
        this.centerX = centerX;
        this.centerY = centerY;
        this.radius = radius;
        this.proportional = proportional;
        this.cycleMethod = cycleMethod == null ? CycleMethod.NO_CYCLE : cycleMethod;
        this.stops = Stop.normalize(stops);
        this.opaque = this.determineOpacity();
    }

    private boolean determineOpacity() {
        int numStops = this.stops.size();
        for (int i = 0; i < numStops; ++i) {
            if (this.stops.get(i).getColor().isOpaque()) continue;
            return false;
        }
        return true;
    }

    @Override
    Object acc_getPlatformPaint() {
        if (this.platformPaint == null) {
            this.platformPaint = Toolkit.getToolkit().getPaint((Paint)this);
        }
        return this.platformPaint;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof RadialGradient) {
            RadialGradient other = (RadialGradient)obj;
            if (this.focusAngle != other.focusAngle || this.focusDistance != other.focusDistance || this.centerX != other.centerX || this.centerY != other.centerY || this.radius != other.radius || this.proportional != other.proportional || this.cycleMethod != other.cycleMethod) {
                return false;
            }
            return this.stops.equals(other.stops);
        }
        return false;
    }

    public int hashCode() {
        if (this.hash == 0) {
            long bits = 17L;
            bits = 37L * bits + Double.doubleToLongBits(this.focusAngle);
            bits = 37L * bits + Double.doubleToLongBits(this.focusDistance);
            bits = 37L * bits + Double.doubleToLongBits(this.centerX);
            bits = 37L * bits + Double.doubleToLongBits(this.centerY);
            bits = 37L * bits + Double.doubleToLongBits(this.radius);
            bits = 37L * bits + (long)(this.proportional ? 1231 : 1237);
            bits = 37L * bits + (long)this.cycleMethod.hashCode();
            for (Stop stop : this.stops) {
                bits = 37L * bits + (long)stop.hashCode();
            }
            this.hash = (int)(bits ^ bits >> 32);
        }
        return this.hash;
    }

    public String toString() {
        StringBuilder s = new StringBuilder("radial-gradient(focus-angle ").append(this.focusAngle).append("deg, focus-distance ").append(this.focusDistance * 100.0).append("% , center ").append(GradientUtils.lengthToString(this.centerX, this.proportional)).append(" ").append(GradientUtils.lengthToString(this.centerY, this.proportional)).append(", radius ").append(GradientUtils.lengthToString(this.radius, this.proportional)).append(", ");
        switch (this.cycleMethod) {
            case REFLECT: {
                s.append("reflect").append(", ");
                break;
            }
            case REPEAT: {
                s.append("repeat").append(", ");
            }
        }
        for (Stop stop : this.stops) {
            s.append(stop).append(", ");
        }
        s.delete(s.length() - 2, s.length());
        s.append(")");
        return s.toString();
    }

    public static RadialGradient valueOf(String value) {
        GradientUtils.Point centerY;
        GradientUtils.Point centerX;
        GradientUtils.Parser parser;
        if (value == null) {
            throw new NullPointerException("gradient must be specified");
        }
        String start = "radial-gradient(";
        String end = ")";
        if (value.startsWith(start)) {
            if (!value.endsWith(end)) {
                throw new IllegalArgumentException("Invalid gradient specification, must end with \"" + end + "\"");
            }
            value = value.substring(start.length(), value.length() - end.length());
        }
        if ((parser = new GradientUtils.Parser(value)).getSize() < 2) {
            throw new IllegalArgumentException("Invalid gradient specification");
        }
        double angle = 0.0;
        double distance = 0.0;
        String[] tokens = parser.splitCurrentToken();
        if ("focus-angle".equals(tokens[0])) {
            GradientUtils.Parser.checkNumberOfArguments(tokens, 1);
            angle = GradientUtils.Parser.parseAngle(tokens[1]);
            parser.shift();
        }
        if ("focus-distance".equals((tokens = parser.splitCurrentToken())[0])) {
            GradientUtils.Parser.checkNumberOfArguments(tokens, 1);
            distance = GradientUtils.Parser.parsePercentage(tokens[1]);
            parser.shift();
        }
        if ("center".equals((tokens = parser.splitCurrentToken())[0])) {
            GradientUtils.Parser.checkNumberOfArguments(tokens, 2);
            centerX = parser.parsePoint(tokens[1]);
            centerY = parser.parsePoint(tokens[2]);
            parser.shift();
        } else {
            centerX = GradientUtils.Point.MIN;
            centerY = GradientUtils.Point.MIN;
        }
        tokens = parser.splitCurrentToken();
        if (!"radius".equals(tokens[0])) {
            throw new IllegalArgumentException("Invalid gradient specification: radius must be specified");
        }
        GradientUtils.Parser.checkNumberOfArguments(tokens, 1);
        GradientUtils.Point radius = parser.parsePoint(tokens[1]);
        parser.shift();
        CycleMethod method = CycleMethod.NO_CYCLE;
        String currentToken = parser.getCurrentToken();
        if ("repeat".equals(currentToken)) {
            method = CycleMethod.REPEAT;
            parser.shift();
        } else if ("reflect".equals(currentToken)) {
            method = CycleMethod.REFLECT;
            parser.shift();
        }
        Stop[] stops = parser.parseStops(radius.proportional, radius.value);
        return new RadialGradient(angle, distance, centerX.value, centerY.value, radius.value, radius.proportional, method, stops);
    }
}

