/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.shape;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.PickRay;
import com.sun.javafx.geom.Vec3d;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.scene.DirtyBits;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.scene.input.PickResultChooser;
import com.sun.javafx.scene.shape.BoxHelper;
import com.sun.javafx.sg.prism.NGBox;
import com.sun.javafx.sg.prism.NGNode;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.geometry.Point2D;
import javafx.geometry.Point3D;
import javafx.scene.Node;
import javafx.scene.shape.CullFace;
import javafx.scene.shape.Shape3D;
import javafx.scene.shape.TriangleMesh;

public class Box
extends Shape3D {
    private TriangleMesh mesh;
    public static final double DEFAULT_SIZE = 2.0;
    private DoubleProperty depth;
    private DoubleProperty height;
    private DoubleProperty width;

    public Box() {
        this(2.0, 2.0, 2.0);
    }

    public Box(double width, double height, double depth) {
        BoxHelper.initHelper(this);
        this.setWidth(width);
        this.setHeight(height);
        this.setDepth(depth);
    }

    public final void setDepth(double value) {
        this.depthProperty().set(value);
    }

    public final double getDepth() {
        return this.depth == null ? 2.0 : this.depth.get();
    }

    public final DoubleProperty depthProperty() {
        if (this.depth == null) {
            this.depth = new SimpleDoubleProperty(this, "depth", 2.0){

                public void invalidated() {
                    NodeHelper.markDirty(Box.this, DirtyBits.MESH_GEOM);
                    Box.this.manager.invalidateBoxMesh(Box.this.key);
                    Box.this.key = null;
                    NodeHelper.geomChanged(Box.this);
                }
            };
        }
        return this.depth;
    }

    public final void setHeight(double value) {
        this.heightProperty().set(value);
    }

    public final double getHeight() {
        return this.height == null ? 2.0 : this.height.get();
    }

    public final DoubleProperty heightProperty() {
        if (this.height == null) {
            this.height = new SimpleDoubleProperty(this, "height", 2.0){

                public void invalidated() {
                    NodeHelper.markDirty(Box.this, DirtyBits.MESH_GEOM);
                    Box.this.manager.invalidateBoxMesh(Box.this.key);
                    Box.this.key = null;
                    NodeHelper.geomChanged(Box.this);
                }
            };
        }
        return this.height;
    }

    public final void setWidth(double value) {
        this.widthProperty().set(value);
    }

    public final double getWidth() {
        return this.width == null ? 2.0 : this.width.get();
    }

    public final DoubleProperty widthProperty() {
        if (this.width == null) {
            this.width = new SimpleDoubleProperty(this, "width", 2.0){

                public void invalidated() {
                    NodeHelper.markDirty(Box.this, DirtyBits.MESH_GEOM);
                    Box.this.manager.invalidateBoxMesh(Box.this.key);
                    Box.this.key = null;
                    NodeHelper.geomChanged(Box.this);
                }
            };
        }
        return this.width;
    }

    private NGNode doCreatePeer() {
        return new NGBox();
    }

    private void doUpdatePeer() {
        if (NodeHelper.isDirty(this, DirtyBits.MESH_GEOM)) {
            NGBox peer = (NGBox)NodeHelper.getPeer(this);
            float w = (float)this.getWidth();
            float h = (float)this.getHeight();
            float d = (float)this.getDepth();
            if (w < 0.0f || h < 0.0f || d < 0.0f) {
                peer.updateMesh(null);
            } else {
                if (this.key == null) {
                    this.key = new BoxKey(w, h, d);
                }
                this.mesh = this.manager.getBoxMesh(w, h, d, this.key);
                this.mesh.updatePG();
                peer.updateMesh(this.mesh.getPGTriangleMesh());
            }
        }
    }

    private BaseBounds doComputeGeomBounds(BaseBounds bounds, BaseTransform tx) {
        float w = (float)this.getWidth();
        float h = (float)this.getHeight();
        float d = (float)this.getDepth();
        if (w < 0.0f || h < 0.0f || d < 0.0f) {
            return bounds.makeEmpty();
        }
        float hw = w * 0.5f;
        float hh = h * 0.5f;
        float hd = d * 0.5f;
        bounds = bounds.deriveWithNewBounds(-hw, -hh, -hd, hw, hh, hd);
        bounds = tx.transform(bounds, bounds);
        return bounds;
    }

    private boolean doComputeContains(double localX, double localY) {
        double w = this.getWidth();
        double h = this.getHeight();
        return -w <= localX && localX <= w && -h <= localY && localY <= h;
    }

    private boolean doComputeIntersects(PickRay pickRay, PickResultChooser pickResult) {
        double w = this.getWidth();
        double h = this.getHeight();
        double d = this.getDepth();
        double hWidth = w / 2.0;
        double hHeight = h / 2.0;
        double hDepth = d / 2.0;
        Vec3d dir = pickRay.getDirectionNoClone();
        double invDirX = dir.x == 0.0 ? Double.POSITIVE_INFINITY : 1.0 / dir.x;
        double invDirY = dir.y == 0.0 ? Double.POSITIVE_INFINITY : 1.0 / dir.y;
        double invDirZ = dir.z == 0.0 ? Double.POSITIVE_INFINITY : 1.0 / dir.z;
        Vec3d origin = pickRay.getOriginNoClone();
        double originX = origin.x;
        double originY = origin.y;
        double originZ = origin.z;
        boolean signX = invDirX < 0.0;
        boolean signY = invDirY < 0.0;
        boolean signZ = invDirZ < 0.0;
        double t0 = Double.NEGATIVE_INFINITY;
        double t1 = Double.POSITIVE_INFINITY;
        int side0 = 48;
        int side1 = 48;
        if (Double.isInfinite(invDirX)) {
            if (!(-hWidth <= originX) || !(hWidth >= originX)) {
                return false;
            }
        } else {
            t0 = ((signX ? hWidth : -hWidth) - originX) * invDirX;
            t1 = ((signX ? -hWidth : hWidth) - originX) * invDirX;
            side0 = signX ? 88 : 120;
            int n = side1 = signX ? 120 : 88;
        }
        if (Double.isInfinite(invDirY)) {
            if (!(-hHeight <= originY) || !(hHeight >= originY)) {
                return false;
            }
        } else {
            double ty0 = ((signY ? hHeight : -hHeight) - originY) * invDirY;
            double ty1 = ((signY ? -hHeight : hHeight) - originY) * invDirY;
            if (t0 > ty1 || ty0 > t1) {
                return false;
            }
            if (ty0 > t0) {
                side0 = signY ? 89 : 121;
                t0 = ty0;
            }
            if (ty1 < t1) {
                side1 = signY ? 121 : 89;
                t1 = ty1;
            }
        }
        if (Double.isInfinite(invDirZ)) {
            if (!(-hDepth <= originZ) || !(hDepth >= originZ)) {
                return false;
            }
        } else {
            double tz0 = ((signZ ? hDepth : -hDepth) - originZ) * invDirZ;
            double tz1 = ((signZ ? -hDepth : hDepth) - originZ) * invDirZ;
            if (t0 > tz1 || tz0 > t1) {
                return false;
            }
            if (tz0 > t0) {
                side0 = signZ ? 90 : 122;
                t0 = tz0;
            }
            if (tz1 < t1) {
                side1 = signZ ? 122 : 90;
                t1 = tz1;
            }
        }
        int side = side0;
        double t = t0;
        CullFace cullFace = this.getCullFace();
        double minDistance = pickRay.getNearClip();
        double maxDistance = pickRay.getFarClip();
        if (t0 > maxDistance) {
            return false;
        }
        if (t0 < minDistance || cullFace == CullFace.FRONT) {
            if (t1 >= minDistance && t1 <= maxDistance && cullFace != CullFace.BACK) {
                side = side1;
                t = t1;
            } else {
                return false;
            }
        }
        if (Double.isInfinite(t) || Double.isNaN(t)) {
            return false;
        }
        if (pickResult != null && pickResult.isCloser(t)) {
            Point3D point = PickResultChooser.computePoint(pickRay, t);
            Point2D txtCoords = null;
            switch (side) {
                case 120: {
                    txtCoords = new Point2D(0.5 - point.getZ() / d, 0.5 + point.getY() / h);
                    break;
                }
                case 88: {
                    txtCoords = new Point2D(0.5 + point.getZ() / d, 0.5 + point.getY() / h);
                    break;
                }
                case 121: {
                    txtCoords = new Point2D(0.5 + point.getX() / w, 0.5 - point.getZ() / d);
                    break;
                }
                case 89: {
                    txtCoords = new Point2D(0.5 + point.getX() / w, 0.5 + point.getZ() / d);
                    break;
                }
                case 122: {
                    txtCoords = new Point2D(0.5 + point.getX() / w, 0.5 + point.getY() / h);
                    break;
                }
                case 90: {
                    txtCoords = new Point2D(0.5 - point.getX() / w, 0.5 + point.getY() / h);
                    break;
                }
                default: {
                    return false;
                }
            }
            pickResult.offer(this, t, -1, point, txtCoords);
        }
        return true;
    }

    static TriangleMesh createMesh(float w, float h, float d) {
        float hw = w / 2.0f;
        float hh = h / 2.0f;
        float hd = d / 2.0f;
        float[] points = new float[]{-hw, -hh, -hd, hw, -hh, -hd, hw, hh, -hd, -hw, hh, -hd, -hw, -hh, hd, hw, -hh, hd, hw, hh, hd, -hw, hh, hd};
        float[] texCoords = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f};
        int[] faceSmoothingGroups = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        int[] faces = new int[]{0, 0, 2, 2, 1, 1, 2, 2, 0, 0, 3, 3, 1, 0, 6, 2, 5, 1, 6, 2, 1, 0, 2, 3, 5, 0, 7, 2, 4, 1, 7, 2, 5, 0, 6, 3, 4, 0, 3, 2, 0, 1, 3, 2, 4, 0, 7, 3, 3, 0, 6, 2, 2, 1, 6, 2, 3, 0, 7, 3, 4, 0, 1, 2, 5, 1, 1, 2, 4, 0, 0, 3};
        TriangleMesh mesh = new TriangleMesh(true);
        mesh.getPoints().setAll(points);
        mesh.getTexCoords().setAll(texCoords);
        mesh.getFaces().setAll(faces);
        mesh.getFaceSmoothingGroups().setAll(faceSmoothingGroups);
        return mesh;
    }

    static {
        BoxHelper.setBoxAccessor(new BoxHelper.BoxAccessor(){

            @Override
            public NGNode doCreatePeer(Node node) {
                return ((Box)node).doCreatePeer();
            }

            @Override
            public void doUpdatePeer(Node node) {
                ((Box)node).doUpdatePeer();
            }

            @Override
            public BaseBounds doComputeGeomBounds(Node node, BaseBounds bounds, BaseTransform tx) {
                return ((Box)node).doComputeGeomBounds(bounds, tx);
            }

            @Override
            public boolean doComputeContains(Node node, double localX, double localY) {
                return ((Box)node).doComputeContains(localX, localY);
            }

            @Override
            public boolean doComputeIntersects(Node node, PickRay pickRay, PickResultChooser pickResult) {
                return ((Box)node).doComputeIntersects(pickRay, pickResult);
            }
        });
    }

    private static class BoxKey
    extends Shape3D.Key {
        final double width;
        final double height;
        final double depth;

        private BoxKey(double width, double height, double depth) {
            this.width = width;
            this.height = height;
            this.depth = depth;
        }

        @Override
        public int hashCode() {
            long bits = 7L;
            bits = 31L * bits + Double.doubleToLongBits(this.depth);
            bits = 31L * bits + Double.doubleToLongBits(this.height);
            bits = 31L * bits + Double.doubleToLongBits(this.width);
            return Long.hashCode(bits);
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof BoxKey)) {
                return false;
            }
            BoxKey other = (BoxKey)obj;
            if (Double.compare(this.depth, other.depth) != 0) {
                return false;
            }
            if (Double.compare(this.height, other.height) != 0) {
                return false;
            }
            return Double.compare(this.width, other.width) == 0;
        }
    }
}

