/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.shape;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.PickRay;
import com.sun.javafx.geom.Vec3d;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.scene.DirtyBits;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.scene.input.PickResultChooser;
import com.sun.javafx.scene.shape.CylinderHelper;
import com.sun.javafx.scene.shape.MeshHelper;
import com.sun.javafx.sg.prism.NGCylinder;
import com.sun.javafx.sg.prism.NGNode;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.geometry.Point2D;
import javafx.geometry.Point3D;
import javafx.scene.Node;
import javafx.scene.shape.CullFace;
import javafx.scene.shape.Shape3D;
import javafx.scene.shape.TriangleMesh;
import javafx.scene.transform.Rotate;

public class Cylinder
extends Shape3D {
    static final int DEFAULT_DIVISIONS = 64;
    static final double DEFAULT_RADIUS = 1.0;
    static final double DEFAULT_HEIGHT = 2.0;
    private int divisions = 64;
    private TriangleMesh mesh;
    private DoubleProperty height;
    private DoubleProperty radius;

    public Cylinder() {
        this(1.0, 2.0, 64);
    }

    public Cylinder(double radius, double height) {
        this(radius, height, 64);
    }

    public Cylinder(double radius, double height, int divisions) {
        CylinderHelper.initHelper(this);
        this.divisions = divisions < 3 ? 3 : divisions;
        this.setRadius(radius);
        this.setHeight(height);
    }

    public final void setHeight(double value) {
        this.heightProperty().set(value);
    }

    public final double getHeight() {
        return this.height == null ? 2.0 : this.height.get();
    }

    public final DoubleProperty heightProperty() {
        if (this.height == null) {
            this.height = new SimpleDoubleProperty(this, "height", 2.0){

                public void invalidated() {
                    NodeHelper.markDirty(Cylinder.this, DirtyBits.MESH_GEOM);
                    Cylinder.this.manager.invalidateCylinderMesh(Cylinder.this.key);
                    Cylinder.this.key = null;
                    NodeHelper.geomChanged(Cylinder.this);
                }
            };
        }
        return this.height;
    }

    public final void setRadius(double value) {
        this.radiusProperty().set(value);
    }

    public final double getRadius() {
        return this.radius == null ? 1.0 : this.radius.get();
    }

    public final DoubleProperty radiusProperty() {
        if (this.radius == null) {
            this.radius = new SimpleDoubleProperty(this, "radius", 1.0){

                public void invalidated() {
                    NodeHelper.markDirty(Cylinder.this, DirtyBits.MESH_GEOM);
                    Cylinder.this.manager.invalidateCylinderMesh(Cylinder.this.key);
                    Cylinder.this.key = null;
                    NodeHelper.geomChanged(Cylinder.this);
                }
            };
        }
        return this.radius;
    }

    public int getDivisions() {
        return this.divisions;
    }

    private void doUpdatePeer() {
        if (NodeHelper.isDirty(this, DirtyBits.MESH_GEOM)) {
            NGCylinder peer = (NGCylinder)NodeHelper.getPeer(this);
            float h = (float)this.getHeight();
            float r = (float)this.getRadius();
            if (h < 0.0f || r < 0.0f) {
                peer.updateMesh(null);
            } else {
                if (this.key == null) {
                    this.key = new CylinderKey(h, r, this.divisions);
                }
                this.mesh = this.manager.getCylinderMesh(h, r, this.divisions, this.key);
                this.mesh.updatePG();
                peer.updateMesh(this.mesh.getPGTriangleMesh());
            }
        }
    }

    private NGNode doCreatePeer() {
        return new NGCylinder();
    }

    private BaseBounds doComputeGeomBounds(BaseBounds bounds, BaseTransform tx) {
        float h = (float)this.getHeight();
        float r = (float)this.getRadius();
        if (r < 0.0f || h < 0.0f) {
            return bounds.makeEmpty();
        }
        float hh = h * 0.5f;
        bounds = bounds.deriveWithNewBounds(-r, -hh, -r, r, hh, r);
        bounds = tx.transform(bounds, bounds);
        return bounds;
    }

    private boolean doComputeContains(double localX, double localY) {
        double w = this.getRadius();
        double hh = this.getHeight() * 0.5;
        return -w <= localX && localX <= w && -hh <= localY && localY <= hh;
    }

    private boolean doComputeIntersects(PickRay pickRay, PickResultChooser pickResult) {
        double t1;
        double t0;
        boolean exactPicking = this.divisions < 64 && this.mesh != null;
        double r = this.getRadius();
        Vec3d dir = pickRay.getDirectionNoClone();
        double dirX = dir.x;
        double dirY = dir.y;
        double dirZ = dir.z;
        Vec3d origin = pickRay.getOriginNoClone();
        double originX = origin.x;
        double originY = origin.y;
        double originZ = origin.z;
        double h = this.getHeight();
        double halfHeight = h / 2.0;
        CullFace cullFace = this.getCullFace();
        double a = dirX * dirX + dirZ * dirZ;
        double b = 2.0 * (dirX * originX + dirZ * originZ);
        double c = originX * originX + originZ * originZ - r * r;
        double discriminant = b * b - 4.0 * a * c;
        double t = Double.POSITIVE_INFINITY;
        double minDistance = pickRay.getNearClip();
        double maxDistance = pickRay.getFarClip();
        if (discriminant >= 0.0 && (dirX != 0.0 || dirZ != 0.0)) {
            double distSqrt = Math.sqrt(discriminant);
            double q = b < 0.0 ? (-b - distSqrt) / 2.0 : (-b + distSqrt) / 2.0;
            t0 = q / a;
            if (t0 > (t1 = c / q)) {
                double temp = t0;
                t0 = t1;
                t1 = temp;
            }
            double y0 = originY + t0 * dirY;
            if (t0 < minDistance || y0 < -halfHeight || y0 > halfHeight || cullFace == CullFace.FRONT) {
                double y1 = originY + t1 * dirY;
                if (t1 >= minDistance && t1 <= maxDistance && y1 >= -halfHeight && y1 <= halfHeight && (cullFace != CullFace.BACK || exactPicking)) {
                    t = t1;
                }
            } else if (t0 <= maxDistance) {
                t = t0;
            }
        }
        boolean topCap = false;
        boolean bottomCap = false;
        if (t == Double.POSITIVE_INFINITY || !exactPicking) {
            double tZ;
            double tX;
            double tBottom = (-halfHeight - originY) / dirY;
            double tTop = (halfHeight - originY) / dirY;
            boolean isT0Bottom = false;
            if (tBottom < tTop) {
                t0 = tBottom;
                t1 = tTop;
                isT0Bottom = true;
            } else {
                t0 = tTop;
                t1 = tBottom;
            }
            if (t0 >= minDistance && t0 <= maxDistance && t0 < t && cullFace != CullFace.FRONT && (tX = originX + dirX * t0) * tX + (tZ = originZ + dirZ * t0) * tZ <= r * r) {
                bottomCap = isT0Bottom;
                topCap = !isT0Bottom;
                t = t0;
            }
            if (t1 >= minDistance && t1 <= maxDistance && t1 < t && (cullFace != CullFace.BACK || exactPicking) && (tX = originX + dirX * t1) * tX + (tZ = originZ + dirZ * t1) * tZ <= r * r) {
                topCap = isT0Bottom;
                bottomCap = !isT0Bottom;
                t = t1;
            }
        }
        if (Double.isInfinite(t) || Double.isNaN(t)) {
            return false;
        }
        if (exactPicking) {
            return MeshHelper.computeIntersects(this.mesh, pickRay, pickResult, this, cullFace, false);
        }
        if (pickResult != null && pickResult.isCloser(t)) {
            Point2D txCoords;
            Point3D point = PickResultChooser.computePoint(pickRay, t);
            if (topCap) {
                txCoords = new Point2D(0.5 + point.getX() / (2.0 * r), 0.5 + point.getZ() / (2.0 * r));
            } else if (bottomCap) {
                txCoords = new Point2D(0.5 + point.getX() / (2.0 * r), 0.5 - point.getZ() / (2.0 * r));
            } else {
                Point3D proj = new Point3D(point.getX(), 0.0, point.getZ());
                Point3D cross = proj.crossProduct(Rotate.Z_AXIS);
                double angle = proj.angle(Rotate.Z_AXIS);
                if (cross.getY() > 0.0) {
                    angle = 360.0 - angle;
                }
                txCoords = new Point2D(1.0 - angle / 360.0, 0.5 + point.getY() / h);
            }
            pickResult.offer(this, t, -1, point, txCoords);
        }
        return true;
    }

    static TriangleMesh createMesh(int div, float h, float r) {
        int i;
        int t2;
        int t0;
        int p2;
        int p0;
        double a;
        int i2;
        int nPonits = div * 2 + 2;
        int tcCount = (div + 1) * 4 + 1;
        int faceCount = div * 4;
        float textureDelta = 0.00390625f;
        float dA = 1.0f / (float)div;
        h *= 0.5f;
        float[] points = new float[nPonits * 3];
        float[] tPoints = new float[tcCount * 2];
        int[] faces = new int[faceCount * 6];
        int[] smoothing = new int[faceCount];
        int pPos = 0;
        int tPos = 0;
        for (i2 = 0; i2 < div; ++i2) {
            a = (double)(dA * (float)i2 * 2.0f) * Math.PI;
            points[pPos + 0] = (float)(Math.sin(a) * (double)r);
            points[pPos + 2] = (float)(Math.cos(a) * (double)r);
            points[pPos + 1] = h;
            tPoints[tPos + 0] = 1.0f - dA * (float)i2;
            tPoints[tPos + 1] = 1.0f - textureDelta;
            pPos += 3;
            tPos += 2;
        }
        tPoints[tPos + 0] = 0.0f;
        tPoints[tPos + 1] = 1.0f - textureDelta;
        tPos += 2;
        for (i2 = 0; i2 < div; ++i2) {
            a = (double)(dA * (float)i2 * 2.0f) * Math.PI;
            points[pPos + 0] = (float)(Math.sin(a) * (double)r);
            points[pPos + 2] = (float)(Math.cos(a) * (double)r);
            points[pPos + 1] = -h;
            tPoints[tPos + 0] = 1.0f - dA * (float)i2;
            tPoints[tPos + 1] = textureDelta;
            pPos += 3;
            tPos += 2;
        }
        tPoints[tPos + 0] = 0.0f;
        tPoints[tPos + 1] = textureDelta;
        tPos += 2;
        points[pPos + 0] = 0.0f;
        points[pPos + 1] = h;
        points[pPos + 2] = 0.0f;
        points[pPos + 3] = 0.0f;
        points[pPos + 4] = -h;
        points[pPos + 5] = 0.0f;
        pPos += 6;
        for (i2 = 0; i2 <= div; ++i2) {
            a = i2 < div ? (double)(dA * (float)i2 * 2.0f) * Math.PI : 0.0;
            tPoints[tPos + 0] = (float)(Math.sin(a) * 0.5) + 0.5f;
            tPoints[tPos + 1] = (float)(Math.cos(a) * 0.5) + 0.5f;
            tPos += 2;
        }
        for (i2 = 0; i2 <= div; ++i2) {
            a = i2 < div ? (double)(dA * (float)i2 * 2.0f) * Math.PI : 0.0;
            tPoints[tPos + 0] = 0.5f + (float)(Math.sin(a) * 0.5);
            tPoints[tPos + 1] = 0.5f - (float)(Math.cos(a) * 0.5);
            tPos += 2;
        }
        tPoints[tPos + 0] = 0.5f;
        tPoints[tPos + 1] = 0.5f;
        tPos += 2;
        int fIndex = 0;
        for (int p02 = 0; p02 < div; ++p02) {
            int p1 = p02 + 1;
            int p22 = p02 + div;
            int p3 = p1 + div;
            faces[fIndex + 0] = p02;
            faces[fIndex + 1] = p02;
            faces[fIndex + 2] = p22;
            faces[fIndex + 3] = p22 + 1;
            faces[fIndex + 4] = p1 == div ? 0 : p1;
            faces[fIndex + 5] = p1;
            faces[(fIndex += 6) + 0] = p3 % div == 0 ? p3 - div : p3;
            faces[fIndex + 1] = p3 + 1;
            faces[fIndex + 2] = p1 == div ? 0 : p1;
            faces[fIndex + 3] = p1;
            faces[fIndex + 4] = p22;
            faces[fIndex + 5] = p22 + 1;
            fIndex += 6;
        }
        int tStart = (div + 1) * 2;
        int t1 = (div + 1) * 4;
        int p1 = div * 2;
        for (p0 = 0; p0 < div; ++p0) {
            p2 = p0 + 1;
            t0 = tStart + p0;
            t2 = t0 + 1;
            faces[fIndex + 0] = p0;
            faces[fIndex + 1] = t0;
            faces[fIndex + 2] = p2 == div ? 0 : p2;
            faces[fIndex + 3] = t2;
            faces[fIndex + 4] = p1;
            faces[fIndex + 5] = t1;
            fIndex += 6;
        }
        p1 = div * 2 + 1;
        tStart = (div + 1) * 3;
        for (p0 = 0; p0 < div; ++p0) {
            p2 = p0 + 1 + div;
            t0 = tStart + p0;
            t2 = t0 + 1;
            faces[fIndex + 0] = p0 + div;
            faces[fIndex + 1] = t0;
            faces[fIndex + 2] = p1;
            faces[fIndex + 3] = t1;
            faces[fIndex + 4] = p2 % div == 0 ? p2 - div : p2;
            faces[fIndex + 5] = t2;
            fIndex += 6;
        }
        for (i = 0; i < div * 2; ++i) {
            smoothing[i] = 1;
        }
        for (i = div * 2; i < div * 4; ++i) {
            smoothing[i] = 2;
        }
        TriangleMesh m = new TriangleMesh(true);
        m.getPoints().setAll(points);
        m.getTexCoords().setAll(tPoints);
        m.getFaces().setAll(faces);
        m.getFaceSmoothingGroups().setAll(smoothing);
        return m;
    }

    static {
        CylinderHelper.setCylinderAccessor(new CylinderHelper.CylinderAccessor(){

            @Override
            public NGNode doCreatePeer(Node node) {
                return ((Cylinder)node).doCreatePeer();
            }

            @Override
            public void doUpdatePeer(Node node) {
                ((Cylinder)node).doUpdatePeer();
            }

            @Override
            public BaseBounds doComputeGeomBounds(Node node, BaseBounds bounds, BaseTransform tx) {
                return ((Cylinder)node).doComputeGeomBounds(bounds, tx);
            }

            @Override
            public boolean doComputeContains(Node node, double localX, double localY) {
                return ((Cylinder)node).doComputeContains(localX, localY);
            }

            @Override
            public boolean doComputeIntersects(Node node, PickRay pickRay, PickResultChooser pickResult) {
                return ((Cylinder)node).doComputeIntersects(pickRay, pickResult);
            }
        });
    }

    private static class CylinderKey
    extends Shape3D.Key {
        final double radius;
        final double height;
        final int divisions;

        private CylinderKey(double radius, double height, int divisions) {
            this.radius = radius;
            this.height = height;
            this.divisions = divisions;
        }

        @Override
        public int hashCode() {
            long bits = 7L;
            bits = 31L * bits + Double.doubleToLongBits(this.radius);
            bits = 31L * bits + Double.doubleToLongBits(this.height);
            bits = 31L * bits + (long)this.divisions;
            return Long.hashCode(bits);
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof CylinderKey)) {
                return false;
            }
            CylinderKey other = (CylinderKey)obj;
            if (this.divisions != other.divisions) {
                return false;
            }
            if (Double.compare(this.radius, other.radius) != 0) {
                return false;
            }
            return Double.compare(this.height, other.height) == 0;
        }
    }
}

