/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.text;

import com.sun.javafx.scene.text.FontHelper;
import com.sun.javafx.tk.Toolkit;
import java.io.File;
import java.io.FilePermission;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import javafx.beans.NamedArg;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;

public final class Font {
    private static final String DEFAULT_FAMILY = "System";
    private static final String DEFAULT_FULLNAME = "System Regular";
    private static float defaultSystemFontSize;
    private static Font DEFAULT;
    private String name;
    private String family;
    private String style;
    private double size;
    private int hash = 0;
    private Object nativeFont;

    private static float getDefaultSystemFontSize() {
        if (defaultSystemFontSize == -1.0f) {
            defaultSystemFontSize = Toolkit.getToolkit().getFontLoader().getSystemFontSize();
        }
        return defaultSystemFontSize;
    }

    public static synchronized Font getDefault() {
        if (DEFAULT == null) {
            DEFAULT = new Font(DEFAULT_FULLNAME, Font.getDefaultSystemFontSize());
        }
        return DEFAULT;
    }

    public static List<String> getFamilies() {
        return Toolkit.getToolkit().getFontLoader().getFamilies();
    }

    public static List<String> getFontNames() {
        return Toolkit.getToolkit().getFontLoader().getFontNames();
    }

    public static List<String> getFontNames(String family) {
        return Toolkit.getToolkit().getFontLoader().getFontNames(family);
    }

    public static Font font(String family, FontWeight weight, FontPosture posture, double size) {
        String fam = family == null || "".equals(family) ? DEFAULT_FAMILY : family;
        double sz = size < 0.0 ? (double)Font.getDefaultSystemFontSize() : size;
        return Toolkit.getToolkit().getFontLoader().font(fam, weight, posture, (float)sz);
    }

    public static Font font(String family, FontWeight weight, double size) {
        return Font.font(family, weight, null, size);
    }

    public static Font font(String family, FontPosture posture, double size) {
        return Font.font(family, null, posture, size);
    }

    public static Font font(String family, double size) {
        return Font.font(family, null, null, size);
    }

    public static Font font(String family) {
        return Font.font(family, null, null, -1.0);
    }

    public static Font font(double size) {
        return Font.font(null, null, null, size);
    }

    public final String getName() {
        return this.name;
    }

    public final String getFamily() {
        return this.family;
    }

    public final String getStyle() {
        return this.style;
    }

    public final double getSize() {
        return this.size;
    }

    public Font(@NamedArg(value="size") double size) {
        this(null, size);
    }

    public Font(@NamedArg(value="name") String name, @NamedArg(value="size") double size) {
        this.name = name;
        this.size = size;
        if (name == null || "".equals(name)) {
            this.name = DEFAULT_FULLNAME;
        }
        if (size < 0.0) {
            this.size = Font.getDefaultSystemFontSize();
        }
        Toolkit.getToolkit().getFontLoader().loadFont(this);
    }

    private Font(Object f, String family, String name, String style, double size) {
        this.nativeFont = f;
        this.family = family;
        this.name = name;
        this.style = style;
        this.size = size;
    }

    public static Font loadFont(String urlStr, double size) {
        Font[] fonts = Font.loadFontInternal(urlStr, size, false);
        return fonts == null ? null : fonts[0];
    }

    public static Font[] loadFonts(String urlStr, double size) {
        return Font.loadFontInternal(urlStr, size, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Font[] loadFontInternal(String urlStr, double size, boolean loadAll) {
        URL url = null;
        try {
            url = new URL(urlStr);
        }
        catch (Exception e) {
            return null;
        }
        if (size <= 0.0) {
            size = Font.getDefaultSystemFontSize();
        }
        if (url.getProtocol().equals("file")) {
            String path = url.getFile();
            path = new File(path).getPath();
            try {
                SecurityManager sm = System.getSecurityManager();
                if (sm != null) {
                    FilePermission filePermission = new FilePermission(path, "read");
                    sm.checkPermission(filePermission);
                }
            }
            catch (Exception e) {
                return null;
            }
            return Toolkit.getToolkit().getFontLoader().loadFont(path, size, loadAll);
        }
        Font[] fonts = null;
        URLConnection connection = null;
        InputStream in = null;
        try {
            connection = url.openConnection();
            in = connection.getInputStream();
            fonts = Toolkit.getToolkit().getFontLoader().loadFont(in, size, loadAll);
        }
        catch (Exception e) {
            Font[] fontArray = null;
            return fontArray;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
        }
        return fonts;
    }

    public static Font loadFont(InputStream in, double size) {
        Font[] fonts;
        if (size <= 0.0) {
            size = Font.getDefaultSystemFontSize();
        }
        return (fonts = Toolkit.getToolkit().getFontLoader().loadFont(in, size, false)) == null ? null : fonts[0];
    }

    public static Font[] loadFonts(InputStream in, double size) {
        Font[] fonts;
        if (size <= 0.0) {
            size = Font.getDefaultSystemFontSize();
        }
        return (fonts = Toolkit.getToolkit().getFontLoader().loadFont(in, size, true)) == null ? null : fonts;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Font[name=");
        builder = builder.append(this.name);
        builder = builder.append(", family=").append(this.family);
        builder = builder.append(", style=").append(this.style);
        builder = builder.append(", size=").append(this.size);
        builder = builder.append("]");
        return builder.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Font) {
            Font other = (Font)obj;
            return (this.name == null ? other.name == null : this.name.equals(other.name)) && this.size == other.size;
        }
        return false;
    }

    public int hashCode() {
        if (this.hash == 0) {
            long bits = 17L;
            bits = 37L * bits + (long)this.name.hashCode();
            bits = 37L * bits + Double.doubleToLongBits(this.size);
            this.hash = (int)(bits ^ bits >> 32);
        }
        return this.hash;
    }

    Object getNativeFont() {
        return this.nativeFont;
    }

    void setNativeFont(Object f, String nam, String fam, String styl) {
        this.nativeFont = f;
        this.name = nam;
        this.family = fam;
        this.style = styl;
    }

    static Font nativeFont(Object f, String name, String family, String style, double size) {
        Font retFont = new Font(f, family, name, style, size);
        return retFont;
    }

    static {
        FontHelper.setFontAccessor(new FontHelper.FontAccessor(){

            @Override
            public Object getNativeFont(Font font) {
                return font.getNativeFont();
            }

            @Override
            public void setNativeFont(Font font, Object f, String nam, String fam, String styl) {
                font.setNativeFont(f, nam, fam, styl);
            }

            @Override
            public Font nativeFont(Object f, String name, String family, String style, double size) {
                return Font.nativeFont(f, name, family, style, size);
            }
        });
        defaultSystemFontSize = -1.0f;
    }
}

