/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.transform;

import com.sun.javafx.geom.transform.Affine3D;
import com.sun.javafx.geom.transform.BaseTransform;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.geometry.Point2D;
import javafx.geometry.Point3D;
import javafx.scene.transform.MatrixType;
import javafx.scene.transform.NonInvertibleTransformException;
import javafx.scene.transform.Transform;

public class Affine
extends Transform {
    AffineAtomicChange atomicChange = new AffineAtomicChange();
    private static final int APPLY_IDENTITY = 0;
    private static final int APPLY_TRANSLATE = 1;
    private static final int APPLY_SCALE = 2;
    private static final int APPLY_SHEAR = 4;
    private static final int APPLY_NON_3D = 0;
    private static final int APPLY_3D_COMPLEX = 4;
    private transient int state2d;
    private transient int state3d;
    private double xx;
    private double xy;
    private double xz;
    private double yx;
    private double yy;
    private double yz;
    private double zx;
    private double zy;
    private double zz;
    private double xt;
    private double yt;
    private double zt;
    private AffineElementProperty mxx;
    private AffineElementProperty mxy;
    private AffineElementProperty mxz;
    private AffineElementProperty tx;
    private AffineElementProperty myx;
    private AffineElementProperty myy;
    private AffineElementProperty myz;
    private AffineElementProperty ty;
    private AffineElementProperty mzx;
    private AffineElementProperty mzy;
    private AffineElementProperty mzz;
    private AffineElementProperty tz;
    private static final int[] rot90conversion = new int[]{4, 5, 4, 5, 2, 3, 6, 7};

    public Affine() {
        this.zz = 1.0;
        this.yy = 1.0;
        this.xx = 1.0;
    }

    public Affine(Transform transform) {
        this(transform.getMxx(), transform.getMxy(), transform.getMxz(), transform.getTx(), transform.getMyx(), transform.getMyy(), transform.getMyz(), transform.getTy(), transform.getMzx(), transform.getMzy(), transform.getMzz(), transform.getTz());
    }

    public Affine(double mxx, double mxy, double tx, double myx, double myy, double ty) {
        this.xx = mxx;
        this.xy = mxy;
        this.xt = tx;
        this.yx = myx;
        this.yy = myy;
        this.yt = ty;
        this.zz = 1.0;
        this.updateState2D();
    }

    public Affine(double mxx, double mxy, double mxz, double tx, double myx, double myy, double myz, double ty, double mzx, double mzy, double mzz, double tz) {
        this.xx = mxx;
        this.xy = mxy;
        this.xz = mxz;
        this.xt = tx;
        this.yx = myx;
        this.yy = myy;
        this.yz = myz;
        this.yt = ty;
        this.zx = mzx;
        this.zy = mzy;
        this.zz = mzz;
        this.zt = tz;
        this.updateState();
    }

    public Affine(double[] matrix, MatrixType type, int offset) {
        if (matrix.length < offset + type.elements()) {
            throw new IndexOutOfBoundsException("The array is too short.");
        }
        switch (type) {
            default: {
                Affine.stateError();
            }
            case MT_2D_3x3: {
                if (matrix[offset + 6] != 0.0 || matrix[offset + 7] != 0.0 || matrix[offset + 8] != 1.0) {
                    throw new IllegalArgumentException("The matrix is not affine");
                }
            }
            case MT_2D_2x3: {
                this.xx = matrix[offset++];
                this.xy = matrix[offset++];
                this.xt = matrix[offset++];
                this.yx = matrix[offset++];
                this.yy = matrix[offset++];
                this.yt = matrix[offset];
                this.zz = 1.0;
                this.updateState2D();
                return;
            }
            case MT_3D_4x4: {
                if (matrix[offset + 12] == 0.0 && matrix[offset + 13] == 0.0 && matrix[offset + 14] == 0.0 && matrix[offset + 15] == 1.0) break;
                throw new IllegalArgumentException("The matrix is not affine");
            }
            case MT_3D_3x4: 
        }
        this.xx = matrix[offset++];
        this.xy = matrix[offset++];
        this.xz = matrix[offset++];
        this.xt = matrix[offset++];
        this.yx = matrix[offset++];
        this.yy = matrix[offset++];
        this.yz = matrix[offset++];
        this.yt = matrix[offset++];
        this.zx = matrix[offset++];
        this.zy = matrix[offset++];
        this.zz = matrix[offset++];
        this.zt = matrix[offset];
        this.updateState();
    }

    public final void setMxx(double value) {
        if (this.mxx == null) {
            if (this.xx != value) {
                this.xx = value;
                this.postProcessChange();
            }
        } else {
            this.mxxProperty().set(value);
        }
    }

    @Override
    public final double getMxx() {
        return this.mxx == null ? this.xx : this.mxx.get();
    }

    public final DoubleProperty mxxProperty() {
        if (this.mxx == null) {
            this.mxx = new AffineElementProperty(this.xx){

                public Object getBean() {
                    return Affine.this;
                }

                public String getName() {
                    return "mxx";
                }
            };
        }
        return this.mxx;
    }

    public final void setMxy(double value) {
        if (this.mxy == null) {
            if (this.xy != value) {
                this.xy = value;
                this.postProcessChange();
            }
        } else {
            this.mxyProperty().set(value);
        }
    }

    @Override
    public final double getMxy() {
        return this.mxy == null ? this.xy : this.mxy.get();
    }

    public final DoubleProperty mxyProperty() {
        if (this.mxy == null) {
            this.mxy = new AffineElementProperty(this.xy){

                public Object getBean() {
                    return Affine.this;
                }

                public String getName() {
                    return "mxy";
                }
            };
        }
        return this.mxy;
    }

    public final void setMxz(double value) {
        if (this.mxz == null) {
            if (this.xz != value) {
                this.xz = value;
                this.postProcessChange();
            }
        } else {
            this.mxzProperty().set(value);
        }
    }

    @Override
    public final double getMxz() {
        return this.mxz == null ? this.xz : this.mxz.get();
    }

    public final DoubleProperty mxzProperty() {
        if (this.mxz == null) {
            this.mxz = new AffineElementProperty(this.xz){

                public Object getBean() {
                    return Affine.this;
                }

                public String getName() {
                    return "mxz";
                }
            };
        }
        return this.mxz;
    }

    public final void setTx(double value) {
        if (this.tx == null) {
            if (this.xt != value) {
                this.xt = value;
                this.postProcessChange();
            }
        } else {
            this.txProperty().set(value);
        }
    }

    @Override
    public final double getTx() {
        return this.tx == null ? this.xt : this.tx.get();
    }

    public final DoubleProperty txProperty() {
        if (this.tx == null) {
            this.tx = new AffineElementProperty(this.xt){

                public Object getBean() {
                    return Affine.this;
                }

                public String getName() {
                    return "tx";
                }
            };
        }
        return this.tx;
    }

    public final void setMyx(double value) {
        if (this.myx == null) {
            if (this.yx != value) {
                this.yx = value;
                this.postProcessChange();
            }
        } else {
            this.myxProperty().set(value);
        }
    }

    @Override
    public final double getMyx() {
        return this.myx == null ? this.yx : this.myx.get();
    }

    public final DoubleProperty myxProperty() {
        if (this.myx == null) {
            this.myx = new AffineElementProperty(this.yx){

                public Object getBean() {
                    return Affine.this;
                }

                public String getName() {
                    return "myx";
                }
            };
        }
        return this.myx;
    }

    public final void setMyy(double value) {
        if (this.myy == null) {
            if (this.yy != value) {
                this.yy = value;
                this.postProcessChange();
            }
        } else {
            this.myyProperty().set(value);
        }
    }

    @Override
    public final double getMyy() {
        return this.myy == null ? this.yy : this.myy.get();
    }

    public final DoubleProperty myyProperty() {
        if (this.myy == null) {
            this.myy = new AffineElementProperty(this.yy){

                public Object getBean() {
                    return Affine.this;
                }

                public String getName() {
                    return "myy";
                }
            };
        }
        return this.myy;
    }

    public final void setMyz(double value) {
        if (this.myz == null) {
            if (this.yz != value) {
                this.yz = value;
                this.postProcessChange();
            }
        } else {
            this.myzProperty().set(value);
        }
    }

    @Override
    public final double getMyz() {
        return this.myz == null ? this.yz : this.myz.get();
    }

    public final DoubleProperty myzProperty() {
        if (this.myz == null) {
            this.myz = new AffineElementProperty(this.yz){

                public Object getBean() {
                    return Affine.this;
                }

                public String getName() {
                    return "myz";
                }
            };
        }
        return this.myz;
    }

    public final void setTy(double value) {
        if (this.ty == null) {
            if (this.yt != value) {
                this.yt = value;
                this.postProcessChange();
            }
        } else {
            this.tyProperty().set(value);
        }
    }

    @Override
    public final double getTy() {
        return this.ty == null ? this.yt : this.ty.get();
    }

    public final DoubleProperty tyProperty() {
        if (this.ty == null) {
            this.ty = new AffineElementProperty(this.yt){

                public Object getBean() {
                    return Affine.this;
                }

                public String getName() {
                    return "ty";
                }
            };
        }
        return this.ty;
    }

    public final void setMzx(double value) {
        if (this.mzx == null) {
            if (this.zx != value) {
                this.zx = value;
                this.postProcessChange();
            }
        } else {
            this.mzxProperty().set(value);
        }
    }

    @Override
    public final double getMzx() {
        return this.mzx == null ? this.zx : this.mzx.get();
    }

    public final DoubleProperty mzxProperty() {
        if (this.mzx == null) {
            this.mzx = new AffineElementProperty(this.zx){

                public Object getBean() {
                    return Affine.this;
                }

                public String getName() {
                    return "mzx";
                }
            };
        }
        return this.mzx;
    }

    public final void setMzy(double value) {
        if (this.mzy == null) {
            if (this.zy != value) {
                this.zy = value;
                this.postProcessChange();
            }
        } else {
            this.mzyProperty().set(value);
        }
    }

    @Override
    public final double getMzy() {
        return this.mzy == null ? this.zy : this.mzy.get();
    }

    public final DoubleProperty mzyProperty() {
        if (this.mzy == null) {
            this.mzy = new AffineElementProperty(this.zy){

                public Object getBean() {
                    return Affine.this;
                }

                public String getName() {
                    return "mzy";
                }
            };
        }
        return this.mzy;
    }

    public final void setMzz(double value) {
        if (this.mzz == null) {
            if (this.zz != value) {
                this.zz = value;
                this.postProcessChange();
            }
        } else {
            this.mzzProperty().set(value);
        }
    }

    @Override
    public final double getMzz() {
        return this.mzz == null ? this.zz : this.mzz.get();
    }

    public final DoubleProperty mzzProperty() {
        if (this.mzz == null) {
            this.mzz = new AffineElementProperty(this.zz){

                public Object getBean() {
                    return Affine.this;
                }

                public String getName() {
                    return "mzz";
                }
            };
        }
        return this.mzz;
    }

    public final void setTz(double value) {
        if (this.tz == null) {
            if (this.zt != value) {
                this.zt = value;
                this.postProcessChange();
            }
        } else {
            this.tzProperty().set(value);
        }
    }

    @Override
    public final double getTz() {
        return this.tz == null ? this.zt : this.tz.get();
    }

    public final DoubleProperty tzProperty() {
        if (this.tz == null) {
            this.tz = new AffineElementProperty(this.zt){

                public Object getBean() {
                    return Affine.this;
                }

                public String getName() {
                    return "tz";
                }
            };
        }
        return this.tz;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setElement(MatrixType type, int row, int column, double value) {
        if (row < 0 || row >= type.rows() || column < 0 || column >= type.columns()) {
            throw new IndexOutOfBoundsException("Index outside of affine matrix " + type + ": [" + row + ", " + column + "]");
        }
        switch (type) {
            default: {
                Affine.stateError();
            }
            case MT_2D_3x3: 
            case MT_2D_2x3: {
                if (!this.isType2D()) {
                    throw new IllegalArgumentException("Cannot access 2D matrix of a 3D transform");
                }
                switch (row) {
                    case 0: {
                        switch (column) {
                            case 0: {
                                this.setMxx(value);
                                return;
                            }
                            case 1: {
                                this.setMxy(value);
                                return;
                            }
                            case 2: {
                                this.setTx(value);
                                return;
                            }
                        }
                    }
                    case 1: {
                        switch (column) {
                            case 0: {
                                this.setMyx(value);
                                return;
                            }
                            case 1: {
                                this.setMyy(value);
                                return;
                            }
                            case 2: {
                                this.setTy(value);
                                return;
                            }
                        }
                    }
                    case 2: {
                        switch (column) {
                            case 0: {
                                if (value != 0.0) throw new IllegalArgumentException("Cannot set affine matrix " + type + " element [" + row + ", " + column + "] to " + value);
                                return;
                            }
                            case 1: {
                                if (value != 0.0) throw new IllegalArgumentException("Cannot set affine matrix " + type + " element [" + row + ", " + column + "] to " + value);
                                return;
                            }
                            case 2: {
                                if (value != 1.0) throw new IllegalArgumentException("Cannot set affine matrix " + type + " element [" + row + ", " + column + "] to " + value);
                                return;
                            }
                        }
                    }
                }
                throw new IllegalArgumentException("Cannot set affine matrix " + type + " element [" + row + ", " + column + "] to " + value);
            }
            case MT_3D_4x4: 
            case MT_3D_3x4: {
                switch (row) {
                    case 0: {
                        switch (column) {
                            case 0: {
                                this.setMxx(value);
                                return;
                            }
                            case 1: {
                                this.setMxy(value);
                                return;
                            }
                            case 2: {
                                this.setMxz(value);
                                return;
                            }
                            case 3: {
                                this.setTx(value);
                                return;
                            }
                        }
                    }
                    case 1: {
                        switch (column) {
                            case 0: {
                                this.setMyx(value);
                                return;
                            }
                            case 1: {
                                this.setMyy(value);
                                return;
                            }
                            case 2: {
                                this.setMyz(value);
                                return;
                            }
                            case 3: {
                                this.setTy(value);
                                return;
                            }
                        }
                    }
                    case 2: {
                        switch (column) {
                            case 0: {
                                this.setMzx(value);
                                return;
                            }
                            case 1: {
                                this.setMzy(value);
                                return;
                            }
                            case 2: {
                                this.setMzz(value);
                                return;
                            }
                            case 3: {
                                this.setTz(value);
                                return;
                            }
                        }
                    }
                    case 3: {
                        switch (column) {
                            case 0: {
                                if (value != 0.0) throw new IllegalArgumentException("Cannot set affine matrix " + type + " element [" + row + ", " + column + "] to " + value);
                                return;
                            }
                            case 1: {
                                if (value != 0.0) throw new IllegalArgumentException("Cannot set affine matrix " + type + " element [" + row + ", " + column + "] to " + value);
                                return;
                            }
                            case 2: {
                                if (value != 0.0) throw new IllegalArgumentException("Cannot set affine matrix " + type + " element [" + row + ", " + column + "] to " + value);
                                return;
                            }
                            case 3: {
                                if (value != 1.0) throw new IllegalArgumentException("Cannot set affine matrix " + type + " element [" + row + ", " + column + "] to " + value);
                                return;
                            }
                        }
                    }
                }
            }
        }
        throw new IllegalArgumentException("Cannot set affine matrix " + type + " element [" + row + ", " + column + "] to " + value);
    }

    private void postProcessChange() {
        if (!this.atomicChange.runs()) {
            this.updateState();
            this.transformChanged();
        }
    }

    @Override
    boolean computeIs2D() {
        return this.state3d == 0;
    }

    @Override
    boolean computeIsIdentity() {
        return this.state3d == 0 && this.state2d == 0;
    }

    @Override
    public double determinant() {
        if (this.state3d == 0) {
            return this.getDeterminant2D();
        }
        return this.getDeterminant3D();
    }

    private double getDeterminant2D() {
        switch (this.state2d) {
            default: {
                Affine.stateError();
            }
            case 6: 
            case 7: {
                return this.getMxx() * this.getMyy() - this.getMxy() * this.getMyx();
            }
            case 4: 
            case 5: {
                return -(this.getMxy() * this.getMyx());
            }
            case 2: 
            case 3: {
                return this.getMxx() * this.getMyy();
            }
            case 0: 
            case 1: 
        }
        return 1.0;
    }

    private double getDeterminant3D() {
        switch (this.state3d) {
            default: {
                Affine.stateError();
            }
            case 1: {
                return 1.0;
            }
            case 2: 
            case 3: {
                return this.getMxx() * this.getMyy() * this.getMzz();
            }
            case 4: 
        }
        double myx = this.getMyx();
        double myy = this.getMyy();
        double myz = this.getMyz();
        double mzx = this.getMzx();
        double mzy = this.getMzy();
        double mzz = this.getMzz();
        return this.getMxx() * (myy * mzz - mzy * myz) + this.getMxy() * (myz * mzx - mzz * myx) + this.getMxz() * (myx * mzy - mzx * myy);
    }

    @Override
    public Transform createConcatenation(Transform transform) {
        Affine a = this.clone();
        a.append(transform);
        return a;
    }

    @Override
    public Affine createInverse() throws NonInvertibleTransformException {
        Affine t = this.clone();
        t.invert();
        return t;
    }

    @Override
    public Affine clone() {
        return new Affine(this);
    }

    public void setToTransform(Transform transform) {
        this.setToTransform(transform.getMxx(), transform.getMxy(), transform.getMxz(), transform.getTx(), transform.getMyx(), transform.getMyy(), transform.getMyz(), transform.getTy(), transform.getMzx(), transform.getMzy(), transform.getMzz(), transform.getTz());
    }

    public void setToTransform(double mxx, double mxy, double tx, double myx, double myy, double ty) {
        this.setToTransform(mxx, mxy, 0.0, tx, myx, myy, 0.0, ty, 0.0, 0.0, 1.0, 0.0);
    }

    public void setToTransform(double mxx, double mxy, double mxz, double tx, double myx, double myy, double myz, double ty, double mzx, double mzy, double mzz, double tz) {
        this.atomicChange.start();
        this.setMxx(mxx);
        this.setMxy(mxy);
        this.setMxz(mxz);
        this.setTx(tx);
        this.setMyx(myx);
        this.setMyy(myy);
        this.setMyz(myz);
        this.setTy(ty);
        this.setMzx(mzx);
        this.setMzy(mzy);
        this.setMzz(mzz);
        this.setTz(tz);
        this.updateState();
        this.atomicChange.end();
    }

    public void setToTransform(double[] matrix, MatrixType type, int offset) {
        if (matrix.length < offset + type.elements()) {
            throw new IndexOutOfBoundsException("The array is too short.");
        }
        switch (type) {
            default: {
                Affine.stateError();
            }
            case MT_2D_3x3: {
                if (matrix[offset + 6] != 0.0 || matrix[offset + 7] != 0.0 || matrix[offset + 8] != 1.0) {
                    throw new IllegalArgumentException("The matrix is not affine");
                }
            }
            case MT_2D_2x3: {
                this.setToTransform(matrix[offset++], matrix[offset++], matrix[offset++], matrix[offset++], matrix[offset++], matrix[offset++]);
                return;
            }
            case MT_3D_4x4: {
                if (matrix[offset + 12] == 0.0 && matrix[offset + 13] == 0.0 && matrix[offset + 14] == 0.0 && matrix[offset + 15] == 1.0) break;
                throw new IllegalArgumentException("The matrix is not affine");
            }
            case MT_3D_3x4: 
        }
        this.setToTransform(matrix[offset++], matrix[offset++], matrix[offset++], matrix[offset++], matrix[offset++], matrix[offset++], matrix[offset++], matrix[offset++], matrix[offset++], matrix[offset++], matrix[offset++], matrix[offset++]);
    }

    public void setToIdentity() {
        this.atomicChange.start();
        if (this.state3d != 0) {
            this.setMxx(1.0);
            this.setMxy(0.0);
            this.setMxz(0.0);
            this.setTx(0.0);
            this.setMyx(0.0);
            this.setMyy(1.0);
            this.setMyz(0.0);
            this.setTy(0.0);
            this.setMzx(0.0);
            this.setMzy(0.0);
            this.setMzz(1.0);
            this.setTz(0.0);
            this.state3d = 0;
            this.state2d = 0;
        } else if (this.state2d != 0) {
            this.setMxx(1.0);
            this.setMxy(0.0);
            this.setTx(0.0);
            this.setMyx(0.0);
            this.setMyy(1.0);
            this.setTy(0.0);
            this.state2d = 0;
        }
        this.atomicChange.end();
    }

    public void invert() throws NonInvertibleTransformException {
        this.atomicChange.start();
        if (this.state3d == 0) {
            this.invert2D();
            this.updateState2D();
        } else {
            this.invert3D();
            this.updateState();
        }
        this.atomicChange.end();
    }

    private void invert2D() throws NonInvertibleTransformException {
        switch (this.state2d) {
            default: {
                Affine.stateError();
            }
            case 7: {
                double Mxx = this.getMxx();
                double Mxy = this.getMxy();
                double Mxt = this.getTx();
                double Myx = this.getMyx();
                double Myy = this.getMyy();
                double Myt = this.getTy();
                double det = this.getDeterminant2D();
                if (det == 0.0) {
                    this.atomicChange.cancel();
                    throw new NonInvertibleTransformException("Determinant is 0");
                }
                this.setMxx(Myy / det);
                this.setMyx(-Myx / det);
                this.setMxy(-Mxy / det);
                this.setMyy(Mxx / det);
                this.setTx((Mxy * Myt - Myy * Mxt) / det);
                this.setTy((Myx * Mxt - Mxx * Myt) / det);
                return;
            }
            case 6: {
                double Mxx = this.getMxx();
                double Mxy = this.getMxy();
                double Myx = this.getMyx();
                double Myy = this.getMyy();
                double det = this.getDeterminant2D();
                if (det == 0.0) {
                    this.atomicChange.cancel();
                    throw new NonInvertibleTransformException("Determinant is 0");
                }
                this.setMxx(Myy / det);
                this.setMyx(-Myx / det);
                this.setMxy(-Mxy / det);
                this.setMyy(Mxx / det);
                return;
            }
            case 5: {
                double Mxy = this.getMxy();
                double Mxt = this.getTx();
                double Myx = this.getMyx();
                double Myt = this.getTy();
                if (Mxy == 0.0 || Myx == 0.0) {
                    this.atomicChange.cancel();
                    throw new NonInvertibleTransformException("Determinant is 0");
                }
                this.setMyx(1.0 / Mxy);
                this.setMxy(1.0 / Myx);
                this.setTx(-Myt / Myx);
                this.setTy(-Mxt / Mxy);
                return;
            }
            case 4: {
                double Mxy = this.getMxy();
                double Myx = this.getMyx();
                if (Mxy == 0.0 || Myx == 0.0) {
                    this.atomicChange.cancel();
                    throw new NonInvertibleTransformException("Determinant is 0");
                }
                this.setMyx(1.0 / Mxy);
                this.setMxy(1.0 / Myx);
                return;
            }
            case 3: {
                double Mxx = this.getMxx();
                double Mxt = this.getTx();
                double Myy = this.getMyy();
                double Myt = this.getTy();
                if (Mxx == 0.0 || Myy == 0.0) {
                    this.atomicChange.cancel();
                    throw new NonInvertibleTransformException("Determinant is 0");
                }
                this.setMxx(1.0 / Mxx);
                this.setMyy(1.0 / Myy);
                this.setTx(-Mxt / Mxx);
                this.setTy(-Myt / Myy);
                return;
            }
            case 2: {
                double Mxx = this.getMxx();
                double Myy = this.getMyy();
                if (Mxx == 0.0 || Myy == 0.0) {
                    this.atomicChange.cancel();
                    throw new NonInvertibleTransformException("Determinant is 0");
                }
                this.setMxx(1.0 / Mxx);
                this.setMyy(1.0 / Myy);
                return;
            }
            case 1: {
                this.setTx(-this.getTx());
                this.setTy(-this.getTy());
                return;
            }
            case 0: 
        }
    }

    private void invert3D() throws NonInvertibleTransformException {
        switch (this.state3d) {
            default: {
                Affine.stateError();
            }
            case 1: {
                this.setTx(-this.getTx());
                this.setTy(-this.getTy());
                this.setTz(-this.getTz());
                return;
            }
            case 2: {
                double mxx_s = this.getMxx();
                double myy_s = this.getMyy();
                double mzz_s = this.getMzz();
                if (mxx_s == 0.0 || myy_s == 0.0 || mzz_s == 0.0) {
                    this.atomicChange.cancel();
                    throw new NonInvertibleTransformException("Determinant is 0");
                }
                this.setMxx(1.0 / mxx_s);
                this.setMyy(1.0 / myy_s);
                this.setMzz(1.0 / mzz_s);
                return;
            }
            case 3: {
                double mxx_st = this.getMxx();
                double tx_st = this.getTx();
                double myy_st = this.getMyy();
                double ty_st = this.getTy();
                double mzz_st = this.getMzz();
                double tz_st = this.getTz();
                if (mxx_st == 0.0 || myy_st == 0.0 || mzz_st == 0.0) {
                    this.atomicChange.cancel();
                    throw new NonInvertibleTransformException("Determinant is 0");
                }
                this.setMxx(1.0 / mxx_st);
                this.setMyy(1.0 / myy_st);
                this.setMzz(1.0 / mzz_st);
                this.setTx(-tx_st / mxx_st);
                this.setTy(-ty_st / myy_st);
                this.setTz(-tz_st / mzz_st);
                return;
            }
            case 4: 
        }
        double mxx = this.getMxx();
        double mxy = this.getMxy();
        double mxz = this.getMxz();
        double tx = this.getTx();
        double myx = this.getMyx();
        double myy = this.getMyy();
        double myz = this.getMyz();
        double ty = this.getTy();
        double mzy = this.getMzy();
        double mzx = this.getMzx();
        double mzz = this.getMzz();
        double tz = this.getTz();
        double det = mxx * (myy * mzz - mzy * myz) + mxy * (myz * mzx - mzz * myx) + mxz * (myx * mzy - mzx * myy);
        if (det == 0.0) {
            this.atomicChange.cancel();
            throw new NonInvertibleTransformException("Determinant is 0");
        }
        double cxx = myy * mzz - myz * mzy;
        double cyx = -myx * mzz + myz * mzx;
        double czx = myx * mzy - myy * mzx;
        double cxt = -mxy * (myz * tz - mzz * ty) - mxz * (ty * mzy - tz * myy) - tx * (myy * mzz - mzy * myz);
        double cxy = -mxy * mzz + mxz * mzy;
        double cyy = mxx * mzz - mxz * mzx;
        double czy = -mxx * mzy + mxy * mzx;
        double cyt = mxx * (myz * tz - mzz * ty) + mxz * (ty * mzx - tz * myx) + tx * (myx * mzz - mzx * myz);
        double cxz = mxy * myz - mxz * myy;
        double cyz = -mxx * myz + mxz * myx;
        double czz = mxx * myy - mxy * myx;
        double czt = -mxx * (myy * tz - mzy * ty) - mxy * (ty * mzx - tz * myx) - tx * (myx * mzy - mzx * myy);
        this.setMxx(cxx / det);
        this.setMxy(cxy / det);
        this.setMxz(cxz / det);
        this.setTx(cxt / det);
        this.setMyx(cyx / det);
        this.setMyy(cyy / det);
        this.setMyz(cyz / det);
        this.setTy(cyt / det);
        this.setMzx(czx / det);
        this.setMzy(czy / det);
        this.setMzz(czz / det);
        this.setTz(czt / det);
    }

    public void append(Transform transform) {
        transform.appendTo(this);
    }

    public void append(double mxx, double mxy, double tx, double myx, double myy, double ty) {
        if (this.state3d == 0) {
            this.atomicChange.start();
            double m_xx = this.getMxx();
            double m_xy = this.getMxy();
            double m_yx = this.getMyx();
            double m_yy = this.getMyy();
            this.setMxx(m_xx * mxx + m_xy * myx);
            this.setMxy(m_xx * mxy + m_xy * myy);
            this.setTx(m_xx * tx + m_xy * ty + this.getTx());
            this.setMyx(m_yx * mxx + m_yy * myx);
            this.setMyy(m_yx * mxy + m_yy * myy);
            this.setTy(m_yx * tx + m_yy * ty + this.getTy());
            this.updateState();
            this.atomicChange.end();
        } else {
            this.append(mxx, mxy, 0.0, tx, myx, myy, 0.0, ty, 0.0, 0.0, 1.0, 0.0);
        }
    }

    public void append(double mxx, double mxy, double mxz, double tx, double myx, double myy, double myz, double ty, double mzx, double mzy, double mzz, double tz) {
        this.atomicChange.start();
        double m_xx = this.getMxx();
        double m_xy = this.getMxy();
        double m_xz = this.getMxz();
        double t_x = this.getTx();
        double m_yx = this.getMyx();
        double m_yy = this.getMyy();
        double m_yz = this.getMyz();
        double t_y = this.getTy();
        double m_zx = this.getMzx();
        double m_zy = this.getMzy();
        double m_zz = this.getMzz();
        double t_z = this.getTz();
        this.setMxx(m_xx * mxx + m_xy * myx + m_xz * mzx);
        this.setMxy(m_xx * mxy + m_xy * myy + m_xz * mzy);
        this.setMxz(m_xx * mxz + m_xy * myz + m_xz * mzz);
        this.setTx(m_xx * tx + m_xy * ty + m_xz * tz + t_x);
        this.setMyx(m_yx * mxx + m_yy * myx + m_yz * mzx);
        this.setMyy(m_yx * mxy + m_yy * myy + m_yz * mzy);
        this.setMyz(m_yx * mxz + m_yy * myz + m_yz * mzz);
        this.setTy(m_yx * tx + m_yy * ty + m_yz * tz + t_y);
        this.setMzx(m_zx * mxx + m_zy * myx + m_zz * mzx);
        this.setMzy(m_zx * mxy + m_zy * myy + m_zz * mzy);
        this.setMzz(m_zx * mxz + m_zy * myz + m_zz * mzz);
        this.setTz(m_zx * tx + m_zy * ty + m_zz * tz + t_z);
        this.updateState();
        this.atomicChange.end();
    }

    public void append(double[] matrix, MatrixType type, int offset) {
        if (matrix.length < offset + type.elements()) {
            throw new IndexOutOfBoundsException("The array is too short.");
        }
        switch (type) {
            default: {
                Affine.stateError();
            }
            case MT_2D_3x3: {
                if (matrix[offset + 6] != 0.0 || matrix[offset + 7] != 0.0 || matrix[offset + 8] != 1.0) {
                    throw new IllegalArgumentException("The matrix is not affine");
                }
            }
            case MT_2D_2x3: {
                this.append(matrix[offset++], matrix[offset++], matrix[offset++], matrix[offset++], matrix[offset++], matrix[offset++]);
                return;
            }
            case MT_3D_4x4: {
                if (matrix[offset + 12] == 0.0 && matrix[offset + 13] == 0.0 && matrix[offset + 14] == 0.0 && matrix[offset + 15] == 1.0) break;
                throw new IllegalArgumentException("The matrix is not affine");
            }
            case MT_3D_3x4: 
        }
        this.append(matrix[offset++], matrix[offset++], matrix[offset++], matrix[offset++], matrix[offset++], matrix[offset++], matrix[offset++], matrix[offset++], matrix[offset++], matrix[offset++], matrix[offset++], matrix[offset++]);
    }

    @Override
    void appendTo(Affine a) {
        switch (this.state3d) {
            default: {
                Affine.stateError();
            }
            case 0: {
                switch (this.state2d) {
                    case 0: {
                        return;
                    }
                    case 1: {
                        a.appendTranslation(this.getTx(), this.getTy());
                        return;
                    }
                    case 2: {
                        a.appendScale(this.getMxx(), this.getMyy());
                        return;
                    }
                    case 3: {
                        a.appendTranslation(this.getTx(), this.getTy());
                        a.appendScale(this.getMxx(), this.getMyy());
                        return;
                    }
                }
                a.append(this.getMxx(), this.getMxy(), this.getTx(), this.getMyx(), this.getMyy(), this.getTy());
                return;
            }
            case 1: {
                a.appendTranslation(this.getTx(), this.getTy(), this.getTz());
                return;
            }
            case 2: {
                a.appendScale(this.getMxx(), this.getMyy(), this.getMzz());
                return;
            }
            case 3: {
                a.appendTranslation(this.getTx(), this.getTy(), this.getTz());
                a.appendScale(this.getMxx(), this.getMyy(), this.getMzz());
                return;
            }
            case 4: 
        }
        a.append(this.getMxx(), this.getMxy(), this.getMxz(), this.getTx(), this.getMyx(), this.getMyy(), this.getMyz(), this.getTy(), this.getMzx(), this.getMzy(), this.getMzz(), this.getTz());
    }

    public void prepend(Transform transform) {
        transform.prependTo(this);
    }

    public void prepend(double mxx, double mxy, double tx, double myx, double myy, double ty) {
        if (this.state3d == 0) {
            this.atomicChange.start();
            double m_xx = this.getMxx();
            double m_xy = this.getMxy();
            double t_x = this.getTx();
            double m_yx = this.getMyx();
            double m_yy = this.getMyy();
            double t_y = this.getTy();
            this.setMxx(mxx * m_xx + mxy * m_yx);
            this.setMxy(mxx * m_xy + mxy * m_yy);
            this.setTx(mxx * t_x + mxy * t_y + tx);
            this.setMyx(myx * m_xx + myy * m_yx);
            this.setMyy(myx * m_xy + myy * m_yy);
            this.setTy(myx * t_x + myy * t_y + ty);
            this.updateState2D();
            this.atomicChange.end();
        } else {
            this.prepend(mxx, mxy, 0.0, tx, myx, myy, 0.0, ty, 0.0, 0.0, 1.0, 0.0);
        }
    }

    public void prepend(double mxx, double mxy, double mxz, double tx, double myx, double myy, double myz, double ty, double mzx, double mzy, double mzz, double tz) {
        this.atomicChange.start();
        double m_xx = this.getMxx();
        double m_xy = this.getMxy();
        double m_xz = this.getMxz();
        double t_x = this.getTx();
        double m_yx = this.getMyx();
        double m_yy = this.getMyy();
        double m_yz = this.getMyz();
        double t_y = this.getTy();
        double m_zx = this.getMzx();
        double m_zy = this.getMzy();
        double m_zz = this.getMzz();
        double t_z = this.getTz();
        this.setMxx(mxx * m_xx + mxy * m_yx + mxz * m_zx);
        this.setMxy(mxx * m_xy + mxy * m_yy + mxz * m_zy);
        this.setMxz(mxx * m_xz + mxy * m_yz + mxz * m_zz);
        this.setTx(mxx * t_x + mxy * t_y + mxz * t_z + tx);
        this.setMyx(myx * m_xx + myy * m_yx + myz * m_zx);
        this.setMyy(myx * m_xy + myy * m_yy + myz * m_zy);
        this.setMyz(myx * m_xz + myy * m_yz + myz * m_zz);
        this.setTy(myx * t_x + myy * t_y + myz * t_z + ty);
        this.setMzx(mzx * m_xx + mzy * m_yx + mzz * m_zx);
        this.setMzy(mzx * m_xy + mzy * m_yy + mzz * m_zy);
        this.setMzz(mzx * m_xz + mzy * m_yz + mzz * m_zz);
        this.setTz(mzx * t_x + mzy * t_y + mzz * t_z + tz);
        this.updateState();
        this.atomicChange.end();
    }

    public void prepend(double[] matrix, MatrixType type, int offset) {
        if (matrix.length < offset + type.elements()) {
            throw new IndexOutOfBoundsException("The array is too short.");
        }
        switch (type) {
            default: {
                Affine.stateError();
            }
            case MT_2D_3x3: {
                if (matrix[offset + 6] != 0.0 || matrix[offset + 7] != 0.0 || matrix[offset + 8] != 1.0) {
                    throw new IllegalArgumentException("The matrix is not affine");
                }
            }
            case MT_2D_2x3: {
                this.prepend(matrix[offset++], matrix[offset++], matrix[offset++], matrix[offset++], matrix[offset++], matrix[offset++]);
                return;
            }
            case MT_3D_4x4: {
                if (matrix[offset + 12] == 0.0 && matrix[offset + 13] == 0.0 && matrix[offset + 14] == 0.0 && matrix[offset + 15] == 1.0) break;
                throw new IllegalArgumentException("The matrix is not affine");
            }
            case MT_3D_3x4: 
        }
        this.prepend(matrix[offset++], matrix[offset++], matrix[offset++], matrix[offset++], matrix[offset++], matrix[offset++], matrix[offset++], matrix[offset++], matrix[offset++], matrix[offset++], matrix[offset++], matrix[offset++]);
    }

    @Override
    void prependTo(Affine a) {
        switch (this.state3d) {
            default: {
                Affine.stateError();
            }
            case 0: {
                switch (this.state2d) {
                    case 0: {
                        return;
                    }
                    case 1: {
                        a.prependTranslation(this.getTx(), this.getTy());
                        return;
                    }
                    case 2: {
                        a.prependScale(this.getMxx(), this.getMyy());
                        return;
                    }
                    case 3: {
                        a.prependScale(this.getMxx(), this.getMyy());
                        a.prependTranslation(this.getTx(), this.getTy());
                        return;
                    }
                }
                a.prepend(this.getMxx(), this.getMxy(), this.getTx(), this.getMyx(), this.getMyy(), this.getTy());
                return;
            }
            case 1: {
                a.prependTranslation(this.getTx(), this.getTy(), this.getTz());
                return;
            }
            case 2: {
                a.prependScale(this.getMxx(), this.getMyy(), this.getMzz());
                return;
            }
            case 3: {
                a.prependScale(this.getMxx(), this.getMyy(), this.getMzz());
                a.prependTranslation(this.getTx(), this.getTy(), this.getTz());
                return;
            }
            case 4: 
        }
        a.prepend(this.getMxx(), this.getMxy(), this.getMxz(), this.getTx(), this.getMyx(), this.getMyy(), this.getMyz(), this.getTy(), this.getMzx(), this.getMzy(), this.getMzz(), this.getTz());
    }

    public void appendTranslation(double tx, double ty) {
        this.atomicChange.start();
        this.translate2D(tx, ty);
        this.atomicChange.end();
    }

    public void appendTranslation(double tx, double ty, double tz) {
        this.atomicChange.start();
        this.translate3D(tx, ty, tz);
        this.atomicChange.end();
    }

    private void translate2D(double tx, double ty) {
        if (this.state3d != 0) {
            this.translate3D(tx, ty, 0.0);
            return;
        }
        switch (this.state2d) {
            default: {
                Affine.stateError();
            }
            case 7: {
                this.setTx(tx * this.getMxx() + ty * this.getMxy() + this.getTx());
                this.setTy(tx * this.getMyx() + ty * this.getMyy() + this.getTy());
                if (this.getTx() == 0.0 && this.getTy() == 0.0) {
                    this.state2d = 6;
                }
                return;
            }
            case 6: {
                this.setTx(tx * this.getMxx() + ty * this.getMxy());
                this.setTy(tx * this.getMyx() + ty * this.getMyy());
                if (this.getTx() != 0.0 || this.getTy() != 0.0) {
                    this.state2d = 7;
                }
                return;
            }
            case 5: {
                this.setTx(ty * this.getMxy() + this.getTx());
                this.setTy(tx * this.getMyx() + this.getTy());
                if (this.getTx() == 0.0 && this.getTy() == 0.0) {
                    this.state2d = 4;
                }
                return;
            }
            case 4: {
                this.setTx(ty * this.getMxy());
                this.setTy(tx * this.getMyx());
                if (this.getTx() != 0.0 || this.getTy() != 0.0) {
                    this.state2d = 5;
                }
                return;
            }
            case 3: {
                this.setTx(tx * this.getMxx() + this.getTx());
                this.setTy(ty * this.getMyy() + this.getTy());
                if (this.getTx() == 0.0 && this.getTy() == 0.0) {
                    this.state2d = 2;
                }
                return;
            }
            case 2: {
                this.setTx(tx * this.getMxx());
                this.setTy(ty * this.getMyy());
                if (this.getTx() != 0.0 || this.getTy() != 0.0) {
                    this.state2d = 3;
                }
                return;
            }
            case 1: {
                this.setTx(tx + this.getTx());
                this.setTy(ty + this.getTy());
                if (this.getTx() == 0.0 && this.getTy() == 0.0) {
                    this.state2d = 0;
                }
                return;
            }
            case 0: 
        }
        this.setTx(tx);
        this.setTy(ty);
        if (tx != 0.0 || ty != 0.0) {
            this.state2d = 1;
        }
    }

    private void translate3D(double tx, double ty, double tz) {
        switch (this.state3d) {
            default: {
                Affine.stateError();
            }
            case 0: {
                this.translate2D(tx, ty);
                if (tz != 0.0) {
                    this.setTz(tz);
                    this.state3d = (this.state2d & 4) == 0 ? this.state2d & 2 | 1 : 4;
                }
                return;
            }
            case 1: {
                this.setTx(tx + this.getTx());
                this.setTy(ty + this.getTy());
                this.setTz(tz + this.getTz());
                if (this.getTz() == 0.0) {
                    this.state3d = 0;
                    this.state2d = this.getTx() == 0.0 && this.getTy() == 0.0 ? 0 : 1;
                }
                return;
            }
            case 2: {
                this.setTx(tx * this.getMxx());
                this.setTy(ty * this.getMyy());
                this.setTz(tz * this.getMzz());
                if (this.getTx() != 0.0 || this.getTy() != 0.0 || this.getTz() != 0.0) {
                    this.state3d |= 1;
                }
                return;
            }
            case 3: {
                this.setTx(tx * this.getMxx() + this.getTx());
                this.setTy(ty * this.getMyy() + this.getTy());
                this.setTz(tz * this.getMzz() + this.getTz());
                if (this.getTz() == 0.0) {
                    if (this.getTx() == 0.0 && this.getTy() == 0.0) {
                        this.state3d = 2;
                    }
                    if (this.getMzz() == 1.0) {
                        this.state2d = this.state3d;
                        this.state3d = 0;
                    }
                }
                return;
            }
            case 4: 
        }
        this.setTx(tx * this.getMxx() + ty * this.getMxy() + tz * this.getMxz() + this.getTx());
        this.setTy(tx * this.getMyx() + ty * this.getMyy() + tz * this.getMyz() + this.getTy());
        this.setTz(tx * this.getMzx() + ty * this.getMzy() + tz * this.getMzz() + this.getTz());
        this.updateState();
    }

    public void prependTranslation(double tx, double ty, double tz) {
        this.atomicChange.start();
        this.preTranslate3D(tx, ty, tz);
        this.atomicChange.end();
    }

    public void prependTranslation(double tx, double ty) {
        this.atomicChange.start();
        this.preTranslate2D(tx, ty);
        this.atomicChange.end();
    }

    private void preTranslate2D(double tx, double ty) {
        if (this.state3d != 0) {
            this.preTranslate3D(tx, ty, 0.0);
            return;
        }
        this.setTx(this.getTx() + tx);
        this.setTy(this.getTy() + ty);
        this.state2d = this.getTx() == 0.0 && this.getTy() == 0.0 ? (this.state2d &= 0xFFFFFFFE) : (this.state2d |= 1);
    }

    private void preTranslate3D(double tx, double ty, double tz) {
        switch (this.state3d) {
            default: {
                Affine.stateError();
            }
            case 0: {
                this.preTranslate2D(tx, ty);
                if (tz != 0.0) {
                    this.setTz(tz);
                    this.state3d = (this.state2d & 4) == 0 ? this.state2d & 2 | 1 : 4;
                }
                return;
            }
            case 1: {
                this.setTx(this.getTx() + tx);
                this.setTy(this.getTy() + ty);
                this.setTz(this.getTz() + tz);
                if (this.getTz() == 0.0) {
                    this.state3d = 0;
                    this.state2d = this.getTx() == 0.0 && this.getTy() == 0.0 ? 0 : 1;
                }
                return;
            }
            case 2: {
                this.setTx(tx);
                this.setTy(ty);
                this.setTz(tz);
                if (tx != 0.0 || ty != 0.0 || tz != 0.0) {
                    this.state3d |= 1;
                }
                return;
            }
            case 3: {
                this.setTx(this.getTx() + tx);
                this.setTy(this.getTy() + ty);
                this.setTz(this.getTz() + tz);
                if (this.getTz() == 0.0) {
                    if (this.getTx() == 0.0 && this.getTy() == 0.0) {
                        this.state3d = 2;
                    }
                    if (this.getMzz() == 1.0) {
                        this.state2d = this.state3d;
                        this.state3d = 0;
                    }
                }
                return;
            }
            case 4: 
        }
        this.setTx(this.getTx() + tx);
        this.setTy(this.getTy() + ty);
        this.setTz(this.getTz() + tz);
        if (this.getTz() == 0.0 && this.getMxz() == 0.0 && this.getMyz() == 0.0 && this.getMzx() == 0.0 && this.getMzy() == 0.0 && this.getMzz() == 1.0) {
            this.state3d = 0;
            this.updateState2D();
        }
    }

    public void appendScale(double sx, double sy) {
        this.atomicChange.start();
        this.scale2D(sx, sy);
        this.atomicChange.end();
    }

    public void appendScale(double sx, double sy, double pivotX, double pivotY) {
        this.atomicChange.start();
        if (pivotX != 0.0 || pivotY != 0.0) {
            this.translate2D(pivotX, pivotY);
            this.scale2D(sx, sy);
            this.translate2D(-pivotX, -pivotY);
        } else {
            this.scale2D(sx, sy);
        }
        this.atomicChange.end();
    }

    public void appendScale(double sx, double sy, Point2D pivot) {
        this.appendScale(sx, sy, pivot.getX(), pivot.getY());
    }

    public void appendScale(double sx, double sy, double sz) {
        this.atomicChange.start();
        this.scale3D(sx, sy, sz);
        this.atomicChange.end();
    }

    public void appendScale(double sx, double sy, double sz, double pivotX, double pivotY, double pivotZ) {
        this.atomicChange.start();
        if (pivotX != 0.0 || pivotY != 0.0 || pivotZ != 0.0) {
            this.translate3D(pivotX, pivotY, pivotZ);
            this.scale3D(sx, sy, sz);
            this.translate3D(-pivotX, -pivotY, -pivotZ);
        } else {
            this.scale3D(sx, sy, sz);
        }
        this.atomicChange.end();
    }

    public void appendScale(double sx, double sy, double sz, Point3D pivot) {
        this.appendScale(sx, sy, sz, pivot.getX(), pivot.getY(), pivot.getZ());
    }

    private void scale2D(double sx, double sy) {
        if (this.state3d != 0) {
            this.scale3D(sx, sy, 1.0);
            return;
        }
        int mystate = this.state2d;
        switch (mystate) {
            default: {
                Affine.stateError();
            }
            case 6: 
            case 7: {
                this.setMxx(this.getMxx() * sx);
                this.setMyy(this.getMyy() * sy);
            }
            case 4: 
            case 5: {
                this.setMxy(this.getMxy() * sy);
                this.setMyx(this.getMyx() * sx);
                if (this.getMxy() == 0.0 && this.getMyx() == 0.0) {
                    mystate &= 1;
                    if (this.getMxx() != 1.0 || this.getMyy() != 1.0) {
                        mystate |= 2;
                    }
                    this.state2d = mystate;
                } else if (this.getMxx() == 0.0 && this.getMyy() == 0.0) {
                    this.state2d &= 0xFFFFFFFD;
                }
                return;
            }
            case 2: 
            case 3: {
                this.setMxx(this.getMxx() * sx);
                this.setMyy(this.getMyy() * sy);
                if (this.getMxx() == 1.0 && this.getMyy() == 1.0) {
                    this.state2d = mystate &= 1;
                }
                return;
            }
            case 0: 
            case 1: 
        }
        this.setMxx(sx);
        this.setMyy(sy);
        if (sx != 1.0 || sy != 1.0) {
            this.state2d = mystate | 2;
        }
    }

    private void scale3D(double sx, double sy, double sz) {
        switch (this.state3d) {
            default: {
                Affine.stateError();
            }
            case 0: {
                this.scale2D(sx, sy);
                if (sz != 1.0) {
                    this.setMzz(sz);
                    this.state3d = (this.state2d & 4) == 0 ? this.state2d & 1 | 2 : 4;
                }
                return;
            }
            case 1: {
                this.setMxx(sx);
                this.setMyy(sy);
                this.setMzz(sz);
                if (sx != 1.0 || sy != 1.0 || sz != 1.0) {
                    this.state3d |= 2;
                }
                return;
            }
            case 2: {
                this.setMxx(this.getMxx() * sx);
                this.setMyy(this.getMyy() * sy);
                this.setMzz(this.getMzz() * sz);
                if (this.getMzz() == 1.0) {
                    this.state3d = 0;
                    this.state2d = this.getMxx() == 1.0 && this.getMyy() == 1.0 ? 0 : 2;
                }
                return;
            }
            case 3: {
                this.setMxx(this.getMxx() * sx);
                this.setMyy(this.getMyy() * sy);
                this.setMzz(this.getMzz() * sz);
                if (this.getMxx() == 1.0 && this.getMyy() == 1.0 && this.getMzz() == 1.0) {
                    this.state3d &= 0xFFFFFFFD;
                }
                if (this.getTz() == 0.0 && this.getMzz() == 1.0) {
                    this.state2d = this.state3d;
                    this.state3d = 0;
                }
                return;
            }
            case 4: 
        }
        this.setMxx(this.getMxx() * sx);
        this.setMxy(this.getMxy() * sy);
        this.setMxz(this.getMxz() * sz);
        this.setMyx(this.getMyx() * sx);
        this.setMyy(this.getMyy() * sy);
        this.setMyz(this.getMyz() * sz);
        this.setMzx(this.getMzx() * sx);
        this.setMzy(this.getMzy() * sy);
        this.setMzz(this.getMzz() * sz);
        if (sx == 0.0 || sy == 0.0 || sz == 0.0) {
            this.updateState();
        }
    }

    public void prependScale(double sx, double sy) {
        this.atomicChange.start();
        this.preScale2D(sx, sy);
        this.atomicChange.end();
    }

    public void prependScale(double sx, double sy, double pivotX, double pivotY) {
        this.atomicChange.start();
        if (pivotX != 0.0 || pivotY != 0.0) {
            this.preTranslate2D(-pivotX, -pivotY);
            this.preScale2D(sx, sy);
            this.preTranslate2D(pivotX, pivotY);
        } else {
            this.preScale2D(sx, sy);
        }
        this.atomicChange.end();
    }

    public void prependScale(double sx, double sy, Point2D pivot) {
        this.prependScale(sx, sy, pivot.getX(), pivot.getY());
    }

    public void prependScale(double sx, double sy, double sz) {
        this.atomicChange.start();
        this.preScale3D(sx, sy, sz);
        this.atomicChange.end();
    }

    public void prependScale(double sx, double sy, double sz, double pivotX, double pivotY, double pivotZ) {
        this.atomicChange.start();
        if (pivotX != 0.0 || pivotY != 0.0 || pivotZ != 0.0) {
            this.preTranslate3D(-pivotX, -pivotY, -pivotZ);
            this.preScale3D(sx, sy, sz);
            this.preTranslate3D(pivotX, pivotY, pivotZ);
        } else {
            this.preScale3D(sx, sy, sz);
        }
        this.atomicChange.end();
    }

    public void prependScale(double sx, double sy, double sz, Point3D pivot) {
        this.prependScale(sx, sy, sz, pivot.getX(), pivot.getY(), pivot.getZ());
    }

    private void preScale2D(double sx, double sy) {
        if (this.state3d != 0) {
            this.preScale3D(sx, sy, 1.0);
            return;
        }
        int mystate = this.state2d;
        switch (mystate) {
            default: {
                Affine.stateError();
            }
            case 7: {
                this.setTx(this.getTx() * sx);
                this.setTy(this.getTy() * sy);
                if (this.getTx() == 0.0 && this.getTy() == 0.0) {
                    this.state2d = mystate &= 0xFFFFFFFE;
                }
            }
            case 6: {
                this.setMxx(this.getMxx() * sx);
                this.setMyy(this.getMyy() * sy);
            }
            case 4: {
                this.setMxy(this.getMxy() * sx);
                this.setMyx(this.getMyx() * sy);
                if (this.getMxy() == 0.0 && this.getMyx() == 0.0) {
                    mystate &= 1;
                    if (this.getMxx() != 1.0 || this.getMyy() != 1.0) {
                        mystate |= 2;
                    }
                    this.state2d = mystate;
                }
                return;
            }
            case 5: {
                this.setTx(this.getTx() * sx);
                this.setTy(this.getTy() * sy);
                this.setMxy(this.getMxy() * sx);
                this.setMyx(this.getMyx() * sy);
                if (this.getMxy() == 0.0 && this.getMyx() == 0.0) {
                    this.state2d = this.getTx() == 0.0 && this.getTy() == 0.0 ? 2 : 3;
                } else if (this.getTx() == 0.0 && this.getTy() == 0.0) {
                    this.state2d = 4;
                }
                return;
            }
            case 3: {
                this.setTx(this.getTx() * sx);
                this.setTy(this.getTy() * sy);
                if (this.getTx() == 0.0 && this.getTy() == 0.0) {
                    this.state2d = mystate &= 0xFFFFFFFE;
                }
            }
            case 2: {
                this.setMxx(this.getMxx() * sx);
                this.setMyy(this.getMyy() * sy);
                if (this.getMxx() == 1.0 && this.getMyy() == 1.0) {
                    this.state2d = mystate &= 1;
                }
                return;
            }
            case 1: {
                this.setTx(this.getTx() * sx);
                this.setTy(this.getTy() * sy);
                if (this.getTx() != 0.0 || this.getTy() != 0.0) break;
                this.state2d = mystate &= 0xFFFFFFFE;
            }
            case 0: 
        }
        this.setMxx(sx);
        this.setMyy(sy);
        if (sx != 1.0 || sy != 1.0) {
            this.state2d = mystate | 2;
        }
    }

    private void preScale3D(double sx, double sy, double sz) {
        switch (this.state3d) {
            default: {
                Affine.stateError();
            }
            case 0: {
                this.preScale2D(sx, sy);
                if (sz != 1.0) {
                    this.setMzz(sz);
                    this.state3d = (this.state2d & 4) == 0 ? this.state2d & 1 | 2 : 4;
                }
                return;
            }
            case 3: {
                this.setTx(this.getTx() * sx);
                this.setTy(this.getTy() * sy);
                this.setTz(this.getTz() * sz);
                this.setMxx(this.getMxx() * sx);
                this.setMyy(this.getMyy() * sy);
                this.setMzz(this.getMzz() * sz);
                if (this.getTx() == 0.0 && this.getTy() == 0.0 && this.getTz() == 0.0) {
                    this.state3d &= 0xFFFFFFFE;
                }
                if (this.getMxx() == 1.0 && this.getMyy() == 1.0 && this.getMzz() == 1.0) {
                    this.state3d &= 0xFFFFFFFD;
                }
                if (this.getTz() == 0.0 && this.getMzz() == 1.0) {
                    this.state2d = this.state3d;
                    this.state3d = 0;
                }
                return;
            }
            case 2: {
                this.setMxx(this.getMxx() * sx);
                this.setMyy(this.getMyy() * sy);
                this.setMzz(this.getMzz() * sz);
                if (this.getMzz() == 1.0) {
                    this.state3d = 0;
                    this.state2d = this.getMxx() == 1.0 && this.getMyy() == 1.0 ? 0 : 2;
                }
                return;
            }
            case 1: {
                this.setTx(this.getTx() * sx);
                this.setTy(this.getTy() * sy);
                this.setTz(this.getTz() * sz);
                this.setMxx(sx);
                this.setMyy(sy);
                this.setMzz(sz);
                if (this.getTx() == 0.0 && this.getTy() == 0.0 && this.getTz() == 0.0) {
                    this.state3d &= 0xFFFFFFFE;
                }
                if (sx != 1.0 || sy != 1.0 || sz != 1.0) {
                    this.state3d |= 2;
                }
                return;
            }
            case 4: 
        }
        this.setMxx(this.getMxx() * sx);
        this.setMxy(this.getMxy() * sx);
        this.setMxz(this.getMxz() * sx);
        this.setTx(this.getTx() * sx);
        this.setMyx(this.getMyx() * sy);
        this.setMyy(this.getMyy() * sy);
        this.setMyz(this.getMyz() * sy);
        this.setTy(this.getTy() * sy);
        this.setMzx(this.getMzx() * sz);
        this.setMzy(this.getMzy() * sz);
        this.setMzz(this.getMzz() * sz);
        this.setTz(this.getTz() * sz);
        if (sx == 0.0 || sy == 0.0 || sz == 0.0) {
            this.updateState();
        }
    }

    public void appendShear(double shx, double shy) {
        this.atomicChange.start();
        this.shear2D(shx, shy);
        this.atomicChange.end();
    }

    public void appendShear(double shx, double shy, double pivotX, double pivotY) {
        this.atomicChange.start();
        if (pivotX != 0.0 || pivotY != 0.0) {
            this.translate2D(pivotX, pivotY);
            this.shear2D(shx, shy);
            this.translate2D(-pivotX, -pivotY);
        } else {
            this.shear2D(shx, shy);
        }
        this.atomicChange.end();
    }

    public void appendShear(double shx, double shy, Point2D pivot) {
        this.appendShear(shx, shy, pivot.getX(), pivot.getY());
    }

    private void shear2D(double shx, double shy) {
        if (this.state3d != 0) {
            this.shear3D(shx, shy);
            return;
        }
        int mystate = this.state2d;
        switch (mystate) {
            default: {
                Affine.stateError();
            }
            case 6: 
            case 7: {
                double M0 = this.getMxx();
                double M1 = this.getMxy();
                this.setMxx(M0 + M1 * shy);
                this.setMxy(M0 * shx + M1);
                M0 = this.getMyx();
                M1 = this.getMyy();
                this.setMyx(M0 + M1 * shy);
                this.setMyy(M0 * shx + M1);
                this.updateState2D();
                return;
            }
            case 4: 
            case 5: {
                this.setMxx(this.getMxy() * shy);
                this.setMyy(this.getMyx() * shx);
                if (this.getMxx() != 0.0 || this.getMyy() != 0.0) {
                    this.state2d = mystate | 2;
                }
                return;
            }
            case 2: 
            case 3: {
                this.setMxy(this.getMxx() * shx);
                this.setMyx(this.getMyy() * shy);
                if (this.getMxy() != 0.0 || this.getMyx() != 0.0) {
                    this.state2d = mystate | 4;
                }
                return;
            }
            case 0: 
            case 1: 
        }
        this.setMxy(shx);
        this.setMyx(shy);
        if (this.getMxy() != 0.0 || this.getMyx() != 0.0) {
            this.state2d = mystate | 2 | 4;
        }
    }

    private void shear3D(double shx, double shy) {
        switch (this.state3d) {
            default: {
                Affine.stateError();
            }
            case 0: {
                this.shear2D(shx, shy);
                return;
            }
            case 1: {
                this.setMxy(shx);
                this.setMyx(shy);
                if (shx != 0.0 || shy != 0.0) {
                    this.state3d = 4;
                }
                return;
            }
            case 2: 
            case 3: {
                this.setMxy(this.getMxx() * shx);
                this.setMyx(this.getMyy() * shy);
                if (this.getMxy() != 0.0 || this.getMyx() != 0.0) {
                    this.state3d = 4;
                }
                return;
            }
            case 4: 
        }
        double m_xx = this.getMxx();
        double m_xy = this.getMxy();
        double m_yx = this.getMyx();
        double m_yy = this.getMyy();
        double m_zx = this.getMzx();
        double m_zy = this.getMzy();
        this.setMxx(m_xx + m_xy * shy);
        this.setMxy(m_xy + m_xx * shx);
        this.setMyx(m_yx + m_yy * shy);
        this.setMyy(m_yy + m_yx * shx);
        this.setMzx(m_zx + m_zy * shy);
        this.setMzy(m_zy + m_zx * shx);
        this.updateState();
    }

    public void prependShear(double shx, double shy) {
        this.atomicChange.start();
        this.preShear2D(shx, shy);
        this.atomicChange.end();
    }

    public void prependShear(double shx, double shy, double pivotX, double pivotY) {
        this.atomicChange.start();
        if (pivotX != 0.0 || pivotY != 0.0) {
            this.preTranslate2D(-pivotX, -pivotY);
            this.preShear2D(shx, shy);
            this.preTranslate2D(pivotX, pivotY);
        } else {
            this.preShear2D(shx, shy);
        }
        this.atomicChange.end();
    }

    public void prependShear(double shx, double shy, Point2D pivot) {
        this.prependShear(shx, shy, pivot.getX(), pivot.getY());
    }

    private void preShear2D(double shx, double shy) {
        if (this.state3d != 0) {
            this.preShear3D(shx, shy);
            return;
        }
        int mystate = this.state2d;
        switch (mystate) {
            default: {
                Affine.stateError();
            }
            case 5: 
            case 7: {
                double t_x_1 = this.getTx();
                double t_y_1 = this.getTy();
                this.setTx(t_x_1 + shx * t_y_1);
                this.setTy(t_y_1 + shy * t_x_1);
            }
            case 4: 
            case 6: {
                double m_xx = this.getMxx();
                double m_xy = this.getMxy();
                double m_yx = this.getMyx();
                double m_yy = this.getMyy();
                this.setMxx(m_xx + shx * m_yx);
                this.setMxy(m_xy + shx * m_yy);
                this.setMyx(shy * m_xx + m_yx);
                this.setMyy(shy * m_xy + m_yy);
                this.updateState2D();
                return;
            }
            case 3: {
                double t_x_2 = this.getTx();
                double t_y_2 = this.getTy();
                this.setTx(t_x_2 + shx * t_y_2);
                this.setTy(t_y_2 + shy * t_x_2);
                if (this.getTx() == 0.0 && this.getTy() == 0.0) {
                    this.state2d = mystate &= 0xFFFFFFFE;
                }
            }
            case 2: {
                this.setMxy(shx * this.getMyy());
                this.setMyx(shy * this.getMxx());
                if (this.getMxy() != 0.0 || this.getMyx() != 0.0) {
                    this.state2d = mystate | 4;
                }
                return;
            }
            case 1: {
                double t_x_3 = this.getTx();
                double t_y_3 = this.getTy();
                this.setTx(t_x_3 + shx * t_y_3);
                this.setTy(t_y_3 + shy * t_x_3);
                if (this.getTx() != 0.0 || this.getTy() != 0.0) break;
                this.state2d = mystate &= 0xFFFFFFFE;
            }
            case 0: 
        }
        this.setMxy(shx);
        this.setMyx(shy);
        if (this.getMxy() != 0.0 || this.getMyx() != 0.0) {
            this.state2d = mystate | 2 | 4;
        }
    }

    private void preShear3D(double shx, double shy) {
        switch (this.state3d) {
            default: {
                Affine.stateError();
            }
            case 0: {
                this.preShear2D(shx, shy);
                return;
            }
            case 1: {
                double tx_t = this.getTx();
                this.setMxy(shx);
                this.setTx(tx_t + this.getTy() * shx);
                this.setMyx(shy);
                this.setTy(tx_t * shy + this.getTy());
                if (shx != 0.0 || shy != 0.0) {
                    this.state3d = 4;
                }
                return;
            }
            case 2: {
                this.setMxy(this.getMyy() * shx);
                this.setMyx(this.getMxx() * shy);
                if (this.getMxy() != 0.0 || this.getMyx() != 0.0) {
                    this.state3d = 4;
                }
                return;
            }
            case 3: {
                double tx_st = this.getTx();
                this.setMxy(this.getMyy() * shx);
                this.setTx(tx_st + this.getTy() * shx);
                this.setMyx(this.getMxx() * shy);
                this.setTy(tx_st * shy + this.getTy());
                if (this.getMxy() != 0.0 || this.getMyx() != 0.0) {
                    this.state3d = 4;
                }
                return;
            }
            case 4: 
        }
        double m_xx = this.getMxx();
        double m_xy = this.getMxy();
        double m_yx = this.getMyx();
        double t_x = this.getTx();
        double m_yy = this.getMyy();
        double m_xz = this.getMxz();
        double m_yz = this.getMyz();
        double t_y = this.getTy();
        this.setMxx(m_xx + m_yx * shx);
        this.setMxy(m_xy + m_yy * shx);
        this.setMxz(m_xz + m_yz * shx);
        this.setTx(t_x + t_y * shx);
        this.setMyx(m_xx * shy + m_yx);
        this.setMyy(m_xy * shy + m_yy);
        this.setMyz(m_xz * shy + m_yz);
        this.setTy(t_x * shy + t_y);
        this.updateState();
    }

    public void appendRotation(double angle) {
        this.atomicChange.start();
        this.rotate2D(angle);
        this.atomicChange.end();
    }

    public void appendRotation(double angle, double pivotX, double pivotY) {
        this.atomicChange.start();
        if (pivotX != 0.0 || pivotY != 0.0) {
            this.translate2D(pivotX, pivotY);
            this.rotate2D(angle);
            this.translate2D(-pivotX, -pivotY);
        } else {
            this.rotate2D(angle);
        }
        this.atomicChange.end();
    }

    public void appendRotation(double angle, Point2D pivot) {
        this.appendRotation(angle, pivot.getX(), pivot.getY());
    }

    public void appendRotation(double angle, double pivotX, double pivotY, double pivotZ, double axisX, double axisY, double axisZ) {
        this.atomicChange.start();
        if (pivotX != 0.0 || pivotY != 0.0 || pivotZ != 0.0) {
            this.translate3D(pivotX, pivotY, pivotZ);
            this.rotate3D(angle, axisX, axisY, axisZ);
            this.translate3D(-pivotX, -pivotY, -pivotZ);
        } else {
            this.rotate3D(angle, axisX, axisY, axisZ);
        }
        this.atomicChange.end();
    }

    public void appendRotation(double angle, double pivotX, double pivotY, double pivotZ, Point3D axis) {
        this.appendRotation(angle, pivotX, pivotY, pivotZ, axis.getX(), axis.getY(), axis.getZ());
    }

    public void appendRotation(double angle, Point3D pivot, Point3D axis) {
        this.appendRotation(angle, pivot.getX(), pivot.getY(), pivot.getZ(), axis.getX(), axis.getY(), axis.getZ());
    }

    private void rotate3D(double angle, double axisX, double axisY, double axisZ) {
        if (axisX == 0.0 && axisY == 0.0) {
            if (axisZ > 0.0) {
                this.rotate3D(angle);
            } else if (axisZ < 0.0) {
                this.rotate3D(-angle);
            }
            return;
        }
        double mag = Math.sqrt(axisX * axisX + axisY * axisY + axisZ * axisZ);
        if (mag == 0.0) {
            return;
        }
        mag = 1.0 / mag;
        double ax = axisX * mag;
        double ay = axisY * mag;
        double az = axisZ * mag;
        double sinTheta = Math.sin(Math.toRadians(angle));
        double cosTheta = Math.cos(Math.toRadians(angle));
        double t = 1.0 - cosTheta;
        double xz = ax * az;
        double xy = ax * ay;
        double yz = ay * az;
        double Txx = t * ax * ax + cosTheta;
        double Txy = t * xy - sinTheta * az;
        double Txz = t * xz + sinTheta * ay;
        double Tyx = t * xy + sinTheta * az;
        double Tyy = t * ay * ay + cosTheta;
        double Tyz = t * yz - sinTheta * ax;
        double Tzx = t * xz - sinTheta * ay;
        double Tzy = t * yz + sinTheta * ax;
        double Tzz = t * az * az + cosTheta;
        block0 : switch (this.state3d) {
            default: {
                Affine.stateError();
            }
            case 0: {
                switch (this.state2d) {
                    default: {
                        Affine.stateError();
                    }
                    case 6: 
                    case 7: {
                        double xx_sst = this.getMxx();
                        double xy_sst = this.getMxy();
                        double yx_sst = this.getMyx();
                        double yy_sst = this.getMyy();
                        this.setMxx(xx_sst * Txx + xy_sst * Tyx);
                        this.setMxy(xx_sst * Txy + xy_sst * Tyy);
                        this.setMxz(xx_sst * Txz + xy_sst * Tyz);
                        this.setMyx(yx_sst * Txx + yy_sst * Tyx);
                        this.setMyy(yx_sst * Txy + yy_sst * Tyy);
                        this.setMyz(yx_sst * Txz + yy_sst * Tyz);
                        this.setMzx(Tzx);
                        this.setMzy(Tzy);
                        this.setMzz(Tzz);
                        break block0;
                    }
                    case 4: 
                    case 5: {
                        double xy_sht = this.getMxy();
                        double yx_sht = this.getMyx();
                        this.setMxx(xy_sht * Tyx);
                        this.setMxy(xy_sht * Tyy);
                        this.setMxz(xy_sht * Tyz);
                        this.setMyx(yx_sht * Txx);
                        this.setMyy(yx_sht * Txy);
                        this.setMyz(yx_sht * Txz);
                        this.setMzx(Tzx);
                        this.setMzy(Tzy);
                        this.setMzz(Tzz);
                        break block0;
                    }
                    case 2: 
                    case 3: {
                        double xx_s = this.getMxx();
                        double yy_s = this.getMyy();
                        this.setMxx(xx_s * Txx);
                        this.setMxy(xx_s * Txy);
                        this.setMxz(xx_s * Txz);
                        this.setMyx(yy_s * Tyx);
                        this.setMyy(yy_s * Tyy);
                        this.setMyz(yy_s * Tyz);
                        this.setMzx(Tzx);
                        this.setMzy(Tzy);
                        this.setMzz(Tzz);
                        break block0;
                    }
                    case 0: 
                    case 1: 
                }
                this.setMxx(Txx);
                this.setMxy(Txy);
                this.setMxz(Txz);
                this.setMyx(Tyx);
                this.setMyy(Tyy);
                this.setMyz(Tyz);
                this.setMzx(Tzx);
                this.setMzy(Tzy);
                this.setMzz(Tzz);
                break;
            }
            case 1: {
                this.setMxx(Txx);
                this.setMxy(Txy);
                this.setMxz(Txz);
                this.setMyx(Tyx);
                this.setMyy(Tyy);
                this.setMyz(Tyz);
                this.setMzx(Tzx);
                this.setMzy(Tzy);
                this.setMzz(Tzz);
                break;
            }
            case 2: 
            case 3: {
                double xx_st = this.getMxx();
                double yy_st = this.getMyy();
                double zz_st = this.getMzz();
                this.setMxx(xx_st * Txx);
                this.setMxy(xx_st * Txy);
                this.setMxz(xx_st * Txz);
                this.setMyx(yy_st * Tyx);
                this.setMyy(yy_st * Tyy);
                this.setMyz(yy_st * Tyz);
                this.setMzx(zz_st * Tzx);
                this.setMzy(zz_st * Tzy);
                this.setMzz(zz_st * Tzz);
                break;
            }
            case 4: {
                double m_xx = this.getMxx();
                double m_xy = this.getMxy();
                double m_xz = this.getMxz();
                double m_yx = this.getMyx();
                double m_yy = this.getMyy();
                double m_yz = this.getMyz();
                double m_zx = this.getMzx();
                double m_zy = this.getMzy();
                double m_zz = this.getMzz();
                this.setMxx(m_xx * Txx + m_xy * Tyx + m_xz * Tzx);
                this.setMxy(m_xx * Txy + m_xy * Tyy + m_xz * Tzy);
                this.setMxz(m_xx * Txz + m_xy * Tyz + m_xz * Tzz);
                this.setMyx(m_yx * Txx + m_yy * Tyx + m_yz * Tzx);
                this.setMyy(m_yx * Txy + m_yy * Tyy + m_yz * Tzy);
                this.setMyz(m_yx * Txz + m_yy * Tyz + m_yz * Tzz);
                this.setMzx(m_zx * Txx + m_zy * Tyx + m_zz * Tzx);
                this.setMzy(m_zx * Txy + m_zy * Tyy + m_zz * Tzy);
                this.setMzz(m_zx * Txz + m_zy * Tyz + m_zz * Tzz);
            }
        }
        this.updateState();
    }

    private void rotate2D(double theta) {
        if (this.state3d != 0) {
            this.rotate3D(theta);
            return;
        }
        double sin = Math.sin(Math.toRadians(theta));
        if (sin == 1.0) {
            this.rotate2D_90();
        } else if (sin == -1.0) {
            this.rotate2D_270();
        } else {
            double cos = Math.cos(Math.toRadians(theta));
            if (cos == -1.0) {
                this.rotate2D_180();
            } else if (cos != 1.0) {
                double M0 = this.getMxx();
                double M1 = this.getMxy();
                this.setMxx(cos * M0 + sin * M1);
                this.setMxy(-sin * M0 + cos * M1);
                M0 = this.getMyx();
                M1 = this.getMyy();
                this.setMyx(cos * M0 + sin * M1);
                this.setMyy(-sin * M0 + cos * M1);
                this.updateState2D();
            }
        }
    }

    private void rotate2D_90() {
        double M0 = this.getMxx();
        this.setMxx(this.getMxy());
        this.setMxy(-M0);
        M0 = this.getMyx();
        this.setMyx(this.getMyy());
        this.setMyy(-M0);
        int newstate = rot90conversion[this.state2d];
        if ((newstate & 6) == 2 && this.getMxx() == 1.0 && this.getMyy() == 1.0) {
            newstate -= 2;
        } else if ((newstate & 6) == 4 && this.getMxy() == 0.0 && this.getMyx() == 0.0) {
            newstate = newstate & 0xFFFFFFFB | 2;
        }
        this.state2d = newstate;
    }

    private void rotate2D_180() {
        this.setMxx(-this.getMxx());
        this.setMyy(-this.getMyy());
        int oldstate = this.state2d;
        if ((oldstate & 4) != 0) {
            this.setMxy(-this.getMxy());
            this.setMyx(-this.getMyx());
        } else {
            this.state2d = this.getMxx() == 1.0 && this.getMyy() == 1.0 ? oldstate & 0xFFFFFFFD : oldstate | 2;
        }
    }

    private void rotate2D_270() {
        double M0 = this.getMxx();
        this.setMxx(-this.getMxy());
        this.setMxy(M0);
        M0 = this.getMyx();
        this.setMyx(-this.getMyy());
        this.setMyy(M0);
        int newstate = rot90conversion[this.state2d];
        if ((newstate & 6) == 2 && this.getMxx() == 1.0 && this.getMyy() == 1.0) {
            newstate -= 2;
        } else if ((newstate & 6) == 4 && this.getMxy() == 0.0 && this.getMyx() == 0.0) {
            newstate = newstate & 0xFFFFFFFB | 2;
        }
        this.state2d = newstate;
    }

    private void rotate3D(double theta) {
        if (this.state3d == 0) {
            this.rotate2D(theta);
            return;
        }
        double sin = Math.sin(Math.toRadians(theta));
        if (sin == 1.0) {
            this.rotate3D_90();
        } else if (sin == -1.0) {
            this.rotate3D_270();
        } else {
            double cos = Math.cos(Math.toRadians(theta));
            if (cos == -1.0) {
                this.rotate3D_180();
            } else if (cos != 1.0) {
                double M0 = this.getMxx();
                double M1 = this.getMxy();
                this.setMxx(cos * M0 + sin * M1);
                this.setMxy(-sin * M0 + cos * M1);
                M0 = this.getMyx();
                M1 = this.getMyy();
                this.setMyx(cos * M0 + sin * M1);
                this.setMyy(-sin * M0 + cos * M1);
                M0 = this.getMzx();
                M1 = this.getMzy();
                this.setMzx(cos * M0 + sin * M1);
                this.setMzy(-sin * M0 + cos * M1);
                this.updateState();
            }
        }
    }

    private void rotate3D_90() {
        double M0 = this.getMxx();
        this.setMxx(this.getMxy());
        this.setMxy(-M0);
        M0 = this.getMyx();
        this.setMyx(this.getMyy());
        this.setMyy(-M0);
        M0 = this.getMzx();
        this.setMzx(this.getMzy());
        this.setMzy(-M0);
        switch (this.state3d) {
            default: {
                Affine.stateError();
            }
            case 1: {
                this.state3d = 4;
                return;
            }
            case 2: 
            case 3: {
                if (this.getMxy() != 0.0 || this.getMyx() != 0.0) {
                    this.state3d = 4;
                }
                return;
            }
            case 4: 
        }
        this.updateState();
    }

    private void rotate3D_180() {
        double mxx = this.getMxx();
        double myy = this.getMyy();
        this.setMxx(-mxx);
        this.setMyy(-myy);
        if (this.state3d == 4) {
            this.setMxy(-this.getMxy());
            this.setMyx(-this.getMyx());
            this.setMzx(-this.getMzx());
            this.setMzy(-this.getMzy());
            this.updateState();
            return;
        }
        this.state3d = mxx == -1.0 && myy == -1.0 && this.getMzz() == 1.0 ? (this.state3d &= 0xFFFFFFFD) : (this.state3d |= 2);
    }

    private void rotate3D_270() {
        double M0 = this.getMxx();
        this.setMxx(-this.getMxy());
        this.setMxy(M0);
        M0 = this.getMyx();
        this.setMyx(-this.getMyy());
        this.setMyy(M0);
        M0 = this.getMzx();
        this.setMzx(-this.getMzy());
        this.setMzy(M0);
        switch (this.state3d) {
            default: {
                Affine.stateError();
            }
            case 1: {
                this.state3d = 4;
                return;
            }
            case 2: 
            case 3: {
                if (this.getMxy() != 0.0 || this.getMyx() != 0.0) {
                    this.state3d = 4;
                }
                return;
            }
            case 4: 
        }
        this.updateState();
    }

    public void prependRotation(double angle) {
        this.atomicChange.start();
        this.preRotate2D(angle);
        this.atomicChange.end();
    }

    public void prependRotation(double angle, double pivotX, double pivotY) {
        this.atomicChange.start();
        if (pivotX != 0.0 || pivotY != 0.0) {
            this.preTranslate2D(-pivotX, -pivotY);
            this.preRotate2D(angle);
            this.preTranslate2D(pivotX, pivotY);
        } else {
            this.preRotate2D(angle);
        }
        this.atomicChange.end();
    }

    public void prependRotation(double angle, Point2D pivot) {
        this.prependRotation(angle, pivot.getX(), pivot.getY());
    }

    public void prependRotation(double angle, double pivotX, double pivotY, double pivotZ, double axisX, double axisY, double axisZ) {
        this.atomicChange.start();
        if (pivotX != 0.0 || pivotY != 0.0 || pivotZ != 0.0) {
            this.preTranslate3D(-pivotX, -pivotY, -pivotZ);
            this.preRotate3D(angle, axisX, axisY, axisZ);
            this.preTranslate3D(pivotX, pivotY, pivotZ);
        } else {
            this.preRotate3D(angle, axisX, axisY, axisZ);
        }
        this.atomicChange.end();
    }

    public void prependRotation(double angle, double pivotX, double pivotY, double pivotZ, Point3D axis) {
        this.prependRotation(angle, pivotX, pivotY, pivotZ, axis.getX(), axis.getY(), axis.getZ());
    }

    public void prependRotation(double angle, Point3D pivot, Point3D axis) {
        this.prependRotation(angle, pivot.getX(), pivot.getY(), pivot.getZ(), axis.getX(), axis.getY(), axis.getZ());
    }

    private void preRotate3D(double angle, double axisX, double axisY, double axisZ) {
        if (axisX == 0.0 && axisY == 0.0) {
            if (axisZ > 0.0) {
                this.preRotate3D(angle);
            } else if (axisZ < 0.0) {
                this.preRotate3D(-angle);
            }
            return;
        }
        double mag = Math.sqrt(axisX * axisX + axisY * axisY + axisZ * axisZ);
        if (mag == 0.0) {
            return;
        }
        mag = 1.0 / mag;
        double ax = axisX * mag;
        double ay = axisY * mag;
        double az = axisZ * mag;
        double sinTheta = Math.sin(Math.toRadians(angle));
        double cosTheta = Math.cos(Math.toRadians(angle));
        double t = 1.0 - cosTheta;
        double xz = ax * az;
        double xy = ax * ay;
        double yz = ay * az;
        double Txx = t * ax * ax + cosTheta;
        double Txy = t * xy - sinTheta * az;
        double Txz = t * xz + sinTheta * ay;
        double Tyx = t * xy + sinTheta * az;
        double Tyy = t * ay * ay + cosTheta;
        double Tyz = t * yz - sinTheta * ax;
        double Tzx = t * xz - sinTheta * ay;
        double Tzy = t * yz + sinTheta * ax;
        double Tzz = t * az * az + cosTheta;
        block0 : switch (this.state3d) {
            default: {
                Affine.stateError();
            }
            case 0: {
                switch (this.state2d) {
                    default: {
                        Affine.stateError();
                    }
                    case 7: {
                        double xx_sst = this.getMxx();
                        double xy_sst = this.getMxy();
                        double tx_sst = this.getTx();
                        double yx_sst = this.getMyx();
                        double yy_sst = this.getMyy();
                        double ty_sst = this.getTy();
                        this.setMxx(Txx * xx_sst + Txy * yx_sst);
                        this.setMxy(Txx * xy_sst + Txy * yy_sst);
                        this.setMxz(Txz);
                        this.setTx(Txx * tx_sst + Txy * ty_sst);
                        this.setMyx(Tyx * xx_sst + Tyy * yx_sst);
                        this.setMyy(Tyx * xy_sst + Tyy * yy_sst);
                        this.setMyz(Tyz);
                        this.setTy(Tyx * tx_sst + Tyy * ty_sst);
                        this.setMzx(Tzx * xx_sst + Tzy * yx_sst);
                        this.setMzy(Tzx * xy_sst + Tzy * yy_sst);
                        this.setMzz(Tzz);
                        this.setTz(Tzx * tx_sst + Tzy * ty_sst);
                        break block0;
                    }
                    case 6: {
                        double xx_ss = this.getMxx();
                        double xy_ss = this.getMxy();
                        double yx_ss = this.getMyx();
                        double yy_ss = this.getMyy();
                        this.setMxx(Txx * xx_ss + Txy * yx_ss);
                        this.setMxy(Txx * xy_ss + Txy * yy_ss);
                        this.setMxz(Txz);
                        this.setMyx(Tyx * xx_ss + Tyy * yx_ss);
                        this.setMyy(Tyx * xy_ss + Tyy * yy_ss);
                        this.setMyz(Tyz);
                        this.setMzx(Tzx * xx_ss + Tzy * yx_ss);
                        this.setMzy(Tzx * xy_ss + Tzy * yy_ss);
                        this.setMzz(Tzz);
                        break block0;
                    }
                    case 5: {
                        double xy_sht = this.getMxy();
                        double tx_sht = this.getTx();
                        double yx_sht = this.getMyx();
                        double ty_sht = this.getTy();
                        this.setMxx(Txy * yx_sht);
                        this.setMxy(Txx * xy_sht);
                        this.setMxz(Txz);
                        this.setTx(Txx * tx_sht + Txy * ty_sht);
                        this.setMyx(Tyy * yx_sht);
                        this.setMyy(Tyx * xy_sht);
                        this.setMyz(Tyz);
                        this.setTy(Tyx * tx_sht + Tyy * ty_sht);
                        this.setMzx(Tzy * yx_sht);
                        this.setMzy(Tzx * xy_sht);
                        this.setMzz(Tzz);
                        this.setTz(Tzx * tx_sht + Tzy * ty_sht);
                        break block0;
                    }
                    case 4: {
                        double xy_sh = this.getMxy();
                        double yx_sh = this.getMyx();
                        this.setMxx(Txy * yx_sh);
                        this.setMxy(Txx * xy_sh);
                        this.setMxz(Txz);
                        this.setMyx(Tyy * yx_sh);
                        this.setMyy(Tyx * xy_sh);
                        this.setMyz(Tyz);
                        this.setMzx(Tzy * yx_sh);
                        this.setMzy(Tzx * xy_sh);
                        this.setMzz(Tzz);
                        break block0;
                    }
                    case 3: {
                        double xx_st = this.getMxx();
                        double tx_st = this.getTx();
                        double yy_st = this.getMyy();
                        double ty_st = this.getTy();
                        this.setMxx(Txx * xx_st);
                        this.setMxy(Txy * yy_st);
                        this.setMxz(Txz);
                        this.setTx(Txx * tx_st + Txy * ty_st);
                        this.setMyx(Tyx * xx_st);
                        this.setMyy(Tyy * yy_st);
                        this.setMyz(Tyz);
                        this.setTy(Tyx * tx_st + Tyy * ty_st);
                        this.setMzx(Tzx * xx_st);
                        this.setMzy(Tzy * yy_st);
                        this.setMzz(Tzz);
                        this.setTz(Tzx * tx_st + Tzy * ty_st);
                        break block0;
                    }
                    case 2: {
                        double xx_s = this.getMxx();
                        double yy_s = this.getMyy();
                        this.setMxx(Txx * xx_s);
                        this.setMxy(Txy * yy_s);
                        this.setMxz(Txz);
                        this.setMyx(Tyx * xx_s);
                        this.setMyy(Tyy * yy_s);
                        this.setMyz(Tyz);
                        this.setMzx(Tzx * xx_s);
                        this.setMzy(Tzy * yy_s);
                        this.setMzz(Tzz);
                        break block0;
                    }
                    case 1: {
                        double tx_t = this.getTx();
                        double ty_t = this.getTy();
                        this.setMxx(Txx);
                        this.setMxy(Txy);
                        this.setMxz(Txz);
                        this.setTx(Txx * tx_t + Txy * ty_t);
                        this.setMyx(Tyx);
                        this.setMyy(Tyy);
                        this.setMyz(Tyz);
                        this.setTy(Tyx * tx_t + Tyy * ty_t);
                        this.setMzx(Tzx);
                        this.setMzy(Tzy);
                        this.setMzz(Tzz);
                        this.setTz(Tzx * tx_t + Tzy * ty_t);
                        break block0;
                    }
                    case 0: 
                }
                this.setMxx(Txx);
                this.setMxy(Txy);
                this.setMxz(Txz);
                this.setMyx(Tyx);
                this.setMyy(Tyy);
                this.setMyz(Tyz);
                this.setMzx(Tzx);
                this.setMzy(Tzy);
                this.setMzz(Tzz);
                break;
            }
            case 1: {
                double tx_t = this.getTx();
                double ty_t = this.getTy();
                double tz_t = this.getTz();
                this.setMxx(Txx);
                this.setMxy(Txy);
                this.setMxz(Txz);
                this.setMyx(Tyx);
                this.setMyy(Tyy);
                this.setMyz(Tyz);
                this.setMzx(Tzx);
                this.setMzy(Tzy);
                this.setMzz(Tzz);
                this.setTx(Txx * tx_t + Txy * ty_t + Txz * tz_t);
                this.setTy(Tyx * tx_t + Tyy * ty_t + Tyz * tz_t);
                this.setTz(Tzx * tx_t + Tzy * ty_t + Tzz * tz_t);
                break;
            }
            case 2: {
                double xx_s = this.getMxx();
                double yy_s = this.getMyy();
                double zz_s = this.getMzz();
                this.setMxx(Txx * xx_s);
                this.setMxy(Txy * yy_s);
                this.setMxz(Txz * zz_s);
                this.setMyx(Tyx * xx_s);
                this.setMyy(Tyy * yy_s);
                this.setMyz(Tyz * zz_s);
                this.setMzx(Tzx * xx_s);
                this.setMzy(Tzy * yy_s);
                this.setMzz(Tzz * zz_s);
                break;
            }
            case 3: {
                double xx_st = this.getMxx();
                double tx_st = this.getTx();
                double yy_st = this.getMyy();
                double ty_st = this.getTy();
                double zz_st = this.getMzz();
                double tz_st = this.getTz();
                this.setMxx(Txx * xx_st);
                this.setMxy(Txy * yy_st);
                this.setMxz(Txz * zz_st);
                this.setTx(Txx * tx_st + Txy * ty_st + Txz * tz_st);
                this.setMyx(Tyx * xx_st);
                this.setMyy(Tyy * yy_st);
                this.setMyz(Tyz * zz_st);
                this.setTy(Tyx * tx_st + Tyy * ty_st + Tyz * tz_st);
                this.setMzx(Tzx * xx_st);
                this.setMzy(Tzy * yy_st);
                this.setMzz(Tzz * zz_st);
                this.setTz(Tzx * tx_st + Tzy * ty_st + Tzz * tz_st);
                break;
            }
            case 4: {
                double m_xx = this.getMxx();
                double m_xy = this.getMxy();
                double m_xz = this.getMxz();
                double t_x = this.getTx();
                double m_yx = this.getMyx();
                double m_yy = this.getMyy();
                double m_yz = this.getMyz();
                double t_y = this.getTy();
                double m_zx = this.getMzx();
                double m_zy = this.getMzy();
                double m_zz = this.getMzz();
                double t_z = this.getTz();
                this.setMxx(Txx * m_xx + Txy * m_yx + Txz * m_zx);
                this.setMxy(Txx * m_xy + Txy * m_yy + Txz * m_zy);
                this.setMxz(Txx * m_xz + Txy * m_yz + Txz * m_zz);
                this.setTx(Txx * t_x + Txy * t_y + Txz * t_z);
                this.setMyx(Tyx * m_xx + Tyy * m_yx + Tyz * m_zx);
                this.setMyy(Tyx * m_xy + Tyy * m_yy + Tyz * m_zy);
                this.setMyz(Tyx * m_xz + Tyy * m_yz + Tyz * m_zz);
                this.setTy(Tyx * t_x + Tyy * t_y + Tyz * t_z);
                this.setMzx(Tzx * m_xx + Tzy * m_yx + Tzz * m_zx);
                this.setMzy(Tzx * m_xy + Tzy * m_yy + Tzz * m_zy);
                this.setMzz(Tzx * m_xz + Tzy * m_yz + Tzz * m_zz);
                this.setTz(Tzx * t_x + Tzy * t_y + Tzz * t_z);
            }
        }
        this.updateState();
    }

    private void preRotate2D(double theta) {
        if (this.state3d != 0) {
            this.preRotate3D(theta);
            return;
        }
        double sin = Math.sin(Math.toRadians(theta));
        if (sin == 1.0) {
            this.preRotate2D_90();
        } else if (sin == -1.0) {
            this.preRotate2D_270();
        } else {
            double cos = Math.cos(Math.toRadians(theta));
            if (cos == -1.0) {
                this.preRotate2D_180();
            } else if (cos != 1.0) {
                double M0 = this.getMxx();
                double M1 = this.getMyx();
                this.setMxx(cos * M0 - sin * M1);
                this.setMyx(sin * M0 + cos * M1);
                M0 = this.getMxy();
                M1 = this.getMyy();
                this.setMxy(cos * M0 - sin * M1);
                this.setMyy(sin * M0 + cos * M1);
                M0 = this.getTx();
                M1 = this.getTy();
                this.setTx(cos * M0 - sin * M1);
                this.setTy(sin * M0 + cos * M1);
                this.updateState2D();
            }
        }
    }

    private void preRotate2D_90() {
        double M0 = this.getMxx();
        this.setMxx(-this.getMyx());
        this.setMyx(M0);
        M0 = this.getMxy();
        this.setMxy(-this.getMyy());
        this.setMyy(M0);
        M0 = this.getTx();
        this.setTx(-this.getTy());
        this.setTy(M0);
        int newstate = rot90conversion[this.state2d];
        if ((newstate & 6) == 2 && this.getMxx() == 1.0 && this.getMyy() == 1.0) {
            newstate -= 2;
        } else if ((newstate & 6) == 4 && this.getMxy() == 0.0 && this.getMyx() == 0.0) {
            newstate = newstate & 0xFFFFFFFB | 2;
        }
        this.state2d = newstate;
    }

    private void preRotate2D_180() {
        this.setMxx(-this.getMxx());
        this.setMxy(-this.getMxy());
        this.setTx(-this.getTx());
        this.setMyx(-this.getMyx());
        this.setMyy(-this.getMyy());
        this.setTy(-this.getTy());
        this.state2d = (this.state2d & 4) != 0 ? (this.getMxx() == 0.0 && this.getMyy() == 0.0 ? (this.state2d &= 0xFFFFFFFD) : (this.state2d |= 2)) : (this.getMxx() == 1.0 && this.getMyy() == 1.0 ? (this.state2d &= 0xFFFFFFFD) : (this.state2d |= 2));
    }

    private void preRotate2D_270() {
        double M0 = this.getMxx();
        this.setMxx(this.getMyx());
        this.setMyx(-M0);
        M0 = this.getMxy();
        this.setMxy(this.getMyy());
        this.setMyy(-M0);
        M0 = this.getTx();
        this.setTx(this.getTy());
        this.setTy(-M0);
        int newstate = rot90conversion[this.state2d];
        if ((newstate & 6) == 2 && this.getMxx() == 1.0 && this.getMyy() == 1.0) {
            newstate -= 2;
        } else if ((newstate & 6) == 4 && this.getMxy() == 0.0 && this.getMyx() == 0.0) {
            newstate = newstate & 0xFFFFFFFB | 2;
        }
        this.state2d = newstate;
    }

    private void preRotate3D(double theta) {
        if (this.state3d == 0) {
            this.preRotate2D(theta);
            return;
        }
        double sin = Math.sin(Math.toRadians(theta));
        if (sin == 1.0) {
            this.preRotate3D_90();
        } else if (sin == -1.0) {
            this.preRotate3D_270();
        } else {
            double cos = Math.cos(Math.toRadians(theta));
            if (cos == -1.0) {
                this.preRotate3D_180();
            } else if (cos != 1.0) {
                double M0 = this.getMxx();
                double M1 = this.getMyx();
                this.setMxx(cos * M0 - sin * M1);
                this.setMyx(sin * M0 + cos * M1);
                M0 = this.getMxy();
                M1 = this.getMyy();
                this.setMxy(cos * M0 - sin * M1);
                this.setMyy(sin * M0 + cos * M1);
                M0 = this.getMxz();
                M1 = this.getMyz();
                this.setMxz(cos * M0 - sin * M1);
                this.setMyz(sin * M0 + cos * M1);
                M0 = this.getTx();
                M1 = this.getTy();
                this.setTx(cos * M0 - sin * M1);
                this.setTy(sin * M0 + cos * M1);
                this.updateState();
            }
        }
    }

    private void preRotate3D_90() {
        double M0 = this.getMxx();
        this.setMxx(-this.getMyx());
        this.setMyx(M0);
        M0 = this.getMxy();
        this.setMxy(-this.getMyy());
        this.setMyy(M0);
        M0 = this.getMxz();
        this.setMxz(-this.getMyz());
        this.setMyz(M0);
        M0 = this.getTx();
        this.setTx(-this.getTy());
        this.setTy(M0);
        switch (this.state3d) {
            default: {
                Affine.stateError();
            }
            case 1: {
                this.state3d = 4;
                return;
            }
            case 2: 
            case 3: {
                if (this.getMxy() != 0.0 || this.getMyx() != 0.0) {
                    this.state3d = 4;
                }
                return;
            }
            case 4: 
        }
        this.updateState();
    }

    private void preRotate3D_180() {
        double mxx = this.getMxx();
        double myy = this.getMyy();
        this.setMxx(-mxx);
        this.setMyy(-myy);
        this.setTx(-this.getTx());
        this.setTy(-this.getTy());
        if (this.state3d == 4) {
            this.setMxy(-this.getMxy());
            this.setMxz(-this.getMxz());
            this.setMyx(-this.getMyx());
            this.setMyz(-this.getMyz());
            this.updateState();
            return;
        }
        this.state3d = mxx == -1.0 && myy == -1.0 && this.getMzz() == 1.0 ? (this.state3d &= 0xFFFFFFFD) : (this.state3d |= 2);
    }

    private void preRotate3D_270() {
        double M0 = this.getMxx();
        this.setMxx(this.getMyx());
        this.setMyx(-M0);
        M0 = this.getMxy();
        this.setMxy(this.getMyy());
        this.setMyy(-M0);
        M0 = this.getMxz();
        this.setMxz(this.getMyz());
        this.setMyz(-M0);
        M0 = this.getTx();
        this.setTx(this.getTy());
        this.setTy(-M0);
        switch (this.state3d) {
            default: {
                Affine.stateError();
            }
            case 1: {
                this.state3d = 4;
                return;
            }
            case 2: 
            case 3: {
                if (this.getMxy() != 0.0 || this.getMyx() != 0.0) {
                    this.state3d = 4;
                }
                return;
            }
            case 4: 
        }
        this.updateState();
    }

    @Override
    public Point2D transform(double x, double y) {
        this.ensureCanTransform2DPoint();
        switch (this.state2d) {
            default: {
                Affine.stateError();
            }
            case 7: {
                return new Point2D(this.getMxx() * x + this.getMxy() * y + this.getTx(), this.getMyx() * x + this.getMyy() * y + this.getTy());
            }
            case 6: {
                return new Point2D(this.getMxx() * x + this.getMxy() * y, this.getMyx() * x + this.getMyy() * y);
            }
            case 5: {
                return new Point2D(this.getMxy() * y + this.getTx(), this.getMyx() * x + this.getTy());
            }
            case 4: {
                return new Point2D(this.getMxy() * y, this.getMyx() * x);
            }
            case 3: {
                return new Point2D(this.getMxx() * x + this.getTx(), this.getMyy() * y + this.getTy());
            }
            case 2: {
                return new Point2D(this.getMxx() * x, this.getMyy() * y);
            }
            case 1: {
                return new Point2D(x + this.getTx(), y + this.getTy());
            }
            case 0: 
        }
        return new Point2D(x, y);
    }

    @Override
    public Point3D transform(double x, double y, double z) {
        switch (this.state3d) {
            default: {
                Affine.stateError();
            }
            case 0: {
                switch (this.state2d) {
                    default: {
                        Affine.stateError();
                    }
                    case 7: {
                        return new Point3D(this.getMxx() * x + this.getMxy() * y + this.getTx(), this.getMyx() * x + this.getMyy() * y + this.getTy(), z);
                    }
                    case 6: {
                        return new Point3D(this.getMxx() * x + this.getMxy() * y, this.getMyx() * x + this.getMyy() * y, z);
                    }
                    case 5: {
                        return new Point3D(this.getMxy() * y + this.getTx(), this.getMyx() * x + this.getTy(), z);
                    }
                    case 4: {
                        return new Point3D(this.getMxy() * y, this.getMyx() * x, z);
                    }
                    case 3: {
                        return new Point3D(this.getMxx() * x + this.getTx(), this.getMyy() * y + this.getTy(), z);
                    }
                    case 2: {
                        return new Point3D(this.getMxx() * x, this.getMyy() * y, z);
                    }
                    case 1: {
                        return new Point3D(x + this.getTx(), y + this.getTy(), z);
                    }
                    case 0: 
                }
                return new Point3D(x, y, z);
            }
            case 1: {
                return new Point3D(x + this.getTx(), y + this.getTy(), z + this.getTz());
            }
            case 2: {
                return new Point3D(this.getMxx() * x, this.getMyy() * y, this.getMzz() * z);
            }
            case 3: {
                return new Point3D(this.getMxx() * x + this.getTx(), this.getMyy() * y + this.getTy(), this.getMzz() * z + this.getTz());
            }
            case 4: 
        }
        return new Point3D(this.getMxx() * x + this.getMxy() * y + this.getMxz() * z + this.getTx(), this.getMyx() * x + this.getMyy() * y + this.getMyz() * z + this.getTy(), this.getMzx() * x + this.getMzy() * y + this.getMzz() * z + this.getTz());
    }

    @Override
    void transform2DPointsImpl(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        switch (this.state2d) {
            default: {
                Affine.stateError();
            }
            case 7: {
                double mxx = this.getMxx();
                double mxy = this.getMxy();
                double tx = this.getTx();
                double myx = this.getMyx();
                double myy = this.getMyy();
                double ty = this.getTy();
                while (--numPts >= 0) {
                    double x = srcPts[srcOff++];
                    double y = srcPts[srcOff++];
                    dstPts[dstOff++] = mxx * x + mxy * y + tx;
                    dstPts[dstOff++] = myx * x + myy * y + ty;
                }
                return;
            }
            case 6: {
                double mxx = this.getMxx();
                double mxy = this.getMxy();
                double myx = this.getMyx();
                double myy = this.getMyy();
                while (--numPts >= 0) {
                    double x = srcPts[srcOff++];
                    double y = srcPts[srcOff++];
                    dstPts[dstOff++] = mxx * x + mxy * y;
                    dstPts[dstOff++] = myx * x + myy * y;
                }
                return;
            }
            case 5: {
                double mxy = this.getMxy();
                double tx = this.getTx();
                double myx = this.getMyx();
                double ty = this.getTy();
                while (--numPts >= 0) {
                    double x = srcPts[srcOff++];
                    dstPts[dstOff++] = mxy * srcPts[srcOff++] + tx;
                    dstPts[dstOff++] = myx * x + ty;
                }
                return;
            }
            case 4: {
                double mxy = this.getMxy();
                double myx = this.getMyx();
                while (--numPts >= 0) {
                    double x = srcPts[srcOff++];
                    dstPts[dstOff++] = mxy * srcPts[srcOff++];
                    dstPts[dstOff++] = myx * x;
                }
                return;
            }
            case 3: {
                double mxx = this.getMxx();
                double tx = this.getTx();
                double myy = this.getMyy();
                double ty = this.getTy();
                while (--numPts >= 0) {
                    dstPts[dstOff++] = mxx * srcPts[srcOff++] + tx;
                    dstPts[dstOff++] = myy * srcPts[srcOff++] + ty;
                }
                return;
            }
            case 2: {
                double mxx = this.getMxx();
                double myy = this.getMyy();
                while (--numPts >= 0) {
                    dstPts[dstOff++] = mxx * srcPts[srcOff++];
                    dstPts[dstOff++] = myy * srcPts[srcOff++];
                }
                return;
            }
            case 1: {
                double tx = this.getTx();
                double ty = this.getTy();
                while (--numPts >= 0) {
                    dstPts[dstOff++] = srcPts[srcOff++] + tx;
                    dstPts[dstOff++] = srcPts[srcOff++] + ty;
                }
                return;
            }
            case 0: 
        }
        if (srcPts != dstPts || srcOff != dstOff) {
            System.arraycopy(srcPts, srcOff, dstPts, dstOff, numPts * 2);
        }
    }

    @Override
    void transform3DPointsImpl(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        switch (this.state3d) {
            default: {
                Affine.stateError();
            }
            case 0: {
                switch (this.state2d) {
                    default: {
                        Affine.stateError();
                    }
                    case 7: {
                        double mxx = this.getMxx();
                        double mxy = this.getMxy();
                        double tx = this.getTx();
                        double myx = this.getMyx();
                        double myy = this.getMyy();
                        double ty = this.getTy();
                        while (--numPts >= 0) {
                            double x = srcPts[srcOff++];
                            double y = srcPts[srcOff++];
                            dstPts[dstOff++] = mxx * x + mxy * y + tx;
                            dstPts[dstOff++] = myx * x + myy * y + ty;
                            dstPts[dstOff++] = srcPts[srcOff++];
                        }
                        return;
                    }
                    case 6: {
                        double mxx = this.getMxx();
                        double mxy = this.getMxy();
                        double myx = this.getMyx();
                        double myy = this.getMyy();
                        while (--numPts >= 0) {
                            double x = srcPts[srcOff++];
                            double y = srcPts[srcOff++];
                            dstPts[dstOff++] = mxx * x + mxy * y;
                            dstPts[dstOff++] = myx * x + myy * y;
                            dstPts[dstOff++] = srcPts[srcOff++];
                        }
                        return;
                    }
                    case 5: {
                        double mxy = this.getMxy();
                        double tx = this.getTx();
                        double myx = this.getMyx();
                        double ty = this.getTy();
                        while (--numPts >= 0) {
                            double x = srcPts[srcOff++];
                            dstPts[dstOff++] = mxy * srcPts[srcOff++] + tx;
                            dstPts[dstOff++] = myx * x + ty;
                            dstPts[dstOff++] = srcPts[srcOff++];
                        }
                        return;
                    }
                    case 4: {
                        double mxy = this.getMxy();
                        double myx = this.getMyx();
                        while (--numPts >= 0) {
                            double x = srcPts[srcOff++];
                            dstPts[dstOff++] = mxy * srcPts[srcOff++];
                            dstPts[dstOff++] = myx * x;
                            dstPts[dstOff++] = srcPts[srcOff++];
                        }
                        return;
                    }
                    case 3: {
                        double mxx = this.getMxx();
                        double tx = this.getTx();
                        double myy = this.getMyy();
                        double ty = this.getTy();
                        while (--numPts >= 0) {
                            dstPts[dstOff++] = mxx * srcPts[srcOff++] + tx;
                            dstPts[dstOff++] = myy * srcPts[srcOff++] + ty;
                            dstPts[dstOff++] = srcPts[srcOff++];
                        }
                        return;
                    }
                    case 2: {
                        double mxx = this.getMxx();
                        double myy = this.getMyy();
                        while (--numPts >= 0) {
                            dstPts[dstOff++] = mxx * srcPts[srcOff++];
                            dstPts[dstOff++] = myy * srcPts[srcOff++];
                            dstPts[dstOff++] = srcPts[srcOff++];
                        }
                        return;
                    }
                    case 1: {
                        double tx = this.getTx();
                        double ty = this.getTy();
                        while (--numPts >= 0) {
                            dstPts[dstOff++] = srcPts[srcOff++] + tx;
                            dstPts[dstOff++] = srcPts[srcOff++] + ty;
                            dstPts[dstOff++] = srcPts[srcOff++];
                        }
                        return;
                    }
                    case 0: 
                }
                if (srcPts != dstPts || srcOff != dstOff) {
                    System.arraycopy(srcPts, srcOff, dstPts, dstOff, numPts * 3);
                }
                return;
            }
            case 1: {
                double tx = this.getTx();
                double ty = this.getTy();
                double tz = this.getTz();
                while (--numPts >= 0) {
                    dstPts[dstOff++] = srcPts[srcOff++] + tx;
                    dstPts[dstOff++] = srcPts[srcOff++] + ty;
                    dstPts[dstOff++] = srcPts[srcOff++] + tz;
                }
                return;
            }
            case 2: {
                double mxx = this.getMxx();
                double myy = this.getMyy();
                double mzz = this.getMzz();
                while (--numPts >= 0) {
                    dstPts[dstOff++] = mxx * srcPts[srcOff++];
                    dstPts[dstOff++] = myy * srcPts[srcOff++];
                    dstPts[dstOff++] = mzz * srcPts[srcOff++];
                }
                return;
            }
            case 3: {
                double mxx = this.getMxx();
                double tx = this.getTx();
                double myy = this.getMyy();
                double ty = this.getTy();
                double mzz = this.getMzz();
                double tz = this.getTz();
                while (--numPts >= 0) {
                    dstPts[dstOff++] = mxx * srcPts[srcOff++] + tx;
                    dstPts[dstOff++] = myy * srcPts[srcOff++] + ty;
                    dstPts[dstOff++] = mzz * srcPts[srcOff++] + tz;
                }
                return;
            }
            case 4: 
        }
        double mxx = this.getMxx();
        double mxy = this.getMxy();
        double mxz = this.getMxz();
        double tx = this.getTx();
        double myx = this.getMyx();
        double myy = this.getMyy();
        double myz = this.getMyz();
        double ty = this.getTy();
        double mzx = this.getMzx();
        double mzy = this.getMzy();
        double mzz = this.getMzz();
        double tz = this.getTz();
        while (--numPts >= 0) {
            double x = srcPts[srcOff++];
            double y = srcPts[srcOff++];
            double z = srcPts[srcOff++];
            dstPts[dstOff++] = mxx * x + mxy * y + mxz * z + tx;
            dstPts[dstOff++] = myx * x + myy * y + myz * z + ty;
            dstPts[dstOff++] = mzx * x + mzy * y + mzz * z + tz;
        }
    }

    @Override
    public Point2D deltaTransform(double x, double y) {
        this.ensureCanTransform2DPoint();
        switch (this.state2d) {
            default: {
                Affine.stateError();
            }
            case 6: 
            case 7: {
                return new Point2D(this.getMxx() * x + this.getMxy() * y, this.getMyx() * x + this.getMyy() * y);
            }
            case 4: 
            case 5: {
                return new Point2D(this.getMxy() * y, this.getMyx() * x);
            }
            case 2: 
            case 3: {
                return new Point2D(this.getMxx() * x, this.getMyy() * y);
            }
            case 0: 
            case 1: 
        }
        return new Point2D(x, y);
    }

    @Override
    public Point3D deltaTransform(double x, double y, double z) {
        switch (this.state3d) {
            default: {
                Affine.stateError();
            }
            case 0: {
                switch (this.state2d) {
                    default: {
                        Affine.stateError();
                    }
                    case 6: 
                    case 7: {
                        return new Point3D(this.getMxx() * x + this.getMxy() * y, this.getMyx() * x + this.getMyy() * y, z);
                    }
                    case 4: 
                    case 5: {
                        return new Point3D(this.getMxy() * y, this.getMyx() * x, z);
                    }
                    case 2: 
                    case 3: {
                        return new Point3D(this.getMxx() * x, this.getMyy() * y, z);
                    }
                    case 0: 
                    case 1: 
                }
                return new Point3D(x, y, z);
            }
            case 1: {
                return new Point3D(x, y, z);
            }
            case 2: 
            case 3: {
                return new Point3D(this.getMxx() * x, this.getMyy() * y, this.getMzz() * z);
            }
            case 4: 
        }
        return new Point3D(this.getMxx() * x + this.getMxy() * y + this.getMxz() * z, this.getMyx() * x + this.getMyy() * y + this.getMyz() * z, this.getMzx() * x + this.getMzy() * y + this.getMzz() * z);
    }

    @Override
    public Point2D inverseTransform(double x, double y) throws NonInvertibleTransformException {
        this.ensureCanTransform2DPoint();
        switch (this.state2d) {
            default: {
                return super.inverseTransform(x, y);
            }
            case 5: {
                double mxy_st = this.getMxy();
                double myx_st = this.getMyx();
                if (mxy_st == 0.0 || myx_st == 0.0) {
                    throw new NonInvertibleTransformException("Determinant is 0");
                }
                return new Point2D(1.0 / myx_st * y - this.getTy() / myx_st, 1.0 / mxy_st * x - this.getTx() / mxy_st);
            }
            case 4: {
                double mxy_s = this.getMxy();
                double myx_s = this.getMyx();
                if (mxy_s == 0.0 || myx_s == 0.0) {
                    throw new NonInvertibleTransformException("Determinant is 0");
                }
                return new Point2D(1.0 / myx_s * y, 1.0 / mxy_s * x);
            }
            case 3: {
                double mxx_st = this.getMxx();
                double myy_st = this.getMyy();
                if (mxx_st == 0.0 || myy_st == 0.0) {
                    throw new NonInvertibleTransformException("Determinant is 0");
                }
                return new Point2D(1.0 / mxx_st * x - this.getTx() / mxx_st, 1.0 / myy_st * y - this.getTy() / myy_st);
            }
            case 2: {
                double mxx_s = this.getMxx();
                double myy_s = this.getMyy();
                if (mxx_s == 0.0 || myy_s == 0.0) {
                    throw new NonInvertibleTransformException("Determinant is 0");
                }
                return new Point2D(1.0 / mxx_s * x, 1.0 / myy_s * y);
            }
            case 1: {
                return new Point2D(x - this.getTx(), y - this.getTy());
            }
            case 0: 
        }
        return new Point2D(x, y);
    }

    @Override
    public Point3D inverseTransform(double x, double y, double z) throws NonInvertibleTransformException {
        switch (this.state3d) {
            default: {
                Affine.stateError();
            }
            case 0: {
                switch (this.state2d) {
                    default: {
                        return super.inverseTransform(x, y, z);
                    }
                    case 5: {
                        double mxy_st = this.getMxy();
                        double myx_st = this.getMyx();
                        if (mxy_st == 0.0 || myx_st == 0.0) {
                            throw new NonInvertibleTransformException("Determinant is 0");
                        }
                        return new Point3D(1.0 / myx_st * y - this.getTy() / myx_st, 1.0 / mxy_st * x - this.getTx() / mxy_st, z);
                    }
                    case 4: {
                        double mxy_s = this.getMxy();
                        double myx_s = this.getMyx();
                        if (mxy_s == 0.0 || myx_s == 0.0) {
                            throw new NonInvertibleTransformException("Determinant is 0");
                        }
                        return new Point3D(1.0 / myx_s * y, 1.0 / mxy_s * x, z);
                    }
                    case 3: {
                        double mxx_st = this.getMxx();
                        double myy_st = this.getMyy();
                        if (mxx_st == 0.0 || myy_st == 0.0) {
                            throw new NonInvertibleTransformException("Determinant is 0");
                        }
                        return new Point3D(1.0 / mxx_st * x - this.getTx() / mxx_st, 1.0 / myy_st * y - this.getTy() / myy_st, z);
                    }
                    case 2: {
                        double mxx_s = this.getMxx();
                        double myy_s = this.getMyy();
                        if (mxx_s == 0.0 || myy_s == 0.0) {
                            throw new NonInvertibleTransformException("Determinant is 0");
                        }
                        return new Point3D(1.0 / mxx_s * x, 1.0 / myy_s * y, z);
                    }
                    case 1: {
                        return new Point3D(x - this.getTx(), y - this.getTy(), z);
                    }
                    case 0: 
                }
                return new Point3D(x, y, z);
            }
            case 1: {
                return new Point3D(x - this.getTx(), y - this.getTy(), z - this.getTz());
            }
            case 2: {
                double mxx_s = this.getMxx();
                double myy_s = this.getMyy();
                double mzz_s = this.getMzz();
                if (mxx_s == 0.0 || myy_s == 0.0 || mzz_s == 0.0) {
                    throw new NonInvertibleTransformException("Determinant is 0");
                }
                return new Point3D(1.0 / mxx_s * x, 1.0 / myy_s * y, 1.0 / mzz_s * z);
            }
            case 3: {
                double mxx_st = this.getMxx();
                double myy_st = this.getMyy();
                double mzz_st = this.getMzz();
                if (mxx_st == 0.0 || myy_st == 0.0 || mzz_st == 0.0) {
                    throw new NonInvertibleTransformException("Determinant is 0");
                }
                return new Point3D(1.0 / mxx_st * x - this.getTx() / mxx_st, 1.0 / myy_st * y - this.getTy() / myy_st, 1.0 / mzz_st * z - this.getTz() / mzz_st);
            }
            case 4: 
        }
        return super.inverseTransform(x, y, z);
    }

    @Override
    void inverseTransform2DPointsImpl(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws NonInvertibleTransformException {
        switch (this.state2d) {
            default: {
                super.inverseTransform2DPointsImpl(srcPts, srcOff, dstPts, dstOff, numPts);
                return;
            }
            case 5: {
                double mxy = this.getMxy();
                double tx = this.getTx();
                double myx = this.getMyx();
                double ty = this.getTy();
                if (mxy == 0.0 || myx == 0.0) {
                    throw new NonInvertibleTransformException("Determinant is 0");
                }
                double tmp = tx;
                tx = -ty / myx;
                ty = -tmp / mxy;
                tmp = myx;
                myx = 1.0 / mxy;
                mxy = 1.0 / tmp;
                while (--numPts >= 0) {
                    double x = srcPts[srcOff++];
                    dstPts[dstOff++] = mxy * srcPts[srcOff++] + tx;
                    dstPts[dstOff++] = myx * x + ty;
                }
                return;
            }
            case 4: {
                double mxy = this.getMxy();
                double myx = this.getMyx();
                if (mxy == 0.0 || myx == 0.0) {
                    throw new NonInvertibleTransformException("Determinant is 0");
                }
                double tmp = myx;
                myx = 1.0 / mxy;
                mxy = 1.0 / tmp;
                while (--numPts >= 0) {
                    double x = srcPts[srcOff++];
                    dstPts[dstOff++] = mxy * srcPts[srcOff++];
                    dstPts[dstOff++] = myx * x;
                }
                return;
            }
            case 3: {
                double mxx = this.getMxx();
                double tx = this.getTx();
                double myy = this.getMyy();
                double ty = this.getTy();
                if (mxx == 0.0 || myy == 0.0) {
                    throw new NonInvertibleTransformException("Determinant is 0");
                }
                tx = -tx / mxx;
                ty = -ty / myy;
                mxx = 1.0 / mxx;
                myy = 1.0 / myy;
                while (--numPts >= 0) {
                    dstPts[dstOff++] = mxx * srcPts[srcOff++] + tx;
                    dstPts[dstOff++] = myy * srcPts[srcOff++] + ty;
                }
                return;
            }
            case 2: {
                double mxx = this.getMxx();
                double myy = this.getMyy();
                if (mxx == 0.0 || myy == 0.0) {
                    throw new NonInvertibleTransformException("Determinant is 0");
                }
                mxx = 1.0 / mxx;
                myy = 1.0 / myy;
                while (--numPts >= 0) {
                    dstPts[dstOff++] = mxx * srcPts[srcOff++];
                    dstPts[dstOff++] = myy * srcPts[srcOff++];
                }
                return;
            }
            case 1: {
                double tx = this.getTx();
                double ty = this.getTy();
                while (--numPts >= 0) {
                    dstPts[dstOff++] = srcPts[srcOff++] - tx;
                    dstPts[dstOff++] = srcPts[srcOff++] - ty;
                }
                return;
            }
            case 0: 
        }
        if (srcPts != dstPts || srcOff != dstOff) {
            System.arraycopy(srcPts, srcOff, dstPts, dstOff, numPts * 2);
        }
    }

    @Override
    void inverseTransform3DPointsImpl(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws NonInvertibleTransformException {
        switch (this.state3d) {
            default: {
                Affine.stateError();
            }
            case 0: {
                switch (this.state2d) {
                    default: {
                        super.inverseTransform3DPointsImpl(srcPts, srcOff, dstPts, dstOff, numPts);
                        return;
                    }
                    case 5: {
                        double mxy = this.getMxy();
                        double tx = this.getTx();
                        double myx = this.getMyx();
                        double ty = this.getTy();
                        if (mxy == 0.0 || myx == 0.0) {
                            throw new NonInvertibleTransformException("Determinant is 0");
                        }
                        double tmp = tx;
                        tx = -ty / myx;
                        ty = -tmp / mxy;
                        tmp = myx;
                        myx = 1.0 / mxy;
                        mxy = 1.0 / tmp;
                        while (--numPts >= 0) {
                            double x = srcPts[srcOff++];
                            dstPts[dstOff++] = mxy * srcPts[srcOff++] + tx;
                            dstPts[dstOff++] = myx * x + ty;
                            dstPts[dstOff++] = srcPts[srcOff++];
                        }
                        return;
                    }
                    case 4: {
                        double mxy = this.getMxy();
                        double myx = this.getMyx();
                        if (mxy == 0.0 || myx == 0.0) {
                            throw new NonInvertibleTransformException("Determinant is 0");
                        }
                        double tmp = myx;
                        myx = 1.0 / mxy;
                        mxy = 1.0 / tmp;
                        while (--numPts >= 0) {
                            double x = srcPts[srcOff++];
                            dstPts[dstOff++] = mxy * srcPts[srcOff++];
                            dstPts[dstOff++] = myx * x;
                            dstPts[dstOff++] = srcPts[srcOff++];
                        }
                        return;
                    }
                    case 3: {
                        double mxx = this.getMxx();
                        double tx = this.getTx();
                        double myy = this.getMyy();
                        double ty = this.getTy();
                        if (mxx == 0.0 || myy == 0.0) {
                            throw new NonInvertibleTransformException("Determinant is 0");
                        }
                        tx = -tx / mxx;
                        ty = -ty / myy;
                        mxx = 1.0 / mxx;
                        myy = 1.0 / myy;
                        while (--numPts >= 0) {
                            dstPts[dstOff++] = mxx * srcPts[srcOff++] + tx;
                            dstPts[dstOff++] = myy * srcPts[srcOff++] + ty;
                            dstPts[dstOff++] = srcPts[srcOff++];
                        }
                        return;
                    }
                    case 2: {
                        double mxx = this.getMxx();
                        double myy = this.getMyy();
                        if (mxx == 0.0 || myy == 0.0) {
                            throw new NonInvertibleTransformException("Determinant is 0");
                        }
                        mxx = 1.0 / mxx;
                        myy = 1.0 / myy;
                        while (--numPts >= 0) {
                            dstPts[dstOff++] = mxx * srcPts[srcOff++];
                            dstPts[dstOff++] = myy * srcPts[srcOff++];
                            dstPts[dstOff++] = srcPts[srcOff++];
                        }
                        return;
                    }
                    case 1: {
                        double tx = this.getTx();
                        double ty = this.getTy();
                        while (--numPts >= 0) {
                            dstPts[dstOff++] = srcPts[srcOff++] - tx;
                            dstPts[dstOff++] = srcPts[srcOff++] - ty;
                            dstPts[dstOff++] = srcPts[srcOff++];
                        }
                        return;
                    }
                    case 0: 
                }
                if (srcPts != dstPts || srcOff != dstOff) {
                    System.arraycopy(srcPts, srcOff, dstPts, dstOff, numPts * 3);
                }
                return;
            }
            case 1: {
                double tx = this.getTx();
                double ty = this.getTy();
                double tz = this.getTz();
                while (--numPts >= 0) {
                    dstPts[dstOff++] = srcPts[srcOff++] - tx;
                    dstPts[dstOff++] = srcPts[srcOff++] - ty;
                    dstPts[dstOff++] = srcPts[srcOff++] - tz;
                }
                return;
            }
            case 2: {
                double mxx = this.getMxx();
                double myy = this.getMyy();
                double mzz = this.getMzz();
                if (mxx == 0.0 || myy == 0.0 | mzz == 0.0) {
                    throw new NonInvertibleTransformException("Determinant is 0");
                }
                mxx = 1.0 / mxx;
                myy = 1.0 / myy;
                mzz = 1.0 / mzz;
                while (--numPts >= 0) {
                    dstPts[dstOff++] = mxx * srcPts[srcOff++];
                    dstPts[dstOff++] = myy * srcPts[srcOff++];
                    dstPts[dstOff++] = mzz * srcPts[srcOff++];
                }
                return;
            }
            case 3: {
                double mxx = this.getMxx();
                double tx = this.getTx();
                double myy = this.getMyy();
                double ty = this.getTy();
                double mzz = this.getMzz();
                double tz = this.getTz();
                if (mxx == 0.0 || myy == 0.0 || mzz == 0.0) {
                    throw new NonInvertibleTransformException("Determinant is 0");
                }
                tx = -tx / mxx;
                ty = -ty / myy;
                tz = -tz / mzz;
                mxx = 1.0 / mxx;
                myy = 1.0 / myy;
                mzz = 1.0 / mzz;
                while (--numPts >= 0) {
                    dstPts[dstOff++] = mxx * srcPts[srcOff++] + tx;
                    dstPts[dstOff++] = myy * srcPts[srcOff++] + ty;
                    dstPts[dstOff++] = mzz * srcPts[srcOff++] + tz;
                }
                return;
            }
            case 4: 
        }
        super.inverseTransform3DPointsImpl(srcPts, srcOff, dstPts, dstOff, numPts);
    }

    @Override
    public Point2D inverseDeltaTransform(double x, double y) throws NonInvertibleTransformException {
        this.ensureCanTransform2DPoint();
        switch (this.state2d) {
            default: {
                return super.inverseDeltaTransform(x, y);
            }
            case 4: 
            case 5: {
                double mxy_s = this.getMxy();
                double myx_s = this.getMyx();
                if (mxy_s == 0.0 || myx_s == 0.0) {
                    throw new NonInvertibleTransformException("Determinant is 0");
                }
                return new Point2D(1.0 / myx_s * y, 1.0 / mxy_s * x);
            }
            case 2: 
            case 3: {
                double mxx_s = this.getMxx();
                double myy_s = this.getMyy();
                if (mxx_s == 0.0 || myy_s == 0.0) {
                    throw new NonInvertibleTransformException("Determinant is 0");
                }
                return new Point2D(1.0 / mxx_s * x, 1.0 / myy_s * y);
            }
            case 0: 
            case 1: 
        }
        return new Point2D(x, y);
    }

    @Override
    public Point3D inverseDeltaTransform(double x, double y, double z) throws NonInvertibleTransformException {
        switch (this.state3d) {
            default: {
                Affine.stateError();
            }
            case 0: {
                switch (this.state2d) {
                    default: {
                        return super.inverseDeltaTransform(x, y, z);
                    }
                    case 4: 
                    case 5: {
                        double mxy_s = this.getMxy();
                        double myx_s = this.getMyx();
                        if (mxy_s == 0.0 || myx_s == 0.0) {
                            throw new NonInvertibleTransformException("Determinant is 0");
                        }
                        return new Point3D(1.0 / myx_s * y, 1.0 / mxy_s * x, z);
                    }
                    case 2: 
                    case 3: {
                        double mxx_s = this.getMxx();
                        double myy_s = this.getMyy();
                        if (mxx_s == 0.0 || myy_s == 0.0) {
                            throw new NonInvertibleTransformException("Determinant is 0");
                        }
                        return new Point3D(1.0 / mxx_s * x, 1.0 / myy_s * y, z);
                    }
                    case 0: 
                    case 1: 
                }
                return new Point3D(x, y, z);
            }
            case 1: {
                return new Point3D(x, y, z);
            }
            case 2: 
            case 3: {
                double mxx_s = this.getMxx();
                double myy_s = this.getMyy();
                double mzz_s = this.getMzz();
                if (mxx_s == 0.0 || myy_s == 0.0 || mzz_s == 0.0) {
                    throw new NonInvertibleTransformException("Determinant is 0");
                }
                return new Point3D(1.0 / mxx_s * x, 1.0 / myy_s * y, 1.0 / mzz_s * z);
            }
            case 4: 
        }
        return super.inverseDeltaTransform(x, y, z);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Affine [\n");
        sb.append("\t").append(this.getMxx());
        sb.append(", ").append(this.getMxy());
        sb.append(", ").append(this.getMxz());
        sb.append(", ").append(this.getTx());
        sb.append('\n');
        sb.append("\t").append(this.getMyx());
        sb.append(", ").append(this.getMyy());
        sb.append(", ").append(this.getMyz());
        sb.append(", ").append(this.getTy());
        sb.append('\n');
        sb.append("\t").append(this.getMzx());
        sb.append(", ").append(this.getMzy());
        sb.append(", ").append(this.getMzz());
        sb.append(", ").append(this.getTz());
        return sb.append("\n]").toString();
    }

    private void updateState() {
        this.updateState2D();
        this.state3d = 0;
        if (this.getMxz() != 0.0 || this.getMyz() != 0.0 || this.getMzx() != 0.0 || this.getMzy() != 0.0) {
            this.state3d = 4;
        } else if ((this.state2d & 4) == 0) {
            if (this.getTz() != 0.0) {
                this.state3d |= 1;
            }
            if (this.getMzz() != 1.0) {
                this.state3d |= 2;
            }
            if (this.state3d != 0) {
                this.state3d |= this.state2d & 3;
            }
        } else if (this.getMzz() != 1.0 || this.getTz() != 0.0) {
            this.state3d = 4;
        }
    }

    private void updateState2D() {
        this.state2d = this.getMxy() == 0.0 && this.getMyx() == 0.0 ? (this.getMxx() == 1.0 && this.getMyy() == 1.0 ? (this.getTx() == 0.0 && this.getTy() == 0.0 ? 0 : 1) : (this.getTx() == 0.0 && this.getTy() == 0.0 ? 2 : 3)) : (this.getMxx() == 0.0 && this.getMyy() == 0.0 ? (this.getTx() == 0.0 && this.getTy() == 0.0 ? 4 : 5) : (this.getTx() == 0.0 && this.getTy() == 0.0 ? 6 : 7));
    }

    private static void stateError() {
        throw new InternalError("missing case in a switch");
    }

    @Override
    void apply(Affine3D trans) {
        trans.concatenate(this.getMxx(), this.getMxy(), this.getMxz(), this.getTx(), this.getMyx(), this.getMyy(), this.getMyz(), this.getTy(), this.getMzx(), this.getMzy(), this.getMzz(), this.getTz());
    }

    @Override
    BaseTransform derive(BaseTransform trans) {
        switch (this.state3d) {
            default: {
                Affine.stateError();
            }
            case 0: {
                switch (this.state2d) {
                    case 0: {
                        return trans;
                    }
                    case 1: {
                        return trans.deriveWithTranslation(this.getTx(), this.getTy());
                    }
                    case 2: {
                        return trans.deriveWithScale(this.getMxx(), this.getMyy(), 1.0);
                    }
                }
                return trans.deriveWithConcatenation(this.getMxx(), this.getMyx(), this.getMxy(), this.getMyy(), this.getTx(), this.getTy());
            }
            case 1: {
                return trans.deriveWithTranslation(this.getTx(), this.getTy(), this.getTz());
            }
            case 2: {
                return trans.deriveWithScale(this.getMxx(), this.getMyy(), this.getMzz());
            }
            case 3: 
            case 4: 
        }
        return trans.deriveWithConcatenation(this.getMxx(), this.getMxy(), this.getMxz(), this.getTx(), this.getMyx(), this.getMyy(), this.getMyz(), this.getTy(), this.getMzx(), this.getMzy(), this.getMzz(), this.getTz());
    }

    int getState2d() {
        return this.state2d;
    }

    int getState3d() {
        return this.state3d;
    }

    boolean atomicChangeRuns() {
        return this.atomicChange.runs();
    }

    private class AffineAtomicChange {
        private boolean running = false;

        private AffineAtomicChange() {
        }

        private void start() {
            if (this.running) {
                throw new InternalError("Affine internal error: trying to run inner atomic operation");
            }
            if (Affine.this.mxx != null) {
                Affine.this.mxx.preProcessAtomicChange();
            }
            if (Affine.this.mxy != null) {
                Affine.this.mxy.preProcessAtomicChange();
            }
            if (Affine.this.mxz != null) {
                Affine.this.mxz.preProcessAtomicChange();
            }
            if (Affine.this.tx != null) {
                Affine.this.tx.preProcessAtomicChange();
            }
            if (Affine.this.myx != null) {
                Affine.this.myx.preProcessAtomicChange();
            }
            if (Affine.this.myy != null) {
                Affine.this.myy.preProcessAtomicChange();
            }
            if (Affine.this.myz != null) {
                Affine.this.myz.preProcessAtomicChange();
            }
            if (Affine.this.ty != null) {
                Affine.this.ty.preProcessAtomicChange();
            }
            if (Affine.this.mzx != null) {
                Affine.this.mzx.preProcessAtomicChange();
            }
            if (Affine.this.mzy != null) {
                Affine.this.mzy.preProcessAtomicChange();
            }
            if (Affine.this.mzz != null) {
                Affine.this.mzz.preProcessAtomicChange();
            }
            if (Affine.this.tz != null) {
                Affine.this.tz.preProcessAtomicChange();
            }
            this.running = true;
        }

        private void end() {
            this.running = false;
            Affine.this.transformChanged();
            if (Affine.this.mxx != null) {
                Affine.this.mxx.postProcessAtomicChange();
            }
            if (Affine.this.mxy != null) {
                Affine.this.mxy.postProcessAtomicChange();
            }
            if (Affine.this.mxz != null) {
                Affine.this.mxz.postProcessAtomicChange();
            }
            if (Affine.this.tx != null) {
                Affine.this.tx.postProcessAtomicChange();
            }
            if (Affine.this.myx != null) {
                Affine.this.myx.postProcessAtomicChange();
            }
            if (Affine.this.myy != null) {
                Affine.this.myy.postProcessAtomicChange();
            }
            if (Affine.this.myz != null) {
                Affine.this.myz.postProcessAtomicChange();
            }
            if (Affine.this.ty != null) {
                Affine.this.ty.postProcessAtomicChange();
            }
            if (Affine.this.mzx != null) {
                Affine.this.mzx.postProcessAtomicChange();
            }
            if (Affine.this.mzy != null) {
                Affine.this.mzy.postProcessAtomicChange();
            }
            if (Affine.this.mzz != null) {
                Affine.this.mzz.postProcessAtomicChange();
            }
            if (Affine.this.tz != null) {
                Affine.this.tz.postProcessAtomicChange();
            }
        }

        private void cancel() {
            this.running = false;
        }

        private boolean runs() {
            return this.running;
        }
    }

    private class AffineElementProperty
    extends SimpleDoubleProperty {
        private boolean needsValueChangedEvent;
        private double oldValue;

        public AffineElementProperty(double initialValue) {
            super(initialValue);
            this.needsValueChangedEvent = false;
        }

        public void invalidated() {
            if (!Affine.this.atomicChange.runs()) {
                Affine.this.updateState();
                Affine.this.transformChanged();
            }
        }

        protected void fireValueChangedEvent() {
            if (!Affine.this.atomicChange.runs()) {
                super.fireValueChangedEvent();
            } else {
                this.needsValueChangedEvent = true;
            }
        }

        private void preProcessAtomicChange() {
            this.oldValue = this.get();
        }

        private void postProcessAtomicChange() {
            if (this.needsValueChangedEvent) {
                this.needsValueChangedEvent = false;
                if (this.oldValue != this.get()) {
                    super.fireValueChangedEvent();
                }
            }
        }
    }
}

