/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.transform;

import com.sun.javafx.geom.transform.Affine3D;
import com.sun.javafx.geom.transform.BaseTransform;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.geometry.Point2D;
import javafx.geometry.Point3D;
import javafx.scene.transform.Affine;
import javafx.scene.transform.NonInvertibleTransformException;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;

public class Scale
extends Transform {
    private DoubleProperty x;
    private DoubleProperty y;
    private DoubleProperty z;
    private DoubleProperty pivotX;
    private DoubleProperty pivotY;
    private DoubleProperty pivotZ;

    public Scale() {
    }

    public Scale(double x, double y) {
        this.setX(x);
        this.setY(y);
    }

    public Scale(double x, double y, double pivotX, double pivotY) {
        this(x, y);
        this.setPivotX(pivotX);
        this.setPivotY(pivotY);
    }

    public Scale(double x, double y, double z) {
        this(x, y);
        this.setZ(z);
    }

    public Scale(double x, double y, double z, double pivotX, double pivotY, double pivotZ) {
        this(x, y, pivotX, pivotY);
        this.setZ(z);
        this.setPivotZ(pivotZ);
    }

    public final void setX(double value) {
        this.xProperty().set(value);
    }

    public final double getX() {
        return this.x == null ? 1.0 : this.x.get();
    }

    public final DoubleProperty xProperty() {
        if (this.x == null) {
            this.x = new DoublePropertyBase(1.0){

                public void invalidated() {
                    Scale.this.transformChanged();
                }

                public Object getBean() {
                    return Scale.this;
                }

                public String getName() {
                    return "x";
                }
            };
        }
        return this.x;
    }

    public final void setY(double value) {
        this.yProperty().set(value);
    }

    public final double getY() {
        return this.y == null ? 1.0 : this.y.get();
    }

    public final DoubleProperty yProperty() {
        if (this.y == null) {
            this.y = new DoublePropertyBase(1.0){

                public void invalidated() {
                    Scale.this.transformChanged();
                }

                public Object getBean() {
                    return Scale.this;
                }

                public String getName() {
                    return "y";
                }
            };
        }
        return this.y;
    }

    public final void setZ(double value) {
        this.zProperty().set(value);
    }

    public final double getZ() {
        return this.z == null ? 1.0 : this.z.get();
    }

    public final DoubleProperty zProperty() {
        if (this.z == null) {
            this.z = new DoublePropertyBase(1.0){

                public void invalidated() {
                    Scale.this.transformChanged();
                }

                public Object getBean() {
                    return Scale.this;
                }

                public String getName() {
                    return "z";
                }
            };
        }
        return this.z;
    }

    public final void setPivotX(double value) {
        this.pivotXProperty().set(value);
    }

    public final double getPivotX() {
        return this.pivotX == null ? 0.0 : this.pivotX.get();
    }

    public final DoubleProperty pivotXProperty() {
        if (this.pivotX == null) {
            this.pivotX = new DoublePropertyBase(){

                public void invalidated() {
                    Scale.this.transformChanged();
                }

                public Object getBean() {
                    return Scale.this;
                }

                public String getName() {
                    return "pivotX";
                }
            };
        }
        return this.pivotX;
    }

    public final void setPivotY(double value) {
        this.pivotYProperty().set(value);
    }

    public final double getPivotY() {
        return this.pivotY == null ? 0.0 : this.pivotY.get();
    }

    public final DoubleProperty pivotYProperty() {
        if (this.pivotY == null) {
            this.pivotY = new DoublePropertyBase(){

                public void invalidated() {
                    Scale.this.transformChanged();
                }

                public Object getBean() {
                    return Scale.this;
                }

                public String getName() {
                    return "pivotY";
                }
            };
        }
        return this.pivotY;
    }

    public final void setPivotZ(double value) {
        this.pivotZProperty().set(value);
    }

    public final double getPivotZ() {
        return this.pivotZ == null ? 0.0 : this.pivotZ.get();
    }

    public final DoubleProperty pivotZProperty() {
        if (this.pivotZ == null) {
            this.pivotZ = new DoublePropertyBase(){

                public void invalidated() {
                    Scale.this.transformChanged();
                }

                public Object getBean() {
                    return Scale.this;
                }

                public String getName() {
                    return "pivotZ";
                }
            };
        }
        return this.pivotZ;
    }

    @Override
    public double getMxx() {
        return this.getX();
    }

    @Override
    public double getMyy() {
        return this.getY();
    }

    @Override
    public double getMzz() {
        return this.getZ();
    }

    @Override
    public double getTx() {
        return (1.0 - this.getX()) * this.getPivotX();
    }

    @Override
    public double getTy() {
        return (1.0 - this.getY()) * this.getPivotY();
    }

    @Override
    public double getTz() {
        return (1.0 - this.getZ()) * this.getPivotZ();
    }

    @Override
    boolean computeIs2D() {
        return this.getZ() == 1.0;
    }

    @Override
    boolean computeIsIdentity() {
        return this.getX() == 1.0 && this.getY() == 1.0 && this.getZ() == 1.0;
    }

    @Override
    void fill2DArray(double[] array) {
        double sx = this.getX();
        double sy = this.getY();
        array[0] = sx;
        array[1] = 0.0;
        array[2] = (1.0 - sx) * this.getPivotX();
        array[3] = 0.0;
        array[4] = sy;
        array[5] = (1.0 - sy) * this.getPivotY();
    }

    @Override
    void fill3DArray(double[] array) {
        double sx = this.getX();
        double sy = this.getY();
        double sz = this.getZ();
        array[0] = sx;
        array[1] = 0.0;
        array[2] = 0.0;
        array[3] = (1.0 - sx) * this.getPivotX();
        array[4] = 0.0;
        array[5] = sy;
        array[6] = 0.0;
        array[7] = (1.0 - sy) * this.getPivotY();
        array[8] = 0.0;
        array[9] = 0.0;
        array[10] = sz;
        array[11] = (1.0 - sz) * this.getPivotZ();
    }

    @Override
    public Transform createConcatenation(Transform transform) {
        Scale other;
        double sx = this.getX();
        double sy = this.getY();
        double sz = this.getZ();
        if (transform instanceof Scale && (other = (Scale)transform).getPivotX() == this.getPivotX() && other.getPivotY() == this.getPivotY() && other.getPivotZ() == this.getPivotZ()) {
            return new Scale(sx * other.getX(), sy * other.getY(), sz * other.getZ(), this.getPivotX(), this.getPivotY(), this.getPivotZ());
        }
        if (transform instanceof Translate) {
            Translate t = (Translate)transform;
            double tx = t.getX();
            double ty = t.getY();
            double tz = t.getZ();
            if ((tx == 0.0 || sx != 1.0 && sx != 0.0) && (ty == 0.0 || sy != 1.0 && sy != 0.0) && (tz == 0.0 || sz != 1.0 && sz != 0.0)) {
                return new Scale(sx, sy, sz, (sx != 1.0 ? sx * tx / (1.0 - sx) : 0.0) + this.getPivotX(), (sy != 1.0 ? sy * ty / (1.0 - sy) : 0.0) + this.getPivotY(), (sz != 1.0 ? sz * tz / (1.0 - sz) : 0.0) + this.getPivotZ());
            }
        }
        if (transform instanceof Affine) {
            Affine a = (Affine)transform.clone();
            a.prepend(this);
            return a;
        }
        double txx = transform.getMxx();
        double txy = transform.getMxy();
        double txz = transform.getMxz();
        double ttx = transform.getTx();
        double tyx = transform.getMyx();
        double tyy = transform.getMyy();
        double tyz = transform.getMyz();
        double tty = transform.getTy();
        double tzx = transform.getMzx();
        double tzy = transform.getMzy();
        double tzz = transform.getMzz();
        double ttz = transform.getTz();
        return new Affine(sx * txx, sx * txy, sx * txz, sx * ttx + (1.0 - sx) * this.getPivotX(), sy * tyx, sy * tyy, sy * tyz, sy * tty + (1.0 - sy) * this.getPivotY(), sz * tzx, sz * tzy, sz * tzz, sz * ttz + (1.0 - sz) * this.getPivotZ());
    }

    @Override
    public Scale createInverse() throws NonInvertibleTransformException {
        double sx = this.getX();
        double sy = this.getY();
        double sz = this.getZ();
        if (sx == 0.0 || sy == 0.0 || sz == 0.0) {
            throw new NonInvertibleTransformException("Zero scale is not invertible");
        }
        return new Scale(1.0 / sx, 1.0 / sy, 1.0 / sz, this.getPivotX(), this.getPivotY(), this.getPivotZ());
    }

    @Override
    public Scale clone() {
        return new Scale(this.getX(), this.getY(), this.getZ(), this.getPivotX(), this.getPivotY(), this.getPivotZ());
    }

    @Override
    public Point2D transform(double x, double y) {
        this.ensureCanTransform2DPoint();
        double mxx = this.getX();
        double myy = this.getY();
        return new Point2D(mxx * x + (1.0 - mxx) * this.getPivotX(), myy * y + (1.0 - myy) * this.getPivotY());
    }

    @Override
    public Point3D transform(double x, double y, double z) {
        double mxx = this.getX();
        double myy = this.getY();
        double mzz = this.getZ();
        return new Point3D(mxx * x + (1.0 - mxx) * this.getPivotX(), myy * y + (1.0 - myy) * this.getPivotY(), mzz * z + (1.0 - mzz) * this.getPivotZ());
    }

    @Override
    void transform2DPointsImpl(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        double xx = this.getX();
        double yy = this.getY();
        double px = this.getPivotX();
        double py = this.getPivotY();
        while (--numPts >= 0) {
            double x = srcPts[srcOff++];
            double y = srcPts[srcOff++];
            dstPts[dstOff++] = xx * x + (1.0 - xx) * px;
            dstPts[dstOff++] = yy * y + (1.0 - yy) * py;
        }
    }

    @Override
    void transform3DPointsImpl(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        double xx = this.getX();
        double yy = this.getY();
        double zz = this.getZ();
        double px = this.getPivotX();
        double py = this.getPivotY();
        double pz = this.getPivotZ();
        while (--numPts >= 0) {
            dstPts[dstOff++] = xx * srcPts[srcOff++] + (1.0 - xx) * px;
            dstPts[dstOff++] = yy * srcPts[srcOff++] + (1.0 - yy) * py;
            dstPts[dstOff++] = zz * srcPts[srcOff++] + (1.0 - zz) * pz;
        }
    }

    @Override
    public Point2D deltaTransform(double x, double y) {
        this.ensureCanTransform2DPoint();
        return new Point2D(this.getX() * x, this.getY() * y);
    }

    @Override
    public Point3D deltaTransform(double x, double y, double z) {
        return new Point3D(this.getX() * x, this.getY() * y, this.getZ() * z);
    }

    @Override
    public Point2D inverseTransform(double x, double y) throws NonInvertibleTransformException {
        this.ensureCanTransform2DPoint();
        double sx = this.getX();
        double sy = this.getY();
        if (sx == 0.0 || sy == 0.0) {
            throw new NonInvertibleTransformException("Zero scale is not invertible");
        }
        double mxx = 1.0 / sx;
        double myy = 1.0 / sy;
        return new Point2D(mxx * x + (1.0 - mxx) * this.getPivotX(), myy * y + (1.0 - myy) * this.getPivotY());
    }

    @Override
    public Point3D inverseTransform(double x, double y, double z) throws NonInvertibleTransformException {
        double sx = this.getX();
        double sy = this.getY();
        double sz = this.getZ();
        if (sx == 0.0 || sy == 0.0 || sz == 0.0) {
            throw new NonInvertibleTransformException("Zero scale is not invertible");
        }
        double mxx = 1.0 / sx;
        double myy = 1.0 / sy;
        double mzz = 1.0 / sz;
        return new Point3D(mxx * x + (1.0 - mxx) * this.getPivotX(), myy * y + (1.0 - myy) * this.getPivotY(), mzz * z + (1.0 - mzz) * this.getPivotZ());
    }

    @Override
    void inverseTransform2DPointsImpl(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws NonInvertibleTransformException {
        double sx = this.getX();
        double sy = this.getY();
        if (sx == 0.0 || sy == 0.0) {
            throw new NonInvertibleTransformException("Zero scale is not invertible");
        }
        double xx = 1.0 / sx;
        double yy = 1.0 / sy;
        double px = this.getPivotX();
        double py = this.getPivotY();
        while (--numPts >= 0) {
            dstPts[dstOff++] = xx * srcPts[srcOff++] + (1.0 - xx) * px;
            dstPts[dstOff++] = yy * srcPts[srcOff++] + (1.0 - yy) * py;
        }
    }

    @Override
    void inverseTransform3DPointsImpl(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws NonInvertibleTransformException {
        double sx = this.getX();
        double sy = this.getY();
        double sz = this.getZ();
        if (sx == 0.0 || sy == 0.0 || sz == 0.0) {
            throw new NonInvertibleTransformException("Zero scale is not invertible");
        }
        double xx = 1.0 / sx;
        double yy = 1.0 / sy;
        double zz = 1.0 / sz;
        double px = this.getPivotX();
        double py = this.getPivotY();
        double pz = this.getPivotZ();
        while (--numPts >= 0) {
            dstPts[dstOff++] = xx * srcPts[srcOff++] + (1.0 - xx) * px;
            dstPts[dstOff++] = yy * srcPts[srcOff++] + (1.0 - yy) * py;
            dstPts[dstOff++] = zz * srcPts[srcOff++] + (1.0 - zz) * pz;
        }
    }

    @Override
    public Point2D inverseDeltaTransform(double x, double y) throws NonInvertibleTransformException {
        this.ensureCanTransform2DPoint();
        double sx = this.getX();
        double sy = this.getY();
        if (sx == 0.0 || sy == 0.0) {
            throw new NonInvertibleTransformException("Zero scale is not invertible");
        }
        return new Point2D(1.0 / sx * x, 1.0 / sy * y);
    }

    @Override
    public Point3D inverseDeltaTransform(double x, double y, double z) throws NonInvertibleTransformException {
        double sx = this.getX();
        double sy = this.getY();
        double sz = this.getZ();
        if (sx == 0.0 || sy == 0.0 || sz == 0.0) {
            throw new NonInvertibleTransformException("Zero scale is not invertible");
        }
        return new Point3D(1.0 / sx * x, 1.0 / sy * y, 1.0 / sz * z);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Scale [");
        sb.append("x=").append(this.getX());
        sb.append(", y=").append(this.getY());
        sb.append(", z=").append(this.getZ());
        sb.append(", pivotX=").append(this.getPivotX());
        sb.append(", pivotY=").append(this.getPivotY());
        sb.append(", pivotZ=").append(this.getPivotZ());
        return sb.append("]").toString();
    }

    @Override
    void apply(Affine3D trans) {
        if (this.getPivotX() != 0.0 || this.getPivotY() != 0.0 || this.getPivotZ() != 0.0) {
            trans.translate(this.getPivotX(), this.getPivotY(), this.getPivotZ());
            trans.scale(this.getX(), this.getY(), this.getZ());
            trans.translate(-this.getPivotX(), -this.getPivotY(), -this.getPivotZ());
        } else {
            trans.scale(this.getX(), this.getY(), this.getZ());
        }
    }

    @Override
    BaseTransform derive(BaseTransform trans) {
        if (this.isIdentity()) {
            return trans;
        }
        if (this.getPivotX() != 0.0 || this.getPivotY() != 0.0 || this.getPivotZ() != 0.0) {
            trans = trans.deriveWithTranslation(this.getPivotX(), this.getPivotY(), this.getPivotZ());
            trans = trans.deriveWithScale(this.getX(), this.getY(), this.getZ());
            return trans.deriveWithTranslation(-this.getPivotX(), -this.getPivotY(), -this.getPivotZ());
        }
        return trans.deriveWithScale(this.getX(), this.getY(), this.getZ());
    }

    @Override
    void validate() {
        this.getX();
        this.getPivotX();
        this.getY();
        this.getPivotY();
        this.getZ();
        this.getPivotZ();
    }

    @Override
    void appendTo(Affine a) {
        a.appendScale(this.getX(), this.getY(), this.getZ(), this.getPivotX(), this.getPivotY(), this.getPivotZ());
    }

    @Override
    void prependTo(Affine a) {
        a.prependScale(this.getX(), this.getY(), this.getZ(), this.getPivotX(), this.getPivotY(), this.getPivotZ());
    }
}

