/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.transform;

import com.sun.javafx.geom.transform.Affine3D;
import com.sun.javafx.geom.transform.BaseTransform;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.geometry.Point2D;
import javafx.geometry.Point3D;
import javafx.scene.transform.Affine;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Transform;

public class Translate
extends Transform {
    private DoubleProperty x;
    private DoubleProperty y;
    private DoubleProperty z;

    public Translate() {
    }

    public Translate(double x, double y) {
        this.setX(x);
        this.setY(y);
    }

    public Translate(double x, double y, double z) {
        this(x, y);
        this.setZ(z);
    }

    public final void setX(double value) {
        this.xProperty().set(value);
    }

    public final double getX() {
        return this.x == null ? 0.0 : this.x.get();
    }

    public final DoubleProperty xProperty() {
        if (this.x == null) {
            this.x = new DoublePropertyBase(){

                public void invalidated() {
                    Translate.this.transformChanged();
                }

                public Object getBean() {
                    return Translate.this;
                }

                public String getName() {
                    return "x";
                }
            };
        }
        return this.x;
    }

    public final void setY(double value) {
        this.yProperty().set(value);
    }

    public final double getY() {
        return this.y == null ? 0.0 : this.y.get();
    }

    public final DoubleProperty yProperty() {
        if (this.y == null) {
            this.y = new DoublePropertyBase(){

                public void invalidated() {
                    Translate.this.transformChanged();
                }

                public Object getBean() {
                    return Translate.this;
                }

                public String getName() {
                    return "y";
                }
            };
        }
        return this.y;
    }

    public final void setZ(double value) {
        this.zProperty().set(value);
    }

    public final double getZ() {
        return this.z == null ? 0.0 : this.z.get();
    }

    public final DoubleProperty zProperty() {
        if (this.z == null) {
            this.z = new DoublePropertyBase(){

                public void invalidated() {
                    Translate.this.transformChanged();
                }

                public Object getBean() {
                    return Translate.this;
                }

                public String getName() {
                    return "z";
                }
            };
        }
        return this.z;
    }

    @Override
    public double getTx() {
        return this.getX();
    }

    @Override
    public double getTy() {
        return this.getY();
    }

    @Override
    public double getTz() {
        return this.getZ();
    }

    @Override
    boolean computeIs2D() {
        return this.getZ() == 0.0;
    }

    @Override
    boolean computeIsIdentity() {
        return this.getX() == 0.0 && this.getY() == 0.0 && this.getZ() == 0.0;
    }

    @Override
    void fill2DArray(double[] array) {
        array[0] = 1.0;
        array[1] = 0.0;
        array[2] = this.getX();
        array[3] = 0.0;
        array[4] = 1.0;
        array[5] = this.getY();
    }

    @Override
    void fill3DArray(double[] array) {
        array[0] = 1.0;
        array[1] = 0.0;
        array[2] = 0.0;
        array[3] = this.getX();
        array[4] = 0.0;
        array[5] = 1.0;
        array[6] = 0.0;
        array[7] = this.getY();
        array[8] = 0.0;
        array[9] = 0.0;
        array[10] = 1.0;
        array[11] = this.getZ();
    }

    @Override
    public Transform createConcatenation(Transform transform) {
        if (transform instanceof Translate) {
            Translate t = (Translate)transform;
            return new Translate(this.getX() + t.getX(), this.getY() + t.getY(), this.getZ() + t.getZ());
        }
        if (transform instanceof Scale) {
            Scale s = (Scale)transform;
            double sx = s.getX();
            double sy = s.getY();
            double sz = s.getZ();
            double tx = this.getX();
            double ty = this.getY();
            double tz = this.getZ();
            if (!(tx != 0.0 && sx == 1.0 || ty != 0.0 && sy == 1.0 || tz != 0.0 && sz == 1.0)) {
                return new Scale(sx, sy, sz, s.getPivotX() + (sx == 1.0 ? 0.0 : tx / (1.0 - sx)), s.getPivotY() + (sy == 1.0 ? 0.0 : ty / (1.0 - sy)), s.getPivotZ() + (sz == 1.0 ? 0.0 : tz / (1.0 - sz)));
            }
        }
        if (transform instanceof Affine) {
            Affine a = (Affine)transform.clone();
            a.prepend(this);
            return a;
        }
        double txx = transform.getMxx();
        double txy = transform.getMxy();
        double txz = transform.getMxz();
        double ttx = transform.getTx();
        double tyx = transform.getMyx();
        double tyy = transform.getMyy();
        double tyz = transform.getMyz();
        double tty = transform.getTy();
        double tzx = transform.getMzx();
        double tzy = transform.getMzy();
        double tzz = transform.getMzz();
        double ttz = transform.getTz();
        return new Affine(txx, txy, txz, ttx + this.getX(), tyx, tyy, tyz, tty + this.getY(), tzx, tzy, tzz, ttz + this.getZ());
    }

    @Override
    public Translate createInverse() {
        return new Translate(-this.getX(), -this.getY(), -this.getZ());
    }

    @Override
    public Translate clone() {
        return new Translate(this.getX(), this.getY(), this.getZ());
    }

    @Override
    public Point2D transform(double x, double y) {
        this.ensureCanTransform2DPoint();
        return new Point2D(x + this.getX(), y + this.getY());
    }

    @Override
    public Point3D transform(double x, double y, double z) {
        return new Point3D(x + this.getX(), y + this.getY(), z + this.getZ());
    }

    @Override
    void transform2DPointsImpl(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        double tx = this.getX();
        double ty = this.getY();
        while (--numPts >= 0) {
            double x = srcPts[srcOff++];
            double y = srcPts[srcOff++];
            dstPts[dstOff++] = x + tx;
            dstPts[dstOff++] = y + ty;
        }
    }

    @Override
    void transform3DPointsImpl(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        double tx = this.getX();
        double ty = this.getY();
        double tz = this.getZ();
        while (--numPts >= 0) {
            double x = srcPts[srcOff++];
            double y = srcPts[srcOff++];
            double z = srcPts[srcOff++];
            dstPts[dstOff++] = x + tx;
            dstPts[dstOff++] = y + ty;
            dstPts[dstOff++] = z + tz;
        }
    }

    @Override
    public Point2D deltaTransform(double x, double y) {
        this.ensureCanTransform2DPoint();
        return new Point2D(x, y);
    }

    @Override
    public Point2D deltaTransform(Point2D point) {
        if (point == null) {
            throw new NullPointerException();
        }
        this.ensureCanTransform2DPoint();
        return point;
    }

    @Override
    public Point3D deltaTransform(double x, double y, double z) {
        return new Point3D(x, y, z);
    }

    @Override
    public Point3D deltaTransform(Point3D point) {
        if (point == null) {
            throw new NullPointerException();
        }
        return point;
    }

    @Override
    public Point2D inverseTransform(double x, double y) {
        this.ensureCanTransform2DPoint();
        return new Point2D(x - this.getX(), y - this.getY());
    }

    @Override
    public Point3D inverseTransform(double x, double y, double z) {
        return new Point3D(x - this.getX(), y - this.getY(), z - this.getZ());
    }

    @Override
    void inverseTransform2DPointsImpl(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        double tx = this.getX();
        double ty = this.getY();
        while (--numPts >= 0) {
            dstPts[dstOff++] = srcPts[srcOff++] - tx;
            dstPts[dstOff++] = srcPts[srcOff++] - ty;
        }
    }

    @Override
    void inverseTransform3DPointsImpl(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        double tx = this.getX();
        double ty = this.getY();
        double tz = this.getZ();
        while (--numPts >= 0) {
            dstPts[dstOff++] = srcPts[srcOff++] - tx;
            dstPts[dstOff++] = srcPts[srcOff++] - ty;
            dstPts[dstOff++] = srcPts[srcOff++] - tz;
        }
    }

    @Override
    public Point2D inverseDeltaTransform(double x, double y) {
        this.ensureCanTransform2DPoint();
        return new Point2D(x, y);
    }

    @Override
    public Point2D inverseDeltaTransform(Point2D point) {
        if (point == null) {
            throw new NullPointerException();
        }
        this.ensureCanTransform2DPoint();
        return point;
    }

    @Override
    public Point3D inverseDeltaTransform(double x, double y, double z) {
        return new Point3D(x, y, z);
    }

    @Override
    public Point3D inverseDeltaTransform(Point3D point) {
        if (point == null) {
            throw new NullPointerException();
        }
        return point;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Translate [");
        sb.append("x=").append(this.getX());
        sb.append(", y=").append(this.getY());
        sb.append(", z=").append(this.getZ());
        return sb.append("]").toString();
    }

    @Override
    void apply(Affine3D trans) {
        trans.translate(this.getX(), this.getY(), this.getZ());
    }

    @Override
    BaseTransform derive(BaseTransform trans) {
        return trans.deriveWithTranslation(this.getX(), this.getY(), this.getZ());
    }

    @Override
    void validate() {
        this.getX();
        this.getY();
        this.getZ();
    }

    @Override
    void appendTo(Affine a) {
        a.appendTranslation(this.getTx(), this.getTy(), this.getTz());
    }

    @Override
    void prependTo(Affine a) {
        a.prependTranslation(this.getTx(), this.getTy(), this.getTz());
    }
}

