/*
 * Decompiled with CFR 0.152.
 */
package javax.media.nativewindow;

import com.jogamp.common.util.PropertyAccess;
import java.util.List;
import javax.media.nativewindow.CapabilitiesChooser;
import javax.media.nativewindow.CapabilitiesImmutable;
import javax.media.nativewindow.NativeWindowException;
import jogamp.nativewindow.Debug;

public class DefaultCapabilitiesChooser
implements CapabilitiesChooser {
    private static final boolean DEBUG;
    private static final int NO_SCORE = -9999999;
    private static final int COLOR_MISMATCH_PENALTY_SCALE = 36;

    @Override
    public int chooseCapabilities(CapabilitiesImmutable capabilitiesImmutable, List<? extends CapabilitiesImmutable> list, int n) {
        int n2;
        int n3;
        int n4;
        if (DEBUG) {
            System.err.println("Desired: " + capabilitiesImmutable);
            for (n4 = 0; n4 < list.size(); ++n4) {
                System.err.println("Available " + n4 + ": " + list.get(n4));
            }
            System.err.println("Window system's recommended choice: " + n);
        }
        n4 = list.size();
        if (n >= 0 && n < n4 && null != list.get(n)) {
            if (DEBUG) {
                System.err.println("Choosing window system's recommended choice of " + n);
                System.err.println(list.get(n));
            }
            return n;
        }
        int[] nArray = new int[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            nArray[n3] = -9999999;
        }
        for (n3 = 0; n3 < n4; ++n3) {
            CapabilitiesImmutable capabilitiesImmutable2 = list.get(n3);
            if (capabilitiesImmutable2 == null || capabilitiesImmutable.isOnscreen() && !capabilitiesImmutable2.isOnscreen()) continue;
            n2 = 0;
            nArray[n3] = n2 += 36 * (capabilitiesImmutable2.getRedBits() + capabilitiesImmutable2.getGreenBits() + capabilitiesImmutable2.getBlueBits() + capabilitiesImmutable2.getAlphaBits() - (capabilitiesImmutable.getRedBits() + capabilitiesImmutable.getGreenBits() + capabilitiesImmutable.getBlueBits() + capabilitiesImmutable.getAlphaBits()));
        }
        if (DEBUG) {
            System.err.print("Scores: [");
            for (n3 = 0; n3 < n4; ++n3) {
                if (n3 > 0) {
                    System.err.print(",");
                }
                System.err.print(" " + nArray[n3]);
            }
            System.err.println(" ]");
        }
        n3 = -9999999;
        int n5 = -1;
        for (n2 = 0; n2 < n4; ++n2) {
            int n6 = nArray[n2];
            if (n6 == -9999999 || n3 != -9999999 && (Math.abs(n6) >= Math.abs(n3) || DefaultCapabilitiesChooser.sign(n3) >= 0 && DefaultCapabilitiesChooser.sign(n6) <= 0)) continue;
            n3 = n6;
            n5 = n2;
        }
        if (n5 < 0) {
            throw new NativeWindowException("Unable to select one of the provided Capabilities");
        }
        if (DEBUG) {
            System.err.println("Chosen index: " + n5);
            System.err.println("Chosen capabilities:");
            System.err.println(list.get(n5));
        }
        return n5;
    }

    private static int sign(int n) {
        if (n < 0) {
            return -1;
        }
        return 1;
    }

    static {
        Debug.initSingleton();
        DEBUG = PropertyAccess.isPropertyDefined((String)"nativewindow.debug.CapabilitiesChooser", (boolean)true);
    }
}

