/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.openal.av;

import com.jogamp.common.util.LFRingbuffer;
import com.jogamp.common.util.PropertyAccess;
import com.jogamp.common.util.Ringbuffer;
import com.jogamp.common.util.locks.LockFactory;
import com.jogamp.common.util.locks.RecursiveLock;
import com.jogamp.openal.AL;
import com.jogamp.openal.ALC;
import com.jogamp.openal.ALCcontext;
import com.jogamp.openal.ALCdevice;
import com.jogamp.openal.ALExt;
import com.jogamp.openal.ALFactory;
import com.jogamp.openal.util.ALHelpers;
import com.jogamp.opengl.util.av.AudioSink;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Arrays;
import jogamp.opengl.Debug;

public class ALAudioSink
implements AudioSink {
    private static final String AL_SOFT_buffer_samples = "AL_SOFT_buffer_samples";
    private static final String ALC_EXT_thread_local_context = "ALC_EXT_thread_local_context";
    private static final boolean DEBUG_TRACE;
    private static final ALC alc;
    private static final AL al;
    private static final ALExt alExt;
    private static final boolean staticAvailable;
    private String deviceSpecifier;
    private ALCdevice device;
    private boolean hasSOFTBufferSamples;
    private boolean hasALC_thread_local_context;
    private AudioSink.AudioFormat preferredAudioFormat;
    private ALCcontext context;
    private final RecursiveLock lock = LockFactory.createRecursiveLock();
    private float playSpeed;
    private float volume = 1.0f;
    private int[] alBufferNames = null;
    private int frameGrowAmount = 0;
    private int frameLimit = 0;
    private Ringbuffer<ALAudioFrame> alFramesAvail = null;
    private Ringbuffer<ALAudioFrame> alFramesPlaying = null;
    private volatile int alBufferBytesQueued = 0;
    private volatile int playingPTS = Integer.MIN_VALUE;
    private volatile int enqueuedFrameCount;
    private int[] alSource = null;
    private AudioSink.AudioFormat chosenFormat = null;
    private int alChannelLayout;
    private int alSampleType;
    private int alFormat;
    private boolean initialized = false;
    private volatile boolean playRequested = false;

    private void clearPreALError(String string) {
        this.checkALError(string);
    }

    private boolean checkALError(String string) {
        boolean bl;
        int n = alc.alcGetError(this.device);
        int n2 = al.alGetError();
        boolean bl2 = bl = 0 == n && 0 == n2;
        if (DEBUG) {
            System.err.println("ALAudioSink." + string + ": ok " + bl + ", err [alc " + ALAudioSink.toHexString(n) + ", al " + ALAudioSink.toHexString(n2) + "]");
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ALAudioSink() {
        if (!staticAvailable) {
            return;
        }
        Class<ALAudioSink> clazz = ALAudioSink.class;
        synchronized (ALAudioSink.class) {
            try {
                this.device = alc.alcOpenDevice(null);
                if (this.device == null) {
                    throw new RuntimeException(ALAudioSink.getThreadName() + ": ALAudioSink: Error opening default OpenAL device");
                }
                int n = 1;
                this.clearPreALError("init." + n++);
                this.deviceSpecifier = alc.alcGetString(this.device, 4101);
                if (this.deviceSpecifier == null) {
                    throw new RuntimeException(ALAudioSink.getThreadName() + ": ALAudioSink: Error getting specifier for default OpenAL device");
                }
                this.context = alc.alcCreateContext(this.device, null);
                if (this.context == null) {
                    throw new RuntimeException(ALAudioSink.getThreadName() + ": ALAudioSink: Error creating OpenAL context for " + this.deviceSpecifier);
                }
                this.lockContext();
                try {
                    if (alc.alcGetError(this.device) != 0) {
                        throw new RuntimeException(ALAudioSink.getThreadName() + ": ALAudioSink: Error making OpenAL context current");
                    }
                    this.hasSOFTBufferSamples = al.alIsExtensionPresent(AL_SOFT_buffer_samples);
                    this.hasALC_thread_local_context = alc.alcIsExtensionPresent(null, ALC_EXT_thread_local_context) || alc.alcIsExtensionPresent(this.device, ALC_EXT_thread_local_context);
                    this.clearPreALError("init." + n++);
                    this.preferredAudioFormat = new AudioSink.AudioFormat(this.querySampleRate(), ALAudioSink.DefaultFormat.sampleSize, ALAudioSink.DefaultFormat.channelCount, ALAudioSink.DefaultFormat.signed, ALAudioSink.DefaultFormat.fixedP, ALAudioSink.DefaultFormat.planar, ALAudioSink.DefaultFormat.littleEndian);
                    if (DEBUG) {
                        System.out.println("ALAudioSink: OpenAL Extensions:" + al.alGetString(45060));
                        this.clearPreALError("init." + n++);
                        System.out.println("ALAudioSink: Null device OpenAL Extensions:" + alc.alcGetString(null, 4102));
                        this.clearPreALError("init." + n++);
                        System.out.println("ALAudioSink: Device " + this.deviceSpecifier + " OpenAL Extensions:" + alc.alcGetString(this.device, 4102));
                        System.out.println("ALAudioSink: hasSOFTBufferSamples " + this.hasSOFTBufferSamples);
                        System.out.println("ALAudioSink: hasALC_thread_local_context " + this.hasALC_thread_local_context);
                        System.out.println("ALAudioSink: preferredAudioFormat " + this.preferredAudioFormat);
                        this.clearPreALError("init." + n++);
                    }
                    this.alSource = new int[1];
                    al.alGenSources(1, this.alSource, 0);
                    int n2 = al.alGetError();
                    if (0 != n2) {
                        this.alSource = null;
                        throw new RuntimeException(ALAudioSink.getThreadName() + ": ALAudioSink: Error generating Source: 0x" + Integer.toHexString(n2));
                    }
                    if (DEBUG) {
                        System.err.println("ALAudioSink: Using device: " + this.deviceSpecifier);
                    }
                    this.initialized = true;
                }
                finally {
                    this.unlockContext();
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            catch (Exception exception) {
                if (DEBUG) {
                    System.err.println(exception.getMessage());
                    exception.printStackTrace();
                }
                this.destroy();
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
            return;
        }
    }

    private final int querySampleRate() {
        int[] nArray = new int[1];
        alc.alcGetIntegerv(this.device, 4103, 1, nArray, 0);
        int n = alc.alcGetError(this.device);
        int n2 = al.alGetError();
        int n3 = 0 == n && 0 == n2 && 0 != nArray[0] ? nArray[0] : ALAudioSink.DefaultFormat.sampleRate;
        if (DEBUG) {
            System.err.println("ALAudioSink.querySampleRate: err [alc " + ALAudioSink.toHexString(n) + ", al " + ALAudioSink.toHexString(n2) + "], freq: " + nArray[0] + " -> " + n3);
        }
        return n3;
    }

    private final void lockContext() {
        this.lock.lock();
        if (this.hasALC_thread_local_context) {
            alExt.alcSetThreadContext(this.context);
        } else {
            alc.alcMakeContextCurrent(this.context);
        }
        int n = alc.alcGetError(null);
        if (0 != n) {
            String string = ALAudioSink.getThreadName() + ": ALCError " + ALAudioSink.toHexString(n) + " while makeCurrent. " + this;
            System.err.println(string);
            Thread.dumpStack();
            this.lock.unlock();
            throw new RuntimeException(string);
        }
        int n2 = al.alGetError();
        if (0 != n2 && DEBUG) {
            System.err.println(ALAudioSink.getThreadName() + ": Prev - ALError " + ALAudioSink.toHexString(n2) + " @ makeCurrent. " + this);
            Thread.dumpStack();
        }
    }

    private final void unlockContext() {
        if (this.hasALC_thread_local_context) {
            alExt.alcSetThreadContext(null);
        } else {
            alc.alcMakeContextCurrent(null);
        }
        this.lock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void destroyContext() {
        this.lock.lock();
        try {
            if (null != this.context) {
                block7: {
                    try {
                        alc.alcDestroyContext(this.context);
                    }
                    catch (Throwable throwable) {
                        if (!DEBUG) break block7;
                        System.err.println("Caught " + throwable.getClass().getName() + ": " + throwable.getMessage());
                        throwable.printStackTrace();
                    }
                }
                this.context = null;
            }
            while (this.lock.getHoldCount() > 1) {
                this.lock.unlock();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public final String toString() {
        int n = null != this.alSource ? this.alSource[0] : 0;
        int n2 = null != this.alBufferNames ? this.alBufferNames.length : 0;
        int n3 = this.context != null ? this.context.hashCode() : 0;
        return "ALAudioSink[init " + this.initialized + ", playRequested " + this.playRequested + ", device " + this.deviceSpecifier + ", ctx " + ALAudioSink.toHexString(n3) + ", alSource " + n + ", chosen " + this.chosenFormat + ", al[chan " + ALHelpers.alChannelLayoutName((int)this.alChannelLayout) + ", type " + ALHelpers.alSampleTypeName((int)this.alSampleType) + ", fmt " + ALAudioSink.toHexString(this.alFormat) + ", soft " + this.hasSOFTBufferSamples + "], playSpeed " + this.playSpeed + ", buffers[total " + n2 + ", avail " + this.alFramesAvail.size() + ", " + "queued[" + this.alFramesPlaying.size() + ", apts " + this.getPTS() + ", " + this.getQueuedTime() + " ms, " + this.alBufferBytesQueued + " bytes], " + "queue[g " + this.frameGrowAmount + ", l " + this.frameLimit + "]";
    }

    private final String shortString() {
        int n = null != this.alSource ? this.alSource[0] : 0;
        int n2 = this.context != null ? this.context.hashCode() : 0;
        return "[ctx " + ALAudioSink.toHexString(n2) + ", playReq " + this.playRequested + ", alSrc " + n + ", queued[" + this.alFramesPlaying.size() + ", " + this.alBufferBytesQueued + " bytes], " + "queue[g " + this.frameGrowAmount + ", l " + this.frameLimit + "]";
    }

    public final String getPerfString() {
        int n = null != this.alBufferNames ? this.alBufferNames.length : 0;
        return "Play [buffer " + this.alFramesPlaying.size() + "/" + n + ", apts " + this.getPTS() + ", " + this.getQueuedTime() + " ms, " + this.alBufferBytesQueued + " bytes]";
    }

    @Override
    public final AudioSink.AudioFormat getPreferredFormat() {
        if (!staticAvailable) {
            return null;
        }
        return this.preferredAudioFormat;
    }

    @Override
    public final int getMaxSupportedChannels() {
        if (!staticAvailable) {
            return 0;
        }
        return this.hasSOFTBufferSamples ? 8 : 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isSupported(AudioSink.AudioFormat audioFormat) {
        int n;
        if (!staticAvailable) {
            return false;
        }
        if (audioFormat.planar || !audioFormat.littleEndian) {
            return false;
        }
        int n2 = ALHelpers.getDefaultALChannelLayout((int)audioFormat.channelCount);
        if (0 != n2 && 0 != (n = ALHelpers.getALSampleType((int)audioFormat.sampleSize, (boolean)audioFormat.signed, (boolean)audioFormat.fixedP))) {
            this.lockContext();
            try {
                int n3 = ALHelpers.getALFormat((int)n2, (int)n, (boolean)this.hasSOFTBufferSamples, (AL)al, (ALExt)alExt);
                boolean bl = 0 != n3;
                return bl;
            }
            finally {
                this.unlockContext();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean init(AudioSink.AudioFormat audioFormat, float f, int n, int n2, int n3) {
        if (!staticAvailable) {
            return false;
        }
        this.alChannelLayout = ALHelpers.getDefaultALChannelLayout((int)audioFormat.channelCount);
        this.alSampleType = ALHelpers.getALSampleType((int)audioFormat.sampleSize, (boolean)audioFormat.signed, (boolean)audioFormat.fixedP);
        this.lockContext();
        try {
            this.alFormat = 0 != this.alChannelLayout && 0 != this.alSampleType ? ALHelpers.getALFormat((int)this.alChannelLayout, (int)this.alSampleType, (boolean)this.hasSOFTBufferSamples, (AL)al, (ALExt)alExt) : 0;
            if (0 == this.alFormat) {
                boolean bl = false;
                return bl;
            }
            this.destroyBuffers();
            float f2 = f > 1.0f ? f : 32.0f;
            int n4 = audioFormat.getFrameCount(n > 0 ? n : 512, f2);
            this.alBufferNames = new int[n4];
            al.alGenBuffers(n4, this.alBufferNames, 0);
            int n5 = al.alGetError();
            if (0 != n5) {
                this.alBufferNames = null;
                throw new RuntimeException(ALAudioSink.getThreadName() + ": ALAudioSink: Error generating Buffers: 0x" + Integer.toHexString(n5));
            }
            Object[] objectArray = new ALAudioFrame[n4];
            for (int i = 0; i < n4; ++i) {
                objectArray[i] = new ALAudioFrame(this.alBufferNames[i]);
            }
            this.alFramesAvail = new LFRingbuffer(objectArray);
            this.alFramesPlaying = new LFRingbuffer(ALAudioFrame[].class, n4);
            this.frameGrowAmount = audioFormat.getFrameCount(n2 > 0 ? n2 : 512, f2);
            this.frameLimit = audioFormat.getFrameCount(n3 > 0 ? n3 : 3072, f2);
            if (DEBUG_TRACE) {
                this.alFramesAvail.dump(System.err, "Avail-init");
                this.alFramesPlaying.dump(System.err, "Playi-init");
            }
        }
        finally {
            this.unlockContext();
        }
        this.chosenFormat = audioFormat;
        return true;
    }

    @Override
    public final AudioSink.AudioFormat getChosenFormat() {
        return this.chosenFormat;
    }

    private static int[] concat(int[] nArray, int[] nArray2) {
        int[] nArray3 = Arrays.copyOf(nArray, nArray.length + nArray2.length);
        System.arraycopy(nArray2, 0, nArray3, nArray.length, nArray2.length);
        return nArray3;
    }

    private boolean growBuffers() {
        if (!this.alFramesAvail.isEmpty() || !this.alFramesPlaying.isFull()) {
            throw new InternalError("Buffers: Avail is !empty " + this.alFramesAvail + " or Playing is !full " + this.alFramesPlaying);
        }
        if (this.alFramesAvail.capacity() >= this.frameLimit || this.alFramesPlaying.capacity() >= this.frameLimit) {
            if (DEBUG) {
                System.err.println(ALAudioSink.getThreadName() + ": ALAudioSink.growBuffers: Frame limit " + this.frameLimit + " reached: Avail " + this.alFramesAvail + ", Playing " + this.alFramesPlaying);
            }
            return false;
        }
        int[] nArray = new int[this.frameGrowAmount];
        al.alGenBuffers(this.frameGrowAmount, nArray, 0);
        int n = al.alGetError();
        if (0 != n) {
            if (DEBUG) {
                System.err.println(ALAudioSink.getThreadName() + ": ALAudioSink.growBuffers: Error generating " + this.frameGrowAmount + " new Buffers: 0x" + Integer.toHexString(n));
            }
            return false;
        }
        this.alBufferNames = ALAudioSink.concat(this.alBufferNames, nArray);
        Object[] objectArray = new ALAudioFrame[this.frameGrowAmount];
        for (int i = 0; i < this.frameGrowAmount; ++i) {
            objectArray[i] = new ALAudioFrame(nArray[i]);
        }
        this.alFramesAvail.growEmptyBuffer(objectArray);
        this.alFramesPlaying.growFullBuffer(this.frameGrowAmount);
        if (this.alFramesAvail.isEmpty() || this.alFramesPlaying.isFull()) {
            throw new InternalError("Buffers: Avail is empty " + this.alFramesAvail + " or Playing is full " + this.alFramesPlaying);
        }
        if (DEBUG) {
            System.err.println(ALAudioSink.getThreadName() + ": ALAudioSink: Buffer grown " + this.frameGrowAmount + ": Avail " + this.alFramesAvail + ", playing " + this.alFramesPlaying);
        }
        if (DEBUG_TRACE) {
            this.alFramesAvail.dump(System.err, "Avail-grow");
            this.alFramesPlaying.dump(System.err, "Playi-grow");
        }
        return true;
    }

    private void destroyBuffers() {
        if (!staticAvailable) {
            return;
        }
        if (null != this.alBufferNames) {
            block4: {
                try {
                    al.alDeleteBuffers(this.alBufferNames.length, this.alBufferNames, 0);
                }
                catch (Throwable throwable) {
                    if (!DEBUG) break block4;
                    System.err.println("Caught " + throwable.getClass().getName() + ": " + throwable.getMessage());
                    throwable.printStackTrace();
                }
            }
            this.alFramesAvail.clear();
            this.alFramesAvail = null;
            this.alFramesPlaying.clear();
            this.alFramesPlaying = null;
            this.alBufferBytesQueued = 0;
            this.alBufferNames = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void destroy() {
        this.initialized = false;
        if (!staticAvailable) {
            return;
        }
        if (null != this.context) {
            this.lockContext();
        }
        try {
            this.stopImpl(true);
            if (null != this.alSource) {
                block11: {
                    try {
                        al.alDeleteSources(1, this.alSource, 0);
                    }
                    catch (Throwable throwable) {
                        if (!DEBUG) break block11;
                        System.err.println("Caught " + throwable.getClass().getName() + ": " + throwable.getMessage());
                        throwable.printStackTrace();
                    }
                }
                this.alSource = null;
            }
            this.destroyBuffers();
        }
        finally {
            this.destroyContext();
        }
        if (null != this.device) {
            block13: {
                try {
                    alc.alcCloseDevice(this.device);
                }
                catch (Throwable throwable) {
                    if (!DEBUG) break block13;
                    System.err.println("Caught " + throwable.getClass().getName() + ": " + throwable.getMessage());
                    throwable.printStackTrace();
                }
            }
            this.device = null;
        }
        this.chosenFormat = null;
    }

    @Override
    public final boolean isInitialized() {
        return this.initialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int dequeueBuffer(boolean bl, boolean bl2) {
        int n;
        int n2 = 0;
        if (this.alBufferBytesQueued > 0) {
            int n3 = Math.max(1, this.alFramesPlaying.size() / 4);
            int[] nArray = new int[1];
            int n4 = 0;
            do {
                al.alGetSourcei(this.alSource[0], 4118, nArray, 0);
                n2 = al.alGetError();
                if (0 != n2) {
                    throw new RuntimeException(ALAudioSink.getThreadName() + ": ALError " + ALAudioSink.toHexString(n2) + " while quering processed buffers at source. " + this);
                }
                if (!bl || nArray[0] >= n3) continue;
                ++n4;
                int n5 = this.chosenFormat.getBytesDuration(this.alBufferBytesQueued / this.alFramesPlaying.size());
                int n6 = Math.max(2, Math.min(100, n3 * n5));
                if (DEBUG) {
                    System.err.println(ALAudioSink.getThreadName() + ": ALAudioSink: Dequeue.wait[" + n4 + "]: avgBufferDura " + n5 + ", releaseBufferLimes " + n3 + ", sleep " + n6 + " ms, playImpl " + (4114 == this.getSourceState(false)) + ", processed " + nArray[0] + ", " + this);
                }
                this.unlockContext();
                try {
                    Thread.sleep(n6 - 1);
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    this.lockContext();
                }
            } while (bl && nArray[0] < n3 && this.alBufferBytesQueued > 0);
            n = nArray[0];
        } else {
            n = 0;
        }
        if (n > 0) {
            int[] nArray = new int[n];
            al.alSourceUnqueueBuffers(this.alSource[0], n, nArray, 0);
            n2 = al.alGetError();
            if (0 != n2) {
                throw new RuntimeException(ALAudioSink.getThreadName() + ": ALError " + ALAudioSink.toHexString(n2) + " while dequeueing " + n + " buffers. " + this);
            }
            for (int i = 0; i < n; ++i) {
                ALAudioFrame aLAudioFrame = (ALAudioFrame)this.alFramesPlaying.get();
                if (null == aLAudioFrame) {
                    if (bl2) continue;
                    throw new InternalError("Internal Error: " + this);
                }
                if (DEBUG_TRACE) {
                    System.err.println("<  [al " + nArray[i] + ", q " + aLAudioFrame.alBuffer + "] <- " + this.shortString() + " @ " + ALAudioSink.getThreadName());
                }
                if (aLAudioFrame.alBuffer != nArray[i] && !bl2) {
                    this.alFramesAvail.dump(System.err, "Avail-deq02-post");
                    this.alFramesPlaying.dump(System.err, "Playi-deq02-post");
                    throw new InternalError("Buffer name mismatch: dequeued: " + nArray[i] + ", released " + aLAudioFrame + ", " + this);
                }
                this.alBufferBytesQueued -= aLAudioFrame.getByteSize();
                if (!this.alFramesAvail.put((Object)aLAudioFrame)) {
                    throw new InternalError("Internal Error: " + this);
                }
                if (!DEBUG_TRACE) continue;
                System.err.println("<< [al " + nArray[i] + ", q " + aLAudioFrame.alBuffer + "] <- " + this.shortString() + " @ " + ALAudioSink.getThreadName());
            }
        }
        return n;
    }

    private final void dequeueForceAll() {
        if (DEBUG_TRACE) {
            System.err.println("<   _FLUSH_  <- " + this.shortString() + " @ " + ALAudioSink.getThreadName());
        }
        int[] nArray = new int[1];
        al.alSourcei(this.alSource[0], 4105, 0);
        if (DEBUG_TRACE) {
            al.alGetSourcei(this.alSource[0], 4118, nArray, 0);
        }
        int n = al.alGetError();
        while (!this.alFramesPlaying.isEmpty()) {
            ALAudioFrame aLAudioFrame = (ALAudioFrame)this.alFramesPlaying.get();
            if (null == aLAudioFrame) {
                throw new InternalError("Internal Error: " + this);
            }
            this.alBufferBytesQueued -= aLAudioFrame.getByteSize();
            if (this.alFramesAvail.put((Object)aLAudioFrame)) continue;
            throw new InternalError("Internal Error: " + this);
        }
        this.alBufferBytesQueued = 0;
        if (DEBUG_TRACE) {
            System.err.println("<<  _FLUSH_  [al " + nArray[0] + ", err " + ALAudioSink.toHexString(n) + "] <- " + this.shortString() + " @ " + ALAudioSink.getThreadName());
            Thread.dumpStack();
        }
    }

    private final int dequeueBuffer(boolean bl, int n, int n2) {
        int n3 = this.dequeueBuffer(bl, false);
        ALAudioFrame aLAudioFrame = (ALAudioFrame)this.alFramesPlaying.peek();
        this.playingPTS = null != aLAudioFrame ? aLAudioFrame.getPTS() : n;
        if (DEBUG && n3 > 0) {
            System.err.println(ALAudioSink.getThreadName() + ": ALAudioSink: Write " + n + ", " + n2 + " ms, dequeued " + n3 + ", wait " + bl + ", " + this.getPerfString());
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final AudioSink.AudioFrame enqueueData(int n, ByteBuffer byteBuffer, int n2) {
        ALAudioFrame aLAudioFrame;
        if (!this.initialized || null == this.chosenFormat) {
            return null;
        }
        this.lockContext();
        try {
            int n3;
            boolean bl;
            int n4 = this.chosenFormat.getBytesDuration(n2);
            if (this.alFramesAvail.isEmpty()) {
                boolean bl2 = bl = this.dequeueBuffer(false, n, n4) > 0;
                if (this.alFramesAvail.isEmpty()) {
                    this.growBuffers();
                }
            } else {
                bl = false;
            }
            if (!bl && this.alFramesPlaying.size() > 0) {
                boolean bl3 = this.isPlayingImpl0() && this.alFramesAvail.isEmpty();
                this.dequeueBuffer(bl3, n, n4);
            }
            if (null == (aLAudioFrame = (ALAudioFrame)this.alFramesAvail.get())) {
                this.alFramesAvail.dump(System.err, "Avail");
                throw new InternalError("Internal Error: avail.get null " + this.alFramesAvail + ", " + this);
            }
            aLAudioFrame.setPTS(n);
            aLAudioFrame.setDuration(n4);
            aLAudioFrame.setByteSize(n2);
            if (!this.alFramesPlaying.put((Object)aLAudioFrame)) {
                throw new InternalError("Internal Error: " + this);
            }
            int[] nArray = new int[]{aLAudioFrame.alBuffer};
            if (this.hasSOFTBufferSamples) {
                n3 = this.chosenFormat.getBytesSampleCount(n2) / this.chosenFormat.channelCount;
                alExt.alBufferSamplesSOFT(aLAudioFrame.alBuffer, this.chosenFormat.sampleRate, this.alFormat, n3, this.alChannelLayout, this.alSampleType, (Buffer)byteBuffer);
            } else {
                al.alBufferData(aLAudioFrame.alBuffer, this.alFormat, (Buffer)byteBuffer, n2, this.chosenFormat.sampleRate);
            }
            if (DEBUG_TRACE) {
                System.err.println(">  " + aLAudioFrame.alBuffer + " -> " + this.shortString() + " @ " + ALAudioSink.getThreadName());
            }
            al.alSourceQueueBuffers(this.alSource[0], 1, nArray, 0);
            n3 = al.alGetError();
            if (0 != n3) {
                throw new RuntimeException(ALAudioSink.getThreadName() + ": ALError " + ALAudioSink.toHexString(n3) + " while queueing buffer " + ALAudioSink.toHexString(nArray[0]) + ". " + this);
            }
            this.alBufferBytesQueued += n2;
            ++this.enqueuedFrameCount;
            if (DEBUG_TRACE) {
                System.err.println(">> " + aLAudioFrame.alBuffer + " -> " + this.shortString() + " @ " + ALAudioSink.getThreadName());
            }
            this.playImpl();
        }
        finally {
            this.unlockContext();
        }
        return aLAudioFrame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isPlaying() {
        if (!this.initialized || null == this.chosenFormat) {
            return false;
        }
        if (this.playRequested) {
            this.lockContext();
            try {
                boolean bl = this.isPlayingImpl0();
                return bl;
            }
            finally {
                this.unlockContext();
            }
        }
        return false;
    }

    private final boolean isPlayingImpl0() {
        if (this.playRequested) {
            return 4114 == this.getSourceState(false);
        }
        return false;
    }

    private final int getSourceState(boolean bl) {
        int[] nArray = new int[1];
        al.alGetSourcei(this.alSource[0], 4112, nArray, 0);
        int n = al.alGetError();
        if (0 != n) {
            String string = ALAudioSink.getThreadName() + ": ALError " + ALAudioSink.toHexString(n) + " while querying SOURCE_STATE. " + this;
            if (bl) {
                if (DEBUG) {
                    System.err.println(string);
                }
            } else {
                throw new RuntimeException(string);
            }
        }
        return nArray[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void play() {
        if (!this.initialized || null == this.chosenFormat) {
            return;
        }
        this.playRequested = true;
        this.lockContext();
        try {
            this.playImpl();
            if (DEBUG) {
                System.err.println(ALAudioSink.getThreadName() + ": ALAudioSink: PLAY playImpl " + (4114 == this.getSourceState(false)) + ", " + this);
            }
        }
        finally {
            this.unlockContext();
        }
    }

    private final void playImpl() {
        if (this.playRequested && 4114 != this.getSourceState(false)) {
            al.alSourcePlay(this.alSource[0]);
            int n = al.alGetError();
            if (0 != n) {
                throw new RuntimeException(ALAudioSink.getThreadName() + ": ALError " + ALAudioSink.toHexString(n) + " while start playing. " + this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void pause() {
        if (!this.initialized || null == this.chosenFormat) {
            return;
        }
        if (this.playRequested) {
            this.lockContext();
            try {
                this.pauseImpl();
                if (DEBUG) {
                    System.err.println(ALAudioSink.getThreadName() + ": ALAudioSink: PAUSE playImpl " + (4114 == this.getSourceState(false)) + ", " + this);
                }
            }
            finally {
                this.unlockContext();
            }
        }
    }

    private final void pauseImpl() {
        if (this.isPlayingImpl0()) {
            this.playRequested = false;
            al.alSourcePause(this.alSource[0]);
            int n = al.alGetError();
            if (0 != n) {
                throw new RuntimeException(ALAudioSink.getThreadName() + ": ALError " + ALAudioSink.toHexString(n) + " while pausing. " + this);
            }
        }
    }

    private final void stopImpl(boolean bl) {
        if (4116 != this.getSourceState(bl)) {
            this.playRequested = false;
            al.alSourceStop(this.alSource[0]);
            int n = al.alGetError();
            if (0 != n) {
                String string = "ALError " + ALAudioSink.toHexString(n) + " while stopping. " + this;
                if (bl) {
                    if (DEBUG) {
                        System.err.println(ALAudioSink.getThreadName() + ": " + string);
                    }
                } else {
                    throw new RuntimeException(ALAudioSink.getThreadName() + ": ALError " + ALAudioSink.toHexString(n) + " while stopping. " + this);
                }
            }
        }
    }

    @Override
    public final float getPlaySpeed() {
        return this.playSpeed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean setPlaySpeed(float f) {
        if (!this.initialized || null == this.chosenFormat) {
            return false;
        }
        this.lockContext();
        try {
            if (Math.abs(1.0f - f) < 0.01f) {
                f = 1.0f;
            }
            if (0.5f <= f && f <= 2.0f) {
                this.playSpeed = f;
                al.alSourcef(this.alSource[0], 4099, this.playSpeed);
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.unlockContext();
        }
        return false;
    }

    @Override
    public final float getVolume() {
        return this.volume;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean setVolume(float f) {
        if (!this.initialized || null == this.chosenFormat) {
            return false;
        }
        this.lockContext();
        try {
            if (Math.abs(f) < 0.01f) {
                f = 0.0f;
            } else if (Math.abs(1.0f - f) < 0.01f) {
                f = 1.0f;
            }
            if (0.0f <= f && f <= 1.0f) {
                this.volume = f;
                al.alSourcef(this.alSource[0], 4106, f);
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.unlockContext();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void flush() {
        if (!this.initialized || null == this.chosenFormat) {
            return;
        }
        this.lockContext();
        try {
            this.stopImpl(false);
            this.dequeueForceAll();
            if (this.alBufferNames.length != this.alFramesAvail.size() || this.alFramesPlaying.size() != 0) {
                throw new InternalError("XXX: " + this);
            }
            if (DEBUG) {
                System.err.println(ALAudioSink.getThreadName() + ": ALAudioSink: FLUSH playImpl " + (4114 == this.getSourceState(false)) + ", " + this);
            }
        }
        finally {
            this.unlockContext();
        }
    }

    @Override
    public final int getEnqueuedFrameCount() {
        return this.enqueuedFrameCount;
    }

    @Override
    public final int getFrameCount() {
        return null != this.alBufferNames ? this.alBufferNames.length : 0;
    }

    @Override
    public final int getQueuedFrameCount() {
        if (!this.initialized || null == this.chosenFormat) {
            return 0;
        }
        return this.alFramesPlaying.size();
    }

    @Override
    public final int getFreeFrameCount() {
        if (!this.initialized || null == this.chosenFormat) {
            return 0;
        }
        return this.alFramesAvail.size();
    }

    @Override
    public final int getQueuedByteCount() {
        if (!this.initialized || null == this.chosenFormat) {
            return 0;
        }
        return this.alBufferBytesQueued;
    }

    @Override
    public final int getQueuedTime() {
        if (!this.initialized || null == this.chosenFormat) {
            return 0;
        }
        return this.chosenFormat.getBytesDuration(this.alBufferBytesQueued);
    }

    @Override
    public final int getPTS() {
        return this.playingPTS;
    }

    private static final String toHexString(int n) {
        return "0x" + Integer.toHexString(n);
    }

    private static final String getThreadName() {
        return Thread.currentThread().getName();
    }

    static {
        ALExt aLExt;
        AL aL;
        ALC aLC;
        block2: {
            Debug.initSingleton();
            DEBUG_TRACE = PropertyAccess.isPropertyDefined((String)"jogl.debug.AudioSink.trace", (boolean)true);
            aLC = null;
            aL = null;
            aLExt = null;
            try {
                aLC = ALFactory.getALC();
                aL = ALFactory.getAL();
                aLExt = ALFactory.getALExt();
            }
            catch (Throwable throwable) {
                if (!DEBUG) break block2;
                System.err.println("ALAudioSink: Caught " + throwable.getClass().getName() + ": " + throwable.getMessage());
                throwable.printStackTrace();
            }
        }
        alc = aLC;
        al = aL;
        alExt = aLExt;
        staticAvailable = null != alc && null != al && null != alExt;
    }

    static class ALAudioFrame
    extends AudioSink.AudioFrame {
        private final int alBuffer;

        ALAudioFrame(int n) {
            this.alBuffer = n;
        }

        public ALAudioFrame(int n, int n2, int n3, int n4) {
            super(n2, n3, n4);
            this.alBuffer = n;
        }

        public final int getALBuffer() {
            return this.alBuffer;
        }

        @Override
        public String toString() {
            return "ALAudioFrame[pts " + this.pts + " ms, l " + this.duration + " ms, " + this.byteSize + " bytes, buffer " + this.alBuffer + "]";
        }
    }
}

