/**
 * Copyright 2014 JogAmp Community. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification, are
 * permitted provided that the following conditions are met:
 *
 *    1. Redistributions of source code must retain the above copyright notice, this list of
 *       conditions and the following disclaimer.
 *
 *    2. Redistributions in binary form must reproduce the above copyright notice, this list
 *       of conditions and the following disclaimer in the documentation and/or other materials
 *       provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY JogAmp Community ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL JogAmp Community OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * The views and conclusions contained in the software and documentation are those of the
 * authors and should not be interpreted as representing official policies, either expressed
 * or implied, of JogAmp Community.
 */
package com.jogamp.plugin.ui;

/**
 * Implemented by user.
 * <p>
 * Representing the user applet child window,
 * which is controlled by the plugin.
 * </p>
 */
public interface NativeWindowDownstream {
    /**
     * Destroys this window incl. releasing all related resources.
     */
    void destroy();

    /**
     * @return The parent NativeWindow, or null if this NativeWindow is top level.
     */
    NativeWindowUpstream getParent();

    /**
     * Returns the window handle for this applet. <P>
     *
     * The window handle shall reflect the platform one
     * for all window related operations, e.g. open, close, resize. <P>
     *
     * On X11 this returns an entity of type Window. <BR>
     * On Microsoft Windows this returns an entity of type HWND.
     */
    long getWindowHandle();

    /**
     * Set size.
     */
    void setSize(int width, int height);

    /**
     * Request focus.
     */
    void requestFocus();

    /**
     * Set this NativeWindow visible state.
     */
    void setVisible(boolean v);

    /**
     * Trigger asynchronous rendering of this display's content.
     * <p>
     * Method shall return immediately and not wait for result.
     * </p>
     */
    void display();

    /**
     * Notify applet that the plugin's window has changed it's position.
     */
    void notifyPositionChanged(NativeWindowUpstream nw);
}
