/**
 * Copyright 2014 JogAmp Community. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification, are
 * permitted provided that the following conditions are met:
 *
 *    1. Redistributions of source code must retain the above copyright notice, this list of
 *       conditions and the following disclaimer.
 *
 *    2. Redistributions in binary form must reproduce the above copyright notice, this list
 *       of conditions and the following disclaimer in the documentation and/or other materials
 *       provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY JogAmp Community ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL JogAmp Community OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * The views and conclusions contained in the software and documentation are those of the
 * authors and should not be interpreted as representing official policies, either expressed
 * or implied, of JogAmp Community.
 */
package com.jogamp.plugin.ui;

/**
 * Representing the plugin window, i.e. the user applet's parent window.
 */
public interface NativeWindowUpstream {
    /**
     * Returns the display connection for this NativeWindow,
     * maybe <code>null</code> for default.
     * <p>
     * On X11 this returns the X11 display connection string, e.g. <code>:0.0</code>.<BR>
     * </p>
     */
    String getDisplayConnection();

    /**
     * Returns the screen index for this NativeWindow.
     */
    int getScreenIndex();

    /**
     * Returns the window handle for this NativeWindow. <P>
     *
     * The window handle shall reflect the platform one
     * for all window related operations, e.g. open, close, resize. <P>
     *
     * On X11 this returns an entity of type Window. <BR>
     * On Microsoft Windows this returns an entity of type HWND.
     */
    long getWindowHandle();

    /**
     * @return the current x position of the top-left corner
     *         of the client area relative to it's parent.
     *         Since the position reflects the client area, it does not include the insets.
     */
    int getX();

    /**
     * @return the current y position of the top-left corner
     *         of the client area relative to it's parent.
     *         Since the position reflects the client area, it does not include the insets.
     */
    int getY();

    /**
     * Returns the width of the client area excluding insets (window decorations).
     * @return width of the client area
     */
    int getWidth();

    /**
     * Returns the height of the client area excluding insets (window decorations).
     * @return height of the client area
     */
    int getHeight();

    /**
     * Notify plugin that the applet's window has been <i>updated</i>, e.g. rendered and swapped.
     */
    void notifySurfaceUpdated(NativeWindowDownstream swappedWin);
}
