/*
 * Decompiled with CFR 0.152.
 */
package demos.devmaster.lesson3;

import com.jogamp.openal.AL;
import com.jogamp.openal.ALException;
import com.jogamp.openal.ALFactory;
import com.jogamp.openal.util.ALut;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Random;

public class MultipleSources {
    static AL al;
    static final int NUM_BUFFERS = 3;
    static final int NUM_SOURCES = 3;
    static final int BATTLE = 0;
    static final int GUN1 = 1;
    static final int GUN2 = 2;
    static int[] buffers;
    static int[] sources;
    static float[][] sourcePos;
    static float[][] sourceVel;
    static float[] listenerPos;
    static float[] listenerVel;
    static float[] listenerOri;

    static int loadALData() {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        ByteBuffer[] byteBufferArray = new ByteBuffer[1];
        int[] nArray3 = new int[1];
        int[] nArray4 = new int[1];
        al.alGenBuffers(3, buffers, 0);
        if (al.alGetError() != 0) {
            return 0;
        }
        ALut.alutLoadWAVFile((InputStream)MultipleSources.class.getClassLoader().getResourceAsStream("demos/data/Battle.wav"), (int[])nArray, (ByteBuffer[])byteBufferArray, (int[])nArray2, (int[])nArray3, (int[])nArray4);
        al.alBufferData(buffers[0], nArray[0], (Buffer)byteBufferArray[0], nArray2[0], nArray3[0]);
        ALut.alutLoadWAVFile((InputStream)MultipleSources.class.getClassLoader().getResourceAsStream("demos/data/Gun1.wav"), (int[])nArray, (ByteBuffer[])byteBufferArray, (int[])nArray2, (int[])nArray3, (int[])nArray4);
        al.alBufferData(buffers[1], nArray[0], (Buffer)byteBufferArray[0], nArray2[0], nArray3[0]);
        ALut.alutLoadWAVFile((InputStream)MultipleSources.class.getClassLoader().getResourceAsStream("demos/data/Gun2.wav"), (int[])nArray, (ByteBuffer[])byteBufferArray, (int[])nArray2, (int[])nArray3, (int[])nArray4);
        al.alBufferData(buffers[2], nArray[0], (Buffer)byteBufferArray[0], nArray2[0], nArray3[0]);
        al.alGenSources(3, sources, 0);
        al.alSourcei(sources[0], 4105, buffers[0]);
        al.alSourcef(sources[0], 4099, 1.0f);
        al.alSourcef(sources[0], 4106, 1.0f);
        al.alSourcefv(sources[0], 4100, sourcePos[0], 0);
        al.alSourcefv(sources[0], 4100, sourceVel[0], 0);
        al.alSourcei(sources[0], 4103, 1);
        al.alSourcei(sources[1], 4105, buffers[1]);
        al.alSourcef(sources[1], 4099, 1.0f);
        al.alSourcef(sources[1], 4106, 1.0f);
        al.alSourcefv(sources[1], 4100, sourcePos[1], 0);
        al.alSourcefv(sources[1], 4100, sourceVel[1], 0);
        al.alSourcei(sources[1], 4103, 0);
        al.alSourcei(sources[2], 4105, buffers[2]);
        al.alSourcef(sources[2], 4099, 1.0f);
        al.alSourcef(sources[2], 4106, 1.0f);
        al.alSourcefv(sources[2], 4100, sourcePos[2], 0);
        al.alSourcefv(sources[2], 4100, sourceVel[2], 0);
        al.alSourcei(sources[2], 4103, 0);
        if (al.alGetError() != 0) {
            return 0;
        }
        return 1;
    }

    static void setListenerValues() {
        al.alListenerfv(4100, listenerPos, 0);
        al.alListenerfv(4102, listenerVel, 0);
        al.alListenerfv(4111, listenerOri, 0);
    }

    static void killAllData() {
        al.alDeleteBuffers(3, buffers, 0);
        al.alDeleteSources(3, sources, 0);
    }

    public static void main(String[] stringArray) {
        try {
            ALut.alutInit();
            al = ALFactory.getAL();
        }
        catch (ALException aLException) {
            aLException.printStackTrace();
            System.exit(1);
        }
        al.alGetError();
        if (MultipleSources.loadALData() == 0) {
            System.exit(1);
        }
        MultipleSources.setListenerValues();
        al.alSourcePlay(sources[0]);
        long l = System.currentTimeMillis();
        long l2 = 0L;
        long l3 = 0L;
        Random random = new Random();
        int[] nArray = new int[1];
        while (l3 < 10000L) {
            l2 = System.currentTimeMillis() - l;
            if (l2 <= 50L) continue;
            l3 += l2;
            l = System.currentTimeMillis();
            int n = Math.abs(random.nextInt() % 2) + 1;
            al.alGetSourcei(sources[n], 4112, nArray, 0);
            if (nArray[0] == 4114) continue;
            double d = (double)(random.nextInt() % 360) * 3.14 / 180.0;
            MultipleSources.sourcePos[n][0] = -((float)Math.cos(d));
            MultipleSources.sourcePos[n][1] = -((float)(random.nextInt() % 2));
            MultipleSources.sourcePos[n][2] = -((float)Math.sin(d));
            al.alSourcefv(sources[n], 4100, sourcePos[n], 0);
            al.alSourcePlay(sources[n]);
        }
        MultipleSources.killAllData();
        System.exit(0);
    }

    static {
        buffers = new int[3];
        sources = new int[3];
        sourcePos = new float[3][3];
        sourceVel = new float[3][3];
        listenerPos = new float[]{0.0f, 0.0f, 0.0f};
        listenerVel = new float[]{0.0f, 0.0f, 0.0f};
        listenerOri = new float[]{0.0f, 0.0f, -1.0f, 0.0f, 1.0f, 0.0f};
    }
}

