/*
 * Decompiled with CFR 0.152.
 */
package demos.devmaster.lesson5;

import com.jogamp.openal.AL;
import com.jogamp.openal.ALC;
import com.jogamp.openal.ALCcontext;
import com.jogamp.openal.ALCdevice;
import com.jogamp.openal.ALException;
import com.jogamp.openal.ALFactory;
import com.jogamp.openal.util.ALut;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;

public class SourcesSharingBuffers {
    static ALC alc;
    static AL al;
    public static final int THUNDER = 0;
    public static final int WATERDROP = 1;
    public static final int STREAM = 2;
    public static final int RAIN = 3;
    public static final int CHIMES = 4;
    public static final int OCEAN = 5;
    public static final int NUM_BUFFERS = 6;
    static int[] buffers;
    static List sources;
    static float[] sourcePos;
    static float[] sourceVel;
    static float[] listenerPos;
    static float[] listenerVel;
    static float[] listenerOri;
    static boolean initialized;

    static void initOpenAL() throws ALException {
        alc = ALFactory.getALC();
        al = ALFactory.getAL();
        ALCdevice aLCdevice = alc.alcOpenDevice(null);
        if (aLCdevice == null) {
            throw new ALException("Error opening default OpenAL device");
        }
        String string = alc.alcGetString(aLCdevice, 4101);
        if (string == null) {
            throw new ALException("Error getting specifier for default OpenAL device");
        }
        System.out.println("Using device " + string);
        ALCcontext aLCcontext = alc.alcCreateContext(aLCdevice, null);
        if (aLCcontext == null) {
            throw new ALException("Error creating OpenAL context");
        }
        alc.alcMakeContextCurrent(aLCcontext);
        if (alc.alcGetError(aLCdevice) != 0) {
            throw new ALException("Error making OpenAL context current");
        }
    }

    static void exitOpenAL() {
        ALCcontext aLCcontext = alc.alcGetCurrentContext();
        ALCdevice aLCdevice = alc.alcGetContextsDevice(aLCcontext);
        alc.alcMakeContextCurrent(null);
        alc.alcDestroyContext(aLCcontext);
        alc.alcCloseDevice(aLCdevice);
    }

    static int loadALData() {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        ByteBuffer[] byteBufferArray = new ByteBuffer[1];
        int[] nArray3 = new int[1];
        int[] nArray4 = new int[1];
        al.alGenBuffers(6, buffers, 0);
        if (al.alGetError() != 0) {
            return 0;
        }
        ALut.alutLoadWAVFile((InputStream)SourcesSharingBuffers.class.getClassLoader().getResourceAsStream("demos/data/thunder.wav"), (int[])nArray, (ByteBuffer[])byteBufferArray, (int[])nArray2, (int[])nArray3, (int[])nArray4);
        al.alBufferData(buffers[0], nArray[0], (Buffer)byteBufferArray[0], nArray2[0], nArray3[0]);
        ALut.alutLoadWAVFile((InputStream)SourcesSharingBuffers.class.getClassLoader().getResourceAsStream("demos/data/waterdrop.wav"), (int[])nArray, (ByteBuffer[])byteBufferArray, (int[])nArray2, (int[])nArray3, (int[])nArray4);
        al.alBufferData(buffers[1], nArray[0], (Buffer)byteBufferArray[0], nArray2[0], nArray3[0]);
        ALut.alutLoadWAVFile((InputStream)SourcesSharingBuffers.class.getClassLoader().getResourceAsStream("demos/data/stream.wav"), (int[])nArray, (ByteBuffer[])byteBufferArray, (int[])nArray2, (int[])nArray3, (int[])nArray4);
        al.alBufferData(buffers[2], nArray[0], (Buffer)byteBufferArray[0], nArray2[0], nArray3[0]);
        ALut.alutLoadWAVFile((InputStream)SourcesSharingBuffers.class.getClassLoader().getResourceAsStream("demos/data/rain.wav"), (int[])nArray, (ByteBuffer[])byteBufferArray, (int[])nArray2, (int[])nArray3, (int[])nArray4);
        al.alBufferData(buffers[3], nArray[0], (Buffer)byteBufferArray[0], nArray2[0], nArray3[0]);
        ALut.alutLoadWAVFile((InputStream)SourcesSharingBuffers.class.getClassLoader().getResourceAsStream("demos/data/ocean.wav"), (int[])nArray, (ByteBuffer[])byteBufferArray, (int[])nArray2, (int[])nArray3, (int[])nArray4);
        al.alBufferData(buffers[5], nArray[0], (Buffer)byteBufferArray[0], nArray2[0], nArray3[0]);
        ALut.alutLoadWAVFile((InputStream)SourcesSharingBuffers.class.getClassLoader().getResourceAsStream("demos/data/chimes.wav"), (int[])nArray, (ByteBuffer[])byteBufferArray, (int[])nArray2, (int[])nArray3, (int[])nArray4);
        al.alBufferData(buffers[4], nArray[0], (Buffer)byteBufferArray[0], nArray2[0], nArray3[0]);
        if (al.alGetError() != 0) {
            return 0;
        }
        return 1;
    }

    static void addSource(int n) {
        int[] nArray = new int[1];
        al.alGenSources(1, nArray, 0);
        if (al.alGetError() != 0) {
            System.err.println("Error generating audio source.");
            System.exit(1);
        }
        al.alSourcei(nArray[0], 4105, buffers[n]);
        al.alSourcef(nArray[0], 4099, 1.0f);
        al.alSourcef(nArray[0], 4106, 1.0f);
        al.alSourcefv(nArray[0], 4100, sourcePos, 0);
        al.alSourcefv(nArray[0], 4102, sourceVel, 0);
        al.alSourcei(nArray[0], 4103, 1);
        al.alSourcePlay(nArray[0]);
        sources.add(new Integer(nArray[0]));
    }

    static void setListenerValues() {
        al.alListenerfv(4100, listenerPos, 0);
        al.alListenerfv(4102, listenerVel, 0);
        al.alListenerfv(4111, listenerOri, 0);
    }

    static void killALData() {
        Iterator iterator = sources.iterator();
        while (iterator.hasNext()) {
            al.alDeleteSources(1, new int[]{(Integer)iterator.next()}, 0);
        }
        sources.clear();
        al.alDeleteBuffers(6, buffers, 0);
        SourcesSharingBuffers.exitOpenAL();
    }

    static void initialize() {
        if (initialized) {
            return;
        }
        initialized = true;
        try {
            SourcesSharingBuffers.initOpenAL();
        }
        catch (ALException aLException) {
            aLException.printStackTrace();
            System.exit(1);
        }
        if (SourcesSharingBuffers.loadALData() == 0) {
            System.exit(1);
        }
        SourcesSharingBuffers.setListenerValues();
    }

    private static void addButton(JFrame jFrame, String string, final int n) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SourcesSharingBuffers.initialize();
                SourcesSharingBuffers.addSource(n);
            }
        });
        jFrame.getContentPane().add(jButton);
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-gui")) continue;
            bl = true;
        }
        if (bl) {
            JFrame jFrame = new JFrame("Sources Sharing Buffers - DevMaster OpenAL Lesson 5");
            jFrame.setDefaultCloseOperation(3);
            jFrame.getContentPane().setLayout(new GridLayout(7, 1));
            SourcesSharingBuffers.addButton(jFrame, "Add Water Drop", 1);
            SourcesSharingBuffers.addButton(jFrame, "Add Thunder", 0);
            SourcesSharingBuffers.addButton(jFrame, "Add Stream", 2);
            SourcesSharingBuffers.addButton(jFrame, "Add Rain", 3);
            SourcesSharingBuffers.addButton(jFrame, "Add Ocean", 5);
            SourcesSharingBuffers.addButton(jFrame, "Add Chimes", 4);
            JButton jButton = new JButton("Quit");
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    System.exit(0);
                }
            });
            jFrame.getContentPane().add(jButton);
            jFrame.pack();
            jFrame.setVisible(true);
        } else {
            SourcesSharingBuffers.initialize();
            char[] cArray = new char[1];
            while (cArray[0] != 'q') {
                try {
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
                    System.out.println("Press a key and hit ENTER: \n\t'w' for Water Drop\n\t't' for Thunder\n\t's' for Stream\n\t'r' for Rain\n\t'o' for Ocean\n\t'c' for Chimes\n\n'q' to Quit\n");
                    bufferedReader.read(cArray);
                    switch (cArray[0]) {
                        case 'w': {
                            SourcesSharingBuffers.addSource(1);
                            break;
                        }
                        case 't': {
                            SourcesSharingBuffers.addSource(0);
                            break;
                        }
                        case 's': {
                            SourcesSharingBuffers.addSource(2);
                            break;
                        }
                        case 'r': {
                            SourcesSharingBuffers.addSource(3);
                            break;
                        }
                        case 'o': {
                            SourcesSharingBuffers.addSource(5);
                            break;
                        }
                        case 'c': {
                            SourcesSharingBuffers.addSource(4);
                        }
                    }
                }
                catch (IOException iOException) {
                    SourcesSharingBuffers.killALData();
                    System.exit(1);
                }
            }
            SourcesSharingBuffers.killALData();
        }
    }

    static {
        buffers = new int[6];
        sources = new ArrayList();
        sourcePos = new float[]{0.0f, 0.0f, 0.0f};
        sourceVel = new float[]{0.0f, 0.0f, 0.0f};
        listenerPos = new float[]{0.0f, 0.0f, 0.0f};
        listenerVel = new float[]{0.0f, 0.0f, 0.0f};
        listenerOri = new float[]{0.0f, 0.0f, -1.0f, 0.0f, 1.0f, 0.0f};
        initialized = false;
    }
}

