/*
 * Decompiled with CFR 0.152.
 */
package demos.devmaster.lesson8;

import de.jarnbjo.ogg.CachedUrlStream;
import de.jarnbjo.ogg.EndOfOggStreamException;
import de.jarnbjo.ogg.LogicalOggStream;
import de.jarnbjo.vorbis.IdentificationHeader;
import de.jarnbjo.vorbis.VorbisStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;

public class OggDecoder {
    private static int BLOCK_SIZE = 262144;
    private VorbisStream vStream;
    private LogicalOggStream loStream;
    private AudioInputStream ais;
    private IdentificationHeader vStreamHdr;
    private AudioFormat audioFormat;
    private URL url;
    private boolean swap = false;
    private boolean endOfStream = false;

    public OggDecoder(URL uRL) {
        this.url = uRL;
    }

    public boolean initialize() {
        try {
            CachedUrlStream cachedUrlStream = new CachedUrlStream(this.url);
            this.loStream = (LogicalOggStream)cachedUrlStream.getLogicalStreams().iterator().next();
            this.vStream = new VorbisStream(this.loStream);
            this.vStreamHdr = this.vStream.getIdentificationHeader();
            this.audioFormat = new AudioFormat(this.vStreamHdr.getSampleRate(), 16, this.vStreamHdr.getChannels(), true, true);
            this.ais = new AudioInputStream(new VorbisInputStream(this.vStream), this.audioFormat, -1L);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public int numChannels() {
        return this.vStreamHdr.getChannels();
    }

    public int sampleRate() {
        return this.vStreamHdr.getSampleRate();
    }

    public void setSwap(boolean bl) {
        this.swap = bl;
    }

    public static void swapBytes(byte[] byArray) {
        OggDecoder.swapBytes(byArray, 0, byArray.length);
    }

    public static void swapBytes(byte[] byArray, int n, int n2) {
        for (int i = n; i < n + n2; i += 2) {
            byte by = byArray[i];
            byArray[i] = byArray[i + 1];
            byArray[i + 1] = by;
        }
    }

    public void play() {
        if (!this.initialize()) {
            return;
        }
        this.dump();
        try {
            int n;
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, this.audioFormat);
            SourceDataLine sourceDataLine = (SourceDataLine)AudioSystem.getLine(info);
            sourceDataLine.open(this.audioFormat);
            sourceDataLine.start();
            byte[] byArray = new byte[BLOCK_SIZE];
            do {
                if ((n = this.read(byArray)) <= 0) continue;
                sourceDataLine.write(byArray, 0, n);
            } while (n >= byArray.length);
            sourceDataLine.drain();
            sourceDataLine.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void toraw(String string) {
        if (!this.initialize()) {
            return;
        }
        this.setSwap(true);
        this.dump();
        try {
            int n;
            byte[] byArray = new byte[BLOCK_SIZE];
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            do {
                if ((n = this.read(byArray)) <= 0) continue;
                fileOutputStream.write(byArray, 0, n);
            } while (n >= byArray.length);
            fileOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public int read(byte[] byArray) throws IOException {
        int n;
        if (this.endOfStream) {
            return -1;
        }
        int n2 = 0;
        for (n = 0; n < byArray.length; n += n2) {
            n2 = this.ais.read(byArray, n, byArray.length - n);
            if (n2 > 0) continue;
            this.endOfStream = true;
            break;
        }
        if (this.swap) {
            OggDecoder.swapBytes(byArray, 0, n);
        }
        return n;
    }

    public void dump() {
        System.err.println("#Channels: " + this.vStreamHdr.getChannels());
        System.err.println("Sample rate: " + this.vStreamHdr.getSampleRate());
        System.err.println("Bitrate: nominal=" + this.vStreamHdr.getNominalBitrate() + ", max=" + this.vStreamHdr.getMaximumBitrate() + ", min=" + this.vStreamHdr.getMinimumBitrate());
    }

    public static void main(String[] stringArray) {
        int n = 0;
        String string = null;
        try {
            URL uRL;
            if (stringArray.length == 0) {
                uRL = OggDecoder.class.getClassLoader().getResource("demos/data/broken_glass.ogg");
                new OggDecoder(uRL).play();
            }
            while (n < stringArray.length) {
                if (stringArray[n].equals("-r")) {
                    string = stringArray[++n];
                } else {
                    System.err.println("Playing: " + stringArray[n]);
                    URL uRL2 = uRL = new File(stringArray[n]).exists() ? new URL("file:" + stringArray[n]) : new URL(stringArray[n]);
                    if (string != null) {
                        new OggDecoder(uRL).toraw(string);
                    } else {
                        new OggDecoder(uRL).play();
                    }
                }
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static class VorbisInputStream
    extends InputStream {
        private VorbisStream source;

        public VorbisInputStream(VorbisStream vorbisStream) {
            this.source = vorbisStream;
        }

        @Override
        public int read() throws IOException {
            return 0;
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            try {
                return this.source.readPcm(byArray, n, n2);
            }
            catch (EndOfOggStreamException endOfOggStreamException) {
                return -1;
            }
        }
    }
}

