/*
 * Decompiled with CFR 0.152.
 */
package demos.devmaster.lesson8;

import com.jogamp.openal.AL;
import com.jogamp.openal.ALException;
import com.jogamp.openal.ALFactory;
import com.jogamp.openal.util.ALut;
import demos.devmaster.lesson8.OggDecoder;
import java.io.File;
import java.net.URL;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class OggStreamer {
    static AL al = null;
    private static boolean debug;
    private static int totalBytes;
    private OggDecoder oggDecoder;
    private static int BUFFER_SIZE;
    private static int NUM_BUFFERS;
    private int[] buffers = new int[NUM_BUFFERS];
    private int[] source = new int[1];
    private int format;
    private int rate;
    private float[] sourcePos = new float[]{0.0f, 0.0f, 0.0f};
    private float[] sourceVel = new float[]{0.0f, 0.0f, 0.0f};
    private float[] sourceDir = new float[]{0.0f, 0.0f, 0.0f};
    private URL url;
    private long sleepTime = 0L;

    private static void debugMsg(String string) {
        if (debug) {
            System.err.println(string);
        }
    }

    public OggStreamer(URL uRL) {
        this.url = uRL;
    }

    public boolean open() {
        this.oggDecoder = new OggDecoder(this.url);
        if (!this.oggDecoder.initialize()) {
            System.err.println("Error initializing ogg stream...");
            return false;
        }
        int n = this.oggDecoder.numChannels();
        int n2 = 2;
        this.format = n == 1 ? 4353 : 4355;
        this.rate = this.oggDecoder.sampleRate();
        this.sleepTime = (long)(1000.0 * (double)BUFFER_SIZE / (double)n2 / (double)n / (double)this.rate / 10.0);
        this.sleepTime = (this.sleepTime + 10L) / 10L * 10L;
        System.err.println("#Buffers: " + NUM_BUFFERS);
        System.err.println("Buffer size: " + BUFFER_SIZE);
        System.err.println("Format: 0x" + Integer.toString(this.format, 16));
        System.err.println("Sleep time: " + this.sleepTime);
        this.oggDecoder.setSwap(true);
        al.alGenBuffers(NUM_BUFFERS, this.buffers, 0);
        this.check();
        al.alGenSources(1, this.source, 0);
        this.check();
        al.alSourcefv(this.source[0], 4100, this.sourcePos, 0);
        al.alSourcefv(this.source[0], 4102, this.sourceVel, 0);
        al.alSourcefv(this.source[0], 4101, this.sourceDir, 0);
        al.alSourcef(this.source[0], 4129, 0.0f);
        al.alSourcei(this.source[0], 514, 1);
        return true;
    }

    public void release() {
        al.alSourceStop(this.source[0]);
        this.empty();
        for (int i = 0; i < NUM_BUFFERS; ++i) {
            al.alDeleteSources(i, this.source, 0);
            this.check();
        }
    }

    public boolean playback() {
        if (this.playing()) {
            return true;
        }
        OggStreamer.debugMsg("playback(): stream all buffers");
        for (int i = 0; i < NUM_BUFFERS; ++i) {
            if (this.stream(this.buffers[i])) continue;
            return false;
        }
        OggStreamer.debugMsg("playback(): queue all buffers & play source");
        al.alSourceQueueBuffers(this.source[0], NUM_BUFFERS, this.buffers, 0);
        al.alSourcePlay(this.source[0]);
        return true;
    }

    public boolean playing() {
        int[] nArray = new int[1];
        al.alGetSourcei(this.source[0], 4112, nArray, 0);
        return nArray[0] == 4114;
    }

    public boolean update() {
        int[] nArray = new int[1];
        boolean bl = true;
        OggStreamer.debugMsg("update()");
        al.alGetSourcei(this.source[0], 4118, nArray, 0);
        while (nArray[0] > 0) {
            int[] nArray2 = new int[1];
            al.alSourceUnqueueBuffers(this.source[0], 1, nArray2, 0);
            this.check();
            OggStreamer.debugMsg("update(): buffer unqueued => " + nArray2[0]);
            bl = this.stream(nArray2[0]);
            OggStreamer.debugMsg("update(): buffer queued => " + nArray2[0]);
            al.alSourceQueueBuffers(this.source[0], 1, nArray2, 0);
            this.check();
            nArray[0] = nArray[0] - 1;
        }
        return bl;
    }

    public boolean stream(int n) {
        byte[] byArray = new byte[BUFFER_SIZE];
        int n2 = 0;
        try {
            n2 = this.oggDecoder.read(byArray);
            if (n2 <= 0) {
                return false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        OggStreamer.debugMsg("stream(): buffer data => " + n + " totalBytes:" + (totalBytes += n2));
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, 0, n2);
        al.alBufferData(n, this.format, (Buffer)byteBuffer, n2, this.rate);
        this.check();
        return true;
    }

    protected void empty() {
        int[] nArray = new int[1];
        al.alGetSourcei(this.source[0], 4117, nArray, 0);
        while (nArray[0] > 0) {
            int[] nArray2 = new int[1];
            al.alSourceUnqueueBuffers(this.source[0], 1, nArray2, 0);
            this.check();
            nArray[0] = nArray[0] - 1;
        }
        this.oggDecoder = null;
    }

    protected void check() {
        if (al.alGetError() != 0) {
            throw new ALException("OpenAL error raised...");
        }
    }

    public boolean playstream() {
        if (!this.open()) {
            return false;
        }
        this.oggDecoder.dump();
        if (!this.playback()) {
            return false;
        }
        while (this.update()) {
            try {
                Thread.sleep(this.sleepTime);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (this.playing() || this.playback()) continue;
            return false;
        }
        return true;
    }

    public static void main(String[] stringArray) {
        if (al == null) {
            return;
        }
        try {
            URL uRL;
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                if ("-bs".equals(stringArray[i])) {
                    BUFFER_SIZE = Integer.valueOf(stringArray[++i]);
                    continue;
                }
                if ("-nb".equals(stringArray[i])) {
                    NUM_BUFFERS = Integer.valueOf(stringArray[++i]);
                    continue;
                }
                if ("-d".equals(stringArray[i])) {
                    debug = true;
                    continue;
                }
                System.err.println("Playing Ogg stream : " + stringArray[i]);
                URL uRL2 = uRL = new File(stringArray[i]).exists() ? new URL("file:" + stringArray[i]) : new URL(stringArray[i]);
                if (new OggStreamer(uRL).playstream()) continue;
                bl = true;
                System.err.println("ERROR!!");
            }
            if (!bl) {
                uRL = OggStreamer.class.getClassLoader().getResource("demos/data/broken_glass.ogg");
                new OggStreamer(uRL).playstream();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.exit(0);
    }

    static {
        try {
            ALut.alutInit();
            al = ALFactory.getAL();
            al.alGetError();
        }
        catch (ALException aLException) {
            System.err.println("Error initializing OpenAL");
            aLException.printStackTrace();
        }
        debug = false;
        totalBytes = 0;
        BUFFER_SIZE = 65536;
        NUM_BUFFERS = 2;
    }
}

