/*
 * Decompiled with CFR 0.152.
 */
package demos.efx;

import com.jogamp.openal.AL;
import com.jogamp.openal.ALC;
import com.jogamp.openal.ALCcontext;
import com.jogamp.openal.ALCdevice;
import com.jogamp.openal.ALExt;
import com.jogamp.openal.ALFactory;
import com.jogamp.openal.util.WAVData;
import com.jogamp.openal.util.WAVLoader;
import java.io.InputStream;
import java.nio.Buffer;

public class EFXFilter {
    private static ALCdevice device;
    private static ALCcontext context;
    private static ALC alc;
    private static AL al;
    private static ALExt alExt;
    private static String wavefile;

    public static void main(String[] stringArray) {
        try {
            EFXFilter.initOpenAL();
            if (alc.alcIsExtensionPresent(device, "ALC_EXT_EFX")) {
                WAVData wAVData = WAVLoader.loadFromStream((InputStream)EFXFilter.class.getClassLoader().getResourceAsStream(wavefile));
                int[] nArray = new int[1];
                al.alGenBuffers(1, nArray, 0);
                al.alBufferData(nArray[0], wAVData.format, (Buffer)wAVData.data, wAVData.size, wAVData.freq);
                int n = nArray[0];
                int[] nArray2 = new int[1];
                al.alGenSources(1, nArray2, 0);
                al.alSourcei(nArray2[0], 4105, n);
                int n2 = nArray2[0];
                EFXFilter.playDry(n2);
                EFXFilter.playDirectFilter(n2);
                EFXFilter.playAuxiliaryNoFilter(n2);
                EFXFilter.playAuxiliaryFilter(n2);
                al.alSourcei(n2, 4105, 0);
                al.alDeleteSources(1, new int[]{n2}, 0);
                al.alDeleteBuffers(1, new int[]{n}, 0);
            } else {
                System.out.println("EFX not supported.");
            }
            EFXFilter.shutdownOpenAL();
            System.exit(0);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            exception.printStackTrace();
            System.exit(1);
        }
    }

    private static void initOpenAL() {
        alc = ALFactory.getALC();
        device = alc.alcOpenDevice(null);
        context = alc.alcCreateContext(device, null);
        alc.alcMakeContextCurrent(context);
        al = ALFactory.getAL();
        alExt = ALFactory.getALExt();
    }

    private static void shutdownOpenAL() {
        alc.alcMakeContextCurrent(null);
        alc.alcDestroyContext(context);
        alc.alcCloseDevice(device);
        alc = null;
        al = null;
    }

    private static void playDry(int n) {
        System.out.println("Source played dry");
        EFXFilter.play(n);
    }

    private static void playDirectFilter(int n) {
        System.out.println("Source played through a direct lowpass filter");
        int n2 = EFXFilter.createFilter(1, 1.0f, 0.5f);
        al.alSourcei(n, 131077, n2);
        EFXFilter.play(n);
        al.alSourcei(n, 131077, 0);
        EFXFilter.deleteFilter(n2);
    }

    private static void playAuxiliaryNoFilter(int n) {
        System.out.println("Source played through an auxiliary reverb without filtering");
        int[] nArray = new int[1];
        alExt.alGenAuxiliaryEffectSlots(1, nArray, 0);
        int[] nArray2 = new int[1];
        alExt.alGenEffects(1, nArray2, 0);
        alExt.alEffecti(nArray2[0], 32769, 1);
        alExt.alAuxiliaryEffectSloti(nArray[0], 1, nArray2[0]);
        al.alSource3i(n, 131078, nArray[0], 0, 0);
        EFXFilter.play(n);
        al.alSource3i(n, 131078, 0, 0, 0);
        alExt.alDeleteAuxiliaryEffectSlots(1, nArray, 0);
        alExt.alDeleteEffects(1, nArray2, 0);
    }

    private static void playAuxiliaryFilter(int n) {
        System.out.println("Source played through an auxiliary reverb with lowpass filter");
        int n2 = EFXFilter.createFilter(1, 1.0f, 0.5f);
        int[] nArray = new int[1];
        alExt.alGenAuxiliaryEffectSlots(1, nArray, 0);
        int[] nArray2 = new int[1];
        alExt.alGenEffects(1, nArray2, 0);
        alExt.alEffecti(nArray2[0], 32769, 1);
        alExt.alAuxiliaryEffectSloti(nArray[0], 1, nArray2[0]);
        al.alSource3i(n, 131078, nArray[0], 0, n2);
        EFXFilter.play(n);
        al.alSource3i(n, 131078, 0, 0, 0);
        alExt.alDeleteAuxiliaryEffectSlots(1, nArray, 0);
        alExt.alDeleteEffects(1, nArray2, 0);
    }

    private static void play(int n) {
        al.alSourcePlay(n);
        while (true) {
            int[] nArray = new int[1];
            al.alGetSourcei(n, 4112, nArray, 0);
            if (nArray[0] != 4114) break;
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException.getMessage(), interruptedException);
            }
        }
    }

    private static int createFilter(int n, float f, float f2) {
        int[] nArray = new int[1];
        alExt.alGenFilters(1, nArray, 0);
        alExt.alFilteri(nArray[0], 32769, n);
        alExt.alFilterf(nArray[0], n, f);
        alExt.alFilterf(nArray[0], n, f2);
        return nArray[0];
    }

    private static void deleteFilter(int n) {
        alExt.alDeleteFilters(1, new int[]{n}, 0);
    }

    static {
        wavefile = "demos/data/Footsteps.wav";
    }
}

