/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl.demos.bandwidth;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opencl.CLBuffer;
import com.jogamp.opencl.CLCommandQueue;
import com.jogamp.opencl.CLContext;
import com.jogamp.opencl.CLDevice;
import com.jogamp.opencl.CLMemory;
import com.jogamp.opencl.CLPlatform;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class BandwidthBenchmark {
    private static int MEMCOPY_ITERATIONS = 100;
    private static int DEFAULT_SIZE = 0x2000000;
    private static int DEFAULT_INCREMENT = 0x400000;
    private static int SHMOO_MEMSIZE_MAX = 0x4000000;
    private static int SHMOO_INCREMENT_1KB = 1024;
    private static int SHMOO_INCREMENT_2KB = 2048;
    private static int SHMOO_INCREMENT_10KB = 10240;
    private static int SHMOO_INCREMENT_100KB = 102400;
    private static int SHMOO_INCREMENT_1MB = 0x100000;
    private static int SHMOO_INCREMENT_2MB = 0x200000;
    private static int SHMOO_INCREMENT_4MB = 0x400000;
    private static int SHMOO_LIMIT_20KB = 20480;
    private static int SHMOO_LIMIT_50KB = 51200;
    private static int SHMOO_LIMIT_100KB = 102400;
    private static int SHMOO_LIMIT_1MB = 0x100000;
    private static int SHMOO_LIMIT_16MB = 0x1000000;
    private static int SHMOO_LIMIT_32MB = 0x2000000;

    public static void main(String[] cLContext) {
        int n = DEFAULT_SIZE;
        int n2 = DEFAULT_SIZE;
        int n3 = DEFAULT_INCREMENT;
        TEST_MODE tEST_MODE = TEST_MODE.QUICK;
        MEMORY mEMORY = MEMORY.PAGEABLE;
        ACCESS aCCESS = ACCESS.DIRECT;
        CLDevice cLDevice = CLPlatform.listCLPlatforms();
        CLPlatform cLPlatform = cLDevice[0];
        for (CLPlatform cLPlatform2 : cLDevice) {
            if (!cLPlatform2.getICDSuffix().equals("NV")) continue;
            cLPlatform = cLPlatform2;
            break;
        }
        CLDevice cLDevice2 = cLPlatform.getMaxFlopsDevice();
        int n4 = -1;
        for (String string : cLContext) {
            if (string.startsWith("--access=")) {
                aCCESS = ACCESS.valueOf(string.substring(9).toUpperCase());
                continue;
            }
            if (string.startsWith("--memory=")) {
                mEMORY = MEMORY.valueOf(string.substring(9).toUpperCase());
                continue;
            }
            if (string.startsWith("--device=")) {
                n4 = Integer.parseInt(string.substring(9).toUpperCase());
                continue;
            }
            if (string.startsWith("--mode=")) {
                tEST_MODE = TEST_MODE.valueOf(string.substring(7).toUpperCase());
                continue;
            }
            if (string.startsWith("--platform=")) {
                cLPlatform = cLDevice[Integer.parseInt(string.substring(11))];
                continue;
            }
            System.out.println("unknown arg: " + string);
            System.exit(1);
        }
        if (n4 != -1) {
            cLDevice2 = cLPlatform.listCLDevices()[n4];
        }
        CLContext cLContext2 = CLContext.create((CLDevice[])new CLDevice[]{cLDevice2});
        System.out.println();
        System.out.println(cLPlatform);
        System.out.println(cLContext2);
        System.out.println();
        BandwidthBenchmark.testBandwidth(cLContext2, n, n2, n3, tEST_MODE, COPY.HOST_TO_DEVICE, aCCESS, mEMORY);
        BandwidthBenchmark.testBandwidth(cLContext2, n, n2, n3, tEST_MODE, COPY.DEVICE_TO_HOST, aCCESS, mEMORY);
        BandwidthBenchmark.testBandwidth(cLContext2, n, n2, n3, tEST_MODE, COPY.DEVICE_TO_DEVICE, aCCESS, mEMORY);
        cLContext2.release();
    }

    private static void testBandwidth(CLContext cLContext, int n, int n2, int n3, TEST_MODE tEST_MODE, COPY cOPY, ACCESS aCCESS, MEMORY mEMORY) {
        switch (tEST_MODE.ordinal()) {
            case 0: {
                BandwidthBenchmark.testBandwidthQuick(cLContext, DEFAULT_SIZE, cOPY, aCCESS, mEMORY);
                break;
            }
            case 1: {
                BandwidthBenchmark.testBandwidthRange(cLContext, n, n2, n3, cOPY, aCCESS, mEMORY);
                break;
            }
            case 2: {
                BandwidthBenchmark.testBandwidthShmoo(cLContext, cOPY, aCCESS, mEMORY);
                break;
            }
        }
    }

    private static void testBandwidthQuick(CLContext cLContext, int n, COPY cOPY, ACCESS aCCESS, MEMORY mEMORY) {
        BandwidthBenchmark.testBandwidthRange(cLContext, n, n, DEFAULT_INCREMENT, cOPY, aCCESS, mEMORY);
    }

    private static void testBandwidthRange(CLContext cLContext, int n, int n2, int n3, COPY cOPY, ACCESS aCCESS, MEMORY mEMORY) {
        CLDevice[] cLDeviceArray;
        int n4 = 1 + (n2 - n) / n3;
        int[] nArray = new int[n4];
        double[] dArray = new double[n4];
        for (CLDevice cLDevice : cLDeviceArray = cLContext.getDevices()) {
            CLCommandQueue cLCommandQueue = cLDevice.createCommandQueue();
            block6: for (int i = 0; i < n4; ++i) {
                nArray[i] = n + i * n3;
                switch (cOPY.ordinal()) {
                    case 0: {
                        int n5 = i;
                        dArray[n5] = dArray[n5] + BandwidthBenchmark.testDeviceToHostTransfer(cLCommandQueue, nArray[i], aCCESS, mEMORY);
                        continue block6;
                    }
                    case 1: {
                        int n6 = i;
                        dArray[n6] = dArray[n6] + BandwidthBenchmark.testHostToDeviceTransfer(cLCommandQueue, nArray[i], aCCESS, mEMORY);
                        continue block6;
                    }
                    case 2: {
                        int n7 = i;
                        dArray[n7] = dArray[n7] + BandwidthBenchmark.testDeviceToDeviceTransfer(cLCommandQueue, nArray[i]);
                    }
                }
            }
            cLCommandQueue.release();
        }
        BandwidthBenchmark.printResultsReadable(nArray, dArray, n4, cOPY, aCCESS, mEMORY, n4);
    }

    private static void testBandwidthShmoo(CLContext cLContext, COPY cOPY, ACCESS aCCESS, MEMORY mEMORY) {
        CLDevice[] cLDeviceArray;
        int n = 1 + SHMOO_LIMIT_20KB / SHMOO_INCREMENT_1KB + (SHMOO_LIMIT_50KB - SHMOO_LIMIT_20KB) / SHMOO_INCREMENT_2KB + (SHMOO_LIMIT_100KB - SHMOO_LIMIT_50KB) / SHMOO_INCREMENT_10KB + (SHMOO_LIMIT_1MB - SHMOO_LIMIT_100KB) / SHMOO_INCREMENT_100KB + (SHMOO_LIMIT_16MB - SHMOO_LIMIT_1MB) / SHMOO_INCREMENT_1MB + (SHMOO_LIMIT_32MB - SHMOO_LIMIT_16MB) / SHMOO_INCREMENT_2MB + (SHMOO_MEMSIZE_MAX - SHMOO_LIMIT_32MB) / SHMOO_INCREMENT_4MB;
        int[] nArray = new int[n];
        double[] dArray = new double[n];
        for (CLDevice cLDevice : cLDeviceArray = cLContext.getDevices()) {
            CLCommandQueue cLCommandQueue = cLDevice.createCommandQueue();
            int n2 = 0;
            int n3 = 0;
            while (n3 <= SHMOO_MEMSIZE_MAX) {
                n3 = n3 < SHMOO_LIMIT_20KB ? (n3 += SHMOO_INCREMENT_1KB) : (n3 < SHMOO_LIMIT_50KB ? (n3 += SHMOO_INCREMENT_2KB) : (n3 < SHMOO_LIMIT_100KB ? (n3 += SHMOO_INCREMENT_10KB) : (n3 < SHMOO_LIMIT_1MB ? (n3 += SHMOO_INCREMENT_100KB) : (n3 < SHMOO_LIMIT_16MB ? (n3 += SHMOO_INCREMENT_1MB) : (n3 < SHMOO_LIMIT_32MB ? (n3 += SHMOO_INCREMENT_2MB) : (n3 += SHMOO_INCREMENT_4MB))))));
                nArray[n2] = n3;
                switch (cOPY.ordinal()) {
                    case 0: {
                        int n4 = n2;
                        dArray[n4] = dArray[n4] + BandwidthBenchmark.testDeviceToHostTransfer(cLCommandQueue, nArray[n2], aCCESS, mEMORY);
                        break;
                    }
                    case 1: {
                        int n5 = n2;
                        dArray[n5] = dArray[n5] + BandwidthBenchmark.testHostToDeviceTransfer(cLCommandQueue, nArray[n2], aCCESS, mEMORY);
                        break;
                    }
                    case 2: {
                        int n6 = n2;
                        dArray[n6] = dArray[n6] + BandwidthBenchmark.testDeviceToDeviceTransfer(cLCommandQueue, nArray[n2]);
                    }
                }
                ++n2;
            }
            cLCommandQueue.release();
        }
        BandwidthBenchmark.printResultsReadable(nArray, dArray, n, cOPY, aCCESS, mEMORY, n);
    }

    private static double testDeviceToHostTransfer(CLCommandQueue cLCommandQueue, int n, ACCESS aCCESS, MEMORY mEMORY) {
        ByteBuffer byteBuffer = null;
        CLBuffer cLBuffer = null;
        CLContext cLContext = cLCommandQueue.getContext();
        if (mEMORY == MEMORY.PINNED) {
            cLBuffer = cLContext.createBuffer(n, new CLMemory.Mem[]{CLMemory.Mem.READ_WRITE, CLMemory.Mem.ALLOCATE_BUFFER});
            byteBuffer = cLCommandQueue.putMapBuffer(cLBuffer, CLMemory.Map.WRITE, true);
            BandwidthBenchmark.fill(byteBuffer);
            cLCommandQueue.putUnmapMemory((CLMemory)cLBuffer, (Buffer)byteBuffer);
        } else {
            byteBuffer = Buffers.newDirectByteBuffer((int)n);
            BandwidthBenchmark.fill(byteBuffer);
        }
        CLBuffer cLBuffer2 = cLContext.createBuffer(n, new CLMemory.Mem[]{CLMemory.Mem.READ_WRITE});
        if (mEMORY == MEMORY.PINNED) {
            byteBuffer = cLCommandQueue.putMapBuffer(cLBuffer, CLMemory.Map.WRITE, true);
            cLBuffer2 = cLBuffer2.cloneWith((Buffer)byteBuffer);
            cLCommandQueue.putWriteBuffer(cLBuffer2, false);
        } else {
            cLBuffer2 = cLBuffer2.cloneWith((Buffer)byteBuffer);
            cLCommandQueue.putWriteBuffer(cLBuffer2, false);
        }
        cLCommandQueue.finish();
        long l = System.nanoTime();
        if (aCCESS == ACCESS.DIRECT) {
            cLBuffer2 = cLBuffer2.cloneWith((Buffer)byteBuffer);
            for (int i = 0; i < MEMCOPY_ITERATIONS; ++i) {
                cLCommandQueue.putReadBuffer(cLBuffer2, false);
            }
            cLCommandQueue.finish();
        } else {
            ByteBuffer byteBuffer2 = cLCommandQueue.putMapBuffer(cLBuffer2, CLMemory.Map.WRITE, true);
            for (int i = 0; i < MEMCOPY_ITERATIONS; ++i) {
                byteBuffer.put(byteBuffer2).rewind();
                byteBuffer2.rewind();
            }
            cLCommandQueue.putUnmapMemory((CLMemory)cLBuffer2, (Buffer)byteBuffer2);
        }
        l = System.nanoTime() - l;
        cLBuffer2.release();
        if (cLBuffer != null) {
            cLCommandQueue.putUnmapMemory((CLMemory)cLBuffer, (Buffer)byteBuffer);
            cLBuffer.release();
        }
        double d = (double)l / 1.0E9;
        return (double)n * (double)MEMCOPY_ITERATIONS / (d * 1048576.0);
    }

    private static double testHostToDeviceTransfer(CLCommandQueue cLCommandQueue, int n, ACCESS aCCESS, MEMORY mEMORY) {
        ByteBuffer byteBuffer;
        CLBuffer cLBuffer = null;
        CLContext cLContext = cLCommandQueue.getContext();
        if (mEMORY == MEMORY.PINNED) {
            cLBuffer = cLContext.createBuffer(n, new CLMemory.Mem[]{CLMemory.Mem.READ_WRITE, CLMemory.Mem.ALLOCATE_BUFFER});
            byteBuffer = cLCommandQueue.putMapBuffer(cLBuffer, CLMemory.Map.WRITE, true);
            BandwidthBenchmark.fill(byteBuffer);
            cLCommandQueue.putUnmapMemory((CLMemory)cLBuffer, (Buffer)byteBuffer);
        } else {
            byteBuffer = Buffers.newDirectByteBuffer((int)n);
            BandwidthBenchmark.fill(byteBuffer);
        }
        CLBuffer cLBuffer2 = cLContext.createBuffer(n, new CLMemory.Mem[]{CLMemory.Mem.READ_WRITE});
        cLCommandQueue.finish();
        long l = System.nanoTime();
        if (aCCESS == ACCESS.DIRECT) {
            if (mEMORY == MEMORY.PINNED) {
                byteBuffer = cLCommandQueue.putMapBuffer(cLBuffer, CLMemory.Map.WRITE, true);
            }
            cLBuffer2 = cLBuffer2.cloneWith((Buffer)byteBuffer);
            for (int i = 0; i < MEMCOPY_ITERATIONS; ++i) {
                cLCommandQueue.putWriteBuffer(cLBuffer2, false);
            }
            cLCommandQueue.finish();
        } else {
            ByteBuffer byteBuffer2 = cLCommandQueue.putMapBuffer(cLBuffer2, CLMemory.Map.READ, true);
            for (int i = 0; i < MEMCOPY_ITERATIONS; ++i) {
                byteBuffer2.put(byteBuffer).rewind();
                byteBuffer.rewind();
            }
            cLCommandQueue.putUnmapMemory((CLMemory)cLBuffer2, (Buffer)byteBuffer2);
        }
        l = System.nanoTime() - l;
        cLBuffer2.release();
        if (cLBuffer != null) {
            cLBuffer.release();
        }
        double d = (double)l / 1.0E9;
        return (double)n * (double)MEMCOPY_ITERATIONS / (d * 1048576.0);
    }

    private static double testDeviceToDeviceTransfer(CLCommandQueue cLCommandQueue, int n) {
        CLContext cLContext = cLCommandQueue.getContext();
        ByteBuffer byteBuffer = Buffers.newDirectByteBuffer((int)n);
        BandwidthBenchmark.fill(byteBuffer);
        CLBuffer cLBuffer = cLContext.createBuffer(n, new CLMemory.Mem[]{CLMemory.Mem.READ_ONLY});
        CLBuffer cLBuffer2 = cLContext.createBuffer(n, new CLMemory.Mem[]{CLMemory.Mem.WRITE_ONLY});
        cLBuffer = cLBuffer.cloneWith((Buffer)byteBuffer);
        cLCommandQueue.putWriteBuffer(cLBuffer, true);
        cLCommandQueue.finish();
        long l = System.nanoTime();
        for (int i = 0; i < MEMCOPY_ITERATIONS; ++i) {
            cLCommandQueue.putCopyBuffer(cLBuffer, cLBuffer2);
        }
        cLCommandQueue.finish();
        l = System.nanoTime() - l;
        cLBuffer.release();
        cLBuffer2.release();
        double d = (double)l / 1.0E9;
        return 2.0 * ((double)n * (double)MEMCOPY_ITERATIONS) / (d * 1048576.0);
    }

    private static void fill(ByteBuffer byteBuffer) {
        int n = 0;
        while (byteBuffer.remaining() > 0) {
            byteBuffer.putChar((char)(n++ & 0xFF));
        }
        byteBuffer.rewind();
    }

    private static void printResultsReadable(int[] nArray, double[] dArray, int n, COPY cOPY, ACCESS aCCESS, MEMORY mEMORY, int n2) {
        int n3;
        if (cOPY == COPY.DEVICE_TO_DEVICE) {
            System.out.print("Device to Device Bandwidth, " + n2 + " Device(s), ");
        } else {
            if (cOPY == COPY.DEVICE_TO_HOST) {
                System.out.print("Device to Host Bandwidth, " + n2 + " Device(s), ");
            } else if (cOPY == COPY.HOST_TO_DEVICE) {
                System.out.print("Host to Device Bandwidth, " + n2 + " Device(s), ");
            }
            if (mEMORY == MEMORY.PAGEABLE) {
                System.out.print("Paged memory");
            } else if (mEMORY == MEMORY.PINNED) {
                System.out.print("Pinned memory");
            }
            if (aCCESS == ACCESS.DIRECT) {
                System.out.println(", direct access");
            } else if (aCCESS == ACCESS.MAPPED) {
                System.out.println(", mapped access");
            }
        }
        System.out.println();
        System.out.println("   Transfer Size (Bytes)\tBandwidth(MB/s)\n");
        for (n3 = 0; n3 < n - 1; ++n3) {
            System.out.printf("   %s\t\t\t%s%.1f\n", nArray[n3], nArray[n3] < 10000 ? "\t" : "", dArray[n3]);
        }
        System.out.printf("   %s\t\t\t%s%.1f\n\n", nArray[n3], nArray[n3] < 10000 ? "\t" : "", dArray[n3]);
    }

    private static enum TEST_MODE {
        QUICK,
        RANGE,
        SHMOO;

    }

    private static enum MEMORY {
        PAGEABLE,
        PINNED;

    }

    private static enum ACCESS {
        MAPPED,
        DIRECT;

    }

    private static enum COPY {
        DEVICE_TO_HOST,
        HOST_TO_DEVICE,
        DEVICE_TO_DEVICE;

    }
}

