/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl.demos.bitonicsort;

import com.jogamp.opencl.CLBuffer;
import com.jogamp.opencl.CLCommandQueue;
import com.jogamp.opencl.CLContext;
import com.jogamp.opencl.CLDevice;
import com.jogamp.opencl.CLKernel;
import com.jogamp.opencl.CLMemory;
import com.jogamp.opencl.CLProgram;
import java.io.IOException;
import java.nio.IntBuffer;
import java.util.Map;
import java.util.Random;

public class BitonicSort {
    private static final String BITONIC_MERGE_GLOBAL = "bitonicMergeGlobal";
    private static final String BITONIC_MERGE_LOCAL = "bitonicMergeLocal";
    private static final String BITONIC_SORT_LOCAL = "bitonicSortLocal";
    private static final String BITONIC_SORT_LOCAL1 = "bitonicSortLocal1";
    private static final int LOCAL_SIZE_LIMIT = 1024;
    private final Map<String, CLKernel> kernels;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BitonicSort() throws IOException {
        System.out.println("Initializing OpenCL...");
        CLContext cLContext = null;
        try {
            int n;
            int n2;
            cLContext = CLContext.create();
            CLCommandQueue cLCommandQueue = cLContext.getMaxFlopsDevice().createCommandQueue();
            System.out.println("Initializing OpenCL bitonic sorter...");
            this.kernels = this.initBitonicSort(cLCommandQueue);
            System.out.println("Creating OpenCL memory objects...");
            CLBuffer cLBuffer = cLContext.createIntBuffer(0x100000, new CLMemory.Mem[]{CLMemory.Mem.READ_ONLY, CLMemory.Mem.USE_BUFFER});
            System.out.println((float)cLBuffer.getCLSize() / 1000000.0f);
            System.out.println("Initializing data...\n");
            Random random = new Random();
            for (n2 = 0; n2 < 0x100000; ++n2) {
                n = random.nextInt(1000000);
                ((IntBuffer)cLBuffer.getBuffer()).put(n2, n);
            }
            n2 = 0x100000;
            n = 0x100000 / n2;
            System.out.printf("Test array length %d (%d arrays in the batch)...\n", n2, n);
            long l = System.currentTimeMillis();
            this.bitonicSort(cLCommandQueue, cLBuffer, cLBuffer, n, n2, 1);
            cLCommandQueue.putReadBuffer(cLBuffer, true);
            System.out.println(System.currentTimeMillis() - l + "ms");
            IntBuffer intBuffer = (IntBuffer)cLBuffer.getBuffer();
            this.printSnapshot(intBuffer, 20);
            this.checkIfSorted(intBuffer);
            System.out.println("\nTEST PASSED");
        }
        finally {
            if (cLContext != null) {
                cLContext.release();
            }
        }
    }

    private Map<String, CLKernel> initBitonicSort(CLCommandQueue cLCommandQueue) throws IOException {
        System.out.println("    creating bitonic sort program");
        CLContext cLContext = cLCommandQueue.getContext();
        CLProgram cLProgram = cLContext.createProgram(this.getClass().getResourceAsStream("BitonicSort.cl")).build(CLProgram.define((String)"LOCAL_SIZE_LIMIT", (Object)1024));
        Map map = cLProgram.createCLKernels();
        System.out.println("    checking minimum supported workgroup size");
        CLDevice cLDevice = cLCommandQueue.getDevice();
        long l = ((CLKernel)map.get(BITONIC_SORT_LOCAL)).getWorkGroupSize(cLDevice);
        long l2 = ((CLKernel)map.get(BITONIC_SORT_LOCAL1)).getWorkGroupSize(cLDevice);
        long l3 = ((CLKernel)map.get(BITONIC_MERGE_LOCAL)).getWorkGroupSize(cLDevice);
        if (l < 512L || l2 < 512L || l3 < 512L) {
            throw new RuntimeException("Minimum work-group size 512 required by this application is not supported on this device.");
        }
        return map;
    }

    public void bitonicSort(CLCommandQueue cLCommandQueue, CLBuffer<?> cLBuffer, CLBuffer<?> cLBuffer2, int n, int n2, int n3) {
        if (n2 < 2) {
            throw new IllegalArgumentException("arrayLength was " + n2);
        }
        n3 = n3 != 0 ? 1 : 0;
        CLKernel cLKernel = this.kernels.get(BITONIC_SORT_LOCAL1);
        CLKernel cLKernel2 = this.kernels.get(BITONIC_SORT_LOCAL);
        CLKernel cLKernel3 = this.kernels.get(BITONIC_MERGE_GLOBAL);
        CLKernel cLKernel4 = this.kernels.get(BITONIC_MERGE_LOCAL);
        if (n2 <= 1024) {
            cLKernel2.putArgs(new CLMemory[]{cLBuffer, cLBuffer2}).putArg(n2).putArg(n3).rewind();
            int n4 = 512;
            int n5 = n * n2 / 2;
            cLCommandQueue.put1DRangeKernel(cLKernel2, 0L, (long)n5, (long)n4);
        } else {
            cLKernel.setArgs(new CLMemory[]{cLBuffer, cLBuffer2});
            int n6 = 512;
            int n7 = n * n2 / 2;
            cLCommandQueue.put1DRangeKernel(cLKernel, 0L, (long)n7, (long)n6);
            block0: for (int i = 2048; i <= n2; i <<= 1) {
                for (int j = i / 2; j > 0; j >>= 1) {
                    if (j < 1024) {
                        cLKernel4.putArgs(new CLMemory[]{cLBuffer, cLBuffer}).putArg(n2).putArg(j).putArg(i).putArg(n3).rewind();
                        n6 = 512;
                        n7 = n * n2 / 2;
                        cLCommandQueue.put1DRangeKernel(cLKernel4, 0L, (long)n7, (long)n6);
                        continue block0;
                    }
                    cLKernel3.putArgs(new CLMemory[]{cLBuffer, cLBuffer}).putArg(n2).putArg(i).putArg(j).putArg(n3).rewind();
                    n7 = n * n2 / 2;
                    cLCommandQueue.put1DRangeKernel(cLKernel3, 0L, (long)n7, 0L);
                }
            }
        }
    }

    private void printSnapshot(IntBuffer intBuffer, int n) {
        for (int i = 0; i < n; ++i) {
            System.out.print(intBuffer.get() + ", ");
        }
        System.out.println("...; " + intBuffer.remaining() + " more");
        intBuffer.rewind();
    }

    private void checkIfSorted(IntBuffer intBuffer) {
        for (int i = 1; i < intBuffer.capacity(); ++i) {
            if (intBuffer.get(i - 1) <= intBuffer.get(i)) continue;
            throw new RuntimeException("not sorted " + intBuffer.get(i - 1) + "!> " + intBuffer.get(i));
        }
    }

    public static void main(String[] stringArray) throws IOException {
        new BitonicSort();
    }
}

