/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl.demos.fft;

import com.jogamp.opencl.CLBuffer;
import com.jogamp.opencl.CLCommandQueue;
import com.jogamp.opencl.CLContext;
import com.jogamp.opencl.CLDevice;
import com.jogamp.opencl.CLKernel;
import com.jogamp.opencl.CLMemory;
import com.jogamp.opencl.CLPlatform;
import com.jogamp.opencl.CLProgram;
import com.jogamp.opencl.demos.fft.CLFFTPlan;
import com.jogamp.opencl.demos.fft.ImageView;
import com.jogamp.opencl.demos.fft.PaintView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import javax.imageio.ImageIO;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BlurTest
implements Runnable,
ChangeListener,
ActionListener {
    boolean demo = false;
    int width = 512;
    int height = 512;
    BufferedImage src;
    BufferedImage psf;
    BufferedImage dst;
    PaintView left;
    ImageView right;
    JSlider sizex;
    JSlider sizey;
    JSlider angle;
    JToggleButton blurButton;
    JToggleButton drawButton;
    Runnable later;
    CLContext cl;
    CLCommandQueue q;
    CLProgram prog;
    CLKernel kImg2Planes;
    CLKernel kPlanes2Img;
    CLKernel kGrey2Plane;
    CLKernel kConvolve;
    CLKernel kDeconvolve;
    CLFFTPlan fft;
    CLBuffer<IntBuffer> argbBuffer;
    CLBuffer<ByteBuffer> greyBuffer;
    CLBuffer<FloatBuffer> aBuffer;
    CLBuffer<FloatBuffer> rBuffer;
    CLBuffer<FloatBuffer> gBuffer;
    CLBuffer<FloatBuffer> bBuffer;
    CLBuffer<FloatBuffer> aCBuffer;
    CLBuffer<FloatBuffer> rCBuffer;
    CLBuffer<FloatBuffer> gCBuffer;
    CLBuffer<FloatBuffer> bCBuffer;
    CLBuffer<FloatBuffer> aGBuffer;
    CLBuffer<FloatBuffer> rGBuffer;
    CLBuffer<FloatBuffer> gGBuffer;
    CLBuffer<FloatBuffer> bGBuffer;
    CLBuffer<FloatBuffer> psfBuffer;
    CLBuffer<FloatBuffer> tmpBuffer;
    CLKernel fft512;
    final String img2Planes = "kernel void img2planes(global const uchar4 *argb, int soff, int sstride,  global float2 *a, global float2 *r, global float2 *g, global float2 *b, int doff, int dstride) { int gx = get_global_id(0); int gy = get_global_id(1); uchar4 v = argb[soff+sstride*gy+gx]; float4 ff = convert_float4(v) * (float4)(1.0f/255); doff += (dstride * gy + gx); b[doff] = (float2){ ff.s0, 0 };\n g[doff] = (float2){ ff.s1, 0 }; r[doff] = (float2){ ff.s2, 0 }; a[doff] = (float2){ ff.s3, 0 };\n}\n\n";
    final String grey2Plane = "kernel void grey2plane(global const uchar *src, int soff, int sstride,  global float2 *dst, int doff, int dstride) { int gx = get_global_id(0); int gy = get_global_id(1); uchar v = src[soff+sstride*gy+gx]; float ff = convert_float(v) * (1.0f/255); gx ^= get_global_size(0)>>1; gy ^= get_global_size(1)>>1; doff += (dstride * gy + gx); dst[doff] = (float2) { ff, 0 };}\n\n";
    final String planes2Img = "kernel void planes2img(global uchar4 *argb, int soff, int sstride, const global float2 *a, const global float2 *r, const global float2 *g, const global float2 *b, int doff, int dstride, float scale) { int gx = get_global_id(0); int gy = get_global_id(1); float4 fr, fi, fa; float2 t; doff += (dstride * gy + gx); float2 s = (float2)scale; t = b[doff]*s; fr.s0 = t.s0; fi.s0 = t.s1; t = g[doff]*s; fr.s1 = t.s0; fi.s1 = t.s1; t = r[doff]*s; fr.s2 = t.s0; fi.s2 = t.s1; t = a[doff]*s; fr.s3 = t.s0; fi.s3 = t.s1; fa = sqrt(fr*fr + fi*fi) * 255; fa = clamp(fa, 0.0f, 255.0f); argb[soff +sstride*gy+gx] = convert_uchar4(fa);}\n\n";
    final String convolve = "kernel void convolve(global const float2 *h, global const float2 *ff, global float2 *g, int stride) { int gx = get_global_id(0); int gy = get_global_id(1); int off = stride * gy + gx; float2 a = h[off]; float2 b = ff[off]; g[off] = (float2) { a.s0 * b.s0 - a.s1 * b.s1, a.s0 * b.s1 + a.s1 * b.s0 };}\n\n";
    final String deconvolve = "kernel void deconvolve(global const float2 *h, global const float2 *ff, global float2 *g, int stride, float k) { int gx = get_global_id(0); int gy = get_global_id(1); int off = stride * gy + gx; float2 a = h[off]; float2 b = ff[off]; float d = b.s0 * b.s0 + b.s1 * b.s1 + k; b.s0 /= d; b.s1 /= -d; g[off] = (float2) { a.s0 * b.s0 - a.s1 * b.s1, a.s0 * b.s1 + a.s1 * b.s0 };}\n\n";

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new BlurTest());
    }

    @Override
    public void run() {
        Object object;
        try {
            this.initCL();
        }
        catch (Exception exception) {
            System.out.println("failed to init cl");
            exception.printStackTrace();
            System.exit(1);
        }
        JFileChooser jFileChooser = new JFileChooser();
        BufferedImage bufferedImage = null;
        while (bufferedImage == null) {
            try {
                object = null;
                jFileChooser.setDialogTitle("Select Image File");
                jFileChooser.setPreferredSize(new Dimension(500, 600));
                if (jFileChooser.showOpenDialog(null) == 0) {
                    object = jFileChooser.getSelectedFile();
                } else {
                    System.exit(0);
                }
                if ((bufferedImage = ImageIO.read((File)object)) != null) continue;
                JOptionPane.showMessageDialog(null, "Couldn't load file");
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(null, "Couldn't load file");
            }
        }
        this.src = new BufferedImage(this.width, this.height, 2);
        this.dst = new BufferedImage(this.width, this.height, 1);
        this.psf = new BufferedImage(this.width, this.height, 10);
        object = this.src.createGraphics();
        ((Graphics)object).drawImage(bufferedImage, (this.width - bufferedImage.getWidth()) / 2, (this.height - bufferedImage.getHeight()) / 2, null);
        ((Graphics)object).dispose();
        JFrame jFrame = new JFrame("Blur Demo");
        jFrame.setDefaultCloseOperation(3);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.ipadx = 3;
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        jPanel2.add((Component)new JLabel("Width"), gridBagConstraints);
        jPanel2.add((Component)new JLabel("Height"), gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = (GridBagConstraints)gridBagConstraints.clone();
        gridBagConstraints2.gridx = 2;
        jPanel2.add((Component)new JLabel("Angle"), gridBagConstraints2);
        gridBagConstraints = (GridBagConstraints)gridBagConstraints.clone();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.sizex = new JSlider(100, 5000, 1000);
        this.sizey = new JSlider(100, 5000, 100);
        jPanel2.add((Component)this.sizex, gridBagConstraints);
        jPanel2.add((Component)this.sizey, gridBagConstraints);
        gridBagConstraints2 = (GridBagConstraints)gridBagConstraints.clone();
        gridBagConstraints2.gridx = 3;
        this.angle = new JSlider(0, 3141);
        jPanel2.add((Component)this.angle, gridBagConstraints2);
        this.sizex.addChangeListener(this);
        this.sizey.addChangeListener(this);
        this.angle.addChangeListener(this);
        JPanel jPanel3 = new JPanel();
        jPanel2.add((Component)jPanel3, gridBagConstraints2);
        JButton jButton = new JButton("Clear");
        jPanel3.add(jButton);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BlurTest.this.doclear();
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        this.blurButton = new JToggleButton("Blur");
        buttonGroup.add(this.blurButton);
        jPanel3.add(this.blurButton);
        this.blurButton.addActionListener(this);
        this.drawButton = new JToggleButton("Draw");
        buttonGroup.add(this.drawButton);
        jPanel3.add(this.drawButton);
        this.drawButton.addActionListener(this);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        this.left = new PaintView(this, this.psf);
        this.right = new ImageView(this.dst);
        jPanel4.add(this.left);
        jPanel4.add(this.right);
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)jPanel4, "Center");
        jFrame.getContentPane().add(jPanel);
        jFrame.pack();
        jFrame.setVisible(true);
        this.loadSource(this.src);
        this.blurButton.doClick();
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (this.drawButton.isSelected()) {
            this.recalc();
        } else {
            double d = (double)this.sizex.getValue() / 100.0;
            double d2 = (double)this.sizey.getValue() / 100.0;
            double d3 = (double)this.angle.getValue() / 1000.0;
            Graphics2D graphics2D = this.psf.createGraphics();
            graphics2D.clearRect(0, 0, this.width, this.height);
            graphics2D.dispose();
            this.left.drawDot(d, d2, d3);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.stateChanged(null);
    }

    private void doclear() {
        Graphics2D graphics2D = this.psf.createGraphics();
        graphics2D.clearRect(0, 0, this.width, this.height);
        graphics2D.dispose();
        this.left.repaint();
        this.recalc();
    }

    private void dorecalc() {
        this.loadPSF(this.psf);
        this.convolve(this.aCBuffer, this.psfBuffer, this.aGBuffer);
        this.convolve(this.rCBuffer, this.psfBuffer, this.rGBuffer);
        this.convolve(this.gCBuffer, this.psfBuffer, this.gGBuffer);
        this.convolve(this.bCBuffer, this.psfBuffer, this.bGBuffer);
        this.fft.executeInterleaved(this.q, 1, CLFFTPlan.CLFFTDirection.Inverse, this.aGBuffer, this.aBuffer, null, null);
        this.fft.executeInterleaved(this.q, 1, CLFFTPlan.CLFFTDirection.Inverse, this.rGBuffer, this.rBuffer, null, null);
        this.fft.executeInterleaved(this.q, 1, CLFFTPlan.CLFFTDirection.Inverse, this.gGBuffer, this.gBuffer, null, null);
        this.fft.executeInterleaved(this.q, 1, CLFFTPlan.CLFFTDirection.Inverse, this.bGBuffer, this.bBuffer, null, null);
        long l = 0L;
        DataBufferByte dataBufferByte = (DataBufferByte)this.psf.getRaster().getDataBuffer();
        byte[] byArray = dataBufferByte.getData();
        for (int i = 0; i < byArray.length; ++i) {
            l += (long)(byArray[i] & 0xFF);
        }
        float f = 255.0f / (float)l / (float)this.width / (float)this.height;
        this.getDestination(this.argbBuffer, this.aBuffer, this.rBuffer, this.gBuffer, this.bBuffer, f);
        this.q.putReadBuffer(this.argbBuffer, true);
        DataBufferInt dataBufferInt = (DataBufferInt)this.dst.getRaster().getDataBuffer();
        ((IntBuffer)this.argbBuffer.getBuffer()).position(0);
        ((IntBuffer)this.argbBuffer.getBuffer()).get(dataBufferInt.getData());
        ((IntBuffer)this.argbBuffer.getBuffer()).position(0);
        this.right.repaint();
    }

    void recalc() {
        if (this.later == null) {
            this.later = new Runnable(){

                @Override
                public void run() {
                    BlurTest.this.later = null;
                    BlurTest.this.dorecalc();
                }
            };
            SwingUtilities.invokeLater(this.later);
        }
    }

    void initCL() throws CLFFTPlan.InvalidContextException {
        CLPlatform[] cLPlatformArray = CLPlatform.listCLPlatforms();
        CLDevice cLDevice = null;
        for (CLPlatform cLPlatform : cLPlatformArray) {
            cLDevice = cLPlatform.getMaxFlopsDevice(new CLDevice.Type[]{CLDevice.Type.GPU});
            if (cLDevice != null) break;
        }
        this.cl = CLContext.create((CLDevice[])new CLDevice[]{cLDevice});
        this.q = this.cl.getDevices()[0].createCommandQueue();
        this.prog = this.cl.createProgram("kernel void img2planes(global const uchar4 *argb, int soff, int sstride,  global float2 *a, global float2 *r, global float2 *g, global float2 *b, int doff, int dstride) { int gx = get_global_id(0); int gy = get_global_id(1); uchar4 v = argb[soff+sstride*gy+gx]; float4 ff = convert_float4(v) * (float4)(1.0f/255); doff += (dstride * gy + gx); b[doff] = (float2){ ff.s0, 0 };\n g[doff] = (float2){ ff.s1, 0 }; r[doff] = (float2){ ff.s2, 0 }; a[doff] = (float2){ ff.s3, 0 };\n}\n\nkernel void planes2img(global uchar4 *argb, int soff, int sstride, const global float2 *a, const global float2 *r, const global float2 *g, const global float2 *b, int doff, int dstride, float scale) { int gx = get_global_id(0); int gy = get_global_id(1); float4 fr, fi, fa; float2 t; doff += (dstride * gy + gx); float2 s = (float2)scale; t = b[doff]*s; fr.s0 = t.s0; fi.s0 = t.s1; t = g[doff]*s; fr.s1 = t.s0; fi.s1 = t.s1; t = r[doff]*s; fr.s2 = t.s0; fi.s2 = t.s1; t = a[doff]*s; fr.s3 = t.s0; fi.s3 = t.s1; fa = sqrt(fr*fr + fi*fi) * 255; fa = clamp(fa, 0.0f, 255.0f); argb[soff +sstride*gy+gx] = convert_uchar4(fa);}\n\nkernel void convolve(global const float2 *h, global const float2 *ff, global float2 *g, int stride) { int gx = get_global_id(0); int gy = get_global_id(1); int off = stride * gy + gx; float2 a = h[off]; float2 b = ff[off]; g[off] = (float2) { a.s0 * b.s0 - a.s1 * b.s1, a.s0 * b.s1 + a.s1 * b.s0 };}\n\nkernel void grey2plane(global const uchar *src, int soff, int sstride,  global float2 *dst, int doff, int dstride) { int gx = get_global_id(0); int gy = get_global_id(1); uchar v = src[soff+sstride*gy+gx]; float ff = convert_float(v) * (1.0f/255); gx ^= get_global_size(0)>>1; gy ^= get_global_size(1)>>1; doff += (dstride * gy + gx); dst[doff] = (float2) { ff, 0 };}\n\nkernel void deconvolve(global const float2 *h, global const float2 *ff, global float2 *g, int stride, float k) { int gx = get_global_id(0); int gy = get_global_id(1); int off = stride * gy + gx; float2 a = h[off]; float2 b = ff[off]; float d = b.s0 * b.s0 + b.s1 * b.s1 + k; b.s0 /= d; b.s1 /= -d; g[off] = (float2) { a.s0 * b.s0 - a.s1 * b.s1, a.s0 * b.s1 + a.s1 * b.s0 };}\n\n");
        this.prog.build("-cl-mad-enable");
        this.kImg2Planes = this.prog.createCLKernel("img2planes");
        this.kPlanes2Img = this.prog.createCLKernel("planes2img");
        this.kGrey2Plane = this.prog.createCLKernel("grey2plane");
        this.kConvolve = this.prog.createCLKernel("convolve");
        this.kDeconvolve = this.prog.createCLKernel("deconvolve");
        this.argbBuffer = this.cl.createIntBuffer(this.width * this.height, new CLMemory.Mem[]{CLMemory.Mem.READ_WRITE});
        this.greyBuffer = this.cl.createByteBuffer(this.width * this.height, new CLMemory.Mem[]{CLMemory.Mem.READ_WRITE});
        this.aBuffer = this.cl.createFloatBuffer(this.width * this.height * 2, new CLMemory.Mem[]{CLMemory.Mem.READ_WRITE});
        this.rBuffer = this.cl.createFloatBuffer(this.width * this.height * 2, new CLMemory.Mem[]{CLMemory.Mem.READ_WRITE});
        this.gBuffer = this.cl.createFloatBuffer(this.width * this.height * 2, new CLMemory.Mem[]{CLMemory.Mem.READ_WRITE});
        this.bBuffer = this.cl.createFloatBuffer(this.width * this.height * 2, new CLMemory.Mem[]{CLMemory.Mem.READ_WRITE});
        this.psfBuffer = this.cl.createFloatBuffer(this.width * this.height * 2, new CLMemory.Mem[]{CLMemory.Mem.READ_WRITE});
        this.tmpBuffer = this.cl.createFloatBuffer(this.width * this.height * 2, new CLMemory.Mem[]{CLMemory.Mem.READ_WRITE});
        this.aCBuffer = this.cl.createFloatBuffer(this.width * this.height * 2, new CLMemory.Mem[]{CLMemory.Mem.READ_WRITE});
        this.rCBuffer = this.cl.createFloatBuffer(this.width * this.height * 2, new CLMemory.Mem[]{CLMemory.Mem.READ_WRITE});
        this.gCBuffer = this.cl.createFloatBuffer(this.width * this.height * 2, new CLMemory.Mem[]{CLMemory.Mem.READ_WRITE});
        this.bCBuffer = this.cl.createFloatBuffer(this.width * this.height * 2, new CLMemory.Mem[]{CLMemory.Mem.READ_WRITE});
        this.aGBuffer = this.cl.createFloatBuffer(this.width * this.height * 2, new CLMemory.Mem[]{CLMemory.Mem.READ_WRITE});
        this.rGBuffer = this.cl.createFloatBuffer(this.width * this.height * 2, new CLMemory.Mem[]{CLMemory.Mem.READ_WRITE});
        this.gGBuffer = this.cl.createFloatBuffer(this.width * this.height * 2, new CLMemory.Mem[]{CLMemory.Mem.READ_WRITE});
        this.bGBuffer = this.cl.createFloatBuffer(this.width * this.height * 2, new CLMemory.Mem[]{CLMemory.Mem.READ_WRITE});
        this.fft = new CLFFTPlan(this.cl, new int[]{this.width, this.height}, CLFFTPlan.CLFFTDataFormat.InterleavedComplexFormat);
    }

    void loadSource(BufferedImage bufferedImage) {
        DataBufferInt dataBufferInt = (DataBufferInt)bufferedImage.getRaster().getDataBuffer();
        ((IntBuffer)this.argbBuffer.getBuffer()).position(0);
        ((IntBuffer)this.argbBuffer.getBuffer()).put(dataBufferInt.getData());
        ((IntBuffer)this.argbBuffer.getBuffer()).position(0);
        this.q.putWriteBuffer(this.argbBuffer, false);
        this.kImg2Planes.setArg(0, this.argbBuffer);
        this.kImg2Planes.setArg(1, 0);
        this.kImg2Planes.setArg(2, this.width);
        this.kImg2Planes.setArg(3, this.aBuffer);
        this.kImg2Planes.setArg(4, this.rBuffer);
        this.kImg2Planes.setArg(5, this.gBuffer);
        this.kImg2Planes.setArg(6, this.bBuffer);
        this.kImg2Planes.setArg(7, 0);
        this.kImg2Planes.setArg(8, this.width);
        this.q.put2DRangeKernel(this.kImg2Planes, 0L, 0L, (long)this.width, (long)this.height, 64L, 1L);
        this.q.finish();
        this.fft.executeInterleaved(this.q, 1, CLFFTPlan.CLFFTDirection.Forward, this.aBuffer, this.aCBuffer, null, null);
        this.fft.executeInterleaved(this.q, 1, CLFFTPlan.CLFFTDirection.Forward, this.rBuffer, this.rCBuffer, null, null);
        this.fft.executeInterleaved(this.q, 1, CLFFTPlan.CLFFTDirection.Forward, this.gBuffer, this.gCBuffer, null, null);
        this.fft.executeInterleaved(this.q, 1, CLFFTPlan.CLFFTDirection.Forward, this.bBuffer, this.bCBuffer, null, null);
    }

    void loadPSF(BufferedImage bufferedImage) {
        assert (bufferedImage.getType() == 10);
        DataBufferByte dataBufferByte = (DataBufferByte)bufferedImage.getRaster().getDataBuffer();
        ((ByteBuffer)this.greyBuffer.getBuffer()).position(0);
        ((ByteBuffer)this.greyBuffer.getBuffer()).put(dataBufferByte.getData());
        ((ByteBuffer)this.greyBuffer.getBuffer()).position(0);
        this.q.putWriteBuffer(this.greyBuffer, false);
        this.kGrey2Plane.setArg(0, this.greyBuffer);
        this.kGrey2Plane.setArg(1, 0);
        this.kGrey2Plane.setArg(2, this.width);
        this.kGrey2Plane.setArg(3, this.tmpBuffer);
        this.kGrey2Plane.setArg(4, 0);
        this.kGrey2Plane.setArg(5, this.width);
        this.q.put2DRangeKernel(this.kGrey2Plane, 0L, 0L, (long)this.width, (long)this.height, 64L, 1L);
        this.fft.executeInterleaved(this.q, 1, CLFFTPlan.CLFFTDirection.Forward, this.tmpBuffer, this.psfBuffer, null, null);
    }

    void convolve(CLBuffer<FloatBuffer> cLBuffer, CLBuffer<FloatBuffer> cLBuffer2, CLBuffer<FloatBuffer> cLBuffer3) {
        this.kConvolve.setArg(0, cLBuffer);
        this.kConvolve.setArg(1, cLBuffer2);
        this.kConvolve.setArg(2, cLBuffer3);
        this.kConvolve.setArg(3, this.width);
        this.q.put2DRangeKernel(this.kConvolve, 0L, 0L, (long)this.width, (long)this.height, 64L, 1L);
    }

    void deconvolve(CLBuffer<FloatBuffer> cLBuffer, CLBuffer<FloatBuffer> cLBuffer2, CLBuffer<FloatBuffer> cLBuffer3, float f) {
        this.kDeconvolve.setArg(0, cLBuffer);
        this.kDeconvolve.setArg(1, cLBuffer2);
        this.kDeconvolve.setArg(2, cLBuffer3);
        this.kDeconvolve.setArg(3, this.width);
        this.kDeconvolve.setArg(4, f);
        this.q.put2DRangeKernel(this.kDeconvolve, 0L, 0L, (long)this.width, (long)this.height, 64L, 1L);
    }

    void getDestination(CLBuffer<IntBuffer> cLBuffer, CLBuffer<FloatBuffer> cLBuffer2, CLBuffer<FloatBuffer> cLBuffer3, CLBuffer<FloatBuffer> cLBuffer4, CLBuffer<FloatBuffer> cLBuffer5, float f) {
        this.kPlanes2Img.setArg(0, cLBuffer);
        this.kPlanes2Img.setArg(1, 0);
        this.kPlanes2Img.setArg(2, this.width);
        this.kPlanes2Img.setArg(3, cLBuffer2);
        this.kPlanes2Img.setArg(4, cLBuffer3);
        this.kPlanes2Img.setArg(5, cLBuffer4);
        this.kPlanes2Img.setArg(6, cLBuffer5);
        this.kPlanes2Img.setArg(7, 0);
        this.kPlanes2Img.setArg(8, this.width);
        this.kPlanes2Img.setArg(9, f);
        this.q.put2DRangeKernel(this.kPlanes2Img, 0L, 0L, (long)this.width, (long)this.height, 64L, 1L);
    }
}

