/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl.demos.fft;

import com.jogamp.opencl.CLBuffer;
import com.jogamp.opencl.CLCommandQueue;
import com.jogamp.opencl.CLContext;
import com.jogamp.opencl.CLDevice;
import com.jogamp.opencl.CLEventList;
import com.jogamp.opencl.CLKernel;
import com.jogamp.opencl.CLMemory;
import com.jogamp.opencl.CLProgram;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.FloatBuffer;
import java.util.LinkedList;

public class CLFFTPlan {
    CLContext context;
    CLFFTDim3 size;
    int dim;
    CLFFTDataFormat format;
    StringBuilder kernel_string;
    CLProgram program;
    LinkedList<CLFFTKernelInfo> kernel_list;
    CLKernel twist_kernel;
    boolean temp_buffer_needed;
    int last_batch_size;
    CLMemory<FloatBuffer> tempmemobj;
    CLMemory<FloatBuffer> tempmemobj_real;
    CLMemory<FloatBuffer> tempmemobj_imag;
    int max_localmem_fft_size;
    int max_work_item_per_workgroup;
    int max_radix;
    int min_mem_coalesce_width;
    int num_local_mem_banks;
    static String baseKernels = "#ifndef M_PI\n#define M_PI 0x1.921fb54442d18p+1\n#endif\n#define complexMul(a,b) ((float2)(mad(-(a).y, (b).y, (a).x * (b).x), mad((a).y, (b).x, (a).x * (b).y)))\n#define conj(a) ((float2)((a).x, -(a).y))\n#define conjTransp(a) ((float2)(-(a).y, (a).x))\n\n#define fftKernel2(a,dir) \\\n{ \\\n    float2 c = (a)[0];    \\\n    (a)[0] = c + (a)[1];  \\\n    (a)[1] = c - (a)[1];  \\\n}\n\n#define fftKernel2S(d1,d2,dir) \\\n{ \\\n    float2 c = (d1);   \\\n    (d1) = c + (d2);   \\\n    (d2) = c - (d2);   \\\n}\n\n#define fftKernel4(a,dir) \\\n{ \\\n    fftKernel2S((a)[0], (a)[2], dir); \\\n    fftKernel2S((a)[1], (a)[3], dir); \\\n    fftKernel2S((a)[0], (a)[1], dir); \\\n    (a)[3] = (float2)(dir)*(conjTransp((a)[3])); \\\n    fftKernel2S((a)[2], (a)[3], dir); \\\n    float2 c = (a)[1]; \\\n    (a)[1] = (a)[2]; \\\n    (a)[2] = c; \\\n}\n\n#define fftKernel4s(a0,a1,a2,a3,dir) \\\n{ \\\n    fftKernel2S((a0), (a2), dir); \\\n    fftKernel2S((a1), (a3), dir); \\\n    fftKernel2S((a0), (a1), dir); \\\n    (a3) = (float2)(dir)*(conjTransp((a3))); \\\n    fftKernel2S((a2), (a3), dir); \\\n    float2 c = (a1); \\\n    (a1) = (a2); \\\n    (a2) = c; \\\n}\n\n#define bitreverse8(a) \\\n{ \\\n    float2 c; \\\n    c = (a)[1]; \\\n    (a)[1] = (a)[4]; \\\n    (a)[4] = c; \\\n    c = (a)[3]; \\\n    (a)[3] = (a)[6]; \\\n    (a)[6] = c; \\\n}\n\n#define fftKernel8(a,dir) \\\n{ \\\n\tconst float2 w1  = (float2)(0x1.6a09e6p-1f,  dir*0x1.6a09e6p-1f);  \\\n\tconst float2 w3  = (float2)(-0x1.6a09e6p-1f, dir*0x1.6a09e6p-1f);  \\\n\tfloat2 c; \\\n\tfftKernel2S((a)[0], (a)[4], dir); \\\n\tfftKernel2S((a)[1], (a)[5], dir); \\\n\tfftKernel2S((a)[2], (a)[6], dir); \\\n\tfftKernel2S((a)[3], (a)[7], dir); \\\n\t(a)[5] = complexMul(w1, (a)[5]); \\\n\t(a)[6] = (float2)(dir)*(conjTransp((a)[6])); \\\n\t(a)[7] = complexMul(w3, (a)[7]); \\\n\tfftKernel2S((a)[0], (a)[2], dir); \\\n\tfftKernel2S((a)[1], (a)[3], dir); \\\n\tfftKernel2S((a)[4], (a)[6], dir); \\\n\tfftKernel2S((a)[5], (a)[7], dir); \\\n\t(a)[3] = (float2)(dir)*(conjTransp((a)[3])); \\\n\t(a)[7] = (float2)(dir)*(conjTransp((a)[7])); \\\n\tfftKernel2S((a)[0], (a)[1], dir); \\\n\tfftKernel2S((a)[2], (a)[3], dir); \\\n\tfftKernel2S((a)[4], (a)[5], dir); \\\n\tfftKernel2S((a)[6], (a)[7], dir); \\\n\tbitreverse8((a)); \\\n}\n\n#define bitreverse4x4(a) \\\n{ \\\n\tfloat2 c; \\\n\tc = (a)[1];  (a)[1]  = (a)[4];  (a)[4]  = c; \\\n\tc = (a)[2];  (a)[2]  = (a)[8];  (a)[8]  = c; \\\n\tc = (a)[3];  (a)[3]  = (a)[12]; (a)[12] = c; \\\n\tc = (a)[6];  (a)[6]  = (a)[9];  (a)[9]  = c; \\\n\tc = (a)[7];  (a)[7]  = (a)[13]; (a)[13] = c; \\\n\tc = (a)[11]; (a)[11] = (a)[14]; (a)[14] = c; \\\n}\n\n#define fftKernel16(a,dir) \\\n{ \\\n    const float w0 = 0x1.d906bcp-1f; \\\n    const float w1 = 0x1.87de2ap-2f; \\\n    const float w2 = 0x1.6a09e6p-1f; \\\n    fftKernel4s((a)[0], (a)[4], (a)[8],  (a)[12], dir); \\\n    fftKernel4s((a)[1], (a)[5], (a)[9],  (a)[13], dir); \\\n    fftKernel4s((a)[2], (a)[6], (a)[10], (a)[14], dir); \\\n    fftKernel4s((a)[3], (a)[7], (a)[11], (a)[15], dir); \\\n    (a)[5]  = complexMul((a)[5], (float2)(w0, dir*w1)); \\\n    (a)[6]  = complexMul((a)[6], (float2)(w2, dir*w2)); \\\n    (a)[7]  = complexMul((a)[7], (float2)(w1, dir*w0)); \\\n    (a)[9]  = complexMul((a)[9], (float2)(w2, dir*w2)); \\\n    (a)[10] = (float2)(dir)*(conjTransp((a)[10])); \\\n    (a)[11] = complexMul((a)[11], (float2)(-w2, dir*w2)); \\\n    (a)[13] = complexMul((a)[13], (float2)(w1, dir*w0)); \\\n    (a)[14] = complexMul((a)[14], (float2)(-w2, dir*w2)); \\\n    (a)[15] = complexMul((a)[15], (float2)(-w0, dir*-w1)); \\\n    fftKernel4((a), dir); \\\n    fftKernel4((a) + 4, dir); \\\n    fftKernel4((a) + 8, dir); \\\n    fftKernel4((a) + 12, dir); \\\n    bitreverse4x4((a)); \\\n}\n\n#define bitreverse32(a) \\\n{ \\\n    float2 c1, c2; \\\n    c1 = (a)[2];   (a)[2] = (a)[1];   c2 = (a)[4];   (a)[4] = c1;   c1 = (a)[8];   (a)[8] = c2;    c2 = (a)[16];  (a)[16] = c1;   (a)[1] = c2; \\\n    c1 = (a)[6];   (a)[6] = (a)[3];   c2 = (a)[12];  (a)[12] = c1;  c1 = (a)[24];  (a)[24] = c2;   c2 = (a)[17];  (a)[17] = c1;   (a)[3] = c2; \\\n    c1 = (a)[10];  (a)[10] = (a)[5];  c2 = (a)[20];  (a)[20] = c1;  c1 = (a)[9];   (a)[9] = c2;    c2 = (a)[18];  (a)[18] = c1;   (a)[5] = c2; \\\n    c1 = (a)[14];  (a)[14] = (a)[7];  c2 = (a)[28];  (a)[28] = c1;  c1 = (a)[25];  (a)[25] = c2;   c2 = (a)[19];  (a)[19] = c1;   (a)[7] = c2; \\\n    c1 = (a)[22];  (a)[22] = (a)[11]; c2 = (a)[13];  (a)[13] = c1;  c1 = (a)[26];  (a)[26] = c2;   c2 = (a)[21];  (a)[21] = c1;   (a)[11] = c2; \\\n    c1 = (a)[30];  (a)[30] = (a)[15]; c2 = (a)[29];  (a)[29] = c1;  c1 = (a)[27];  (a)[27] = c2;   c2 = (a)[23];  (a)[23] = c1;   (a)[15] = c2; \\\n}\n\n#define fftKernel32(a,dir) \\\n{ \\\n    fftKernel2S((a)[0],  (a)[16], dir); \\\n    fftKernel2S((a)[1],  (a)[17], dir); \\\n    fftKernel2S((a)[2],  (a)[18], dir); \\\n    fftKernel2S((a)[3],  (a)[19], dir); \\\n    fftKernel2S((a)[4],  (a)[20], dir); \\\n    fftKernel2S((a)[5],  (a)[21], dir); \\\n    fftKernel2S((a)[6],  (a)[22], dir); \\\n    fftKernel2S((a)[7],  (a)[23], dir); \\\n    fftKernel2S((a)[8],  (a)[24], dir); \\\n    fftKernel2S((a)[9],  (a)[25], dir); \\\n    fftKernel2S((a)[10], (a)[26], dir); \\\n    fftKernel2S((a)[11], (a)[27], dir); \\\n    fftKernel2S((a)[12], (a)[28], dir); \\\n    fftKernel2S((a)[13], (a)[29], dir); \\\n    fftKernel2S((a)[14], (a)[30], dir); \\\n    fftKernel2S((a)[15], (a)[31], dir); \\\n    (a)[17] = complexMul((a)[17], (float2)(0x1.f6297cp-1f, dir*0x1.8f8b84p-3f)); \\\n    (a)[18] = complexMul((a)[18], (float2)(0x1.d906bcp-1f, dir*0x1.87de2ap-2f)); \\\n    (a)[19] = complexMul((a)[19], (float2)(0x1.a9b662p-1f, dir*0x1.1c73b4p-1f)); \\\n    (a)[20] = complexMul((a)[20], (float2)(0x1.6a09e6p-1f, dir*0x1.6a09e6p-1f)); \\\n    (a)[21] = complexMul((a)[21], (float2)(0x1.1c73b4p-1f, dir*0x1.a9b662p-1f)); \\\n    (a)[22] = complexMul((a)[22], (float2)(0x1.87de2ap-2f, dir*0x1.d906bcp-1f)); \\\n    (a)[23] = complexMul((a)[23], (float2)(0x1.8f8b84p-3f, dir*0x1.f6297cp-1f)); \\\n    (a)[24] = complexMul((a)[24], (float2)(0x0p+0f, dir*0x1p+0f)); \\\n    (a)[25] = complexMul((a)[25], (float2)(-0x1.8f8b84p-3f, dir*0x1.f6297cp-1f)); \\\n    (a)[26] = complexMul((a)[26], (float2)(-0x1.87de2ap-2f, dir*0x1.d906bcp-1f)); \\\n    (a)[27] = complexMul((a)[27], (float2)(-0x1.1c73b4p-1f, dir*0x1.a9b662p-1f)); \\\n    (a)[28] = complexMul((a)[28], (float2)(-0x1.6a09e6p-1f, dir*0x1.6a09e6p-1f)); \\\n    (a)[29] = complexMul((a)[29], (float2)(-0x1.a9b662p-1f, dir*0x1.1c73b4p-1f)); \\\n    (a)[30] = complexMul((a)[30], (float2)(-0x1.d906bcp-1f, dir*0x1.87de2ap-2f)); \\\n    (a)[31] = complexMul((a)[31], (float2)(-0x1.f6297cp-1f, dir*0x1.8f8b84p-3f)); \\\n    fftKernel16((a), dir); \\\n    fftKernel16((a) + 16, dir); \\\n    bitreverse32((a)); \\\n}\n\n";
    static String twistKernelInterleaved = "__kernel void \\\nclFFT_1DTwistInterleaved(__global float2 *in, unsigned int startRow, unsigned int numCols, unsigned int N, unsigned int numRowsToProcess, int dir) \\\n{ \\\n   float2 a, w; \\\n   float ang; \\\n   unsigned int j; \\\n\tunsigned int i = get_global_id(0); \\\n\tunsigned int startIndex = i; \\\n\t \\\n\tif(i < numCols) \\\n\t{ \\\n\t    for(j = 0; j < numRowsToProcess; j++) \\\n\t    { \\\n\t        a = in[startIndex]; \\\n\t        ang = 2.0f * M_PI * dir * i * (startRow + j) / N; \\\n\t        w = (float2)(native_cos(ang), native_sin(ang)); \\\n\t        a = complexMul(a, w); \\\n\t        in[startIndex] = a; \\\n\t        startIndex += numCols; \\\n\t    } \\\n\t}\t \\\n} \\\n";
    static String twistKernelPlannar = "__kernel void \\\nclFFT_1DTwistSplit(__global float *in_real, __global float *in_imag , unsigned int startRow, unsigned int numCols, unsigned int N, unsigned int numRowsToProcess, int dir) \\\n{ \\\n    float2 a, w; \\\n    float ang; \\\n    unsigned int j; \\\n\tunsigned int i = get_global_id(0); \\\n\tunsigned int startIndex = i; \\\n\t \\\n\tif(i < numCols) \\\n\t{ \\\n\t    for(j = 0; j < numRowsToProcess; j++) \\\n\t    { \\\n\t        a = (float2)(in_real[startIndex], in_imag[startIndex]); \\\n\t        ang = 2.0f * M_PI * dir * i * (startRow + j) / N; \\\n\t        w = (float2)(native_cos(ang), native_sin(ang)); \\\n\t        a = complexMul(a, w); \\\n\t        in_real[startIndex] = a.x; \\\n\t        in_imag[startIndex] = a.y; \\\n\t        startIndex += numCols; \\\n\t    } \\\n\t}\t \\\n} \\\n";

    public CLFFTPlan(CLContext cLContext, int[] nArray, CLFFTDataFormat cLFFTDataFormat) throws InvalidContextException {
        boolean bl = true;
        boolean bl2 = false;
        if (nArray.length < 1 || nArray.length > 3) {
            throw new IllegalArgumentException("Dimensions must be between 1 and 3");
        }
        this.size = new CLFFTDim3(nArray);
        bl |= this.size.x != 0 && (this.size.x - 1 & this.size.x) == 0;
        bl |= this.size.y != 0 && (this.size.y - 1 & this.size.y) == 0;
        if (!(bl |= this.size.z != 0 && (this.size.z - 1 & this.size.z) == 0)) {
            throw new IllegalArgumentException("Sizes must be power of two");
        }
        this.context = cLContext;
        this.dim = nArray.length;
        this.format = cLFFTDataFormat;
        this.temp_buffer_needed = false;
        this.last_batch_size = 0;
        this.max_localmem_fft_size = 2048;
        this.max_work_item_per_workgroup = 256;
        this.max_radix = 16;
        this.min_mem_coalesce_width = 16;
        this.num_local_mem_banks = 16;
        boolean bl3 = false;
        while (!bl3) {
            this.kernel_list = new LinkedList();
            this.kernel_string = new StringBuilder();
            this.getBlockConfigAndKernelString();
            this.program = cLContext.createProgram(this.kernel_string.toString());
            CLDevice[] cLDeviceArray = cLContext.getDevices();
            for (int i = 0; i < cLDeviceArray.length; ++i) {
                CLDevice cLDevice = cLDeviceArray[i];
                if (cLDevice.getType() != CLDevice.Type.GPU) continue;
                bl2 = true;
                this.program.build("-cl-mad-enable", new CLDevice[]{cLDevice});
            }
            if (!bl2) {
                throw new InvalidContextException();
            }
            this.createKernelList();
            if (this.getPatchingRequired(cLDeviceArray)) {
                this.max_work_item_per_workgroup = (int)this.getMaxKernelWorkGroupSize(cLDeviceArray);
                this.release();
                continue;
            }
            bl3 = true;
        }
    }

    public void release() {
        this.program.release();
    }

    void allocateTemporaryBufferInterleaved(int n) {
        if (this.temp_buffer_needed && this.last_batch_size != n) {
            this.last_batch_size = n;
            int n2 = this.size.x * this.size.y * this.size.z * n * 2 * 4;
            if (this.tempmemobj != null) {
                this.tempmemobj.release();
            }
            this.tempmemobj = this.context.createFloatBuffer(n2, new CLMemory.Mem[]{CLMemory.Mem.READ_WRITE});
        }
    }

    public void executeInterleaved(CLCommandQueue cLCommandQueue, int n, CLFFTDirection cLFFTDirection, CLBuffer<FloatBuffer> cLBuffer, CLBuffer<FloatBuffer> cLBuffer2, CLEventList cLEventList, CLEventList cLEventList2) {
        if (this.format != CLFFTDataFormat.InterleavedComplexFormat) {
            throw new IllegalArgumentException();
        }
        boolean bl = false;
        boolean bl2 = cLBuffer == cLBuffer2;
        this.allocateTemporaryBufferInterleaved(n);
        CLMemory[] cLMemoryArray = new CLMemory[]{cLBuffer, cLBuffer2, this.tempmemobj};
        int n2 = this.kernel_list.size();
        boolean bl3 = (n2 & 1) != 0;
        int n3 = 0;
        int n4 = 1;
        if (this.temp_buffer_needed) {
            if (bl2) {
                bl = false;
                n3 = 1;
                n4 = 2;
            } else {
                n4 = (n2 & 1) == 1 ? 1 : 2;
            }
            for (CLFFTKernelInfo cLFFTKernelInfo : this.kernel_list) {
                if (bl2 && bl3 && !bl && cLFFTKernelInfo.in_place_possible) {
                    n4 = n3;
                    bl = true;
                }
                int n5 = n;
                WorkDimensions workDimensions = this.getKernelWorkDimensions(cLFFTKernelInfo, n5);
                cLFFTKernelInfo.kernel.setArg(0, cLMemoryArray[n3]);
                cLFFTKernelInfo.kernel.setArg(1, cLMemoryArray[n4]);
                cLFFTKernelInfo.kernel.setArg(2, cLFFTDirection.value());
                cLFFTKernelInfo.kernel.setArg(3, workDimensions.batchSize);
                cLCommandQueue.put2DRangeKernel(cLFFTKernelInfo.kernel, 0L, 0L, workDimensions.gWorkItems, 1L, workDimensions.lWorkItems, 1L);
                n3 = n4 == 1 ? 1 : 2;
                n4 = n4 == 1 ? 2 : 1;
            }
        } else {
            for (CLFFTKernelInfo cLFFTKernelInfo : this.kernel_list) {
                int n6 = n;
                WorkDimensions workDimensions = this.getKernelWorkDimensions(cLFFTKernelInfo, n6);
                cLFFTKernelInfo.kernel.setArg(0, cLMemoryArray[n3]);
                cLFFTKernelInfo.kernel.setArg(1, cLMemoryArray[n4]);
                cLFFTKernelInfo.kernel.setArg(2, cLFFTDirection.value());
                cLFFTKernelInfo.kernel.setArg(3, workDimensions.batchSize);
                cLCommandQueue.put2DRangeKernel(cLFFTKernelInfo.kernel, 0L, 0L, workDimensions.gWorkItems, 1L, workDimensions.lWorkItems, 1L);
                n3 = 1;
                n4 = 1;
            }
        }
    }

    void allocateTemporaryBufferPlanar(int n) {
        if (this.temp_buffer_needed && this.last_batch_size != n) {
            this.last_batch_size = n;
            int n2 = this.size.x * this.size.y * this.size.z * n * 4;
            if (this.tempmemobj_real != null) {
                this.tempmemobj_real.release();
            }
            if (this.tempmemobj_imag != null) {
                this.tempmemobj_imag.release();
            }
            this.tempmemobj_real = this.context.createFloatBuffer(n2, new CLMemory.Mem[]{CLMemory.Mem.READ_WRITE});
            this.tempmemobj_imag = this.context.createFloatBuffer(n2, new CLMemory.Mem[]{CLMemory.Mem.READ_WRITE});
        }
    }

    public void executePlanar(CLCommandQueue cLCommandQueue, int n, CLFFTDirection cLFFTDirection, CLBuffer<FloatBuffer> cLBuffer, CLBuffer<FloatBuffer> cLBuffer2, CLBuffer<FloatBuffer> cLBuffer3, CLBuffer<FloatBuffer> cLBuffer4, CLEventList cLEventList, CLEventList cLEventList2) {
        if (this.format != CLFFTDataFormat.SplitComplexFormat) {
            throw new IllegalArgumentException();
        }
        boolean bl = false;
        boolean bl2 = cLBuffer == cLBuffer3 && cLBuffer2 == cLBuffer4;
        this.allocateTemporaryBufferPlanar(n);
        CLMemory[] cLMemoryArray = new CLMemory[3];
        CLMemory[] cLMemoryArray2 = new CLMemory[3];
        cLMemoryArray[0] = cLBuffer;
        cLMemoryArray[1] = cLBuffer3;
        cLMemoryArray[2] = this.tempmemobj_real;
        cLMemoryArray2[0] = cLBuffer2;
        cLMemoryArray2[1] = cLBuffer4;
        cLMemoryArray2[2] = this.tempmemobj_imag;
        int n2 = this.kernel_list.size();
        boolean bl3 = (n2 & 1) == 1;
        int n3 = 0;
        int n4 = 1;
        if (this.temp_buffer_needed) {
            if (bl2) {
                bl = false;
                n3 = 1;
                n4 = 2;
            } else {
                n4 = (n2 & 1) == 1 ? 1 : 2;
            }
            for (CLFFTKernelInfo cLFFTKernelInfo : this.kernel_list) {
                if (bl2 && bl3 && !bl && cLFFTKernelInfo.in_place_possible) {
                    n4 = n3;
                    bl = true;
                }
                int n5 = n;
                WorkDimensions workDimensions = this.getKernelWorkDimensions(cLFFTKernelInfo, n5);
                cLFFTKernelInfo.kernel.setArg(0, cLMemoryArray[n3]);
                cLFFTKernelInfo.kernel.setArg(1, cLMemoryArray2[n3]);
                cLFFTKernelInfo.kernel.setArg(2, cLMemoryArray[n4]);
                cLFFTKernelInfo.kernel.setArg(3, cLMemoryArray2[n4]);
                cLFFTKernelInfo.kernel.setArg(4, cLFFTDirection.value());
                cLFFTKernelInfo.kernel.setArg(5, workDimensions.batchSize);
                cLCommandQueue.put1DRangeKernel(cLFFTKernelInfo.kernel, 0L, workDimensions.gWorkItems, workDimensions.lWorkItems);
                n3 = n4 == 1 ? 1 : 2;
                n4 = n4 == 1 ? 2 : 1;
            }
        } else {
            for (CLFFTKernelInfo cLFFTKernelInfo : this.kernel_list) {
                int n6 = n;
                WorkDimensions workDimensions = this.getKernelWorkDimensions(cLFFTKernelInfo, n6);
                cLFFTKernelInfo.kernel.setArg(0, cLMemoryArray[n3]);
                cLFFTKernelInfo.kernel.setArg(1, cLMemoryArray2[n3]);
                cLFFTKernelInfo.kernel.setArg(2, cLMemoryArray[n4]);
                cLFFTKernelInfo.kernel.setArg(3, cLMemoryArray2[n4]);
                cLFFTKernelInfo.kernel.setArg(4, cLFFTDirection.value());
                cLFFTKernelInfo.kernel.setArg(5, workDimensions.batchSize);
                cLCommandQueue.put1DRangeKernel(cLFFTKernelInfo.kernel, 0L, workDimensions.gWorkItems, workDimensions.lWorkItems);
                n3 = 1;
                n4 = 1;
            }
        }
    }

    public void dumpPlan(OutputStream outputStream) {
        PrintStream printStream = outputStream == null ? System.out : new PrintStream(outputStream);
        for (CLFFTKernelInfo cLFFTKernelInfo : this.kernel_list) {
            int n = 1;
            WorkDimensions workDimensions = this.getKernelWorkDimensions(cLFFTKernelInfo, n);
            printStream.printf("Run kernel %s with global dim = {%d*BatchSize}, local dim={%d}\n", cLFFTKernelInfo.kernel_name, workDimensions.gWorkItems, workDimensions.lWorkItems);
        }
        printStream.printf("%s\n", this.kernel_string.toString());
        printStream.close();
    }

    WorkDimensions getKernelWorkDimensions(CLFFTKernelInfo cLFFTKernelInfo, int n) {
        int n2 = cLFFTKernelInfo.num_workitems_per_workgroup;
        int n3 = cLFFTKernelInfo.num_workgroups;
        int n4 = cLFFTKernelInfo.num_xforms_per_workgroup;
        switch (cLFFTKernelInfo.dir.ordinal()) {
            case 0: {
                n3 = (n *= this.size.y * this.size.z) % n4 != 0 ? n / n4 + 1 : n / n4;
                n3 *= cLFFTKernelInfo.num_workgroups;
                break;
            }
            case 1: {
                n3 *= (n *= this.size.z);
                break;
            }
            case 2: {
                n3 *= n;
            }
        }
        return new WorkDimensions(n, n3 * n2, n2);
    }

    private void getBlockConfigAndKernelString() {
        this.temp_buffer_needed = false;
        this.kernel_string.append(baseKernels);
        if (this.format == CLFFTDataFormat.SplitComplexFormat) {
            this.kernel_string.append(twistKernelPlannar);
        } else {
            this.kernel_string.append(twistKernelInterleaved);
        }
        switch (this.dim) {
            case 1: {
                this.FFT1D(CLFFTKernelDir.X);
                break;
            }
            case 2: {
                this.FFT1D(CLFFTKernelDir.X);
                this.FFT1D(CLFFTKernelDir.Y);
                break;
            }
            case 3: {
                this.FFT1D(CLFFTKernelDir.X);
                this.FFT1D(CLFFTKernelDir.Y);
                this.FFT1D(CLFFTKernelDir.Z);
                break;
            }
            default: {
                return;
            }
        }
        this.temp_buffer_needed = false;
        for (CLFFTKernelInfo cLFFTKernelInfo : this.kernel_list) {
            this.temp_buffer_needed |= !cLFFTKernelInfo.in_place_possible;
        }
    }

    private void createKernelList() {
        for (CLFFTKernelInfo cLFFTKernelInfo : this.kernel_list) {
            cLFFTKernelInfo.kernel = this.program.createCLKernel(cLFFTKernelInfo.kernel_name);
        }
        this.twist_kernel = this.format == CLFFTDataFormat.SplitComplexFormat ? this.program.createCLKernel("clFFT_1DTwistSplit") : this.program.createCLKernel("clFFT_1DTwistInterleaved");
    }

    private boolean getPatchingRequired(CLDevice[] cLDeviceArray) {
        for (int i = 0; i < cLDeviceArray.length; ++i) {
            for (CLFFTKernelInfo cLFFTKernelInfo : this.kernel_list) {
                if (cLFFTKernelInfo.kernel.getWorkGroupSize(cLDeviceArray[i]) >= (long)cLFFTKernelInfo.num_workitems_per_workgroup) continue;
                return true;
            }
        }
        return false;
    }

    long getMaxKernelWorkGroupSize(CLDevice[] cLDeviceArray) {
        long l = Integer.MAX_VALUE;
        for (int i = 0; i < cLDeviceArray.length; ++i) {
            for (CLFFTKernelInfo cLFFTKernelInfo : this.kernel_list) {
                long l2 = cLFFTKernelInfo.kernel.getWorkGroupSize(cLDeviceArray[i]);
                if (l <= l2) continue;
                l = l2;
            }
        }
        return l;
    }

    int log2(int n) {
        return 32 - Integer.numberOfLeadingZeros(n - 1);
    }

    int getRadixArray(int n, int[] nArray, int n2) {
        if (n2 > 1) {
            n2 = Math.min(n, n2);
            int n3 = 0;
            while (n > n2) {
                nArray[n3++] = n2;
                n /= n2;
            }
            nArray[n3++] = n;
            return n3;
        }
        switch (n) {
            case 2: {
                nArray[0] = 2;
                return 1;
            }
            case 4: {
                nArray[0] = 4;
                return 1;
            }
            case 8: {
                nArray[0] = 8;
                return 1;
            }
            case 16: {
                nArray[0] = 8;
                nArray[1] = 2;
                return 2;
            }
            case 32: {
                nArray[0] = 8;
                nArray[1] = 4;
                return 2;
            }
            case 64: {
                nArray[0] = 8;
                nArray[1] = 8;
                return 2;
            }
            case 128: {
                nArray[0] = 8;
                nArray[1] = 4;
                nArray[2] = 4;
                return 3;
            }
            case 256: {
                nArray[0] = 4;
                nArray[1] = 4;
                nArray[2] = 4;
                nArray[3] = 4;
                return 4;
            }
            case 512: {
                nArray[0] = 8;
                nArray[1] = 8;
                nArray[2] = 8;
                return 3;
            }
            case 1024: {
                nArray[0] = 16;
                nArray[1] = 16;
                nArray[2] = 4;
                return 3;
            }
            case 2048: {
                nArray[0] = 8;
                nArray[1] = 8;
                nArray[2] = 8;
                nArray[3] = 4;
                return 4;
            }
        }
        return 0;
    }

    void insertHeader(StringBuilder stringBuilder, String string, CLFFTDataFormat cLFFTDataFormat) {
        if (cLFFTDataFormat == CLFFTDataFormat.SplitComplexFormat) {
            stringBuilder.append("__kernel void ").append(string).append("(__global float *in_real, __global float *in_imag, __global float *out_real, __global float *out_imag, int dir, int S)\n");
        } else {
            stringBuilder.append("__kernel void ").append(string).append("(__global float2 *in, __global float2 *out, int dir, int S)\n");
        }
    }

    void insertVariables(StringBuilder stringBuilder, int n) {
        stringBuilder.append("    int i, j, r, indexIn, indexOut, index, tid, bNum, xNum, k, l;\n");
        stringBuilder.append("    int s, ii, jj, offset;\n");
        stringBuilder.append("    float2 w;\n");
        stringBuilder.append("    float ang, angf, ang1;\n");
        stringBuilder.append("    __local float *lMemStore, *lMemLoad;\n");
        stringBuilder.append("    float2 a[").append(n).append("];\n");
        stringBuilder.append("    int lId = get_local_id( 0 );\n");
        stringBuilder.append("    int groupId = get_group_id( 0 );\n");
    }

    void formattedLoad(StringBuilder stringBuilder, int n, int n2, CLFFTDataFormat cLFFTDataFormat) {
        if (cLFFTDataFormat == CLFFTDataFormat.InterleavedComplexFormat) {
            stringBuilder.append("        a[").append(n).append("] = in[").append(n2).append("];\n");
        } else {
            stringBuilder.append("        a[").append(n).append("].x = in_real[").append(n2).append("];\n");
            stringBuilder.append("        a[").append(n).append("].y = in_imag[").append(n2).append("];\n");
        }
    }

    void formattedStore(StringBuilder stringBuilder, int n, int n2, CLFFTDataFormat cLFFTDataFormat) {
        if (cLFFTDataFormat == CLFFTDataFormat.InterleavedComplexFormat) {
            stringBuilder.append("        out[").append(n2).append("] = a[").append(n).append("];\n");
        } else {
            stringBuilder.append("        out_real[").append(n2).append("] = a[").append(n).append("].x;\n");
            stringBuilder.append("        out_imag[").append(n2).append("] = a[").append(n).append("].y;\n");
        }
    }

    int insertGlobalLoadsAndTranspose(StringBuilder stringBuilder, int n, int n2, int n3, int n4, int n5, CLFFTDataFormat cLFFTDataFormat) {
        int n6 = this.log2(n2);
        int n7 = n2 * n3;
        int n8 = 0;
        if (n3 > 1) {
            stringBuilder.append("        s = S & ").append(n3 - 1).append(";\n");
        }
        if (n2 >= n5) {
            if (n3 > 1) {
                stringBuilder.append("    ii = lId & ").append(n2 - 1).append(";\n");
                stringBuilder.append("    jj = lId >> ").append(n6).append(";\n");
                stringBuilder.append("    if( !s || (groupId < get_num_groups(0)-1) || (jj < s) ) {\n");
                stringBuilder.append("        offset = mad24( mad24(groupId, ").append(n3).append(", jj), ").append(n).append(", ii );\n");
                if (cLFFTDataFormat == CLFFTDataFormat.InterleavedComplexFormat) {
                    stringBuilder.append("        in += offset;\n");
                    stringBuilder.append("        out += offset;\n");
                } else {
                    stringBuilder.append("        in_real += offset;\n");
                    stringBuilder.append("        in_imag += offset;\n");
                    stringBuilder.append("        out_real += offset;\n");
                    stringBuilder.append("        out_imag += offset;\n");
                }
                for (int i = 0; i < n4; ++i) {
                    this.formattedLoad(stringBuilder, i, i * n2, cLFFTDataFormat);
                }
                stringBuilder.append("    }\n");
            } else {
                stringBuilder.append("    ii = lId;\n");
                stringBuilder.append("    jj = 0;\n");
                stringBuilder.append("    offset =  mad24(groupId, ").append(n).append(", ii);\n");
                if (cLFFTDataFormat == CLFFTDataFormat.InterleavedComplexFormat) {
                    stringBuilder.append("        in += offset;\n");
                    stringBuilder.append("        out += offset;\n");
                } else {
                    stringBuilder.append("        in_real += offset;\n");
                    stringBuilder.append("        in_imag += offset;\n");
                    stringBuilder.append("        out_real += offset;\n");
                    stringBuilder.append("        out_imag += offset;\n");
                }
                for (int i = 0; i < n4; ++i) {
                    this.formattedLoad(stringBuilder, i, i * n2, cLFFTDataFormat);
                }
            }
        } else if (n >= n5) {
            int n9;
            int n10;
            int n11 = n / n5;
            int n12 = n3 / (n7 / n5);
            stringBuilder.append("    ii = lId & ").append(n5 - 1).append(";\n");
            stringBuilder.append("    jj = lId >> ").append(this.log2(n5)).append(";\n");
            stringBuilder.append("    lMemStore = sMem + mad24( jj, ").append(n + n2).append(", ii );\n");
            stringBuilder.append("    offset = mad24( groupId, ").append(n3).append(", jj);\n");
            stringBuilder.append("    offset = mad24( offset, ").append(n).append(", ii );\n");
            if (cLFFTDataFormat == CLFFTDataFormat.InterleavedComplexFormat) {
                stringBuilder.append("        in += offset;\n");
                stringBuilder.append("        out += offset;\n");
            } else {
                stringBuilder.append("        in_real += offset;\n");
                stringBuilder.append("        in_imag += offset;\n");
                stringBuilder.append("        out_real += offset;\n");
                stringBuilder.append("        out_imag += offset;\n");
            }
            stringBuilder.append("if((groupId == get_num_groups(0)-1) && s) {\n");
            for (n10 = 0; n10 < n12; ++n10) {
                stringBuilder.append("    if( jj < s ) {\n");
                for (n9 = 0; n9 < n11; ++n9) {
                    this.formattedLoad(stringBuilder, n10 * n11 + n9, n9 * n5 + n10 * (n7 / n5) * n, cLFFTDataFormat);
                }
                stringBuilder.append("    }\n");
                if (n10 == n12 - 1) continue;
                stringBuilder.append("    jj += ").append(n7 / n5).append(";\n");
            }
            stringBuilder.append("}\n ");
            stringBuilder.append("else {\n");
            for (n10 = 0; n10 < n12; ++n10) {
                for (n9 = 0; n9 < n11; ++n9) {
                    this.formattedLoad(stringBuilder, n10 * n11 + n9, n9 * n5 + n10 * (n7 / n5) * n, cLFFTDataFormat);
                }
            }
            stringBuilder.append("}\n");
            stringBuilder.append("    ii = lId & ").append(n2 - 1).append(";\n");
            stringBuilder.append("    jj = lId >> ").append(n6).append(";\n");
            stringBuilder.append("    lMemLoad  = sMem + mad24( jj, ").append(n + n2).append(", ii);\n");
            for (n10 = 0; n10 < n12; ++n10) {
                for (n9 = 0; n9 < n11; ++n9) {
                    stringBuilder.append("    lMemStore[").append(n9 * n5 + n10 * (n7 / n5) * (n + n2)).append("] = a[").append(n10 * n11 + n9).append("].x;\n");
                }
            }
            stringBuilder.append("    barrier( CLK_LOCAL_MEM_FENCE );\n");
            for (n10 = 0; n10 < n4; ++n10) {
                stringBuilder.append("    a[").append(n10).append("].x = lMemLoad[").append(n10 * n2).append("];\n");
            }
            stringBuilder.append("    barrier( CLK_LOCAL_MEM_FENCE );\n");
            for (n10 = 0; n10 < n12; ++n10) {
                for (n9 = 0; n9 < n11; ++n9) {
                    stringBuilder.append("    lMemStore[").append(n9 * n5 + n10 * (n7 / n5) * (n + n2)).append("] = a[").append(n10 * n11 + n9).append("].y;\n");
                }
            }
            stringBuilder.append("    barrier( CLK_LOCAL_MEM_FENCE );\n");
            for (n10 = 0; n10 < n4; ++n10) {
                stringBuilder.append("    a[").append(n10).append("].y = lMemLoad[").append(n10 * n2).append("];\n");
            }
            stringBuilder.append("    barrier( CLK_LOCAL_MEM_FENCE );\n");
            n8 = (n + n2) * n3;
        } else {
            int n13;
            stringBuilder.append("    offset = mad24( groupId,  ").append(n * n3).append(", lId );\n");
            if (cLFFTDataFormat == CLFFTDataFormat.InterleavedComplexFormat) {
                stringBuilder.append("        in += offset;\n");
                stringBuilder.append("        out += offset;\n");
            } else {
                stringBuilder.append("        in_real += offset;\n");
                stringBuilder.append("        in_imag += offset;\n");
                stringBuilder.append("        out_real += offset;\n");
                stringBuilder.append("        out_imag += offset;\n");
            }
            stringBuilder.append("    ii = lId & ").append(n - 1).append(";\n");
            stringBuilder.append("    jj = lId >> ").append(this.log2(n)).append(";\n");
            stringBuilder.append("    lMemStore = sMem + mad24( jj, ").append(n + n2).append(", ii );\n");
            stringBuilder.append("if((groupId == get_num_groups(0)-1) && s) {\n");
            for (n13 = 0; n13 < n4; ++n13) {
                stringBuilder.append("    if(jj < s )\n");
                this.formattedLoad(stringBuilder, n13, n13 * n7, cLFFTDataFormat);
                if (n13 == n4 - 1) continue;
                stringBuilder.append("    jj += ").append(n7 / n).append(";\n");
            }
            stringBuilder.append("}\n");
            stringBuilder.append("else {\n");
            for (n13 = 0; n13 < n4; ++n13) {
                this.formattedLoad(stringBuilder, n13, n13 * n7, cLFFTDataFormat);
            }
            stringBuilder.append("}\n");
            if (n2 > 1) {
                stringBuilder.append("    ii = lId & ").append(n2 - 1).append(";\n");
                stringBuilder.append("    jj = lId >> ").append(n6).append(";\n");
                stringBuilder.append("    lMemLoad = sMem + mad24( jj, ").append(n + n2).append(", ii );\n");
            } else {
                stringBuilder.append("    ii = 0;\n");
                stringBuilder.append("    jj = lId;\n");
                stringBuilder.append("    lMemLoad = sMem + mul24( jj, ").append(n + n2).append(");\n");
            }
            for (n13 = 0; n13 < n4; ++n13) {
                stringBuilder.append("    lMemStore[").append(n13 * (n7 / n) * (n + n2)).append("] = a[").append(n13).append("].x;\n");
            }
            stringBuilder.append("    barrier( CLK_LOCAL_MEM_FENCE );\n");
            for (n13 = 0; n13 < n4; ++n13) {
                stringBuilder.append("    a[").append(n13).append("].x = lMemLoad[").append(n13 * n2).append("];\n");
            }
            stringBuilder.append("    barrier( CLK_LOCAL_MEM_FENCE );\n");
            for (n13 = 0; n13 < n4; ++n13) {
                stringBuilder.append("    lMemStore[").append(n13 * (n7 / n) * (n + n2)).append("] = a[").append(n13).append("].y;\n");
            }
            stringBuilder.append("    barrier( CLK_LOCAL_MEM_FENCE );\n");
            for (n13 = 0; n13 < n4; ++n13) {
                stringBuilder.append("    a[").append(n13).append("].y = lMemLoad[").append(n13 * n2).append("];\n");
            }
            stringBuilder.append("    barrier( CLK_LOCAL_MEM_FENCE );\n");
            n8 = (n + n2) * n3;
        }
        return n8;
    }

    int insertGlobalStoresAndTranspose(StringBuilder stringBuilder, int n, int n2, int n3, int n4, int n5, int n6, CLFFTDataFormat cLFFTDataFormat) {
        int n7 = n4 * n5;
        int n8 = 0;
        int n9 = n2 / n3;
        if (n4 >= n6) {
            if (n5 > 1) {
                stringBuilder.append("    if( !s || (groupId < get_num_groups(0)-1) || (jj < s) ) {\n");
            }
            for (int i = 0; i < n2; ++i) {
                int n10 = i % n9;
                int n11 = i / n9;
                int n12 = n10 * n3 + n11;
                this.formattedStore(stringBuilder, n12, i * n4, cLFFTDataFormat);
            }
            if (n5 > 1) {
                stringBuilder.append("    }\n");
            }
        } else if (n >= n6) {
            int n13;
            int n14;
            int n15;
            int n16;
            int n17 = n / n6;
            int n18 = n5 / (n7 / n6);
            stringBuilder.append("    lMemLoad  = sMem + mad24( jj, ").append(n + n4).append(", ii );\n");
            stringBuilder.append("    ii = lId & ").append(n6 - 1).append(";\n");
            stringBuilder.append("    jj = lId >> ").append(this.log2(n6)).append(";\n");
            stringBuilder.append("    lMemStore = sMem + mad24( jj,").append(n + n4).append(", ii );\n");
            for (n16 = 0; n16 < n2; ++n16) {
                n15 = n16 % n9;
                n14 = n16 / n9;
                n13 = n15 * n3 + n14;
                stringBuilder.append("    lMemLoad[").append(n16 * n4).append("] = a[").append(n13).append("].x;\n");
            }
            stringBuilder.append("    barrier( CLK_LOCAL_MEM_FENCE );\n");
            for (n16 = 0; n16 < n18; ++n16) {
                for (n15 = 0; n15 < n17; ++n15) {
                    stringBuilder.append("    a[").append(n16 * n17 + n15).append("].x = lMemStore[").append(n15 * n6 + n16 * (n7 / n6) * (n + n4)).append("];\n");
                }
            }
            stringBuilder.append("    barrier( CLK_LOCAL_MEM_FENCE );\n");
            for (n16 = 0; n16 < n2; ++n16) {
                n15 = n16 % n9;
                n14 = n16 / n9;
                n13 = n15 * n3 + n14;
                stringBuilder.append("    lMemLoad[").append(n16 * n4).append("] = a[").append(n13).append("].y;\n");
            }
            stringBuilder.append("    barrier( CLK_LOCAL_MEM_FENCE );\n");
            for (n16 = 0; n16 < n18; ++n16) {
                for (n15 = 0; n15 < n17; ++n15) {
                    stringBuilder.append("    a[").append(n16 * n17 + n15).append("].y = lMemStore[").append(n15 * n6 + n16 * (n7 / n6) * (n + n4)).append("];\n");
                }
            }
            stringBuilder.append("    barrier( CLK_LOCAL_MEM_FENCE );\n");
            stringBuilder.append("if((groupId == get_num_groups(0)-1) && s) {\n");
            for (n16 = 0; n16 < n18; ++n16) {
                stringBuilder.append("    if( jj < s ) {\n");
                for (n15 = 0; n15 < n17; ++n15) {
                    this.formattedStore(stringBuilder, n16 * n17 + n15, n15 * n6 + n16 * (n7 / n6) * n, cLFFTDataFormat);
                }
                stringBuilder.append("    }\n");
                if (n16 == n18 - 1) continue;
                stringBuilder.append("    jj += ").append(n7 / n6).append(";\n");
            }
            stringBuilder.append("}\n");
            stringBuilder.append("else {\n");
            for (n16 = 0; n16 < n18; ++n16) {
                for (n15 = 0; n15 < n17; ++n15) {
                    this.formattedStore(stringBuilder, n16 * n17 + n15, n15 * n6 + n16 * (n7 / n6) * n, cLFFTDataFormat);
                }
            }
            stringBuilder.append("}\n");
            n8 = (n + n4) * n5;
        } else {
            int n19;
            int n20;
            int n21;
            int n22;
            stringBuilder.append("    lMemLoad  = sMem + mad24( jj,").append(n + n4).append(", ii );\n");
            stringBuilder.append("    ii = lId & ").append(n - 1).append(";\n");
            stringBuilder.append("    jj = lId >> ").append(this.log2(n)).append(";\n");
            stringBuilder.append("    lMemStore = sMem + mad24( jj,").append(n + n4).append(", ii );\n");
            for (n22 = 0; n22 < n2; ++n22) {
                n21 = n22 % n9;
                n20 = n22 / n9;
                n19 = n21 * n3 + n20;
                stringBuilder.append("    lMemLoad[").append(n22 * n4).append("] = a[").append(n19).append("].x;\n");
            }
            stringBuilder.append("    barrier( CLK_LOCAL_MEM_FENCE );\n");
            for (n22 = 0; n22 < n2; ++n22) {
                stringBuilder.append("    a[").append(n22).append("].x = lMemStore[").append(n22 * (n7 / n) * (n + n4)).append("];\n");
            }
            stringBuilder.append("    barrier( CLK_LOCAL_MEM_FENCE );\n");
            for (n22 = 0; n22 < n2; ++n22) {
                n21 = n22 % n9;
                n20 = n22 / n9;
                n19 = n21 * n3 + n20;
                stringBuilder.append("    lMemLoad[").append(n22 * n4).append("] = a[").append(n19).append("].y;\n");
            }
            stringBuilder.append("    barrier( CLK_LOCAL_MEM_FENCE );\n");
            for (n22 = 0; n22 < n2; ++n22) {
                stringBuilder.append("    a[").append(n22).append("].y = lMemStore[").append(n22 * (n7 / n) * (n + n4)).append("];\n");
            }
            stringBuilder.append("    barrier( CLK_LOCAL_MEM_FENCE );\n");
            stringBuilder.append("if((groupId == get_num_groups(0)-1) && s) {\n");
            for (n22 = 0; n22 < n2; ++n22) {
                stringBuilder.append("    if(jj < s ) {\n");
                this.formattedStore(stringBuilder, n22, n22 * n7, cLFFTDataFormat);
                stringBuilder.append("    }\n");
                if (n22 == n2 - 1) continue;
                stringBuilder.append("    jj +=").append(n7 / n).append(";\n");
            }
            stringBuilder.append("}\n");
            stringBuilder.append("else {\n");
            for (n22 = 0; n22 < n2; ++n22) {
                this.formattedStore(stringBuilder, n22, n22 * n7, cLFFTDataFormat);
            }
            stringBuilder.append("}\n");
            n8 = (n + n4) * n5;
        }
        return n8;
    }

    void insertfftKernel(StringBuilder stringBuilder, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            stringBuilder.append("    fftKernel").append(n).append("(a+").append(i * n).append(", dir);\n");
        }
    }

    void insertTwiddleKernel(StringBuilder stringBuilder, int n, int n2, int n3, int n4, int n5) {
        int n6 = this.log2(n3);
        for (int i = 0; i < n2; ++i) {
            if (i == 0) {
                if (n3 > 1) {
                    stringBuilder.append("    angf = (float) (ii >> ").append(n6).append(");\n");
                } else {
                    stringBuilder.append("    angf = (float) ii;\n");
                }
            } else if (n3 > 1) {
                stringBuilder.append("    angf = (float) ((").append(i * n5).append(" + ii) >>").append(n6).append(");\n");
            } else {
                stringBuilder.append("    angf = (float) (").append(i * n5).append(" + ii);\n");
            }
            for (int j = 1; j < n; ++j) {
                int n7 = i * n + j;
                stringBuilder.append("    ang = dir * ( 2.0f * M_PI * ").append(j).append(".0f / ").append(n4).append(".0f )").append(" * angf;\n");
                stringBuilder.append("    w = (float2)(native_cos(ang), native_sin(ang));\n");
                stringBuilder.append("    a[").append(n7).append("] = complexMul(a[").append(n7).append("], w);\n");
            }
        }
    }

    fftPadding getPadding(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        int n8;
        if (n <= n2 || n2 >= n6) {
            n8 = 0;
        } else {
            n7 = (n < n6 ? n : n6) / n2;
            int n9 = 1;
            if (n7 > n5) {
                n9 = n7 / n5;
            }
            n8 = n9 = n2 * n9;
        }
        int n10 = n >= n6 || n4 == 1 ? 0 : ((n7 = (n3 + n8) * n5 & n6 - 1) >= n ? 0 : n - n7);
        n7 = (n3 + n8) * n5 * n4 + n10 * (n4 - 1);
        return new fftPadding(n7, n8, n10);
    }

    void insertLocalStores(StringBuilder stringBuilder, int n, int n2, int n3, int n4, int n5, String string) {
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                int n6 = j * (n4 + n5) + i * n3;
                stringBuilder.append("    lMemStore[").append(n6).append("] = a[").append(i * n2 + j).append("].").append(string).append(";\n");
            }
        }
        stringBuilder.append("    barrier(CLK_LOCAL_MEM_FENCE);\n");
    }

    void insertLocalLoads(StringBuilder stringBuilder, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, String string) {
        int n9 = n / n3;
        int n10 = Math.max(n4 / n6, 1);
        int n11 = n6;
        int n12 = Math.max(n6 / n4, 1);
        n12 = Math.min(n12, n2);
        int n13 = n2 / n12;
        int n14 = (n / n2 + n8) * n12;
        int n15 = Math.max(n9 / n6, 1);
        int n16 = n6 / (n4 * n2) > 1 ? n6 / (n4 * n2) : 1;
        n16 *= n4;
        int n17 = n7 / n3;
        for (int i = 0; i < n15; ++i) {
            int n18 = i / (n10 * n13);
            int n19 = i % (n10 * n13);
            int n20 = n19 % n10;
            int n21 = n19 / n10;
            for (int j = 0; j < n3; ++j) {
                int n22 = n21 * n14 + n20 * n11 + n18 * n16 + j * n17;
                stringBuilder.append("    a[").append(i * n3 + j).append("].").append(string).append(" = lMemLoad[").append(n22).append("];\n");
            }
        }
        stringBuilder.append("    barrier(CLK_LOCAL_MEM_FENCE);\n");
    }

    void insertLocalLoadIndexArithmatic(StringBuilder stringBuilder, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n * n2;
        int n9 = this.log2(n8);
        int n10 = this.log2(n);
        int n11 = (n3 + n6) * n2 + n7;
        if (n8 < n4) {
            if (n == 1) {
                stringBuilder.append("    j = ii & ").append(n8 - 1).append(";\n");
            } else {
                stringBuilder.append("    j = (ii & ").append(n8 - 1).append(") >> ").append(n10).append(";\n");
            }
            if (n == 1) {
                stringBuilder.append("    i = ii >> ").append(n9).append(";\n");
            } else {
                stringBuilder.append("    i = mad24(ii >> ").append(n9).append(", ").append(n).append(", ii & ").append(n - 1).append(");\n");
            }
        } else {
            if (n == 1) {
                stringBuilder.append("    j = ii;\n");
            } else {
                stringBuilder.append("    j = ii >> ").append(n10).append(";\n");
            }
            if (n == 1) {
                stringBuilder.append("    i = 0;\n");
            } else {
                stringBuilder.append("    i = ii & ").append(n - 1).append(";\n");
            }
        }
        if (n5 > 1) {
            stringBuilder.append("    i = mad24(jj, ").append(n11).append(", i);\n");
        }
        stringBuilder.append("    lMemLoad = sMem + mad24(j, ").append(n3 + n6).append(", i);\n");
    }

    void insertLocalStoreIndexArithmatic(StringBuilder stringBuilder, int n, int n2, int n3, int n4, int n5) {
        if (n2 == 1) {
            stringBuilder.append("    lMemStore = sMem + ii;\n");
        } else {
            stringBuilder.append("    lMemStore = sMem + mad24(jj, ").append((n + n4) * n3 + n5).append(", ii);\n");
        }
    }

    void createLocalMemfftKernelString() {
        int n;
        int[] nArray = new int[10];
        int n2 = this.size.x;
        assert (n2 <= this.max_work_item_per_workgroup * this.max_radix);
        int n3 = this.getRadixArray(n2, nArray, 0);
        assert (n3 > 0);
        if (n2 / nArray[0] > this.max_work_item_per_workgroup) {
            n3 = this.getRadixArray(n2, nArray, this.max_radix);
        }
        assert (nArray[0] <= this.max_radix);
        assert (n2 / nArray[0] <= this.max_work_item_per_workgroup);
        int n4 = 1;
        for (int i = 0; i < n3; ++i) {
            assert (nArray[i] != 0 && !(nArray[i] - 1 != 0 & nArray[i] != 0));
            n4 *= nArray[i];
        }
        assert (n4 == n2);
        StringBuilder stringBuilder = new StringBuilder();
        CLFFTDataFormat cLFFTDataFormat = this.format;
        StringBuilder stringBuilder2 = this.kernel_string;
        int n5 = this.kernel_list.size();
        String string = "fft" + n5;
        CLFFTKernelInfo cLFFTKernelInfo = new CLFFTKernelInfo();
        this.kernel_list.add(cLFFTKernelInfo);
        cLFFTKernelInfo.dir = CLFFTKernelDir.X;
        cLFFTKernelInfo.in_place_possible = true;
        cLFFTKernelInfo.kernel_name = string;
        int n6 = n2 / nArray[0];
        int n7 = n = n6 <= 64 ? 64 : n6;
        assert (n <= this.max_work_item_per_workgroup);
        int n8 = n / n6;
        cLFFTKernelInfo.num_workgroups = 1;
        cLFFTKernelInfo.num_xforms_per_workgroup = n8;
        cLFFTKernelInfo.num_workitems_per_workgroup = n;
        int[] nArray2 = nArray;
        int n9 = nArray2[0];
        int n10 = 0;
        this.insertVariables(stringBuilder, n9);
        n10 = this.insertGlobalLoadsAndTranspose(stringBuilder, n2, n6, n8, n9, this.min_mem_coalesce_width, cLFFTDataFormat);
        cLFFTKernelInfo.lmem_size = n10 > cLFFTKernelInfo.lmem_size ? n10 : cLFFTKernelInfo.lmem_size;
        String string2 = "x";
        String string3 = "y";
        int n11 = 1;
        int n12 = n2;
        for (int i = 0; i < n3; ++i) {
            int n13 = nArray2[0] / nArray2[i];
            int n14 = n2 / nArray2[i];
            int n15 = n11 * nArray2[i];
            this.insertfftKernel(stringBuilder, nArray2[i], n13);
            if (i >= n3 - 1) continue;
            this.insertTwiddleKernel(stringBuilder, nArray2[i], n13, n11, n12, n6);
            fftPadding fftPadding2 = this.getPadding(n6, n11, n14, n8, nArray2[i], this.num_local_mem_banks);
            cLFFTKernelInfo.lmem_size = fftPadding2.lMemSize > cLFFTKernelInfo.lmem_size ? fftPadding2.lMemSize : cLFFTKernelInfo.lmem_size;
            this.insertLocalStoreIndexArithmatic(stringBuilder, n14, n8, nArray2[i], fftPadding2.offset, fftPadding2.midPad);
            this.insertLocalLoadIndexArithmatic(stringBuilder, n11, nArray2[i], n14, n6, n8, fftPadding2.offset, fftPadding2.midPad);
            this.insertLocalStores(stringBuilder, n13, nArray2[i], n6, n14, fftPadding2.offset, string2);
            this.insertLocalLoads(stringBuilder, n2, nArray2[i], nArray2[i + 1], n11, n15, n6, n14, fftPadding2.offset, string2);
            this.insertLocalStores(stringBuilder, n13, nArray2[i], n6, n14, fftPadding2.offset, string3);
            this.insertLocalLoads(stringBuilder, n2, nArray2[i], nArray2[i + 1], n11, n15, n6, n14, fftPadding2.offset, string3);
            n11 = n15;
            n12 /= nArray2[i];
        }
        n10 = this.insertGlobalStoresAndTranspose(stringBuilder, n2, n9, nArray2[n3 - 1], n6, n8, this.min_mem_coalesce_width, cLFFTDataFormat);
        cLFFTKernelInfo.lmem_size = n10 > cLFFTKernelInfo.lmem_size ? n10 : cLFFTKernelInfo.lmem_size;
        this.insertHeader(stringBuilder2, string, cLFFTDataFormat);
        stringBuilder2.append("{\n");
        if (cLFFTKernelInfo.lmem_size > 0) {
            stringBuilder2.append("    __local float sMem[").append(cLFFTKernelInfo.lmem_size).append("];\n");
        }
        stringBuilder2.append((CharSequence)stringBuilder);
        stringBuilder2.append("}\n");
    }

    int getGlobalRadixInfo(int n, int[] nArray, int[] nArray2, int[] nArray3) {
        int n2;
        int n3 = Math.min(n, 128);
        int n4 = 0;
        int n5 = n;
        while (n5 > n3) {
            n5 /= n3;
            ++n4;
        }
        for (n2 = 0; n2 < n4; ++n2) {
            nArray[n2] = n3;
        }
        nArray[n4] = n5;
        ++n4;
        for (n2 = 0; n2 < n4; ++n2) {
            int n6 = nArray[n2];
            if (n6 <= 8) {
                nArray2[n2] = n6;
                nArray3[n2] = 1;
                continue;
            }
            int n7 = 2;
            int n8 = n6 / n7;
            while (n8 > n7) {
                n8 = n6 / (n7 *= 2);
            }
            nArray2[n2] = n7;
            nArray3[n2] = n8;
        }
        return n4;
    }

    void createGlobalFFTKernelString(int n, int n2, CLFFTKernelDir cLFFTKernelDir, int n3) {
        int n4;
        int[] nArray = new int[10];
        int[] nArray2 = new int[10];
        int[] nArray3 = new int[10];
        int n5 = this.max_work_item_per_workgroup;
        int n6 = this.max_radix;
        int n7 = this.min_mem_coalesce_width;
        CLFFTDataFormat cLFFTDataFormat = this.format;
        boolean bl = cLFFTKernelDir != CLFFTKernelDir.X;
        int n8 = n4 = this.getGlobalRadixInfo(n, nArray, nArray2, nArray3);
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = this.kernel_string;
        int n9 = this.kernel_list.size();
        int n10 = n;
        int n11 = this.log2(n);
        int n12 = bl ? n2 : 1;
        n7 = bl ? Math.min(n2, n7) : n7;
        for (int i = 0; i < n8; ++i) {
            int n13;
            int n14;
            int n15;
            int n16;
            int n17;
            int n18;
            int n19;
            stringBuilder.setLength(0);
            int n20 = nArray[i];
            int n21 = nArray2[i];
            int n22 = nArray3[i];
            int n23 = n12;
            for (n19 = 0; n19 < n8; ++n19) {
                if (n19 == i) continue;
                n23 *= nArray[n19];
            }
            int n24 = n12;
            for (n19 = 0; n19 < i; ++n19) {
                n24 *= nArray[n19];
            }
            int n25 = n22;
            n7 = n22 == 1 ? this.max_work_item_per_workgroup : n7;
            n7 = Math.min(n7, n23);
            int n26 = n7 * n25;
            n26 = Math.min(n26, n5);
            n7 = n26 / n25;
            assert (n22 <= n21);
            assert (n21 * n22 == n20);
            assert (n21 <= n6);
            assert (n26 <= n5);
            int n27 = n21 / n22;
            int n28 = n26 / n7;
            int n29 = this.log2(n24);
            int n30 = n18 = n23 / n7;
            n30 = !bl ? (n30 *= n2) : (n30 *= n3);
            String string = "fft" + n9;
            CLFFTKernelInfo cLFFTKernelInfo = new CLFFTKernelInfo();
            cLFFTKernelInfo.lmem_size = n22 == 1 ? 0 : (n24 == 1 ? (n20 + 1) * n7 : n26 * n21);
            cLFFTKernelInfo.num_workgroups = n30;
            cLFFTKernelInfo.num_xforms_per_workgroup = 1;
            cLFFTKernelInfo.num_workitems_per_workgroup = n26;
            cLFFTKernelInfo.dir = cLFFTKernelDir;
            cLFFTKernelInfo.in_place_possible = i == n8 - 1 && (n8 & 1) != 0;
            cLFFTKernelInfo.kernel_name = string;
            this.insertVariables(stringBuilder, n21);
            if (bl) {
                stringBuilder.append("xNum = groupId >> ").append(this.log2(n18)).append(";\n");
                stringBuilder.append("groupId = groupId & ").append(n18 - 1).append(";\n");
                stringBuilder.append("indexIn = mad24(groupId, ").append(n7).append(", xNum << ").append(this.log2(n * n2)).append(");\n");
                stringBuilder.append("tid = mul24(groupId, ").append(n7).append(");\n");
                stringBuilder.append("i = tid >> ").append(n29).append(";\n");
                stringBuilder.append("j = tid & ").append(n24 - 1).append(";\n");
                n17 = n20 * n12;
                for (n19 = 0; n19 < i; ++n19) {
                    n17 *= nArray[n19];
                }
                stringBuilder.append("indexOut = mad24(i, ").append(n17).append(", j + ").append("(xNum << ").append(this.log2(n * n2)).append("));\n");
                stringBuilder.append("bNum = groupId;\n");
            } else {
                n17 = this.log2(n18);
                stringBuilder.append("bNum = groupId & ").append(n18 - 1).append(";\n");
                stringBuilder.append("xNum = groupId >> ").append(n17).append(";\n");
                stringBuilder.append("indexIn = mul24(bNum, ").append(n7).append(");\n");
                stringBuilder.append("tid = indexIn;\n");
                stringBuilder.append("i = tid >> ").append(n29).append(";\n");
                stringBuilder.append("j = tid & ").append(n24 - 1).append(";\n");
                n16 = n20 * n12;
                for (n19 = 0; n19 < i; ++n19) {
                    n16 *= nArray[n19];
                }
                stringBuilder.append("indexOut = mad24(i, ").append(n16).append(", j);\n");
                stringBuilder.append("indexIn += (xNum << ").append(n11).append(");\n");
                stringBuilder.append("indexOut += (xNum << ").append(n11).append(");\n");
            }
            n17 = this.log2(n7);
            stringBuilder.append("tid = lId;\n");
            stringBuilder.append("i = tid & ").append(n7 - 1).append(";\n");
            stringBuilder.append("j = tid >> ").append(n17).append(";\n");
            stringBuilder.append("indexIn += mad24(j, ").append(n23).append(", i);\n");
            if (cLFFTDataFormat == CLFFTDataFormat.SplitComplexFormat) {
                stringBuilder.append("in_real += indexIn;\n");
                stringBuilder.append("in_imag += indexIn;\n");
                for (n15 = 0; n15 < n21; ++n15) {
                    stringBuilder.append("a[").append(n15).append("].x = in_real[").append(n15 * n28 * n23).append("];\n");
                }
                for (n15 = 0; n15 < n21; ++n15) {
                    stringBuilder.append("a[").append(n15).append("].y = in_imag[").append(n15 * n28 * n23).append("];\n");
                }
            } else {
                stringBuilder.append("in += indexIn;\n");
                for (n15 = 0; n15 < n21; ++n15) {
                    stringBuilder.append("a[").append(n15).append("] = in[").append(n15 * n28 * n23).append("];\n");
                }
            }
            stringBuilder.append("fftKernel").append(n21).append("(a, dir);\n");
            if (n22 > 1) {
                for (n14 = 1; n14 < n21; ++n14) {
                    stringBuilder.append("ang = dir*(2.0f*M_PI*").append(n14).append("/").append(n20).append(")*j;\n");
                    stringBuilder.append("w = (float2)(native_cos(ang), native_sin(ang));\n");
                    stringBuilder.append("a[").append(n14).append("] = complexMul(a[").append(n14).append("], w);\n");
                }
                n27 = n21 / n22;
                stringBuilder.append("indexIn = mad24(j, ").append(n26 * n27).append(", i);\n");
                stringBuilder.append("lMemStore = sMem + tid;\n");
                stringBuilder.append("lMemLoad = sMem + indexIn;\n");
                for (n14 = 0; n14 < n21; ++n14) {
                    stringBuilder.append("lMemStore[").append(n14 * n26).append("] = a[").append(n14).append("].x;\n");
                }
                stringBuilder.append("barrier(CLK_LOCAL_MEM_FENCE);\n");
                for (n14 = 0; n14 < n27; ++n14) {
                    for (n13 = 0; n13 < n22; ++n13) {
                        stringBuilder.append("a[").append(n14 * n22 + n13).append("].x = lMemLoad[").append(n13 * n7 + n14 * n26).append("];\n");
                    }
                }
                stringBuilder.append("barrier(CLK_LOCAL_MEM_FENCE);\n");
                for (n14 = 0; n14 < n21; ++n14) {
                    stringBuilder.append("lMemStore[").append(n14 * n26).append("] = a[").append(n14).append("].y;\n");
                }
                stringBuilder.append("barrier(CLK_LOCAL_MEM_FENCE);\n");
                for (n14 = 0; n14 < n27; ++n14) {
                    for (n13 = 0; n13 < n22; ++n13) {
                        stringBuilder.append("a[").append(n14 * n22 + n13).append("].y = lMemLoad[").append(n13 * n7 + n14 * n26).append("];\n");
                    }
                }
                stringBuilder.append("barrier(CLK_LOCAL_MEM_FENCE);\n");
                for (n15 = 0; n15 < n27; ++n15) {
                    stringBuilder.append("fftKernel").append(n22).append("(a + ").append(n15 * n22).append(", dir);\n");
                }
            }
            if (i < n8 - 1) {
                stringBuilder.append("l = ((bNum << ").append(n17).append(") + i) >> ").append(n29).append(";\n");
                stringBuilder.append("k = j << ").append(this.log2(n21 / n22)).append(";\n");
                stringBuilder.append("ang1 = dir*(2.0f*M_PI/").append(n10).append(")*l;\n");
                for (n13 = 0; n13 < n21; ++n13) {
                    stringBuilder.append("ang = ang1*(k + ").append(n13 % n22 * n21 + n13 / n22).append(");\n");
                    stringBuilder.append("w = (float2)(native_cos(ang), native_sin(ang));\n");
                    stringBuilder.append("a[").append(n13).append("] = complexMul(a[").append(n13).append("], w);\n");
                }
            }
            if (n24 == 1) {
                int n31;
                stringBuilder.append("lMemStore = sMem + mad24(i, ").append(n20 + 1).append(", j << ").append(this.log2(n21 / n22)).append(");\n");
                stringBuilder.append("lMemLoad = sMem + mad24(tid >> ").append(this.log2(n20)).append(", ").append(n20 + 1).append(", tid & ").append(n20 - 1).append(");\n");
                for (n19 = 0; n19 < n21 / n22; ++n19) {
                    for (n15 = 0; n15 < n22; ++n15) {
                        stringBuilder.append("lMemStore[ ").append(n19 + n15 * n21).append("] = a[").append(n19 * n22 + n15).append("].x;\n");
                    }
                }
                stringBuilder.append("barrier(CLK_LOCAL_MEM_FENCE);\n");
                if (n26 >= n20) {
                    for (n19 = 0; n19 < n21; ++n19) {
                        stringBuilder.append("a[").append(n19).append("].x = lMemLoad[").append(n19 * (n20 + 1) * (n26 / n20)).append("];\n");
                    }
                } else {
                    n16 = n20 / n26;
                    n31 = n21 / n16;
                    for (n19 = 0; n19 < n31; ++n19) {
                        for (n15 = 0; n15 < n16; ++n15) {
                            stringBuilder.append("a[").append(n19 * n16 + n15).append("].x = lMemLoad[").append(n15 * n26 + n19 * (n20 + 1)).append("];\n");
                        }
                    }
                }
                stringBuilder.append("barrier(CLK_LOCAL_MEM_FENCE);\n");
                for (n19 = 0; n19 < n21 / n22; ++n19) {
                    for (n15 = 0; n15 < n22; ++n15) {
                        stringBuilder.append("lMemStore[ ").append(n19 + n15 * n21).append("] = a[").append(n19 * n22 + n15).append("].y;\n");
                    }
                }
                stringBuilder.append("barrier(CLK_LOCAL_MEM_FENCE);\n");
                if (n26 >= n20) {
                    for (n19 = 0; n19 < n21; ++n19) {
                        stringBuilder.append("a[").append(n19).append("].y = lMemLoad[").append(n19 * (n20 + 1) * (n26 / n20)).append("];\n");
                    }
                } else {
                    n16 = n20 / n26;
                    n31 = n21 / n16;
                    for (n19 = 0; n19 < n31; ++n19) {
                        for (n15 = 0; n15 < n16; ++n15) {
                            stringBuilder.append("a[").append(n19 * n16 + n15).append("].y = lMemLoad[").append(n15 * n26 + n19 * (n20 + 1)).append("];\n");
                        }
                    }
                }
                stringBuilder.append("barrier(CLK_LOCAL_MEM_FENCE);\n");
                stringBuilder.append("indexOut += tid;\n");
                if (cLFFTDataFormat == CLFFTDataFormat.SplitComplexFormat) {
                    stringBuilder.append("out_real += indexOut;\n");
                    stringBuilder.append("out_imag += indexOut;\n");
                    for (n14 = 0; n14 < n21; ++n14) {
                        stringBuilder.append("out_real[").append(n14 * n26).append("] = a[").append(n14).append("].x;\n");
                    }
                    for (n14 = 0; n14 < n21; ++n14) {
                        stringBuilder.append("out_imag[").append(n14 * n26).append("] = a[").append(n14).append("].y;\n");
                    }
                } else {
                    stringBuilder.append("out += indexOut;\n");
                    for (n14 = 0; n14 < n21; ++n14) {
                        stringBuilder.append("out[").append(n14 * n26).append("] = a[").append(n14).append("];\n");
                    }
                }
            } else {
                stringBuilder.append("indexOut += mad24(j, ").append(n27 * n24).append(", i);\n");
                if (cLFFTDataFormat == CLFFTDataFormat.SplitComplexFormat) {
                    stringBuilder.append("out_real += indexOut;\n");
                    stringBuilder.append("out_imag += indexOut;\n");
                    for (n14 = 0; n14 < n21; ++n14) {
                        stringBuilder.append("out_real[").append((n14 % n22 * n21 + n14 / n22) * n24).append("] = a[").append(n14).append("].x;\n");
                    }
                    for (n14 = 0; n14 < n21; ++n14) {
                        stringBuilder.append("out_imag[").append((n14 % n22 * n21 + n14 / n22) * n24).append("] = a[").append(n14).append("].y;\n");
                    }
                } else {
                    stringBuilder.append("out += indexOut;\n");
                    for (n14 = 0; n14 < n21; ++n14) {
                        stringBuilder.append("out[").append((n14 % n22 * n21 + n14 / n22) * n24).append("] = a[").append(n14).append("];\n");
                    }
                }
            }
            this.insertHeader(stringBuilder2, string, cLFFTDataFormat);
            stringBuilder2.append("{\n");
            if (cLFFTKernelInfo.lmem_size > 0) {
                stringBuilder2.append("    __local float sMem[").append(cLFFTKernelInfo.lmem_size).append("];\n");
            }
            stringBuilder2.append((CharSequence)stringBuilder);
            stringBuilder2.append("}\n");
            n10 /= n20;
            this.kernel_list.add(cLFFTKernelInfo);
            ++n9;
        }
    }

    void FFT1D(CLFFTKernelDir cLFFTKernelDir) {
        int[] nArray = new int[10];
        switch (cLFFTKernelDir.ordinal()) {
            case 0: {
                if (this.size.x > this.max_localmem_fft_size) {
                    this.createGlobalFFTKernelString(this.size.x, 1, cLFFTKernelDir, 1);
                    break;
                }
                if (this.size.x <= 1) break;
                this.getRadixArray(this.size.x, nArray, 0);
                if (this.size.x / nArray[0] <= this.max_work_item_per_workgroup) {
                    this.createLocalMemfftKernelString();
                    break;
                }
                this.getRadixArray(this.size.x, nArray, this.max_radix);
                if (this.size.x / nArray[0] <= this.max_work_item_per_workgroup) {
                    this.createLocalMemfftKernelString();
                    break;
                }
                this.createGlobalFFTKernelString(this.size.x, 1, cLFFTKernelDir, 1);
                break;
            }
            case 1: {
                if (this.size.y <= 1) break;
                this.createGlobalFFTKernelString(this.size.y, this.size.x, cLFFTKernelDir, 1);
                break;
            }
            case 2: {
                if (this.size.z <= 1) break;
                this.createGlobalFFTKernelString(this.size.z, this.size.x * this.size.y, cLFFTKernelDir, 1);
                break;
            }
            default: {
                return;
            }
        }
    }

    private class CLFFTDim3 {
        int x;
        int y;
        int z;

        CLFFTDim3(int[] nArray) {
            this.x = nArray[0];
            this.y = nArray.length > 1 ? nArray[1] : 1;
            this.z = nArray.length > 2 ? nArray[2] : 1;
        }
    }

    public static enum CLFFTDataFormat {
        SplitComplexFormat,
        InterleavedComplexFormat;

    }

    public class InvalidContextException
    extends Exception {
    }

    class CLFFTKernelInfo {
        CLKernel kernel;
        String kernel_name;
        int lmem_size;
        int num_workgroups;
        int num_xforms_per_workgroup;
        int num_workitems_per_workgroup;
        CLFFTKernelDir dir;
        boolean in_place_possible;

        CLFFTKernelInfo() {
        }
    }

    private class WorkDimensions {
        int batchSize;
        long gWorkItems;
        long lWorkItems;

        public WorkDimensions(int n, long l, long l2) {
            this.batchSize = n;
            this.gWorkItems = l;
            this.lWorkItems = l2;
        }
    }

    public static enum CLFFTDirection {
        Forward{

            @Override
            int value() {
                return -1;
            }
        }
        ,
        Inverse{

            @Override
            int value() {
                return 1;
            }
        };


        abstract int value();
    }

    static enum CLFFTKernelDir {
        X,
        Y,
        Z;

    }

    private class fftPadding {
        int lMemSize;
        int offset;
        int midPad;

        public fftPadding(int n, int n2, int n3) {
            this.lMemSize = n;
            this.offset = n2;
            this.midPad = n3;
        }
    }
}

