/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl.demos.fft;

import com.jogamp.opencl.demos.fft.BlurTest;
import com.jogamp.opencl.demos.fft.ImageView;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;

class PaintView
extends ImageView
implements MouseListener,
MouseMotionListener {
    Graphics2D imgg;
    Paint paint;
    Shape brush;
    BlurTest win;

    public PaintView(BlurTest blurTest, BufferedImage bufferedImage) {
        super(bufferedImage);
        this.win = blurTest;
        this.paint = new RadialGradientPaint(new Point2D.Float(0.0f, 0.0f), 3.0f, new float[]{0.0f, 1.0f}, new Color[]{new Color(255, 255, 255, 255), new Color(255, 255, 255, 0)});
        this.brush = new Ellipse2D.Float(-5.0f, -5.0f, 11.0f, 11.0f);
        this.imgg = bufferedImage.createGraphics();
        this.addMouseListener(this);
    }

    void drawPaint(double d, double d2) {
        Graphics2D graphics2D = (Graphics2D)this.imgg.create();
        graphics2D.translate(d, d2);
        graphics2D.setPaint(this.paint);
        graphics2D.fill(this.brush);
        graphics2D.dispose();
        this.repaint(new Rectangle((int)(d - 6.0), (int)(d2 - 6.0), 12, 12));
        this.win.recalc();
    }

    public void drawDot(double d, double d2, double d3) {
        Graphics2D graphics2D = (Graphics2D)this.imgg.create();
        graphics2D.setPaint(this.paint);
        graphics2D.translate(this.img.getWidth() / 2, this.img.getHeight() / 2);
        graphics2D.rotate(d3);
        graphics2D.scale(d, d2);
        graphics2D.fill(this.brush);
        graphics2D.dispose();
        this.repaint();
        this.win.recalc();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1) {
            this.addMouseMotionListener(this);
            this.drawPaint(mouseEvent.getX(), mouseEvent.getY());
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1) {
            this.removeMouseMotionListener(this);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.drawPaint(mouseEvent.getX(), mouseEvent.getY());
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }
}

