/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl.demos.fractal;

import com.jogamp.opencl.CLBuffer;
import com.jogamp.opencl.CLCommandQueue;
import com.jogamp.opencl.CLDevice;
import com.jogamp.opencl.CLEvent;
import com.jogamp.opencl.CLEventList;
import com.jogamp.opencl.CLException;
import com.jogamp.opencl.CLKernel;
import com.jogamp.opencl.CLMemory;
import com.jogamp.opencl.CLPlatform;
import com.jogamp.opencl.CLProgram;
import com.jogamp.opencl.gl.CLGLBuffer;
import com.jogamp.opencl.gl.CLGLContext;
import com.jogamp.opencl.gl.CLGLObject;
import com.jogamp.opencl.util.CLProgramConfiguration;
import com.jogamp.opengl.DebugGL2;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.util.awt.TextRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public class MultiDeviceFractal
implements GLEventListener {
    private static final int MAX_PARRALLELISM_LEVEL = 8;
    private static final int MAX_ITERATIONS = 500;
    private final GLCanvas canvas;
    private CLGLContext clContext;
    private CLCommandQueue[] queues;
    private CLKernel[] kernels;
    private CLProgram[] programs;
    private CLEventList probes;
    private ArrayList<CLGLBuffer<?>> pboBuffers;
    private ArrayList<CLBuffer<IntBuffer>> colorMap;
    private int width = 0;
    private int height = 0;
    private double minX = -2.0;
    private double minY = -1.2f;
    private double maxX = 0.6f;
    private double maxY = 1.3f;
    private int slices;
    private boolean drawSeperator;
    private boolean doublePrecision;
    private boolean buffersInitialized;
    private boolean rebuild;
    private final TextRenderer textRenderer;

    public MultiDeviceFractal(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.canvas = new GLCanvas((GLCapabilitiesImmutable)new GLCapabilities(GLProfile.get((String)"GL2")));
        this.canvas.addGLEventListener((GLEventListener)this);
        this.initSceneInteraction();
        Frame frame = new Frame("JOCL Multi Device Mandelbrot Set");
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                MultiDeviceFractal.this.release(windowEvent.getWindow());
            }
        });
        this.canvas.setPreferredSize(new Dimension(n, n2));
        frame.add((Component)this.canvas);
        frame.pack();
        frame.setVisible(true);
        this.textRenderer = new TextRenderer(frame.getFont().deriveFont(1, 14.0f), true, true, null, false);
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        if (this.clContext == null) {
            gLAutoDrawable.setGL((GL)new DebugGL2(gLAutoDrawable.getGL().getGL2()));
            gLAutoDrawable.getGL().glFinish();
            this.initCL(gLAutoDrawable.getContext());
            GL2 gL2 = gLAutoDrawable.getGL().getGL2();
            gL2.setSwapInterval(0);
            gL2.glDisable(2929);
            gL2.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
            this.initView(gL2, gLAutoDrawable.getSurfaceWidth(), gLAutoDrawable.getSurfaceHeight());
            this.initPBO((GL)gL2);
            gLAutoDrawable.getGL().glFinish();
            this.setKernelConstants();
        }
    }

    private void initCL(GLContext gLContext) {
        block9: {
            try {
                int n;
                CLPlatform cLPlatform = CLPlatform.getDefault();
                this.clContext = cLPlatform.getICDSuffix().equals("NV") ? CLGLContext.create((GLContext)gLContext, (CLDevice[])new CLDevice[]{cLPlatform.getMaxFlopsDevice(new CLDevice.Type[]{CLDevice.Type.GPU})}) : CLGLContext.create((GLContext)gLContext, (CLPlatform)cLPlatform, (CLDevice.Type[])new CLDevice.Type[]{CLDevice.Type.ALL});
                CLDevice[] cLDeviceArray = this.clContext.getDevices();
                this.slices = Math.min(cLDeviceArray.length, 8);
                this.queues = new CLCommandQueue[this.slices];
                this.kernels = new CLKernel[this.slices];
                this.probes = new CLEventList(this.slices);
                this.colorMap = new ArrayList(this.slices);
                for (n = 0; n < this.slices; ++n) {
                    this.colorMap.add((CLBuffer<IntBuffer>)this.clContext.createIntBuffer(64, new CLMemory.Mem[]{CLMemory.Mem.READ_ONLY}));
                    this.initColorMap((IntBuffer)this.colorMap.get(n).getBuffer(), 32, Color.BLUE, Color.GREEN, Color.RED);
                    this.queues[n] = cLDeviceArray[n].createCommandQueue(CLCommandQueue.Mode.PROFILING_MODE).putWriteBuffer(this.colorMap.get(n), true);
                }
                n = 1;
                for (CLDevice cLDevice : cLDeviceArray) {
                    if (this.isDoubleFPAvailable(cLDevice)) continue;
                    n = 0;
                    break;
                }
                if (n != 0) {
                    this.programs = new CLProgram[]{this.clContext.createProgram(this.getClass().getResourceAsStream("Mandelbrot.cl"))};
                } else {
                    this.programs = new CLProgram[this.slices];
                    for (int i = 0; i < this.slices; ++i) {
                        this.programs[i] = this.clContext.createProgram(this.getClass().getResourceAsStream("Mandelbrot.cl"));
                    }
                }
                this.buildProgram();
            }
            catch (IOException iOException) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "can not find 'Mandelbrot.cl' in classpath.", iOException);
                if (this.clContext != null) {
                    this.clContext.release();
                }
            }
            catch (CLException cLException) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "something went wrong, hopefully nobody got hurt", cLException);
                if (this.clContext == null) break block9;
                this.clContext.release();
            }
        }
    }

    private void initColorMap(IntBuffer intBuffer, int n, Color ... colorArray) {
        for (int i = 0; i < colorArray.length - 1; ++i) {
            Color color = colorArray[i];
            int n2 = color.getRed();
            int n3 = color.getGreen();
            int n4 = color.getBlue();
            color = colorArray[i + 1];
            int n5 = color.getRed();
            int n6 = color.getGreen();
            int n7 = color.getBlue();
            int n8 = n5 - n2;
            int n9 = n6 - n3;
            int n10 = n7 - n4;
            for (int j = 0; j < n; ++j) {
                float f = (float)j / (float)(n - 1);
                int n11 = (int)((float)n2 + f * (float)n8);
                int n12 = (int)((float)n3 + f * (float)n9);
                int n13 = (int)((float)n4 + f * (float)n10);
                intBuffer.put(n11 << 16 | n12 << 8 | n13 << 0);
            }
        }
        intBuffer.rewind();
    }

    private void initView(GL2 gL2, int n, int n2) {
        gL2.glViewport(0, 0, n, n2);
        gL2.glMatrixMode(5888);
        gL2.glLoadIdentity();
        gL2.glMatrixMode(5889);
        gL2.glLoadIdentity();
        gL2.glOrtho(0.0, (double)n, 0.0, (double)n2, 0.0, 1.0);
    }

    private void initPBO(GL gL) {
        int n;
        int[] nArray;
        if (this.pboBuffers != null) {
            nArray = new int[this.pboBuffers.size()];
            for (n = 0; n < this.pboBuffers.size(); ++n) {
                CLGLBuffer<?> cLGLBuffer = this.pboBuffers.get(n);
                nArray[n] = cLGLBuffer.GLID;
                cLGLBuffer.release();
            }
            gL.glDeleteBuffers(nArray.length, nArray, 0);
        }
        this.pboBuffers = new ArrayList(this.slices);
        nArray = new int[this.slices];
        gL.glGenBuffers(this.slices, nArray, 0);
        for (n = 0; n < this.slices; ++n) {
            int n2 = this.width * this.height * 4 / this.slices;
            gL.glBindBuffer(35052, nArray[n]);
            gL.glBufferData(35052, (long)n2, null, 35040);
            gL.glBindBuffer(35052, 0);
            this.pboBuffers.add(this.clContext.createFromGLBuffer(nArray[n], (long)n2, new CLMemory.Mem[]{CLMemory.Mem.WRITE_ONLY}));
        }
        this.buffersInitialized = true;
    }

    private void buildProgram() {
        Object object;
        int n;
        if (this.programs[0] != null && this.rebuild) {
            for (n = 0; n < this.programs.length; ++n) {
                object = this.programs[n].getSource();
                this.programs[n].release();
                this.programs[n] = this.clContext.createProgram((String)object);
            }
        }
        for (n = 0; n < this.programs.length; ++n) {
            object = this.queues[n].getDevice();
            CLProgramConfiguration cLProgramConfiguration = this.programs[n].prepare();
            if (this.doublePrecision && this.isDoubleFPAvailable((CLDevice)object)) {
                cLProgramConfiguration.withDefine("DOUBLE_FP");
                if (!object.isDoubleFPAvailable() && object.isExtensionAvailable("cl_amd_fp64")) {
                    cLProgramConfiguration.withDefine("AMD_FP");
                }
            }
            if (this.programs.length > 1) {
                cLProgramConfiguration.forDevice(object);
            }
            System.out.println(cLProgramConfiguration);
            cLProgramConfiguration.withOption("-cl-fast-relaxed-math").build();
        }
        this.rebuild = false;
        for (n = 0; n < this.kernels.length; ++n) {
            this.kernels[n] = this.programs[Math.min(n, this.programs.length)].createCLKernel("mandelbrot");
        }
    }

    private void setKernelConstants() {
        for (int i = 0; i < this.slices; ++i) {
            this.kernels[i].setForce32BitArgs(!this.doublePrecision || !this.isDoubleFPAvailable(this.queues[i].getDevice())).setArg(6, (CLMemory)this.pboBuffers.get(i)).setArg(7, (CLMemory)this.colorMap.get(i)).setArg(8, ((IntBuffer)this.colorMap.get(i).getBuffer()).capacity()).setArg(9, 500);
        }
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        GL gL = gLAutoDrawable.getGL();
        gL.glFinish();
        if (!this.buffersInitialized) {
            this.initPBO(gL);
            this.setKernelConstants();
        }
        if (this.rebuild) {
            this.buildProgram();
            this.setKernelConstants();
        }
        this.compute();
        this.render(gL.getGL2());
    }

    private void compute() {
        int n;
        int n2 = (int)((float)this.width / (float)this.slices);
        double d = (this.maxX - this.minX) / (double)this.slices;
        double d2 = this.maxY - this.minY;
        this.probes.release();
        for (n = 0; n < this.slices; ++n) {
            this.kernels[n].putArg(n2).putArg(this.height).putArg(this.minX + d * (double)n).putArg(this.minY).putArg(d).putArg(d2).rewind();
            this.queues[n].putAcquireGLObject((CLGLObject)this.pboBuffers.get(n)).put2DRangeKernel(this.kernels[n], 0L, 0L, (long)n2, (long)this.height, 0L, 0L, this.probes).putReleaseGLObject((CLGLObject)this.pboBuffers.get(n));
        }
        for (n = 0; n < this.slices; ++n) {
            this.queues[n].finish();
        }
    }

    private void render(GL2 gL2) {
        int n;
        gL2.glClear(16384);
        int n2 = this.width / this.slices;
        for (n = 0; n < this.slices; ++n) {
            int n3 = this.drawSeperator ? n : 0;
            gL2.glBindBuffer(35052, this.pboBuffers.get((int)n).GLID);
            gL2.glRasterPos2i(n2 * n + n3, 0);
            gL2.glDrawPixels(n2, this.height, 32993, 5121, 0L);
        }
        gL2.glBindBuffer(35052, 0);
        this.textRenderer.beginRendering(this.width, this.height, false);
        this.textRenderer.draw("device/time/precision", 10, this.height - 15);
        for (n = 0; n < this.slices; ++n) {
            CLDevice cLDevice = this.queues[n].getDevice();
            boolean bl = this.doublePrecision && this.isDoubleFPAvailable(cLDevice);
            CLEvent cLEvent = this.probes.getEvent(n);
            long l = cLEvent.getProfilingInfo(CLEvent.ProfilingCommand.START);
            long l2 = cLEvent.getProfilingInfo(CLEvent.ProfilingCommand.END);
            this.textRenderer.draw(cLDevice.getType().toString() + n + " " + (int)((float)(l2 - l) / 1000000.0f) + "ms @" + (bl ? "64bit" : "32bit"), 10, this.height - (20 + 16 * (this.slices - n)));
        }
        this.textRenderer.endRendering();
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        if (this.width == n3 && this.height == n4) {
            return;
        }
        this.width = n3;
        this.height = n4;
        this.initPBO(gLAutoDrawable.getGL());
        this.setKernelConstants();
        this.initView(gLAutoDrawable.getGL().getGL2(), n3, n4);
    }

    private void initSceneInteraction() {
        MouseAdapter mouseAdapter = new MouseAdapter(){
            Point lastpos = new Point();

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                double d = (double)(this.lastpos.x - mouseEvent.getX()) * (MultiDeviceFractal.this.maxX - MultiDeviceFractal.this.minX) / (double)MultiDeviceFractal.this.width;
                double d2 = (double)(this.lastpos.y - mouseEvent.getY()) * (MultiDeviceFractal.this.maxY - MultiDeviceFractal.this.minY) / (double)MultiDeviceFractal.this.height;
                MultiDeviceFractal.this.minX += d;
                MultiDeviceFractal.this.minY -= d2;
                MultiDeviceFractal.this.maxX += d;
                MultiDeviceFractal.this.maxY -= d2;
                this.lastpos = mouseEvent.getPoint();
                MultiDeviceFractal.this.canvas.display();
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                this.lastpos = mouseEvent.getPoint();
            }

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                float f = (float)mouseWheelEvent.getWheelRotation() / 25.0f;
                double d = (double)f * (MultiDeviceFractal.this.maxX - MultiDeviceFractal.this.minX);
                double d2 = (double)f * (MultiDeviceFractal.this.maxY - MultiDeviceFractal.this.minY);
                double d3 = (double)((float)mouseWheelEvent.getX() / (float)MultiDeviceFractal.this.width - 0.5f) * d * 2.0;
                double d4 = (double)((float)mouseWheelEvent.getY() / (float)MultiDeviceFractal.this.height - 0.5f) * d2 * 2.0;
                MultiDeviceFractal.this.minX += d + d3;
                MultiDeviceFractal.this.minY += d2 - d4;
                MultiDeviceFractal.this.maxX += -d + d3;
                MultiDeviceFractal.this.maxY += -d2 - d4;
                MultiDeviceFractal.this.canvas.display();
            }
        };
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 32) {
                    MultiDeviceFractal.this.drawSeperator = !MultiDeviceFractal.this.drawSeperator;
                } else if (keyEvent.getKeyChar() > '0' && keyEvent.getKeyChar() < '9') {
                    int n = keyEvent.getKeyChar() - 48;
                    MultiDeviceFractal.this.slices = Math.min(n, Math.min(MultiDeviceFractal.this.queues.length, 8));
                    MultiDeviceFractal.this.buffersInitialized = false;
                } else if (keyEvent.getKeyCode() == 68) {
                    MultiDeviceFractal.this.doublePrecision = !MultiDeviceFractal.this.doublePrecision;
                    MultiDeviceFractal.this.rebuild = true;
                }
                MultiDeviceFractal.this.canvas.display();
            }
        };
        this.canvas.addMouseMotionListener((MouseMotionListener)mouseAdapter);
        this.canvas.addMouseWheelListener((MouseWheelListener)mouseAdapter);
        this.canvas.addKeyListener((KeyListener)keyAdapter);
    }

    private boolean isDoubleFPAvailable(CLDevice cLDevice) {
        return cLDevice.isDoubleFPAvailable() || cLDevice.isExtensionAvailable("cl_amd_fp64");
    }

    private void release(Window window) {
        if (this.clContext != null) {
            this.clContext.release();
        }
        window.dispose();
    }

    public void dispose(GLAutoDrawable gLAutoDrawable) {
    }

    public static void main(String[] stringArray) {
        GLProfile.initSingleton();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new MultiDeviceFractal(512, 512);
            }
        });
    }
}

