/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl.demos.gamma;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opencl.CLBuffer;
import com.jogamp.opencl.CLCommandQueue;
import com.jogamp.opencl.CLContext;
import com.jogamp.opencl.CLDevice;
import com.jogamp.opencl.CLKernel;
import com.jogamp.opencl.CLMemory;
import com.jogamp.opencl.CLPlatform;
import com.jogamp.opencl.CLProgram;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class CLSimpleGammaCorrection {
    private static InputStream getStreamFor(String string) {
        return CLSimpleGammaCorrection.class.getResourceAsStream(string);
    }

    public static BufferedImage readImage(String string) throws IOException {
        return ImageIO.read(CLSimpleGammaCorrection.getStreamFor(string));
    }

    private static BufferedImage createImage(int n, int n2, CLBuffer<FloatBuffer> cLBuffer) {
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        float[] fArray = new float[((FloatBuffer)cLBuffer.getBuffer()).capacity()];
        ((FloatBuffer)cLBuffer.getBuffer()).get(fArray).rewind();
        bufferedImage.getRaster().setPixels(0, 0, n, n2, fArray);
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws IOException {
        CLPlatform cLPlatform = CLPlatform.getDefault();
        CLContext cLContext = CLContext.create((CLDevice[])new CLDevice[]{cLPlatform.getMaxFlopsDevice()});
        try {
            CLProgram cLProgram = cLContext.createProgram(CLSimpleGammaCorrection.getStreamFor("Gamma.cl"));
            cLProgram.build("-cl-fast-relaxed-math");
            assert (cLProgram.isExecutable());
            BufferedImage bufferedImage = CLSimpleGammaCorrection.readImage("lena.png");
            assert (bufferedImage.getColorModel().getNumComponents() == 3);
            float[] fArray = bufferedImage.getRaster().getPixels(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), (float[])null);
            FloatBuffer floatBuffer = Buffers.newDirectFloatBuffer((float[])fArray);
            CLBuffer cLBuffer = cLContext.createBuffer((Buffer)floatBuffer, new CLMemory.Mem[]{CLMemory.Mem.READ_WRITE});
            CLCommandQueue cLCommandQueue = cLContext.getDevices()[0].createCommandQueue(CLCommandQueue.Mode.PROFILING_MODE);
            int n = cLCommandQueue.getDevice().getMaxWorkGroupSize();
            int n2 = CLSimpleGammaCorrection.roundUp(n, floatBuffer.capacity());
            CLKernel cLKernel = cLProgram.createCLKernel("gamma");
            CLSimpleGammaCorrection.show(bufferedImage, 0, 50, "reference");
            float f = 0.5f;
            CLSimpleGammaCorrection.gammaCorrection(f, cLCommandQueue, cLKernel, (CLBuffer<FloatBuffer>)cLBuffer, n, n2);
            CLSimpleGammaCorrection.show(CLSimpleGammaCorrection.createImage(bufferedImage.getWidth(), bufferedImage.getHeight(), (CLBuffer<FloatBuffer>)cLBuffer), bufferedImage.getWidth() / 2, 50, "gamma=" + f);
            f = 1.5f;
            CLSimpleGammaCorrection.gammaCorrection(f, cLCommandQueue, cLKernel, (CLBuffer<FloatBuffer>)cLBuffer, n, n2);
            CLSimpleGammaCorrection.show(CLSimpleGammaCorrection.createImage(bufferedImage.getWidth(), bufferedImage.getHeight(), (CLBuffer<FloatBuffer>)cLBuffer), bufferedImage.getWidth() / 2 * 2, 50, "gamma=" + f);
            f = 2.0f;
            CLSimpleGammaCorrection.gammaCorrection(f, cLCommandQueue, cLKernel, (CLBuffer<FloatBuffer>)cLBuffer, n, n2);
            CLSimpleGammaCorrection.show(CLSimpleGammaCorrection.createImage(bufferedImage.getWidth(), bufferedImage.getHeight(), (CLBuffer<FloatBuffer>)cLBuffer), bufferedImage.getWidth() / 2 * 3, 50, "gamma=" + f);
        }
        finally {
            cLContext.release();
        }
    }

    private static void gammaCorrection(float f, CLCommandQueue cLCommandQueue, CLKernel cLKernel, CLBuffer<FloatBuffer> cLBuffer, int n, int n2) {
        float f2 = (float)Math.pow(255.0, 1.0f - f);
        cLKernel.putArg(cLBuffer).putArg(f).putArg(f2).putArg(cLBuffer.getNIOSize()).rewind();
        cLCommandQueue.putWriteBuffer(cLBuffer, false);
        cLCommandQueue.put1DRangeKernel(cLKernel, 0L, (long)n2, (long)n);
        cLCommandQueue.putReadBuffer(cLBuffer, true);
    }

    private static void show(final BufferedImage bufferedImage, final int n, final int n2, final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame jFrame = new JFrame("gamma correction example [" + string + "]");
                jFrame.setDefaultCloseOperation(3);
                jFrame.add(new JLabel(new ImageIcon(bufferedImage)));
                jFrame.pack();
                jFrame.setLocation(n, n2);
                jFrame.setVisible(true);
            }
        });
    }

    private static int roundUp(int n, int n2) {
        int n3 = n2 % n;
        if (n3 == 0) {
            return n2;
        }
        return n2 + n - n3;
    }
}

