/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl.demos.hellojocl;

import com.jogamp.opencl.CLBuffer;
import com.jogamp.opencl.CLCommandQueue;
import com.jogamp.opencl.CLContext;
import com.jogamp.opencl.CLDevice;
import com.jogamp.opencl.CLKernel;
import com.jogamp.opencl.CLMemory;
import com.jogamp.opencl.CLProgram;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.util.Random;

public class HelloJOCL {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws IOException {
        CLContext cLContext = CLContext.create();
        System.out.println("created " + cLContext);
        try {
            CLDevice cLDevice = cLContext.getMaxFlopsDevice();
            System.out.println("using " + cLDevice);
            CLCommandQueue cLCommandQueue = cLDevice.createCommandQueue();
            int n = 1444477;
            int n2 = Math.min(cLDevice.getMaxWorkGroupSize(), 256);
            int n3 = HelloJOCL.roundUp(n2, n);
            CLProgram cLProgram = cLContext.createProgram(HelloJOCL.class.getResourceAsStream("VectorAdd.cl")).build();
            CLBuffer cLBuffer = cLContext.createFloatBuffer(n3, new CLMemory.Mem[]{CLMemory.Mem.READ_ONLY});
            CLBuffer cLBuffer2 = cLContext.createFloatBuffer(n3, new CLMemory.Mem[]{CLMemory.Mem.READ_ONLY});
            CLBuffer cLBuffer3 = cLContext.createFloatBuffer(n3, new CLMemory.Mem[]{CLMemory.Mem.WRITE_ONLY});
            System.out.println("used device memory: " + (cLBuffer.getCLSize() + cLBuffer2.getCLSize() + cLBuffer3.getCLSize()) / 1000000L + "MB");
            HelloJOCL.fillBuffer((FloatBuffer)cLBuffer.getBuffer(), 12345);
            HelloJOCL.fillBuffer((FloatBuffer)cLBuffer2.getBuffer(), 67890);
            CLKernel cLKernel = cLProgram.createCLKernel("VectorAdd");
            cLKernel.putArgs(new CLMemory[]{cLBuffer, cLBuffer2, cLBuffer3}).putArg(n);
            long l = System.nanoTime();
            cLCommandQueue.putWriteBuffer(cLBuffer, false).putWriteBuffer(cLBuffer2, false).put1DRangeKernel(cLKernel, 0L, (long)n3, (long)n2).putReadBuffer(cLBuffer3, true);
            l = System.nanoTime() - l;
            System.out.println("a+b=c results snapshot: ");
            for (int i = 0; i < 10; ++i) {
                System.out.print(((FloatBuffer)cLBuffer3.getBuffer()).get() + ", ");
            }
            System.out.println("...; " + ((FloatBuffer)cLBuffer3.getBuffer()).remaining() + " more");
            System.out.println("computation took: " + l / 1000000L + "ms");
        }
        finally {
            cLContext.release();
        }
    }

    private static void fillBuffer(FloatBuffer floatBuffer, int n) {
        Random random = new Random(n);
        while (floatBuffer.remaining() != 0) {
            floatBuffer.put(random.nextFloat() * 100.0f);
        }
        floatBuffer.rewind();
    }

    private static int roundUp(int n, int n2) {
        int n3 = n2 % n;
        if (n3 == 0) {
            return n2;
        }
        return n2 + n - n3;
    }
}

