/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl.demos.info;

import com.jogamp.common.JogampRuntimeException;
import com.jogamp.opencl.CLPlatform;
import com.jogamp.opencl.JoclVersion;
import com.jogamp.opencl.util.ExceptionReporter;
import java.awt.Container;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.UIManager;

public class CLInfo {
    public static void main(String[] stringArray) {
        Logger logger = Logger.getLogger(CLInfo.class.getName());
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            logger.log(Level.INFO, null, exception);
        }
        JoclVersion joclVersion = JoclVersion.getInstance();
        logger.info("\n" + joclVersion.getAllVersions(null).toString());
        try {
            CLPlatform.initialize();
        }
        catch (JogampRuntimeException jogampRuntimeException) {
            logger.log(Level.SEVERE, null, jogampRuntimeException);
            ExceptionReporter.appear("I tried hard but I really can't initialize JOCL. Is OpenCL properly set up?", jogampRuntimeException);
            return;
        }
        JFrame jFrame = new JFrame("OpenCL Info");
        jFrame.setDefaultCloseOperation(2);
        Container container = jFrame.getContentPane();
        JEditorPane jEditorPane = new JEditorPane();
        jEditorPane.setContentType("text/html");
        jEditorPane.setEditable(false);
        container.add(new JScrollPane(jEditorPane));
        jEditorPane.setText(joclVersion.getOpenCLHtmlInfo(null).toString());
        jFrame.setSize(800, 600);
        jFrame.setVisible(true);
    }
}

