/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl.demos.joglinterop;

import com.jogamp.opencl.CLCommandQueue;
import com.jogamp.opencl.CLDevice;
import com.jogamp.opencl.CLKernel;
import com.jogamp.opencl.CLMemory;
import com.jogamp.opencl.CLPlatform;
import com.jogamp.opencl.CLProgram;
import com.jogamp.opencl.demos.joglinterop.UserSceneInteraction;
import com.jogamp.opencl.gl.CLGLBuffer;
import com.jogamp.opencl.gl.CLGLContext;
import com.jogamp.opengl.DebugGL2;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.glu.gl2.GLUgl2;
import com.jogamp.opengl.util.Animator;
import java.awt.Component;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class GLCLInteroperabilityDemo
implements GLEventListener {
    private final GLUgl2 glu = new GLUgl2();
    private final int MESH_SIZE = 256;
    private int width;
    private int height;
    private final int[] glObjects = new int[2];
    private final int VERTICES = 0;
    private final UserSceneInteraction usi = new UserSceneInteraction();
    private CLGLContext clContext;
    private CLKernel kernel;
    private CLCommandQueue commandQueue;
    private CLGLBuffer<?> clBuffer;
    private float step = 0.0f;

    public GLCLInteroperabilityDemo() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GLCLInteroperabilityDemo.this.initUI();
            }
        });
    }

    private void initUI() {
        this.width = 600;
        this.height = 400;
        GLCapabilities gLCapabilities = new GLCapabilities(GLProfile.get((String)"GL2"));
        gLCapabilities.setSampleBuffers(true);
        gLCapabilities.setNumSamples(4);
        GLCanvas gLCanvas = new GLCanvas((GLCapabilitiesImmutable)gLCapabilities);
        gLCanvas.addGLEventListener((GLEventListener)this);
        this.usi.init((Component)gLCanvas);
        JFrame jFrame = new JFrame("JOGL-JOCL Interoperability Example");
        jFrame.setDefaultCloseOperation(3);
        jFrame.add((Component)gLCanvas);
        jFrame.setSize(this.width, this.height);
        jFrame.setVisible(true);
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        if (this.clContext == null) {
            GL2 gL2 = CLPlatform.getDefault().listCLDevices();
            CLDevice cLDevice = null;
            for (CLDevice cLDevice2 : gL2) {
                if (!cLDevice2.isGLMemorySharingSupported()) continue;
                cLDevice = cLDevice2;
                break;
            }
            if (null == cLDevice) {
                throw new RuntimeException("couldn't find any CL/GL memory sharing devices ..");
            }
            this.clContext = CLGLContext.create((GLContext)gLAutoDrawable.getContext(), (CLDevice[])new CLDevice[]{cLDevice});
            gLAutoDrawable.setGL((GL)new DebugGL2(gLAutoDrawable.getGL().getGL2()));
            GL2 gL22 = gLAutoDrawable.getGL().getGL2();
            gL22.setSwapInterval(1);
            gL22.glPolygonMode(1032, 6913);
            gL22.glGenBuffers(this.glObjects.length, this.glObjects, 0);
            gL22.glEnableClientState(32884);
            gL22.glBindBuffer(34962, this.glObjects[0]);
            gL22.glBufferData(34962, 0x100000L, null, 35048);
            gL22.glBindBuffer(34962, 0);
            gL22.glDisableClientState(32884);
            this.pushPerspectiveView(gL22);
            gL22.glFinish();
            this.initCL(gL22, 0x100000);
            Animator animator = new Animator(gLAutoDrawable);
            animator.start();
        }
    }

    private void initCL(GL2 gL2, int n) {
        CLProgram cLProgram;
        try {
            cLProgram = this.clContext.createProgram(this.getClass().getResourceAsStream("JoglInterop.cl"));
            cLProgram.build();
            System.out.println(cLProgram.getBuildStatus());
            System.out.println(cLProgram.isExecutable());
            System.out.println(cLProgram.getBuildLog());
        }
        catch (IOException iOException) {
            throw new RuntimeException("can not handle exception", iOException);
        }
        this.commandQueue = this.clContext.getMaxFlopsDevice().createCommandQueue();
        this.clBuffer = this.clContext.createFromGLBuffer(this.glObjects[0], (long)n, new CLMemory.Mem[]{CLMemory.Mem.WRITE_ONLY});
        System.out.println("cl buffer type: " + this.clBuffer.getGLObjectType());
        System.out.println("shared with gl buffer: " + this.clBuffer.getGLObjectID());
        this.kernel = cLProgram.createCLKernel("sineWave").putArg(this.clBuffer).putArg(256).rewind();
        System.out.println("cl initialised");
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        GL2 gL2 = gLAutoDrawable.getGL().getGL2();
        gL2.glFinish();
        this.computeHeightfield();
        gL2.glClear(16640);
        gL2.glLoadIdentity();
        this.usi.interact(gL2);
        gL2.glBindBuffer(34962, this.glObjects[0]);
        gL2.glVertexPointer(4, 5126, 0, 0L);
        gL2.glEnableClientState(32884);
        gL2.glDrawArrays(0, 0, 65536);
        gL2.glDisableClientState(32884);
    }

    private void computeHeightfield() {
        this.kernel.setArg(2, this.step += 0.05f);
        this.commandQueue.putAcquireGLObject(this.clBuffer).put2DRangeKernel(this.kernel, 0L, 0L, 256L, 256L, 0L, 0L).putReleaseGLObject(this.clBuffer).finish();
    }

    private void pushPerspectiveView(GL2 gL2) {
        gL2.glMatrixMode(5889);
        gL2.glPushMatrix();
        gL2.glLoadIdentity();
        this.glu.gluPerspective(60.0f, (float)this.width / (float)this.height, 1.0f, 1000.0f);
        gL2.glMatrixMode(5888);
        gL2.glPushMatrix();
        gL2.glLoadIdentity();
    }

    private void popView(GL2 gL2) {
        gL2.glMatrixMode(5889);
        gL2.glPopMatrix();
        gL2.glMatrixMode(5888);
        gL2.glPopMatrix();
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        this.width = n3;
        this.height = n4;
        GL2 gL2 = gLAutoDrawable.getGL().getGL2();
        this.popView(gL2);
        this.pushPerspectiveView(gL2);
    }

    public void dispose(GLAutoDrawable gLAutoDrawable) {
    }

    public static void main(String[] stringArray) {
        GLProfile.initSingleton();
        new GLCLInteroperabilityDemo();
    }
}

