/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl.demos.joglinterop;

import com.jogamp.opengl.GL2;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;

public class UserSceneInteraction {
    private float z = -20.0f;
    private float rotx = 45.0f;
    private float roty = 30.0f;
    private Point dragstart;
    private MOUSE_MODE dragmode = MOUSE_MODE.DRAG_ROTATE;

    public void init(Component component) {
        this.initMouseListeners(component);
    }

    private void initMouseListeners(Component component) {
        component.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                if (UserSceneInteraction.this.dragstart != null) {
                    switch (UserSceneInteraction.this.dragmode.ordinal()) {
                        case 0: {
                            UserSceneInteraction.this.rotx = (float)((double)UserSceneInteraction.this.rotx + ((double)mouseEvent.getY() - UserSceneInteraction.this.dragstart.getY()));
                            UserSceneInteraction.this.roty = (float)((double)UserSceneInteraction.this.roty + ((double)mouseEvent.getX() - UserSceneInteraction.this.dragstart.getX()));
                            break;
                        }
                        case 1: {
                            UserSceneInteraction.this.z = (float)((double)UserSceneInteraction.this.z + ((double)mouseEvent.getY() - UserSceneInteraction.this.dragstart.getY()) / 5.0);
                        }
                    }
                }
                UserSceneInteraction.this.dragstart = mouseEvent.getPoint();
            }
        });
        component.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                UserSceneInteraction.this.z += mouseWheelEvent.getWheelRotation() * 5;
            }
        });
        component.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                switch (mouseEvent.getButton()) {
                    case 1: {
                        UserSceneInteraction.this.dragmode = MOUSE_MODE.DRAG_ROTATE;
                        break;
                    }
                    case 2: {
                        UserSceneInteraction.this.dragmode = MOUSE_MODE.DRAG_ZOOM;
                        break;
                    }
                    case 3: {
                        UserSceneInteraction.this.dragmode = MOUSE_MODE.DRAG_ZOOM;
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                switch (mouseEvent.getButton()) {
                    case 1: {
                        UserSceneInteraction.this.dragmode = MOUSE_MODE.DRAG_ZOOM;
                        break;
                    }
                    case 2: {
                        UserSceneInteraction.this.dragmode = MOUSE_MODE.DRAG_ROTATE;
                        break;
                    }
                    case 3: {
                        UserSceneInteraction.this.dragmode = MOUSE_MODE.DRAG_ROTATE;
                    }
                }
                UserSceneInteraction.this.dragstart = null;
            }
        });
    }

    public void interact(GL2 gL2) {
        gL2.glTranslatef(0.0f, 0.0f, this.z);
        gL2.glRotatef(this.rotx, 1.0f, 0.0f, 0.0f);
        gL2.glRotatef(this.roty, 0.0f, 1.0f, 0.0f);
    }

    private static enum MOUSE_MODE {
        DRAG_ROTATE,
        DRAG_ZOOM;

    }
}

