/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl.demos.julia3d;

import com.jogamp.opencl.CLBuffer;
import com.jogamp.opencl.CLCommandQueue;
import com.jogamp.opencl.CLContext;
import com.jogamp.opencl.CLDevice;
import com.jogamp.opencl.CLKernel;
import com.jogamp.opencl.CLMemory;
import com.jogamp.opencl.CLPlatform;
import com.jogamp.opencl.CLProgram;
import com.jogamp.opencl.demos.julia3d.Renderer;
import com.jogamp.opencl.demos.julia3d.UserSceneController;
import com.jogamp.opencl.demos.julia3d.structs.Camera;
import com.jogamp.opencl.demos.julia3d.structs.RenderingConfig;
import com.jogamp.opencl.demos.julia3d.structs.Vec;
import com.jogamp.opencl.util.CLPlatformFilters;
import com.jogamp.opencl.util.Filter;
import com.jogamp.opengl.GLProfile;
import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class Julia3d {
    private final CLContext context;
    private CLBuffer<FloatBuffer> pixelBuffer;
    private final CLBuffer<ByteBuffer> configBuffer;
    private final CLCommandQueue commandQueue;
    private final CLProgram program;
    private final CLKernel julia;
    private final CLKernel multiply;
    private final int workGroupSize;
    private final String kernelFileName = "rendering_kernel.cl";
    final RenderingConfig config;

    private Julia3d(RenderingConfig renderingConfig) {
        this.config = renderingConfig;
        this.updateCamera();
        CLDevice cLDevice = CLPlatform.getDefault((Filter[])new Filter[]{CLPlatformFilters.type((CLDevice.Type)CLDevice.Type.GPU)}).getMaxFlopsDevice();
        if (cLDevice == null) {
            cLDevice = CLPlatform.getDefault().getMaxFlopsDevice();
        }
        this.context = CLContext.create((CLDevice[])new CLDevice[]{cLDevice});
        this.workGroupSize = Math.min(256, cLDevice.getMaxWorkGroupSize());
        this.configBuffer = this.context.createBuffer((Buffer)this.config.getBuffer(), new CLMemory.Mem[]{CLMemory.Mem.READ_ONLY});
        this.commandQueue = cLDevice.createCommandQueue();
        try {
            this.program = this.context.createProgram(Julia3d.class.getResourceAsStream("rendering_kernel.cl")).build("-cl-fast-relaxed-math");
        }
        catch (IOException iOException) {
            throw new RuntimeException("unable to load program from source", iOException);
        }
        this.julia = this.program.createCLKernel("JuliaGPU");
        this.multiply = this.program.createCLKernel("multiply");
        System.out.println(this.program.getBuildStatus(cLDevice));
        System.out.println(this.program.getBuildLog());
    }

    void update(boolean bl) {
        this.updateCamera();
        int n = this.config.getWidth() * this.config.getHeight() * 3;
        if (bl) {
            if (this.pixelBuffer != null) {
                this.pixelBuffer.release();
            }
            this.pixelBuffer = this.context.createFloatBuffer(n, new CLMemory.Mem[]{CLMemory.Mem.READ_WRITE, CLMemory.Mem.USE_BUFFER});
        }
        this.commandQueue.putWriteBuffer(this.configBuffer, true);
        this.julia.putArg(this.pixelBuffer).putArg(this.configBuffer).rewind();
        this.multiply.putArg(this.pixelBuffer).putArg(n).rewind();
    }

    void compute(boolean bl) {
        int n = this.config.getWidth() * this.config.getHeight();
        if (n % this.workGroupSize != 0) {
            n = (n / this.workGroupSize + 1) * this.workGroupSize;
        }
        int n2 = this.workGroupSize;
        int n3 = this.config.getSuperSamplingSize();
        if (!bl && n3 > 1) {
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < n3; ++j) {
                    float f = ((float)j + 0.5f) / (float)n3;
                    float f2 = ((float)i + 0.5f) / (float)n3;
                    if (j == 0 && i == 0) {
                        this.julia.setArg(2, 0).setArg(3, f).setArg(4, f2);
                        this.commandQueue.put1DRangeKernel(this.julia, 0L, (long)n, (long)n2);
                        continue;
                    }
                    if (j == n3 - 1 && i == n3 - 1) {
                        this.julia.setArg(2, 1).setArg(3, f).setArg(4, f2);
                        this.multiply.setArg(2, 1.0f / (float)(n3 * n3));
                        this.commandQueue.put1DRangeKernel(this.julia, 0L, (long)n, (long)n2).put1DRangeKernel(this.multiply, 0L, (long)(n * 3), (long)n2);
                        continue;
                    }
                    this.julia.setArg(2, 1).setArg(3, f).setArg(4, f2);
                    this.commandQueue.put1DRangeKernel(this.julia, 0L, (long)n, (long)n2);
                }
            }
        } else {
            this.julia.setArg(2, 0).setArg(3, 0.0f).setArg(4, 0.0f);
            this.commandQueue.put1DRangeKernel(this.julia, 0L, (long)n, (long)n2);
        }
        this.commandQueue.putBarrier().putReadBuffer(this.pixelBuffer, true);
    }

    private void updateCamera() {
        Camera camera = this.config.getCamera();
        Vec vec = camera.getDir();
        Vec vec2 = camera.getTarget();
        Vec vec3 = camera.getX();
        Vec vec4 = camera.getY();
        Vec vec5 = camera.getOrig();
        UserSceneController.vsub(vec, vec2, vec5);
        UserSceneController.vnorm(vec);
        Vec vec6 = Vec.create().setX(0.0f).setY(1.0f).setZ(0.0f);
        UserSceneController.vxcross(vec3, vec, vec6);
        UserSceneController.vnorm(vec3);
        UserSceneController.vmul(vec3, (float)this.config.getWidth() * 0.5135f / (float)this.config.getHeight(), vec3);
        UserSceneController.vxcross(vec4, vec3, vec);
        UserSceneController.vnorm(vec4);
        UserSceneController.vmul(vec4, 0.5135f, vec4);
    }

    CLDevice getDevice() {
        return this.commandQueue.getDevice();
    }

    public static void main(String[] stringArray) {
        GLProfile.initSingleton();
        final RenderingConfig renderingConfig = RenderingConfig.create().setWidth(640).setHeight(480).setEnableShadow(1).setSuperSamplingSize(2).setActvateFastRendering(1).setMaxIterations(9).setEpsilon(0.00225f).setLight(new float[]{5.0f, 10.0f, 15.0f}).setMu(new float[]{-0.2f, 0.4f, -0.4f, -0.4f});
        renderingConfig.getCamera().getOrig().setX(1.0f).setY(2.0f).setZ(8.0f);
        renderingConfig.getCamera().getTarget().setX(0.0f).setY(0.0f).setZ(0.0f);
        final Julia3d julia3d = new Julia3d(renderingConfig);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Renderer renderer = new Renderer(julia3d);
                CLDevice cLDevice = julia3d.getDevice();
                JFrame jFrame = new JFrame("Java OpenCL - Julia3D " + cLDevice.getType() + " " + cLDevice.getName());
                jFrame.setDefaultCloseOperation(2);
                jFrame.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosed(WindowEvent windowEvent) {
                        julia3d.release();
                        System.exit(0);
                    }
                });
                Canvas canvas = renderer.getCanvas();
                canvas.setPreferredSize(new Dimension(renderingConfig.getWidth(), renderingConfig.getHeight()));
                jFrame.add(canvas);
                jFrame.pack();
                jFrame.setVisible(true);
            }
        });
    }

    Buffer getPixelBuffer() {
        return this.pixelBuffer.getBuffer();
    }

    void release() {
        this.context.release();
    }
}

