/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl.demos.julia3d;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opencl.demos.julia3d.Julia3d;
import com.jogamp.opencl.demos.julia3d.UserSceneController;
import com.jogamp.opencl.demos.julia3d.structs.RenderingConfig;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.util.awt.TextRenderer;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Font;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.util.Timer;
import java.util.TimerTask;

public class Renderer
implements GLEventListener {
    public static final int MU_RECT_SIZE = 80;
    private final Julia3d julia3d;
    private final GLCanvas canvas;
    private final RenderingConfig config;
    private final FloatBuffer juliaSlice;
    private final UserSceneController usi;
    private final TextRenderer textRenderer;
    private TimerTask task;
    private final Timer timer;

    public Renderer(Julia3d julia3d) {
        this.julia3d = julia3d;
        this.config = julia3d.config;
        this.timer = new Timer(true);
        this.juliaSlice = Buffers.newDirectFloatBuffer((int)25600);
        this.canvas = new GLCanvas((GLCapabilitiesImmutable)new GLCapabilities(GLProfile.get((String)"GL2")));
        this.canvas.addGLEventListener((GLEventListener)this);
        this.usi = new UserSceneController();
        this.usi.init(this, (Component)this.canvas, this.config);
        this.textRenderer = new TextRenderer(new Font("Helvetica", 1, 14), true, true, null, false);
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        gLAutoDrawable.getGL().getGL2().glMatrixMode(5889);
    }

    void update() {
        this.julia3d.update(false);
        this.canvas.display();
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        this.julia3d.compute(this.config.getActvateFastRendering() == 1);
        GL2 gL2 = gLAutoDrawable.getGL().getGL2();
        gL2.glClear(16384);
        gL2.glRasterPos2i(0, 0);
        gL2.glDrawPixels(this.config.getWidth(), this.config.getHeight(), 6407, 5126, this.julia3d.getPixelBuffer());
        int n = this.config.getWidth();
        int n2 = this.config.getHeight();
        float[] fArray = this.config.getMu();
        gL2.glEnable(3042);
        gL2.glBlendFunc(770, 771);
        int n3 = n - 80 - 2;
        int n4 = 1;
        this.drawJuliaSlice(gL2, n3, n4, fArray[0], fArray[1]);
        int n5 = n - 80 - 2;
        int n6 = 82;
        this.drawJuliaSlice(gL2, n5, n6, fArray[2], fArray[3]);
        gL2.glDisable(3042);
        gL2.glColor3f(1.0f, 1.0f, 1.0f);
        int n7 = (int)((float)n3 + 80.0f * (fArray[0] + 1.5f) / 3.0f);
        int n8 = (int)((float)n4 + 80.0f * (fArray[1] + 1.5f) / 3.0f);
        gL2.glBegin(1);
        gL2.glVertex2i(n7 - 4, n8);
        gL2.glVertex2i(n7 + 4, n8);
        gL2.glVertex2i(n7, n8 - 4);
        gL2.glVertex2i(n7, n8 + 4);
        gL2.glEnd();
        int n9 = (int)((float)n5 + 80.0f * (fArray[2] + 1.5f) / 3.0f);
        int n10 = (int)((float)n6 + 80.0f * (fArray[3] + 1.5f) / 3.0f);
        gL2.glBegin(1);
        gL2.glVertex2i(n9 - 4, n10);
        gL2.glVertex2i(n9 + 4, n10);
        gL2.glVertex2i(n9, n10 - 4);
        gL2.glVertex2i(n9, n10 + 4);
        gL2.glEnd();
        this.textRenderer.beginRendering(n, n2);
        this.textRenderer.draw(String.format("Epsilon %.5f - Max. Iter. %d", Float.valueOf(this.config.getEpsilon()), this.config.getMaxIterations()), 8, 10);
        this.textRenderer.draw(String.format("Mu = (%.3f, %.3f, %.3f, %.3f)", Float.valueOf(fArray[0]), Float.valueOf(fArray[1]), Float.valueOf(fArray[2]), Float.valueOf(fArray[3])), 8, 25);
        this.textRenderer.draw(String.format("Shadow %s - SuperSampling %dx%d - Fast rendering %s", this.config.getEnableShadow() == 1 ? "on" : "off", this.config.getSuperSamplingSize(), this.config.getSuperSamplingSize(), this.config.getActvateFastRendering() == 1 ? "on" : "off"), 8, 40);
        this.textRenderer.endRendering();
        if (this.task != null) {
            this.task.cancel();
        }
        if (this.config.getActvateFastRendering() == 1) {
            this.task = new TimerTask(){

                @Override
                public void run() {
                    Renderer.this.config.setActvateFastRendering(0);
                    Renderer.this.update();
                    Renderer.this.config.setActvateFastRendering(1);
                }
            };
            this.timer.schedule(this.task, 2000L);
        }
    }

    private void drawJuliaSlice(GL2 gL2, int n, int n2, float f, float f2) {
        int n3 = 0;
        float f3 = 0.0375f;
        for (int i = 0; i < 80; ++i) {
            for (int j = 0; j < 80; ++j) {
                float f4;
                float f5;
                int n4;
                float f6 = (float)i * f3 - 1.5f;
                float f7 = (float)j * f3 - 1.5f;
                for (n4 = 0; n4 < 64 && !((f5 = f6 * f6) + (f4 = f7 * f7) > 4.0f); ++n4) {
                    float f8 = f5 - f4 + f;
                    float f9 = 2.0f * f6 * f7 + f2;
                    f6 = f8;
                    f7 = f9;
                }
                this.juliaSlice.put(n3++, (float)n4 / 64.0f);
                this.juliaSlice.put(n3++, 0.0f);
                this.juliaSlice.put(n3++, 0.0f);
                this.juliaSlice.put(n3++, 0.5f);
            }
        }
        gL2.glRasterPos2i(n, n2);
        gL2.glDrawPixels(80, 80, 6408, 5126, (Buffer)this.juliaSlice);
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        this.config.setWidth(n3);
        this.config.setHeight(n4);
        GL2 gL2 = gLAutoDrawable.getGL().getGL2();
        gL2.glViewport(0, 0, n3, n4);
        gL2.glLoadIdentity();
        gL2.glOrtho(-0.5, (double)((float)n3 - 0.5f), -0.5, (double)((float)n4 - 0.5f), -1.0, 1.0);
        this.julia3d.update(true);
    }

    public void dispose(GLAutoDrawable gLAutoDrawable) {
    }

    public Canvas getCanvas() {
        return this.canvas;
    }
}

