/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl.demos.julia3d;

import com.jogamp.opencl.demos.julia3d.Renderer;
import com.jogamp.opencl.demos.julia3d.structs.RenderingConfig;
import com.jogamp.opencl.demos.julia3d.structs.Vec;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;

public class UserSceneController {
    private Point dragstart;
    private RenderingConfig model;
    private Renderer view;
    private MOUSE_MODE dragmode = MOUSE_MODE.DRAG_ROTATE;

    public void init(Renderer renderer, Component component, RenderingConfig renderingConfig) {
        this.initMouseListeners(component);
        this.view = renderer;
        this.model = renderingConfig;
    }

    private void initMouseListeners(Component component) {
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                switch (UserSceneController.this.dragmode.ordinal()) {
                    case 0: {
                        if (UserSceneController.this.dragstart != null) {
                            int n3 = UserSceneController.this.model.getHeight();
                            int n4 = UserSceneController.this.model.getWidth();
                            int n5 = n3 - n2 - 1;
                            int n6 = n4 - 80 - 2;
                            int n7 = 1;
                            int n8 = n4 - 80 - 2;
                            int n9 = 82;
                            if (n >= n6 && n <= n6 + 80 && n5 >= n7 && n5 <= n7 + 80) {
                                float[] fArray = UserSceneController.this.model.getMu();
                                fArray[0] = 3.0f * (float)(n - n6) / 80.0f - 1.5f;
                                fArray[1] = 3.0f * (float)(n5 - n7) / 80.0f - 1.5f;
                                UserSceneController.this.model.setMu(fArray);
                            } else if (n >= n8 && n <= n8 + 80 && n5 >= n9 && n5 <= n9 + 80) {
                                float[] fArray = UserSceneController.this.model.getMu();
                                fArray[2] = 3.0f * (float)(n - n8) / 80.0f - 1.5f;
                                fArray[3] = 3.0f * (float)(n5 - n9) / 80.0f - 1.5f;
                                UserSceneController.this.model.setMu(fArray);
                            } else {
                                UserSceneController.this.rotateCameraYbyOrig((double)0.01f * ((double)n - UserSceneController.this.dragstart.getX()));
                                UserSceneController.this.rotateCameraXbyOrig((double)0.01f * ((double)n2 - UserSceneController.this.dragstart.getY()));
                            }
                        }
                        UserSceneController.this.dragstart = mouseEvent.getPoint();
                        UserSceneController.this.view.update();
                        break;
                    }
                    case 1: {
                        if (UserSceneController.this.dragstart != null) {
                            float f = (float)(((double)n2 - UserSceneController.this.dragstart.getY()) / 10.0);
                            UserSceneController.this.zoom(f);
                        }
                        UserSceneController.this.dragstart = mouseEvent.getPoint();
                        UserSceneController.this.view.update();
                    }
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                switch (mouseEvent.getButton()) {
                    case 1: {
                        UserSceneController.this.dragmode = MOUSE_MODE.DRAG_ROTATE;
                        break;
                    }
                    case 2: {
                        UserSceneController.this.dragmode = MOUSE_MODE.DRAG_ZOOM;
                        break;
                    }
                    case 3: {
                        UserSceneController.this.dragmode = MOUSE_MODE.DRAG_ZOOM;
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                switch (mouseEvent.getButton()) {
                    case 1: {
                        UserSceneController.this.dragmode = MOUSE_MODE.DRAG_ZOOM;
                        break;
                    }
                    case 2: {
                        UserSceneController.this.dragmode = MOUSE_MODE.DRAG_ROTATE;
                        break;
                    }
                    case 3: {
                        UserSceneController.this.dragmode = MOUSE_MODE.DRAG_ROTATE;
                    }
                }
                UserSceneController.this.dragstart = null;
            }

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                float f = (float)mouseWheelEvent.getWheelRotation() * 0.1f;
                UserSceneController.this.zoom(f);
                UserSceneController.this.view.update();
            }
        };
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                switch (keyEvent.getKeyChar()) {
                    case 'l': {
                        UserSceneController.this.model.setEnableShadow(UserSceneController.this.model.getEnableShadow() == 0 ? 1 : 0);
                        break;
                    }
                    case '1': {
                        UserSceneController.this.model.setEpsilon(Math.max(1.0E-4f, UserSceneController.this.model.getEpsilon() * 0.75f));
                        break;
                    }
                    case '2': {
                        UserSceneController.this.model.setEpsilon(UserSceneController.this.model.getEpsilon() * 1.0f / 0.75f);
                        break;
                    }
                    case '3': {
                        UserSceneController.this.model.setMaxIterations(Math.max(1, UserSceneController.this.model.getMaxIterations() - 1));
                        break;
                    }
                    case '4': {
                        UserSceneController.this.model.setMaxIterations(Math.min(12, UserSceneController.this.model.getMaxIterations() + 1));
                        break;
                    }
                    case '5': {
                        UserSceneController.this.model.setSuperSamplingSize(Math.max(1, UserSceneController.this.model.getSuperSamplingSize() - 1));
                        break;
                    }
                    case '6': {
                        UserSceneController.this.model.setSuperSamplingSize(Math.min(5, UserSceneController.this.model.getSuperSamplingSize() + 1));
                        break;
                    }
                }
                UserSceneController.this.view.update();
            }
        };
        component.addKeyListener(keyAdapter);
        component.addMouseListener(mouseAdapter);
        component.addMouseMotionListener(mouseAdapter);
        component.addMouseWheelListener(mouseAdapter);
    }

    private void zoom(float f) {
        Vec vec = this.model.getCamera().getOrig();
        vec.setX(vec.getX() + f).setY(vec.getY() + f).setZ(vec.getZ() + f);
    }

    private void rotateLightX(float f) {
        float[] fArray = this.model.getLight();
        float f2 = fArray[1];
        float f3 = fArray[2];
        fArray[1] = (float)((double)f2 * Math.cos(f) + (double)f3 * Math.sin(f));
        fArray[2] = (float)((double)(-f2) * Math.sin(f) + (double)f3 * Math.cos(f));
        this.model.setLight(fArray);
    }

    private void rotateLightY(float f) {
        float[] fArray = this.model.getLight();
        float f2 = fArray[0];
        float f3 = fArray[2];
        fArray[0] = (float)((double)f2 * Math.cos(f) - (double)f3 * Math.sin(f));
        fArray[2] = (float)((double)f2 * Math.sin(f) + (double)f3 * Math.cos(f));
        this.model.setLight(fArray);
    }

    private void rotateCameraXbyOrig(double d) {
        Vec vec = this.model.getCamera().getOrig();
        float f = vec.getY();
        float f2 = vec.getZ();
        vec.setY((float)((double)f * Math.cos(d) + (double)f2 * Math.sin(d)));
        vec.setZ((float)((double)(-f) * Math.sin(d) + (double)f2 * Math.cos(d)));
    }

    private void rotateCameraYbyOrig(double d) {
        Vec vec = this.model.getCamera().getOrig();
        float f = vec.getX();
        float f2 = vec.getZ();
        vec.setX((float)((double)f * Math.cos(d) - (double)f2 * Math.sin(d)));
        vec.setZ((float)((double)f * Math.sin(d) + (double)f2 * Math.cos(d)));
    }

    public static final void vadd(Vec vec, Vec vec2, Vec vec3) {
        vec.setX(vec2.getX() + vec3.getX());
        vec.setY(vec2.getY() + vec3.getY());
        vec.setZ(vec2.getZ() + vec3.getZ());
    }

    public static final void vsub(Vec vec, Vec vec2, Vec vec3) {
        vec.setX(vec2.getX() - vec3.getX());
        vec.setY(vec2.getY() - vec3.getY());
        vec.setZ(vec2.getZ() - vec3.getZ());
    }

    public static final void vmul(Vec vec, float f, Vec vec2) {
        vec.setX(f * vec2.getX());
        vec.setY(f * vec2.getY());
        vec.setZ(f * vec2.getZ());
    }

    public static final float vdot(Vec vec, Vec vec2) {
        return vec.getX() * vec2.getX() + vec.getY() * vec2.getY() + vec.getZ() * vec2.getZ();
    }

    public static final void vnorm(Vec vec) {
        float f = (float)(1.0 / Math.sqrt(UserSceneController.vdot(vec, vec)));
        UserSceneController.vmul(vec, f, vec);
    }

    public static final void vxcross(Vec vec, Vec vec2, Vec vec3) {
        vec.setX(vec2.getY() * vec3.getZ() - vec2.getZ() * vec3.getY());
        vec.setY(vec2.getZ() * vec3.getX() - vec2.getX() * vec3.getZ());
        vec.setZ(vec2.getX() * vec3.getY() - vec2.getY() * vec3.getX());
    }

    private static enum MOUSE_MODE {
        DRAG_ROTATE,
        DRAG_ZOOM;

    }
}

