/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl.demos.radixsort;

import com.jogamp.opencl.CLBuffer;
import com.jogamp.opencl.CLCommandQueue;
import com.jogamp.opencl.CLContext;
import com.jogamp.opencl.CLKernel;
import com.jogamp.opencl.CLMemory;
import com.jogamp.opencl.CLProgram;
import com.jogamp.opencl.CLResource;
import com.jogamp.opencl.demos.radixsort.Scan;
import java.io.IOException;
import java.nio.IntBuffer;

public class RadixSort
implements CLResource {
    private static final int NUM_BANKS = 16;
    private static final int WARP_SIZE = 32;
    private static final int bitStep = 4;
    private final int CTA_SIZE;
    private final CLKernel ckRadixSortBlocksKeysOnly;
    private final CLKernel ckFindRadixOffsets;
    private final CLKernel ckScanNaive;
    private final CLKernel ckReorderDataKeysOnly;
    private final CLBuffer<?> tempKeys;
    private final CLBuffer<?> mCounters;
    private final CLBuffer<?> mCountersSum;
    private final CLBuffer<?> mBlockOffsets;
    private final CLCommandQueue queue;
    private final Scan scan;
    private final CLProgram program;

    public RadixSort(CLCommandQueue cLCommandQueue, int n, int n2) throws IOException {
        this.CTA_SIZE = n2;
        this.scan = new Scan(cLCommandQueue, n / 2 / n2 * 16);
        int n3 = n % (n2 * 4) == 0 ? n / (n2 * 4) : n / (n2 * 4) + 1;
        this.queue = cLCommandQueue;
        CLContext cLContext = cLCommandQueue.getContext();
        this.tempKeys = cLContext.createBuffer(4 * n, new CLMemory.Mem[]{CLMemory.Mem.READ_WRITE});
        this.mCounters = cLContext.createBuffer(128 * n3, new CLMemory.Mem[]{CLMemory.Mem.READ_WRITE});
        this.mCountersSum = cLContext.createBuffer(128 * n3, new CLMemory.Mem[]{CLMemory.Mem.READ_WRITE});
        this.mBlockOffsets = cLContext.createBuffer(128 * n3, new CLMemory.Mem[]{CLMemory.Mem.READ_WRITE});
        this.program = cLContext.createProgram(this.getClass().getResourceAsStream("RadixSort.cl")).build(new String[]{"-cl-mad-enable", CLProgram.define((String)"WARP_SIZE", (Object)32)});
        this.ckRadixSortBlocksKeysOnly = this.program.createCLKernel("radixSortBlocksKeysOnly");
        this.ckFindRadixOffsets = this.program.createCLKernel("findRadixOffsets");
        this.ckScanNaive = this.program.createCLKernel("scanNaive");
        this.ckReorderDataKeysOnly = this.program.createCLKernel("reorderDataKeysOnly");
    }

    void sort(CLBuffer<IntBuffer> cLBuffer, int n, int n2) {
        this.radixSortKeysOnly(cLBuffer, n, n2);
    }

    void radixSortKeysOnly(CLBuffer<IntBuffer> cLBuffer, int n, int n2) {
        int n3 = 0;
        while (n2 > n3 * 4) {
            this.radixSortStepKeysOnly(cLBuffer, 4, n3 * 4, n);
            ++n3;
        }
    }

    void radixSortStepKeysOnly(CLBuffer<IntBuffer> cLBuffer, int n, int n2, int n3) {
        this.radixSortBlocksKeysOnlyOCL(cLBuffer, n, n2, n3);
        this.findRadixOffsetsOCL(n2, n3);
        this.scan.scanExclusiveLarge(this.mCountersSum, this.mCounters, 1, n3 / 2 / this.CTA_SIZE * 16);
        this.reorderDataKeysOnlyOCL(cLBuffer, n2, n3);
    }

    void radixSortBlocksKeysOnlyOCL(CLBuffer<IntBuffer> cLBuffer, int n, int n2, int n3) {
        int n4 = n3 / 4 / this.CTA_SIZE;
        int n5 = this.CTA_SIZE * n4;
        int n6 = this.CTA_SIZE;
        this.ckRadixSortBlocksKeysOnly.putArg(cLBuffer).putArg(this.tempKeys).putArg(n).putArg(n2).putArg(n3).putArg(n4).putNullArg(4 * this.CTA_SIZE * 4).rewind();
        this.queue.put1DRangeKernel(this.ckRadixSortBlocksKeysOnly, 0L, (long)n5, (long)n6);
    }

    void findRadixOffsetsOCL(int n, int n2) {
        int n3 = n2 / 2 / this.CTA_SIZE;
        int n4 = this.CTA_SIZE * n3;
        int n5 = this.CTA_SIZE;
        this.ckFindRadixOffsets.putArg(this.tempKeys).putArg(this.mCounters).putArg(this.mBlockOffsets).putArg(n).putArg(n2).putArg(n3).putNullArg(2 * this.CTA_SIZE * 4).rewind();
        this.queue.put1DRangeKernel(this.ckFindRadixOffsets, 0L, (long)n4, (long)n5);
    }

    void scanNaiveOCL(int n) {
        int n2;
        int n3 = n2 = n / 2 / this.CTA_SIZE * 16;
        int n4 = n2;
        int n5 = n2 / 16;
        int n6 = 4 * (n2 + n5);
        this.ckScanNaive.putArg(this.mCountersSum).putArg(this.mCounters).putArg(n2).putNullArg(2 * n6).rewind();
        this.queue.put1DRangeKernel(this.ckScanNaive, 0L, (long)n3, (long)n4);
    }

    void reorderDataKeysOnlyOCL(CLBuffer<IntBuffer> cLBuffer, int n, int n2) {
        int n3 = n2 / 2 / this.CTA_SIZE;
        int n4 = this.CTA_SIZE * n3;
        int n5 = this.CTA_SIZE;
        this.ckReorderDataKeysOnly.putArg(cLBuffer).putArg(this.tempKeys).putArg(this.mBlockOffsets).putArg(this.mCountersSum).putArg(this.mCounters).putArg(n).putArg(n2).putArg(n3).putNullArg(2 * this.CTA_SIZE * 4).rewind();
        this.queue.put1DRangeKernel(this.ckReorderDataKeysOnly, 0L, (long)n4, (long)n5);
    }

    public void release() {
        this.scan.release();
        this.program.release();
        this.tempKeys.release();
        this.mCounters.release();
        this.mCountersSum.release();
        this.mBlockOffsets.release();
    }

    public boolean isReleased() {
        return this.scan.isReleased();
    }
}

