/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl.demos.radixsort;

import com.jogamp.opencl.CLBuffer;
import com.jogamp.opencl.CLCommandQueue;
import com.jogamp.opencl.CLContext;
import com.jogamp.opencl.CLDevice;
import com.jogamp.opencl.CLMemory;
import com.jogamp.opencl.CLPlatform;
import com.jogamp.opencl.demos.radixsort.RadixSort;
import java.io.IOException;
import java.nio.IntBuffer;
import java.util.Random;

public class RadixSortDemo {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RadixSortDemo() throws IOException {
        CLContext cLContext = null;
        try {
            cLContext = CLContext.create((CLDevice[])new CLDevice[]{CLPlatform.getDefault().getMaxFlopsDevice(new CLDevice.Type[]{CLDevice.Type.GPU})});
            CLDevice cLDevice = cLContext.getDevices()[0];
            CLCommandQueue cLCommandQueue = cLDevice.createCommandQueue();
            int n = Integer.MAX_VALUE;
            int n2 = 10;
            int[] nArray = new int[]{128, 256};
            int n3 = cLDevice.getMaxWorkGroupSize();
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] <= n3) continue;
                throw new RuntimeException("Workgroup size " + nArray[i] + " greater than device max of " + n3);
            }
            int[] nArray2 = new int[]{32768, 65536, 131072, 262144, 524288, 0x100000, 0x200000, 0x400000, 0x800000};
            for (int i = 0; i < nArray.length; ++i) {
                int n4 = nArray[i];
                System.out.println("\n = = = workgroup size: " + n4 + " = = = ");
                for (int j = 0; j < nArray2.length; ++j) {
                    if (n4 == 128 && nArray2[j] >= 0x800000 || n4 == 256 && nArray2[j] <= 32768) continue;
                    int n5 = nArray2[j];
                    CLBuffer cLBuffer = cLContext.createIntBuffer(n5, new CLMemory.Mem[]{CLMemory.Mem.READ_WRITE});
                    System.out.print("array size: " + (float)cLBuffer.getCLSize() / 1000000.0f + "MB; ");
                    System.out.println("elements: " + cLBuffer.getCLCapacity() / 1000 + "K");
                    this.fillBuffer((CLBuffer<IntBuffer>)cLBuffer, n);
                    RadixSort radixSort = new RadixSort(cLCommandQueue, n5, n4);
                    for (int k = 0; k < n2; ++k) {
                        cLCommandQueue.finish();
                        long l = System.nanoTime();
                        cLCommandQueue.putWriteBuffer(cLBuffer, false);
                        radixSort.sort((CLBuffer<IntBuffer>)cLBuffer, n5, 32);
                        cLCommandQueue.putReadBuffer(cLBuffer, true);
                        System.out.println("time: " + (float)(System.nanoTime() - l) / 1000000.0f + "ms");
                    }
                    System.out.print("snapshot: ");
                    this.printSnapshot((IntBuffer)cLBuffer.getBuffer(), 20);
                    System.out.println("validating...");
                    this.checkIfSorted((IntBuffer)cLBuffer.getBuffer());
                    System.out.println("values sorted");
                    cLBuffer.release();
                    radixSort.release();
                }
            }
        }
        finally {
            if (cLContext != null) {
                cLContext.release();
            }
        }
    }

    private void fillBuffer(CLBuffer<IntBuffer> cLBuffer, int n) {
        Random random = new Random(42L);
        for (int i = 0; i < ((IntBuffer)cLBuffer.getBuffer()).capacity(); ++i) {
            int n2 = random.nextInt(n);
            ((IntBuffer)cLBuffer.getBuffer()).put(i, n2);
        }
    }

    private void printSnapshot(IntBuffer intBuffer, int n) {
        for (int i = 0; i < n; ++i) {
            System.out.print(intBuffer.get() + ", ");
        }
        System.out.println("...; " + intBuffer.remaining() + " more");
        intBuffer.rewind();
    }

    private void checkIfSorted(IntBuffer intBuffer) {
        for (int i = 1; i < intBuffer.capacity(); ++i) {
            if (intBuffer.get(i - 1) <= intBuffer.get(i)) continue;
            throw new RuntimeException("not sorted " + intBuffer.get(i - 1) + " !> " + intBuffer.get(i));
        }
    }

    public static void main(String[] stringArray) throws IOException {
        new RadixSortDemo();
    }
}

