/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl.demos.radixsort;

import com.jogamp.opencl.CLBuffer;
import com.jogamp.opencl.CLCommandQueue;
import com.jogamp.opencl.CLContext;
import com.jogamp.opencl.CLKernel;
import com.jogamp.opencl.CLMemory;
import com.jogamp.opencl.CLProgram;
import com.jogamp.opencl.CLResource;
import java.io.IOException;

public class Scan
implements CLResource {
    private static final int MAX_WORKGROUP_INCLUSIVE_SCAN_SIZE = 1024;
    private static final int WORKGROUP_SIZE = 256;
    private static final int MAX_BATCH_ELEMENTS = 0x4000000;
    private static final int MIN_LARGE_ARRAY_SIZE = 2048;
    private static final int MAX_LARGE_ARRAY_SIZE = 262144;
    private final CLKernel ckScanExclusiveLocal1;
    private final CLKernel ckScanExclusiveLocal2;
    private final CLKernel ckUniformUpdate;
    private final CLCommandQueue queue;
    private final CLProgram program;
    private CLBuffer<?> buffer;

    public Scan(CLCommandQueue cLCommandQueue, int n) throws IOException {
        this.queue = cLCommandQueue;
        CLContext cLContext = cLCommandQueue.getContext();
        if (n > 1024) {
            this.buffer = cLContext.createBuffer(n / 1024 * 4, new CLMemory.Mem[]{CLMemory.Mem.READ_WRITE});
        }
        this.program = cLContext.createProgram(this.getClass().getResourceAsStream("Scan_b.cl")).build("-cl-mad-enable");
        this.ckScanExclusiveLocal1 = this.program.createCLKernel("scanExclusiveLocal1");
        this.ckScanExclusiveLocal2 = this.program.createCLKernel("scanExclusiveLocal2");
        this.ckUniformUpdate = this.program.createCLKernel("uniformUpdate");
    }

    void scanExclusiveLarge(CLBuffer<?> cLBuffer, CLBuffer<?> cLBuffer2, int n, int n2) {
        if (!Scan.isPowerOf2(n2)) {
            throw new RuntimeException();
        }
        if (n2 < 2048 || n2 > 262144) {
            throw new RuntimeException();
        }
        if (n * n2 > 0x4000000) {
            throw new RuntimeException();
        }
        this.scanExclusiveLocal1(cLBuffer, cLBuffer2, n * n2 / 1024, 1024);
        this.scanExclusiveLocal2(this.buffer, cLBuffer, cLBuffer2, n, n2 / 1024);
        this.uniformUpdate(cLBuffer, this.buffer, n * n2 / 1024);
    }

    void scanExclusiveLocal1(CLBuffer<?> cLBuffer, CLBuffer<?> cLBuffer2, int n, int n2) {
        this.ckScanExclusiveLocal1.putArg(cLBuffer).putArg(cLBuffer2).putNullArg(2048).putArg(n2).rewind();
        int n3 = 256;
        int n4 = n * n2 / 4;
        this.queue.put1DRangeKernel(this.ckScanExclusiveLocal1, 0L, (long)n4, (long)n3);
    }

    void scanExclusiveLocal2(CLBuffer<?> cLBuffer, CLBuffer<?> cLBuffer2, CLBuffer<?> cLBuffer3, int n, int n2) {
        int n3 = n * n2;
        this.ckScanExclusiveLocal2.putArg(cLBuffer).putArg(cLBuffer2).putArg(cLBuffer3).putNullArg(2048).putArg(n3).putArg(n2).rewind();
        int n4 = 256;
        int n5 = this.iSnapUp(n3, 256);
        this.queue.put1DRangeKernel(this.ckScanExclusiveLocal2, 0L, (long)n5, (long)n4);
    }

    void uniformUpdate(CLBuffer<?> cLBuffer, CLBuffer<?> cLBuffer2, int n) {
        this.ckUniformUpdate.setArgs(new CLMemory[]{cLBuffer, cLBuffer2});
        int n2 = 256;
        int n3 = n * 256;
        this.queue.put1DRangeKernel(this.ckUniformUpdate, 0L, (long)n3, (long)n2);
    }

    private int iSnapUp(int n, int n2) {
        return n % n2 == 0 ? n : n - n % n2 + n2;
    }

    public static boolean isPowerOf2(int n) {
        return (n - 1 & n) == 0;
    }

    public void release() {
        this.program.release();
        if (this.buffer != null) {
            this.buffer.release();
        }
    }

    public boolean isReleased() {
        return this.program.isReleased();
    }
}

