/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen;

import com.jogamp.gluegen.CodeGenUtils;
import com.jogamp.gluegen.CodeUnit;
import com.jogamp.gluegen.GlueGen;
import java.io.IOException;
import java.util.List;

public class CCodeUnit
extends CodeUnit {
    public final String cUnitName;
    public static final String NewDirectByteBufferCopyUnitCode = "static const char * nameCopyNativeToDirectByteBuffer = \"copyNativeToDirectByteBuffer\";\nstatic const char * nameCopyNativeToDirectByteBufferSignature = \"(JJ)Ljava/nio/ByteBuffer;\";\n\nstatic jobject JVMUtil_NewDirectByteBufferCopy(JNIEnv *env, jclass clazzBuffers, void * source_address, size_t capacity) {\n    jmethodID cstrBuffersNew = (*env)->GetStaticMethodID(env, clazzBuffers, nameCopyNativeToDirectByteBuffer, nameCopyNativeToDirectByteBufferSignature);\n    if(NULL==cstrBuffersNew) {\n        fprintf(stderr, \"Can't get method Buffers.%s(%s)\\n\", nameCopyNativeToDirectByteBuffer, nameCopyNativeToDirectByteBufferSignature);\n        (*env)->FatalError(env, nameCopyNativeToDirectByteBuffer);\n        return JNI_FALSE;\n    }\n    jobject jbyteBuffer  = (*env)->CallStaticObjectMethod(env, clazzBuffers, cstrBuffersNew, (jlong)(intptr_t)source_address, (jlong)capacity);\n    if( (*env)->ExceptionCheck(env) ) {\n        (*env)->ExceptionDescribe(env);\n        (*env)->ExceptionClear(env);\n        (*env)->FatalError(env, \"Exception occurred\");\n        return NULL;\n    }\n    return jbyteBuffer;\n}\n";

    public CCodeUnit(String string, String string2, Object object) throws IOException {
        super(string, object);
        this.cUnitName = string2;
        CodeGenUtils.emitAutogeneratedWarning(this.output, object, "C-Unit: " + string2 + ", " + string);
    }

    public void emitHeader(String string, String string2, List<String> list) {
        this.emitln("#include <jni.h>");
        this.emitln("#include <stdlib.h>");
        this.emitln("#include <string.h>");
        this.emitln("#include <assert.h>");
        this.emitln("#include <stddef.h>");
        this.emitln();
        this.emitJNIEnvDecl();
        this.emitln();
        this.emitln("static jobject JVMUtil_NewDirectByteBufferCopy(JNIEnv *env, jclass clazzBuffers, void * source_address, size_t capacity); /* forward decl. */");
        this.emitln();
        boolean bl = false;
        for (String string3 : list) {
            this.emitln(string3);
            bl = bl || string3.contains("JVMUtil_NewDirectByteBufferCopy");
        }
        this.emitln();
        if (bl) {
            this.addTailCode(NewDirectByteBufferCopyUnitCode);
        }
    }

    public void emitJNIEnvDecl() {
        this.emitln(CCodeUnit.getJNIEnvDecl());
    }

    public void emitJNIOnLoadJNIEnvCode(String string) {
        this.emitln(CCodeUnit.getJNIOnLoadJNIEnvCode(string));
    }

    @Override
    public String toString() {
        return "CCodeUnit[unit " + this.cUnitName + ", file " + this.filename + "]";
    }

    public static final String getJNIEnvDecl() {
        return "JavaVM* JVMUtil_GetJavaVM();\nJNIEnv* JVMUtil_GetJNIEnv(int asDaemon, int* jvmAttached);\nvoid JVMUtil_ReleaseJNIEnv(JNIEnv* env, int detachJVM);\n";
    }

    public static final String getJNIOnLoadJNIEnvCode(String string) {
        String string2 = string + "_jvmHandle";
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("static JavaVM *").append(string2).append(" = NULL;\n");
        stringBuilder.append("\n");
        stringBuilder.append("JavaVM* JVMUtil_GetJavaVM() {\n");
        stringBuilder.append("  return ").append(string2).append(";\n");
        stringBuilder.append("}\n");
        stringBuilder.append("JNIEXPORT jint JNICALL JNI_OnLoad(JavaVM *initVM, void *reserved) {\n");
        stringBuilder.append("  (void)reserved;\n");
        stringBuilder.append("  ").append(string2).append(" = initVM;\n");
        if (GlueGen.debug()) {
            stringBuilder.append("  fprintf(stderr, \"ON_LOAD_0 lib '").append(string).append("'\\n\");\n");
        }
        stringBuilder.append("  return JNI_VERSION_1_6;\n");
        stringBuilder.append("}\n");
        stringBuilder.append("JNIEXPORT jint JNICALL JNI_OnLoad_").append(string).append("(JavaVM *initVM, void *reserved) {\n");
        stringBuilder.append("  (void)reserved;\n");
        stringBuilder.append("  ").append(string2).append(" = initVM;\n");
        if (GlueGen.debug()) {
            stringBuilder.append("  fprintf(stderr, \"ON_LOAD_1 lib '").append(string).append("'\\n\");\n");
        }
        stringBuilder.append("  return JNI_VERSION_1_6;\n");
        stringBuilder.append("}\n");
        stringBuilder.append("\n");
        stringBuilder.append("JNIEXPORT void JNICALL JNI_OnUnload(JavaVM *vm, void *reserved) {\n");
        stringBuilder.append("  (void)vm;\n");
        stringBuilder.append("  (void)reserved;\n");
        stringBuilder.append("  ").append(string2).append(" = NULL;\n");
        if (GlueGen.debug()) {
            stringBuilder.append("  fprintf(stderr, \"ON_UNLOAD_0 lib '").append(string).append("'\\n\");\n");
        }
        stringBuilder.append("}\n");
        stringBuilder.append("\n");
        stringBuilder.append("JNIEXPORT void JNICALL JNI_OnUnload_").append(string).append("(JavaVM *vm, void *reserved) {\n");
        stringBuilder.append("  (void)vm;\n");
        stringBuilder.append("  (void)reserved;\n");
        stringBuilder.append("  ").append(string2).append(" = NULL;\n");
        if (GlueGen.debug()) {
            stringBuilder.append("  fprintf(stderr, \"ON_UNLOAD_1 lib '").append(string).append("'\\n\");\n");
        }
        stringBuilder.append("}\n");
        stringBuilder.append("\n");
        stringBuilder.append("JNIEnv* JVMUtil_GetJNIEnv(int asDaemon, int* jvmAttached) {\n");
        stringBuilder.append("    JNIEnv* curEnv = NULL;\n");
        stringBuilder.append("    JNIEnv* newEnv = NULL;\n");
        stringBuilder.append("    int envRes;\n");
        stringBuilder.append("\n");
        stringBuilder.append("    if( NULL != jvmAttached ) {\n");
        stringBuilder.append("      *jvmAttached = 0;\n");
        stringBuilder.append("    }\n");
        stringBuilder.append("    if(NULL==").append(string2).append(") {\n");
        stringBuilder.append("        fprintf(stderr, \"JVMUtil_GetJNIEnv(").append(string).append("): No JavaVM handle registered.\\n\");\n");
        stringBuilder.append("        return NULL;\n");
        stringBuilder.append("    }\n");
        stringBuilder.append("\n");
        stringBuilder.append("    // retrieve this thread's JNIEnv curEnv - or detect it's detached\n");
        stringBuilder.append("    envRes = (*").append(string2).append(")->GetEnv(").append(string2).append(", (void **) &curEnv, JNI_VERSION_1_6) ;\n");
        stringBuilder.append("    if( JNI_EDETACHED == envRes ) {\n");
        stringBuilder.append("        // detached thread - attach to JVM as daemon, w/o need to be detached!\n");
        stringBuilder.append("        if( asDaemon ) {\n");
        stringBuilder.append("            envRes = (*").append(string2).append(")->AttachCurrentThreadAsDaemon(").append(string2).append(", (void**) &newEnv, NULL);\n");
        stringBuilder.append("        } else {\n");
        stringBuilder.append("            envRes = (*").append(string2).append(")->AttachCurrentThread(").append(string2).append(", (void**) &newEnv, NULL);\n");
        stringBuilder.append("        }\n");
        stringBuilder.append("        if( JNI_OK != envRes ) {\n");
        stringBuilder.append("            fprintf(stderr, \"JVMUtil_GetJNIEnv(").append(string).append("): Can't attach thread: %d\\n\", envRes);\n");
        stringBuilder.append("            return NULL;\n");
        stringBuilder.append("        }\n");
        stringBuilder.append("        curEnv = newEnv;\n");
        stringBuilder.append("    } else if( JNI_OK != envRes ) {\n");
        stringBuilder.append("        // oops ..\n");
        stringBuilder.append("        fprintf(stderr, \"JVMUtil_GetJNIEnv(").append(string).append("): Can't GetEnv: %d\\n\", envRes);\n");
        stringBuilder.append("        return NULL;\n");
        stringBuilder.append("    }\n");
        stringBuilder.append("    if (curEnv==NULL) {\n");
        stringBuilder.append("        fprintf(stderr, \"JVMUtil_GetJNIEnv(").append(string).append("): env is NULL\\n\");\n");
        stringBuilder.append("        return NULL;\n");
        stringBuilder.append("    }\n");
        stringBuilder.append("    if( NULL != jvmAttached ) {\n");
        stringBuilder.append("      *jvmAttached = NULL != newEnv;\n");
        stringBuilder.append("    }\n");
        if (GlueGen.debug()) {
            stringBuilder.append("    fprintf(stderr, \"JVMUtil_GetJNIEnv(").append(string).append(", asDaemon %d): jvmAttached %d -> env %p\\n.\", asDaemon, (NULL != newEnv), curEnv);\n");
        }
        stringBuilder.append("    return curEnv;\n");
        stringBuilder.append("}\n");
        stringBuilder.append("\n");
        stringBuilder.append("void JVMUtil_ReleaseJNIEnv(JNIEnv* env, int detachJVM) {\n");
        stringBuilder.append("    if(NULL==").append(string2).append(") {\n");
        stringBuilder.append("        fprintf(stderr, \"JVMUtil_ReleaseJNIEnv(").append(string).append("): No JavaVM handle registered.\\n\");\n");
        stringBuilder.append("        return;\n");
        stringBuilder.append("    }\n");
        stringBuilder.append("    if( detachJVM ) {\n");
        stringBuilder.append("      jint res = (*").append(string2).append(")->DetachCurrentThread(").append(string2).append(") ;\n");
        stringBuilder.append("      if( 0 != res ) {\n");
        stringBuilder.append("        fprintf(stderr, \"JVMUtil_ReleaseJNIEnv(").append(string).append(", env %p): Failed with res %d\\n.\", env, res);\n");
        stringBuilder.append("        return;\n");
        stringBuilder.append("      }\n");
        if (GlueGen.debug()) {
            stringBuilder.append("      fprintf(stderr, \"JVMUtil_ReleaseJNIEnv(").append(string).append(", env %p) -> res %d\\n.\", env, res);\n");
        }
        stringBuilder.append("    }\n");
        stringBuilder.append("}\n");
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }
}

