/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen;

import com.jogamp.gluegen.CMethodBindingEmitter;
import com.jogamp.gluegen.CodeGenUtils;
import com.jogamp.gluegen.CodeUnit;
import com.jogamp.gluegen.JavaConfiguration;
import com.jogamp.gluegen.JavaType;
import com.jogamp.gluegen.MethodBinding;
import com.jogamp.gluegen.cgram.types.Type;
import java.nio.ByteBuffer;

public final class JavaCallbackEmitter {
    final JavaConfiguration cfg;
    final MethodBinding binding;
    final String setFuncSignature;
    final JavaConfiguration.JavaCallbackInfo info;
    final String capIfaceName;
    final String lowIfaceName;
    final String lockInstanceName;
    final String dataMapInstanceName;
    final String dataInstanceName;
    final String DataClassName;
    final String fqUsrParamClassName;
    final JavaType cbFuncJavaReturnType;
    final String jcbNextIDVarName;
    final boolean userParamDefined;
    final String setFuncCBArgName;
    final Type setFuncUserParamCType;
    final JavaType setFuncUserParamJType;
    final String setFuncUserParamTypeName;
    final String setFuncUserParamArgName;
    final boolean userParamIsKey;
    final boolean userParamIsCompound;
    final boolean userParamIsMappedToID;
    final String userParamIDMapInstanceName;
    final String userParamClassName;
    final boolean customKeyClass;
    final String KeyClassName;
    final boolean useDataMap;

    public JavaCallbackEmitter(JavaConfiguration javaConfiguration, MethodBinding methodBinding, JavaConfiguration.JavaCallbackInfo javaCallbackInfo, String string) {
        this.cfg = javaConfiguration;
        this.binding = methodBinding;
        this.setFuncSignature = string;
        this.info = javaCallbackInfo;
        this.capIfaceName = CodeGenUtils.capitalizeString(methodBinding.getInterfaceName());
        this.lowIfaceName = CodeGenUtils.decapitalizeString(methodBinding.getInterfaceName());
        this.lockInstanceName = this.lowIfaceName + "Lock";
        this.dataMapInstanceName = this.lowIfaceName + "DataMap";
        this.dataInstanceName = this.lowIfaceName + "Data";
        this.DataClassName = this.capIfaceName + "Data";
        this.fqUsrParamClassName = javaConfiguration.packageName() + "." + javaConfiguration.className() + "." + this.DataClassName;
        this.cbFuncJavaReturnType = javaCallbackInfo.cbFuncBinding.getJavaReturnType();
        this.jcbNextIDVarName = "NEXT_" + this.capIfaceName + "_ID";
        this.setFuncCBArgName = this.binding.getArgumentName(javaCallbackInfo.setFuncCBParamIdx);
        boolean bl = this.userParamDefined = javaCallbackInfo.setFuncUserParamIdx >= 0;
        if (!this.userParamDefined) {
            this.setFuncUserParamCType = null;
            this.setFuncUserParamJType = null;
            this.setFuncUserParamTypeName = null;
            this.setFuncUserParamArgName = null;
            this.userParamIsKey = false;
        } else {
            this.setFuncUserParamCType = methodBinding.getCArgumentType(javaCallbackInfo.setFuncUserParamIdx);
            this.setFuncUserParamJType = methodBinding.getJavaArgumentType(javaCallbackInfo.setFuncUserParamIdx);
            this.setFuncUserParamTypeName = this.setFuncUserParamJType.getName();
            this.setFuncUserParamArgName = this.binding.getArgumentName(javaCallbackInfo.setFuncUserParamIdx);
            this.userParamIsKey = this.info.setFuncKeyIndices.contains(this.info.setFuncUserParamIdx);
        }
        if (null != this.setFuncUserParamJType && !this.setFuncUserParamJType.isLong()) {
            if (this.setFuncUserParamJType.isCompoundTypeWrapper()) {
                this.userParamIsCompound = true;
                this.userParamIsMappedToID = false;
                this.userParamIDMapInstanceName = null;
            } else {
                this.userParamIsCompound = false;
                this.userParamIsMappedToID = true;
                this.userParamIDMapInstanceName = this.userParamIsKey ? this.lowIfaceName + "UserObjIDMap" : null;
            }
        } else {
            this.userParamIsCompound = false;
            this.userParamIsMappedToID = false;
            this.userParamIDMapInstanceName = null;
        }
        this.userParamClassName = this.userParamDefined ? (this.userParamIsCompound ? this.setFuncUserParamTypeName : (null != javaCallbackInfo.userParamClassName ? javaCallbackInfo.userParamClassName : "Object")) : null;
        if (null != javaCallbackInfo.customKeyClassName) {
            this.customKeyClass = true;
            this.KeyClassName = javaCallbackInfo.customKeyClassName;
            this.useDataMap = true;
        } else {
            this.customKeyClass = false;
            this.KeyClassName = this.capIfaceName + "Key";
            this.useDataMap = javaCallbackInfo.setFuncKeyIndices.size() > 0;
        }
    }

    public void emitJavaAdditionalCode(CodeUnit codeUnit, boolean bl) {
        if (bl) {
            if (this.useDataMap) {
                if (!this.customKeyClass && !this.info.keyClassEmitted) {
                    this.emitJavaKeyClass(codeUnit);
                    codeUnit.emitln();
                    this.info.keyClassEmitted = true;
                }
                this.emitJavaBriefAPIDoc(codeUnit, "Returns ", "set of ", "", "for ");
                codeUnit.emitln("  public Set<" + this.KeyClassName + "> get" + this.capIfaceName + "Keys();");
                codeUnit.emitln();
                this.emitJavaBriefAPIDoc(codeUnit, "Returns ", "whether callback ", "if callback ", "is mapped for ");
                codeUnit.emitln("  public boolean is" + this.capIfaceName + "Mapped(" + this.KeyClassName + " key);");
                codeUnit.emitln();
                this.emitJavaBriefAPIDoc(codeUnit, "Returns " + this.info.cbFuncTypeName + " callback ", "mapped to ", "", "for ");
                codeUnit.emitln("  public " + this.info.cbFuncTypeName + " get" + this.capIfaceName + "(" + this.KeyClassName + " key);");
                codeUnit.emitln();
                if (this.userParamDefined) {
                    this.emitJavaBriefAPIDoc(codeUnit, "Returns user-param ", "mapped to ", "", "for ");
                    codeUnit.emitln("  public " + this.userParamClassName + " get" + this.capIfaceName + "UserParam(" + this.KeyClassName + " key);");
                    codeUnit.emitln();
                }
                this.emitJavaBriefAPIDoc(codeUnit, "Releases all callback data ", "mapped via ", "", "skipping toolkit API. Favor passing `null` callback ref to ");
                codeUnit.emitln("  public int releaseAll" + this.capIfaceName + "();");
                codeUnit.emitln();
                this.emitJavaBriefAPIDoc(codeUnit, "Releases callback data ", "mapped to ", "", "skipping toolkit API. Favor passing `null` callback ref to ");
                codeUnit.emitln("  public void release" + this.capIfaceName + "(" + this.KeyClassName + " key);");
                codeUnit.emitln();
            } else {
                this.emitJavaBriefAPIDoc(codeUnit, "Returns ", "whether callback ", "if callback ", "is mapped for ");
                codeUnit.emitln("  public boolean is" + this.capIfaceName + "Mapped();");
                codeUnit.emitln();
                this.emitJavaBriefAPIDoc(codeUnit, "Returns " + this.info.cbFuncTypeName + " callback ", "mapped to ", "", "for ");
                codeUnit.emitln("  public " + this.info.cbFuncTypeName + " get" + this.capIfaceName + "();");
                codeUnit.emitln();
                if (this.userParamDefined) {
                    this.emitJavaBriefAPIDoc(codeUnit, "Returns user-param ", "mapped to ", "", "for ");
                    codeUnit.emitln("  public " + this.userParamClassName + " get" + this.capIfaceName + "UserParam();");
                    codeUnit.emitln();
                }
                this.emitJavaBriefAPIDoc(codeUnit, "Releases callback data ", "", "", "skipping toolkit API. Favor passing `null` callback ref to ");
                codeUnit.emitln("  public void release" + this.capIfaceName + "();");
                codeUnit.emitln();
            }
        } else {
            if (this.useDataMap) {
                if (!this.customKeyClass && !this.info.keyClassEmitted) {
                    this.emitJavaKeyClass(codeUnit);
                    codeUnit.emitln();
                    this.info.keyClassEmitted = true;
                }
                this.emitJavaBriefAPIDoc(codeUnit, "Returns ", "set of ", "", "for ");
                codeUnit.emitln("  public final Set<" + this.KeyClassName + "> get" + this.capIfaceName + "Keys() {");
                codeUnit.emitln("    synchronized( " + this.lockInstanceName + " ) {");
                codeUnit.emitln("      return " + this.dataMapInstanceName + ".keySet();");
                codeUnit.emitln("    }");
                codeUnit.emitln("  }");
                codeUnit.emitln();
                this.emitJavaBriefAPIDoc(codeUnit, "Returns ", "whether callback ", "if callback ", "is mapped for ");
                codeUnit.emitln("  public final boolean is" + this.capIfaceName + "Mapped(" + this.KeyClassName + " key) {");
                codeUnit.emitln("    synchronized( " + this.lockInstanceName + " ) {");
                codeUnit.emitln("      return null != " + this.dataMapInstanceName + ".get(key);");
                codeUnit.emitln("    }");
                codeUnit.emitln("  }");
                codeUnit.emitln();
                this.emitJavaBriefAPIDoc(codeUnit, "Returns " + this.info.cbFuncTypeName + " callback ", "mapped to ", "", "for ");
                codeUnit.emitln("  public final " + this.info.cbFuncTypeName + " get" + this.capIfaceName + "(" + this.KeyClassName + " key) {");
                codeUnit.emitln("    synchronized( " + this.lockInstanceName + " ) {");
                codeUnit.emitln("      final " + this.DataClassName + " value = " + this.dataMapInstanceName + ".get(key);");
                codeUnit.emitln("      return null != value ? value.func : null;");
                codeUnit.emitln("    }");
                codeUnit.emitln("  }");
                codeUnit.emitln();
                if (this.userParamDefined) {
                    this.emitJavaBriefAPIDoc(codeUnit, "Returns user-param ", "mapped to ", "", "for ");
                    codeUnit.emitln("  public final " + this.userParamClassName + " get" + this.capIfaceName + "UserParam(" + this.KeyClassName + " key) {");
                    codeUnit.emitln("    synchronized( " + this.lockInstanceName + " ) {");
                    codeUnit.emitln("      final " + this.DataClassName + " value = " + this.dataMapInstanceName + ".get(key);");
                    codeUnit.emitln("      return null != value ? value.param : null;");
                    codeUnit.emitln("    }");
                    codeUnit.emitln("  }");
                    codeUnit.emitln();
                }
                this.emitJavaBriefAPIDoc(codeUnit, "Releases all callback data ", "mapped via ", "", "skipping toolkit API. Favor passing `null` callback ref to ");
                codeUnit.emitln("  public final int releaseAll" + this.capIfaceName + "() {");
                codeUnit.emitln("    synchronized( " + this.lockInstanceName + " ) {");
                codeUnit.emitln("      final Set<" + this.KeyClassName + "> keySet = " + this.dataMapInstanceName + ".keySet();");
                codeUnit.emitln("      final " + this.KeyClassName + "[] keys = keySet.toArray(new " + this.KeyClassName + "[keySet.size()]);");
                codeUnit.emitln("      for(int i=0; i<keys.length; ++i) {");
                codeUnit.emitln("        final " + this.KeyClassName + " key = keys[i];");
                codeUnit.emitln("          release" + this.capIfaceName + "(key);");
                codeUnit.emitln("      }");
                codeUnit.emitln("      return keys.length;");
                codeUnit.emitln("    }");
                codeUnit.emitln("  }");
                codeUnit.emitln();
                this.emitJavaBriefAPIDoc(codeUnit, "Releases callback data ", "mapped to ", "", "skipping toolkit API. Favor passing `null` callback ref to ");
                codeUnit.emitln("  public final void release" + this.capIfaceName + "(" + this.KeyClassName + " key) {");
                codeUnit.emitln("    synchronized( " + this.lockInstanceName + " ) {");
                if (this.userParamIsMappedToID && this.userParamIsKey) {
                    codeUnit.emitln("      " + this.DataClassName + " value = " + this.dataMapInstanceName + ".remove(key);");
                    codeUnit.emitln("      if( null != value ) {");
                    codeUnit.emitln("        " + this.userParamIDMapInstanceName + ".remove(value.paramID);");
                    codeUnit.emitln("      }");
                } else {
                    codeUnit.emitln("      /* " + this.DataClassName + " value = */ " + this.dataMapInstanceName + ".remove(key);");
                }
                codeUnit.emitln("    }");
                codeUnit.emitln("  }");
                codeUnit.emitln();
            } else {
                this.emitJavaBriefAPIDoc(codeUnit, "Returns ", "whether callback ", "if callback ", "is mapped for ");
                codeUnit.emitln("  public final boolean is" + this.capIfaceName + "Mapped() {");
                codeUnit.emitln("    synchronized( " + this.lockInstanceName + " ) {");
                codeUnit.emitln("      return null != " + this.dataInstanceName + ";");
                codeUnit.emitln("    }");
                codeUnit.emitln("  }");
                codeUnit.emitln();
                this.emitJavaBriefAPIDoc(codeUnit, "Returns " + this.info.cbFuncTypeName + " callback ", "mapped to ", "", "for ");
                codeUnit.emitln("  public final " + this.info.cbFuncTypeName + " get" + this.capIfaceName + "() {");
                codeUnit.emitln("    synchronized( " + this.lockInstanceName + " ) {");
                codeUnit.emitln("      final " + this.DataClassName + " value = " + this.dataInstanceName + ";");
                codeUnit.emitln("      return null != value ? value.func : null;");
                codeUnit.emitln("    }");
                codeUnit.emitln("  }");
                codeUnit.emitln();
                if (this.userParamDefined) {
                    this.emitJavaBriefAPIDoc(codeUnit, "Returns user-param ", "mapped to ", "", "for ");
                    codeUnit.emitln("  public final " + this.userParamClassName + " get" + this.capIfaceName + "UserParam() {");
                    codeUnit.emitln("    synchronized( " + this.lockInstanceName + " ) {");
                    codeUnit.emitln("      final " + this.DataClassName + " value = " + this.dataInstanceName + ";");
                    codeUnit.emitln("      return null != value ? value.param : null;");
                    codeUnit.emitln("    }");
                    codeUnit.emitln("  }");
                    codeUnit.emitln();
                }
                this.emitJavaBriefAPIDoc(codeUnit, "Releases callback data ", "", "", "skipping toolkit API. Favor passing `null` callback ref to ");
                codeUnit.emitln("  public final void release" + this.capIfaceName + "() {");
                codeUnit.emitln("    synchronized( " + this.lockInstanceName + " ) {");
                codeUnit.emitln("      // final " + this.DataClassName + " value = " + this.dataInstanceName + ";");
                if (this.userParamIsMappedToID && this.userParamIsKey) {
                    codeUnit.emitln("      " + this.userParamIDMapInstanceName + ".remove(dataInstanceName.paramID);");
                }
                codeUnit.emitln("      " + this.dataInstanceName + " = null;");
                codeUnit.emitln("    }");
                codeUnit.emitln("  }");
                codeUnit.emitln();
            }
            codeUnit.emitln("  private final void add" + this.capIfaceName + "(" + this.binding.getJavaSelectParameter(new StringBuilder(), this.info.setFuncKeyIndices, true).toString() + this.DataClassName + " value) {");
            if (this.useDataMap) {
                codeUnit.emitln("    final " + this.KeyClassName + " key = new " + this.KeyClassName + "(" + this.binding.getJavaCallSelectArguments(new StringBuilder(), this.info.setFuncKeyIndices, false).toString() + ");");
                if (this.userParamIsMappedToID && this.userParamIsKey) {
                    codeUnit.emitln("    final " + this.DataClassName + " old = " + this.dataMapInstanceName + ".put(key, value);");
                } else {
                    codeUnit.emitln("    /* final " + this.DataClassName + " old = */ " + this.dataMapInstanceName + ".put(key, value);");
                }
            } else {
                if (this.userParamIsMappedToID && this.userParamIsKey) {
                    codeUnit.emitln("    final " + this.DataClassName + " old = " + this.dataInstanceName + ";");
                } else {
                    codeUnit.emitln("    // final " + this.DataClassName + " old = " + this.dataInstanceName + ";");
                }
                codeUnit.emitln("    " + this.dataInstanceName + " = value;");
            }
            if (this.userParamIsMappedToID && this.userParamIsKey) {
                codeUnit.emitln("    if( null != old ) {");
                codeUnit.emitln("      " + this.userParamIDMapInstanceName + ".remove(old.paramID);");
                codeUnit.emitln("    }");
                codeUnit.emitln("    if( null != value.param ) {");
                codeUnit.emitln("      " + this.userParamIDMapInstanceName + ".put(value.paramID, value.param);");
                codeUnit.emitln("    }");
            }
            codeUnit.emitln("  }");
            codeUnit.emitln();
            if (!this.cfg.emittedJavaCallbackUserParamClasses.contains(this.fqUsrParamClassName)) {
                this.emitJavaDataClass(codeUnit);
                this.cfg.emittedJavaCallbackUserParamClasses.add(this.fqUsrParamClassName);
            }
            if (this.useDataMap) {
                codeUnit.emitln("  private static final Map<" + this.KeyClassName + ", " + this.DataClassName + "> " + this.dataMapInstanceName + " = new HashMap<" + this.KeyClassName + ", " + this.DataClassName + ">();");
            } else {
                codeUnit.emitln("  private static " + this.DataClassName + " " + this.dataInstanceName + " = null;");
            }
            if (this.userParamIsMappedToID && this.userParamIsKey) {
                codeUnit.emitln("  private static final LongObjectHashMap " + this.userParamIDMapInstanceName + " = new LongObjectHashMap();");
            }
            codeUnit.emitln("  private static long " + this.jcbNextIDVarName + " = 1;");
            codeUnit.emitln("  private static final Object " + this.lockInstanceName + " = new Object();");
            codeUnit.emitln();
            this.emitJavaStaticCallback(codeUnit);
        }
    }

    private final void emitJavaBriefAPIDoc(CodeUnit codeUnit, String string, String string2, String string3, String string4) {
        codeUnit.emit("  /** " + string);
        if (this.info.setFuncKeyIndices.size() > 0) {
            codeUnit.emit(string2);
            codeUnit.emit("Key { " + this.binding.getJavaSelectParameter(new StringBuilder(), this.info.setFuncKeyIndices, false).toString() + " } ");
        } else {
            codeUnit.emit(string3);
        }
        codeUnit.emit(string4);
        codeUnit.emitln("<br> <code>" + this.setFuncSignature + "</code> */");
    }

    private final void emitJavaKeyClass(CodeUnit codeUnit) {
        if (this.cfg.shouldIgnoreInInterface(this.KeyClassName)) {
            return;
        }
        this.emitJavaBriefAPIDoc(codeUnit, "", "", "", "for ");
        codeUnit.emitln("  public static class " + this.KeyClassName + " {");
        this.binding.forEachParameter((n, n2, type, javaType, string) -> {
            if (!type.isVoid() && this.info.setFuncKeyIndices.contains(n)) {
                codeUnit.emitln("    public final " + javaType + " " + string + ";");
                return true;
            }
            return false;
        });
        codeUnit.emitln("    public " + this.KeyClassName + "(" + this.binding.getJavaSelectParameter(new StringBuilder(), this.info.setFuncKeyIndices, false).toString() + ") {");
        this.binding.forEachParameter((n, n2, type, javaType, string) -> {
            if (!type.isVoid() && this.info.setFuncKeyIndices.contains(n)) {
                codeUnit.emitln("      this." + string + " = " + string + ";");
                return true;
            }
            return false;
        });
        codeUnit.emitln("    }");
        codeUnit.emitln("    @Override");
        codeUnit.emitln("    public boolean equals(final Object o) {");
        codeUnit.emitln("      if( this == o ) {");
        codeUnit.emitln("        return true;");
        codeUnit.emitln("      }");
        codeUnit.emitln("      if( !(o instanceof " + this.KeyClassName + ") ) {");
        codeUnit.emitln("        return false;");
        codeUnit.emitln("      }");
        int n3 = this.binding.forEachParameter((n, n2, type, javaType, string) -> {
            if (!type.isVoid() && this.info.setFuncKeyIndices.contains(n)) {
                if (0 == n2) {
                    codeUnit.emitln("      final " + this.KeyClassName + " o2 = (" + this.KeyClassName + ")o;");
                    codeUnit.emit("      return ");
                } else {
                    codeUnit.emitln(" &&");
                    codeUnit.emit("             ");
                }
                if (javaType.isCompoundTypeWrapper()) {
                    codeUnit.emit(string + ".getDirectBufferAddress() == o2." + string + ".getDirectBufferAddress()");
                } else if (javaType.isPrimitive() || n == this.info.setFuncUserParamIdx) {
                    codeUnit.emit(string + " == o2." + string);
                } else {
                    codeUnit.emit(string + ".equals( o2." + string + " )");
                }
                return true;
            }
            return false;
        });
        if (0 == n3) {
            codeUnit.emit("      return true");
        }
        codeUnit.emitln(";");
        codeUnit.emitln("    }");
        codeUnit.emitln("    @Override");
        codeUnit.emitln("    public int hashCode() {");
        n3 = this.binding.forEachParameter((n, n2, type, javaType, string) -> {
            if (!type.isVoid() && this.info.setFuncKeyIndices.contains(n)) {
                if (0 == n2) {
                    codeUnit.emitln("      // 31 * x == (x << 5) - x");
                    codeUnit.emit("      int hash = ");
                } else {
                    codeUnit.emit("      hash = ((hash << 5) - hash) + ");
                }
                if (javaType.isPrimitive()) {
                    if (javaType.isLong()) {
                        codeUnit.emitln("HashUtil.getAddrHash32_EqualDist( " + string + " );");
                    } else {
                        codeUnit.emitln(string + ";");
                    }
                } else if (javaType.isCompoundTypeWrapper()) {
                    codeUnit.emitln("HashUtil.getAddrHash32_EqualDist( " + string + ".getDirectBufferAddress() );");
                } else if (n == this.info.setFuncUserParamIdx) {
                    codeUnit.emitln("System.identityHashCode( " + string + " );");
                } else {
                    codeUnit.emitln(string + ".hashCode();");
                }
                return true;
            }
            return false;
        });
        if (0 == n3) {
            codeUnit.emitln("      return 0;");
        } else {
            codeUnit.emitln("      return hash;");
        }
        codeUnit.emitln("    }");
        codeUnit.emitln("  }");
    }

    private final void emitJavaDataClass(CodeUnit codeUnit) {
        codeUnit.emitln("  private static class " + this.DataClassName + " {");
        codeUnit.emitln("    final " + this.info.cbFuncTypeName + " func;");
        if (this.userParamDefined) {
            codeUnit.emitln("    // userParamArgCType " + this.setFuncUserParamCType);
            codeUnit.emitln("    // userParamArgJType " + this.setFuncUserParamJType);
            codeUnit.emitln("    final " + this.setFuncUserParamTypeName + " param;");
            if (this.userParamIsMappedToID) {
                codeUnit.emitln("    final long paramID;");
            }
        } else {
            codeUnit.emitln("    // No user param defined.");
        }
        codeUnit.emit("    " + this.DataClassName + "(final " + this.info.cbFuncTypeName + " func");
        if (this.userParamDefined) {
            if (this.userParamIsMappedToID) {
                codeUnit.emit(", final long paramID");
            }
            codeUnit.emit(", final " + this.setFuncUserParamTypeName + " param");
        }
        codeUnit.emitln(") {");
        codeUnit.emitln("      this.func = func;");
        if (this.userParamDefined) {
            if (this.userParamIsMappedToID) {
                codeUnit.emitln("      this.paramID = paramID;");
            }
            codeUnit.emitln("      this.param = param;");
        }
        codeUnit.emitln("    }");
        codeUnit.emitln("  }");
    }

    public final String getJavaStaticCallbackSignature() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        this.info.cbFuncBinding.forEachParameter((n, n2, type, javaType, string) -> {
            if (!type.isVoid() && !javaType.isPascalLen()) {
                if (n == this.info.cbFuncUserParamIdx) {
                    stringBuilder.append("J");
                } else {
                    stringBuilder.append(javaType.getDescriptor(this.cfg));
                }
                return true;
            }
            return false;
        });
        stringBuilder.append(")");
        stringBuilder.append(this.cbFuncJavaReturnType.getDescriptor(this.cfg));
        return stringBuilder.toString();
    }

    public final int appendJavaAdditionalJNIParameter(StringBuilder stringBuilder) {
        stringBuilder.append("Class<?> staticCBClazz, String callbackSignature");
        if (!this.userParamDefined) {
            return 2;
        }
        stringBuilder.append(", long nativeUserParam");
        return 3;
    }

    public final int appendJavaAdditionalJNIArguments(StringBuilder stringBuilder) {
        stringBuilder.append("this.getClass(), \"" + this.getJavaStaticCallbackSignature() + "\"");
        if (!this.userParamDefined) {
            return 2;
        }
        stringBuilder.append(", nativeUserParam");
        return 3;
    }

    public void emitJavaSetFuncPreCall(CodeUnit codeUnit) {
        if (this.userParamDefined) {
            codeUnit.emitln("    final long nativeUserParam;");
        }
        codeUnit.emitln("    synchronized( " + this.lockInstanceName + " ) {");
        if (this.userParamDefined) {
            if (this.setFuncUserParamJType.isLong()) {
                codeUnit.emitln("      nativeUserParam = " + this.setFuncUserParamArgName + ";");
            } else {
                codeUnit.emitln("      if( null != " + this.setFuncUserParamArgName + " ) {");
                if (this.setFuncUserParamJType.isCompoundTypeWrapper()) {
                    codeUnit.emitln("        nativeUserParam = " + this.setFuncUserParamArgName + ".getDirectBufferAddress();");
                } else {
                    codeUnit.emitln("        nativeUserParam = " + this.jcbNextIDVarName + "++;");
                    codeUnit.emitln("        if( 0 >= " + this.jcbNextIDVarName + " ) { " + this.jcbNextIDVarName + " = 1; }");
                }
                codeUnit.emitln("      } else {");
                codeUnit.emitln("        nativeUserParam = 0;");
                codeUnit.emitln("      }");
            }
        }
        codeUnit.emitln("      if( null != " + this.setFuncCBArgName + " ) {");
        codeUnit.emit("        add" + this.capIfaceName + "(" + this.binding.getJavaCallSelectArguments(new StringBuilder(), this.info.setFuncKeyIndices, true).toString() + "new " + this.DataClassName + "(" + this.setFuncCBArgName);
        if (this.userParamDefined) {
            if (this.userParamIsMappedToID) {
                codeUnit.emit(", nativeUserParam");
            }
            codeUnit.emit(", " + this.setFuncUserParamArgName);
        }
        codeUnit.emitln("));");
        codeUnit.emitln("      } else { ");
        codeUnit.emitln("        // release a previously mapped instance ");
        if (this.useDataMap) {
            codeUnit.emitln("        release" + this.capIfaceName + "( new " + this.KeyClassName + "( " + this.binding.getJavaCallSelectArguments(new StringBuilder(), this.info.setFuncKeyIndices, false).toString() + " ) );");
        } else {
            codeUnit.emitln("        release" + this.capIfaceName + "();");
        }
        codeUnit.emitln("      }");
        codeUnit.emitln("    } // synchronized ");
        codeUnit.emitln();
    }

    private final void emitJavaStaticCallback(CodeUnit codeUnit) {
        codeUnit.emitln("  /** Static callback invocation, dispatching to " + this.info.cbSimpleClazzName + " for callback <br> <code>" + this.info.cbFuncType.toString(this.info.cbFuncTypeName, false, true) + "</code> */");
        codeUnit.emit("  /* pp */ static " + this.cbFuncJavaReturnType.getName() + " invoke" + this.capIfaceName + "(");
        boolean[] blArray = new boolean[]{false};
        JavaType[] javaTypeArray = new JavaType[]{null};
        this.info.cbFuncBinding.forEachParameter((n, n2, type, javaType, string) -> {
            if (!type.isVoid() && !javaType.isPascalLen()) {
                if (0 < n2) {
                    codeUnit.emit(", ");
                }
                if (n == this.info.cbFuncUserParamIdx) {
                    codeUnit.emit("long nativeUserParam");
                    if (javaType.isCompoundTypeWrapper()) {
                        blArray[0] = true;
                        javaTypeArray[0] = javaType;
                    }
                } else {
                    codeUnit.emit(javaType + " " + string);
                }
                return true;
            }
            return false;
        });
        codeUnit.emitln(") {");
        boolean[] blArray2 = new boolean[]{false};
        if (this.userParamDefined) {
            if (blArray[0]) {
                codeUnit.emitln("    final " + javaTypeArray[0] + " " + this.info.cbFuncUserParamName + " = " + javaTypeArray[0] + ".derefPointer(nativeUserParam);");
                blArray2[0] = true;
            } else if (this.userParamIsMappedToID && this.userParamIsKey) {
                codeUnit.emitln("    final " + this.userParamClassName + " " + this.info.cbFuncUserParamName + ";");
            }
        }
        codeUnit.emitln("    final " + this.DataClassName + " value;");
        codeUnit.emitln("    synchronized( " + this.lockInstanceName + " ) {");
        if (this.userParamDefined && this.userParamIsMappedToID && this.userParamIsKey && !blArray[0]) {
            codeUnit.emitln("      " + this.info.cbFuncUserParamName + " = (" + this.userParamClassName + ") " + this.userParamIDMapInstanceName + ".get(nativeUserParam);");
            blArray2[0] = true;
        }
        if (this.useDataMap) {
            codeUnit.emitln("      final " + this.KeyClassName + " key = new " + this.KeyClassName + "(" + this.info.cbFuncBinding.getJavaCallSelectArguments(new StringBuilder(), this.info.cbFuncKeyIndices, false).toString() + ");");
            codeUnit.emitln("      value = " + this.dataMapInstanceName + ".get(key);");
        } else {
            codeUnit.emitln("      value = " + this.dataInstanceName + ";");
        }
        codeUnit.emitln("    }");
        codeUnit.emitln("    if( null == value ) {");
        if (!this.cbFuncJavaReturnType.isVoid()) {
            codeUnit.emitln("      return 0;");
        } else {
            codeUnit.emitln("      return;");
        }
        codeUnit.emitln("    }");
        if (!this.cbFuncJavaReturnType.isVoid()) {
            codeUnit.emit("    return ");
        } else {
            codeUnit.emit("    ");
        }
        codeUnit.emit("value.func.callback(");
        this.info.cbFuncBinding.forEachParameter((n, n2, type, javaType, string) -> {
            if (!type.isVoid() && !javaType.isPascalLen()) {
                if (0 < n2) {
                    codeUnit.emit(", ");
                }
                if (n == this.info.cbFuncUserParamIdx && !blArray2[0]) {
                    codeUnit.emit("value.param");
                } else {
                    codeUnit.emit(string);
                }
                return true;
            }
            return false;
        });
        codeUnit.emitln(");");
        codeUnit.emitln("  }");
        codeUnit.emitln();
    }

    public int appendCAdditionalParameter(StringBuilder stringBuilder) {
        stringBuilder.append(", jclass staticCBClazz, jstring jcallbackSignature");
        if (!this.userParamDefined) {
            return 2;
        }
        stringBuilder.append(", jlong jnativeUserParam");
        return 3;
    }

    public void emitCOptArgumentSuffix(CodeUnit codeUnit, int n) {
        if (n == this.info.setFuncCBParamIdx || n == this.info.setFuncUserParamIdx) {
            codeUnit.emit("_native");
        }
    }

    public void appendCAdditionalJNIDescriptor(StringBuilder stringBuilder) {
        JavaType.appendJNIDescriptor(stringBuilder, Class.class, false);
        JavaType.appendJNIDescriptor(stringBuilder, String.class, false);
        if (this.userParamDefined) {
            JavaType.appendJNIDescriptor(stringBuilder, Long.TYPE, false);
        }
    }

    public void emitCSetFuncPreCall(CodeUnit codeUnit) {
        String string;
        String string2;
        String string3 = CodeGenUtils.capitalizeString(this.info.setFuncName);
        String string4 = this.info.setFuncName + "(" + this.info.cbSimpleClazzName + ")";
        String string5 = "invoke" + string3;
        String string6 = "staticCBClazz" + string3;
        String string7 = "staticCBMethod" + string3;
        String string8 = this.binding.getArgumentName(this.info.setFuncCBParamIdx);
        String string9 = string8 + "_native";
        if (this.userParamDefined) {
            string2 = this.info.cbFuncUserParamType.getCName();
            string = this.binding.getArgumentName(this.info.setFuncUserParamIdx) + "_native";
        } else {
            string2 = null;
            string = null;
        }
        codeUnit.emitln();
        codeUnit.emitln("  // JavaCallback handling");
        codeUnit.emitln("  if( NULL == staticCBClazz ) { (*env)->FatalError(env, \"NULL staticCBClazz passed to '" + string4 + "'\"); }");
        codeUnit.emitln("  " + this.info.cbFuncTypeName + " " + string9 + ";");
        if (this.userParamDefined) {
            codeUnit.emitln("  " + string2 + "* " + string + ";");
        }
        codeUnit.emitln("  if( NULL != " + string8 + " ) {");
        codeUnit.emitln("    if( NULL == " + string6 + " || NULL == " + string7 + " ) {");
        codeUnit.emitln("      jclass staticCBClazz2 = (*env)->NewGlobalRef(env, staticCBClazz);");
        codeUnit.emitln("      if( NULL == staticCBClazz2 ) { (*env)->FatalError(env, \"Failed NewGlobalRef(staticCBClazz) in '" + string4 + "'\"); }");
        codeUnit.emitln("      const char* callbackSignature = (*env)->GetStringUTFChars(env, jcallbackSignature, (jboolean*)NULL);");
        codeUnit.emitln("      if( NULL == callbackSignature ) { (*env)->FatalError(env, \"Failed callbackSignature in '" + string4 + "'\"); }");
        codeUnit.emitln("      jmethodID cbMethodID = (*env)->GetStaticMethodID(env, staticCBClazz2, \"" + string5 + "\", callbackSignature);");
        codeUnit.emitln("      if( NULL == cbMethodID ) {");
        codeUnit.emitln("        char cmsg[400];");
        codeUnit.emitln("        snprintf(cmsg, 400, \"Failed GetStaticMethodID of '" + string5 + "(%s)' in '" + string4 + "'\", callbackSignature);");
        codeUnit.emitln("        (*env)->FatalError(env, cmsg);");
        codeUnit.emitln("      }");
        codeUnit.emitln("      (*env)->ReleaseStringUTFChars(env, jcallbackSignature, callbackSignature);");
        codeUnit.emitln("      " + string6 + " = staticCBClazz2;");
        codeUnit.emitln("      " + string7 + " = cbMethodID;");
        codeUnit.emitln("    }");
        JavaType javaType = JavaType.createForClass(ByteBuffer.class);
        for (int i = 0; i < this.info.cbFuncBinding.getNumArguments(); ++i) {
            String string10 = CodeGenUtils.capitalizeString(this.info.cbFuncBinding.getArgumentName(i));
            JavaType javaType2 = this.info.cbFuncBinding.getJavaArgumentType(i);
            if (i == this.info.cbFuncUserParamIdx || !javaType2.isCompoundTypeWrapper()) continue;
            String string11 = "staticCBArg" + string10 + "Clazz" + string3;
            String string12 = "staticCBArg" + string10 + "Method" + string3;
            codeUnit.emitln("    if( NULL == " + string11 + " || NULL == " + string12 + " ) {");
            String string13 = javaType2.getDescriptor(this.cfg);
            String string14 = javaType2.getName(this.cfg);
            String string15 = string14.replace(".", "/");
            codeUnit.emitln("      jclass " + string11 + "2 = (*env)->FindClass(env, \"" + string15 + "\");");
            codeUnit.emitln("      if( NULL == " + string11 + "2 ) { (*env)->FatalError(env, \"Failed FindClass(" + string15 + ") in '" + string4 + "'\"); }");
            codeUnit.emitln("      jmethodID " + string12 + "2 = (*env)->GetStaticMethodID(env, " + string11 + "2, \"create\", \"(" + javaType.getDescriptor() + ")" + string13 + "\");");
            codeUnit.emitln("      if( NULL == " + string12 + "2 ) {");
            codeUnit.emitln("        char cmsg[400];");
            codeUnit.emitln("        snprintf(cmsg, 400, \"Failed GetStaticMethodID of '" + string14 + ".create(" + javaType.getDescriptor() + ")" + string13 + " in " + string4 + "'\");");
            codeUnit.emitln("        (*env)->FatalError(env, cmsg);");
            codeUnit.emitln("      }");
            codeUnit.emitln("      " + string11 + " = " + string11 + "2;");
            codeUnit.emitln("      " + string12 + " = " + string12 + "2;");
            codeUnit.emitln("    }");
        }
        codeUnit.emitln("    " + string9 + " = func" + string3 + ";");
        if (this.userParamDefined) {
            codeUnit.emitln("    " + string + " = (" + string2 + "*) jnativeUserParam;");
        }
        codeUnit.emitln("  } else {");
        codeUnit.emitln("    " + string9 + " = NULL;");
        if (this.userParamDefined) {
            codeUnit.emitln("    " + string + " = NULL;");
        }
        codeUnit.emitln("  }");
        codeUnit.emitln();
    }

    public void emitCAdditionalCode(CodeUnit codeUnit, CMethodBindingEmitter cMethodBindingEmitter) {
        String string;
        String string2;
        String string3;
        JavaType javaType;
        String string4;
        int n;
        String string5;
        String string6;
        String string7 = CodeGenUtils.capitalizeString(this.info.setFuncName);
        String string8 = this.info.setFuncName + "(" + this.info.cbSimpleClazzName + ")";
        String string9 = "staticCBClazz" + string7;
        String string10 = "staticCBMethod" + string7;
        String string11 = "func" + string7;
        if (this.userParamDefined) {
            string6 = this.info.cbFuncUserParamType.getCName();
            string5 = this.info.cbFuncBinding.getArgumentName(this.info.cbFuncUserParamIdx);
        } else {
            string6 = null;
            string5 = null;
        }
        Type type = this.info.cbFuncBinding.getCReturnType();
        JavaType javaType2 = this.info.cbFuncBinding.getJavaReturnType();
        codeUnit.emitln();
        codeUnit.emitln("static jclass " + string9 + " = NULL;");
        codeUnit.emitln("static jmethodID " + string10 + " = NULL;");
        for (n = 0; n < this.info.cbFuncBinding.getNumArguments(); ++n) {
            string4 = CodeGenUtils.capitalizeString(this.info.cbFuncBinding.getArgumentName(n));
            javaType = this.info.cbFuncBinding.getJavaArgumentType(n);
            if (n == this.info.cbFuncUserParamIdx || !javaType.isCompoundTypeWrapper()) continue;
            string3 = "staticCBArg" + string4 + "Clazz" + string7;
            string2 = "staticCBArg" + string4 + "Method" + string7;
            codeUnit.emitln("static jclass " + string3 + " = NULL;");
            codeUnit.emitln("static jmethodID " + string2 + " = NULL;");
        }
        codeUnit.emitln();
        codeUnit.emit("static " + type.getCName() + " " + string11 + "(");
        codeUnit.emit(this.info.cbFuncBinding.getCParameterList(new StringBuilder(), false, null).toString());
        codeUnit.emitln(") {");
        codeUnit.emitln("  int detachJVM = 0;");
        codeUnit.emitln("  JNIEnv* env = JVMUtil_GetJNIEnv(1 /* daemon */, &detachJVM);");
        codeUnit.emitln("  jclass cbClazz = " + string9 + ";");
        codeUnit.emitln("  jmethodID cbMethod = " + string10 + ";");
        for (n = 0; n < this.info.cbFuncBinding.getNumArguments(); ++n) {
            string4 = CodeGenUtils.capitalizeString(this.info.cbFuncBinding.getArgumentName(n));
            javaType = this.info.cbFuncBinding.getJavaArgumentType(n);
            if (n == this.info.cbFuncUserParamIdx || !javaType.isCompoundTypeWrapper()) continue;
            string3 = "staticCBArg" + string4 + "Clazz" + string7;
            string2 = "staticCBArg" + string4 + "Method" + string7;
            codeUnit.emitln("  jclass cbClazzArg" + string4 + " = " + string3 + ";");
            codeUnit.emitln("  jmethodID cbMethodArg" + string4 + " = " + string2 + ";");
        }
        codeUnit.emitln("  if( NULL == env || NULL == cbClazz || NULL == cbMethod ) {");
        if (!type.isVoid()) {
            codeUnit.emitln("    return 0;");
        } else {
            codeUnit.emitln("    return;");
        }
        codeUnit.emitln("  }");
        this.emitJavaCallbackBodyCToJavaPreCall(cMethodBindingEmitter);
        if (this.userParamDefined) {
            codeUnit.emitln("  " + string6 + "* " + string5 + "_jni = (" + string6 + "*) " + string5 + ";");
        }
        codeUnit.emitln("  // C Params: " + this.info.cbFuncBinding.getCParameterList(new StringBuilder(), false, null).toString());
        codeUnit.emitln("  // J Params: " + this.info.cbFuncBinding.getJavaParameterList(new StringBuilder()).toString());
        if (!type.isVoid()) {
            codeUnit.emit("  " + type.getCName() + " _res = 0;");
            string = "return _res;";
        } else {
            string = "return;";
        }
        if (!type.isVoid()) {
            codeUnit.emit("  _res = (" + type.getCName() + ") ");
        } else {
            codeUnit.emit("  ");
        }
        codeUnit.emit("(*env)->CallStatic" + CodeGenUtils.capitalizeString(javaType2.getName()) + "Method(env, cbClazz, cbMethod, ");
        this.emitCBodyPassArguments(codeUnit);
        codeUnit.emitln(");");
        codeUnit.emitln("  if( (*env)->ExceptionCheck(env) ) {");
        codeUnit.emitln("    fprintf(stderr, \"Info: Callback '" + string8 + "': Exception in Java Callback caught:\\n\");");
        codeUnit.emitln("    (*env)->ExceptionDescribe(env);");
        codeUnit.emitln("    (*env)->ExceptionClear(env);");
        codeUnit.emitln("  }");
        codeUnit.emitln("  JVMUtil_ReleaseJNIEnv(env, detachJVM);");
        codeUnit.emitln("  " + string);
        codeUnit.emitln("}");
        codeUnit.emitln();
    }

    private int emitJavaCallbackBodyCToJavaPreCall(CMethodBindingEmitter cMethodBindingEmitter) {
        int n = 0;
        for (int i = 0; i < cMethodBindingEmitter.binding.getNumArguments(); ++i) {
            if (i == this.info.cbFuncUserParamIdx || !cMethodBindingEmitter.emitBodyMapCToJNIType(i, true)) continue;
            ++n;
        }
        return n;
    }

    private int emitCBodyPassArguments(CodeUnit codeUnit) {
        int n = 0;
        boolean bl = false;
        for (int i = 0; i < this.info.cbFuncBinding.getNumArguments(); ++i) {
            JavaType javaType = this.info.cbFuncBinding.getJavaArgumentType(i);
            if (javaType.isPascalLen()) continue;
            if (bl) {
                codeUnit.emit(", ");
                bl = false;
            }
            String string = this.info.cbFuncBinding.getArgumentName(i);
            if (i != this.info.cbFuncUserParamIdx && javaType.isCompoundTypeWrapper()) {
                String string2 = CodeGenUtils.capitalizeString(string);
                String string3 = string + "_jni";
                codeUnit.emit(string3 + " != NULL ? (*env)->CallStaticObjectMethod(env, cbClazzArg" + string2 + ", cbMethodArg" + string2 + ", " + string3 + ") : NULL");
            } else {
                codeUnit.emit(string + "_jni");
            }
            bl = true;
            ++n;
        }
        return n;
    }
}

