/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen;

import com.jogamp.common.nio.NativeBuffer;
import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.gluegen.JavaConfiguration;
import com.jogamp.gluegen.cgram.types.Type;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.List;

public class JavaType {
    private final Class<?> clazz;
    private final String clazzName;
    private final String structName;
    private final Type elementType;
    private final C_PTR primitivePointerType;
    private final boolean opaqued;
    public final PascalStringElem pascalStrElem;
    private static JavaType objectType;
    private static JavaType nioBufferType;
    private static JavaType nioByteBufferType;
    private static JavaType nioShortBufferType;
    private static JavaType nioIntBufferType;
    private static JavaType nioLongBufferType;
    private static JavaType nioPointerBufferType;
    private static JavaType nioFloatBufferType;
    private static JavaType nioDoubleBufferType;
    private static JavaType nioByteBufferArrayType;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (object == null) return false;
        if (!(object instanceof JavaType)) {
            return false;
        }
        JavaType javaType = (JavaType)object;
        if (this == javaType) return true;
        if (javaType.clazz != this.clazz) return false;
        if (!(this.clazzName != null ? this.clazzName.equals(javaType.clazzName) : javaType.clazzName == null)) {
            if (this.clazzName == null) return false;
            if (javaType.clazzName == null) return false;
            if (!this.clazzName.equals(javaType.clazzName)) return false;
        }
        if (!(this.structName != null ? this.structName.equals(javaType.structName) : javaType.structName == null)) {
            if (this.structName == null) return false;
            if (javaType.structName == null) return false;
            if (!this.structName.equals(javaType.structName)) return false;
        }
        if (this.elementType != javaType.elementType) {
            if (this.elementType == null) return false;
            if (javaType.elementType == null) return false;
            if (!this.elementType.equals(javaType.elementType)) return false;
        }
        if (this.primitivePointerType != javaType.primitivePointerType) return false;
        return true;
    }

    public int hashCode() {
        if (this.clazz != null) {
            return this.clazz.hashCode();
        }
        if (this.clazzName != null) {
            return this.clazzName.hashCode();
        }
        if (this.structName != null) {
            return this.structName.hashCode();
        }
        if (this.elementType != null) {
            return this.elementType.hashCode();
        }
        if (this.primitivePointerType != null) {
            return this.primitivePointerType.hashCode();
        }
        return 0;
    }

    public JavaType getElementType() {
        return new JavaType(this.elementType);
    }

    public Type getElementCType() {
        return this.elementType;
    }

    public static JavaType createForOpaqueClass(Class<?> clazz) {
        return new JavaType(clazz, true, null);
    }

    public static JavaType createForClass(Class<?> clazz) {
        return new JavaType(clazz, false, null);
    }

    public static JavaType createForStringClass(Class<?> clazz, PascalStringElem pascalStringElem) {
        return new JavaType(clazz, false, pascalStringElem);
    }

    public static JavaType createForNamedClass(String string) {
        return new JavaType(string, null);
    }

    public static JavaType createForCStruct(String string) {
        return new JavaType(null, string);
    }

    public static JavaType createForCArray(Type type) {
        return new JavaType(type);
    }

    public static JavaType createForCVoidPointer() {
        return new JavaType(C_PTR.VOID);
    }

    public static JavaType createForCCharPointer() {
        return new JavaType(C_PTR.CHAR);
    }

    public static JavaType createForCShortPointer() {
        return new JavaType(C_PTR.SHORT);
    }

    public static JavaType createForCInt32Pointer() {
        return new JavaType(C_PTR.INT32);
    }

    public static JavaType createForCInt64Pointer() {
        return new JavaType(C_PTR.INT64);
    }

    public static JavaType createForCFloatPointer() {
        return new JavaType(C_PTR.FLOAT);
    }

    public static JavaType createForCDoublePointer() {
        return new JavaType(C_PTR.DOUBLE);
    }

    public static JavaType createForJNIEnv() {
        return JavaType.createForCStruct("JNIEnv");
    }

    public static JavaType forObjectClass() {
        if (objectType == null) {
            objectType = JavaType.createForClass(Object.class);
        }
        return objectType;
    }

    public static JavaType forNIOBufferClass() {
        if (nioBufferType == null) {
            nioBufferType = JavaType.createForClass(Buffer.class);
        }
        return nioBufferType;
    }

    public static JavaType forNIOByteBufferClass() {
        if (nioByteBufferType == null) {
            nioByteBufferType = JavaType.createForClass(ByteBuffer.class);
        }
        return nioByteBufferType;
    }

    public static JavaType forNIOShortBufferClass() {
        if (nioShortBufferType == null) {
            nioShortBufferType = JavaType.createForClass(ShortBuffer.class);
        }
        return nioShortBufferType;
    }

    public static JavaType forNIOIntBufferClass() {
        if (nioIntBufferType == null) {
            nioIntBufferType = JavaType.createForClass(IntBuffer.class);
        }
        return nioIntBufferType;
    }

    public static JavaType forNIOLongBufferClass() {
        if (nioLongBufferType == null) {
            nioLongBufferType = JavaType.createForClass(LongBuffer.class);
        }
        return nioLongBufferType;
    }

    public static JavaType forNIOPointerBufferClass() {
        if (nioPointerBufferType == null) {
            nioPointerBufferType = JavaType.createForClass(PointerBuffer.class);
        }
        return nioPointerBufferType;
    }

    public static JavaType forNIOFloatBufferClass() {
        if (nioFloatBufferType == null) {
            nioFloatBufferType = JavaType.createForClass(FloatBuffer.class);
        }
        return nioFloatBufferType;
    }

    public static JavaType forNIODoubleBufferClass() {
        if (nioDoubleBufferType == null) {
            nioDoubleBufferType = JavaType.createForClass(DoubleBuffer.class);
        }
        return nioDoubleBufferType;
    }

    public static JavaType forNIOByteBufferArrayClass() {
        if (nioByteBufferArrayType == null) {
            ByteBuffer[] byteBufferArray = new ByteBuffer[]{};
            nioByteBufferArrayType = JavaType.createForClass(byteBufferArray.getClass());
        }
        return nioByteBufferArrayType;
    }

    public Class<?> getJavaClass() {
        return this.clazz;
    }

    public String getName() {
        return this.getName(null);
    }

    public String getName(JavaConfiguration javaConfiguration) {
        if (this.clazz != null) {
            if (this.clazz.isArray()) {
                return JavaType.arrayName(this.clazz);
            }
            return this.clazz.getName();
        }
        if (this.clazzName != null) {
            return (null != javaConfiguration ? javaConfiguration.packageForStruct(this.clazzName) + "." : "") + this.clazzName;
        }
        if (this.elementType != null) {
            return this.elementType.getName();
        }
        return (null != javaConfiguration ? javaConfiguration.packageForStruct(this.clazzName) + "." : "") + this.structName;
    }

    public String getDescriptor() {
        return this.getDescriptor(null);
    }

    public String getDescriptor(JavaConfiguration javaConfiguration) {
        if (this.clazz != null) {
            return JavaType.descriptor(this.clazz);
        }
        if (null != this.clazzName) {
            return JavaType.descriptor((null != javaConfiguration ? javaConfiguration.packageForStruct(this.clazzName) + "." : "") + this.clazzName);
        }
        if (null != this.structName) {
            return JavaType.descriptor((null != javaConfiguration ? javaConfiguration.packageForStruct(this.structName) + "." : "") + this.structName);
        }
        if (this.elementType != null) {
            if (this.elementType.getName() == null) {
                throw new RuntimeException("elementType.name is null: " + this.getDebugString());
            }
            return "[" + JavaType.descriptor(this.elementType.getName());
        }
        return "ANON_NIO";
    }

    public String getJNIMethodDesciptor() {
        return JavaType.toJNIMethodDescriptor(this.getDescriptor());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StringBuilder appendDescriptor(StringBuilder stringBuilder, Class<?> clazz, boolean bl) {
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                stringBuilder.append("Z");
                return stringBuilder;
            } else if (clazz == Byte.TYPE) {
                stringBuilder.append("B");
                return stringBuilder;
            } else if (clazz == Character.TYPE) {
                stringBuilder.append("C");
                return stringBuilder;
            } else if (clazz == Short.TYPE) {
                stringBuilder.append("S");
                return stringBuilder;
            } else if (clazz == Integer.TYPE) {
                stringBuilder.append("I");
                return stringBuilder;
            } else if (clazz == Long.TYPE) {
                stringBuilder.append("J");
                return stringBuilder;
            } else if (clazz == Float.TYPE) {
                stringBuilder.append("F");
                return stringBuilder;
            } else {
                if (clazz != Double.TYPE) throw new RuntimeException("Illegal primitive type \"" + clazz.getName() + "\"");
                stringBuilder.append("D");
            }
            return stringBuilder;
        } else if (bl) {
            if (clazz.isArray()) {
                stringBuilder.append("[");
                Class<?> clazz2 = clazz.getComponentType();
                JavaType.appendDescriptor(stringBuilder, clazz2, clazz2 == ByteBuffer.class);
                return stringBuilder;
            } else {
                stringBuilder.append("L");
                stringBuilder.append(clazz.getName().replace('.', '/'));
                stringBuilder.append(";");
            }
            return stringBuilder;
        } else if (clazz.isArray()) {
            stringBuilder.append("[");
            JavaType.appendDescriptor(stringBuilder, clazz.getComponentType(), false);
            return stringBuilder;
        } else if (clazz == String.class) {
            stringBuilder.append("L");
            stringBuilder.append(clazz.getName().replace('.', '/'));
            stringBuilder.append(";");
            return stringBuilder;
        } else {
            stringBuilder.append("Ljava/lang/Object;");
        }
        return stringBuilder;
    }

    public static StringBuilder appendJNIDescriptor(StringBuilder stringBuilder, Class<?> clazz, boolean bl) {
        int n = stringBuilder.length();
        return JavaType.toJNIMethodDescriptor(JavaType.appendDescriptor(stringBuilder, clazz, bl), n);
    }

    public static String toJNIMethodDescriptor(String string) {
        return string.replace("_", "_1").replace("/", "_").replace(";", "_2").replace("[", "_3");
    }

    public static StringBuilder toJNIMethodDescriptor(StringBuilder stringBuilder, int n) {
        JavaType.replace(stringBuilder, n, "_", "_1");
        JavaType.replace(stringBuilder, n, "/", "_");
        JavaType.replace(stringBuilder, n, ";", "_2");
        JavaType.replace(stringBuilder, n, "[", "_3");
        return stringBuilder;
    }

    private static StringBuilder replace(StringBuilder stringBuilder, int n, String string, String string2) {
        n = stringBuilder.indexOf(string, n);
        while (0 <= n) {
            stringBuilder.replace(n, n + string.length(), string2);
            n = stringBuilder.indexOf(string, n + string2.length());
        }
        return stringBuilder;
    }

    public String jniTypeName() {
        if (this.isCompoundTypeWrapper()) {
            return "jobject";
        }
        if (this.isArrayOfCompoundTypeWrappers()) {
            return "jobjectArray /* of ByteBuffer */";
        }
        if (this.clazzName != null) {
            return "jobject";
        }
        if (this.clazz == null) {
            return null;
        }
        if (this.isVoid()) {
            return "void";
        }
        if (this.isPrimitive()) {
            return "j" + this.clazz.getName();
        }
        if (this.isPrimitiveArray() || this.isNIOBuffer()) {
            return "jobject";
        }
        if (this.isArray()) {
            if (this.isStringArray()) {
                return "jobjectArray /*elements are String*/";
            }
            Class<?> clazz = this.clazz.getComponentType();
            if (this.isNIOBufferArray()) {
                return "jobjectArray /*elements are " + clazz.getName() + "*/";
            }
            if (clazz.isArray()) {
                if (clazz.getComponentType().isPrimitive()) {
                    return "jobjectArray /* elements are " + clazz.getComponentType() + "[]*/";
                }
                throw new RuntimeException("Multi-dimensional arrays of types that are not primitives or Strings are not supported.");
            }
            throw new RuntimeException("Unexpected and unsupported array type: \"" + this + "\"");
        }
        if (this.isString()) {
            return "jstring";
        }
        return "jobject";
    }

    public boolean isOpaqued() {
        return this.opaqued;
    }

    public boolean isNIOBuffer() {
        return this.clazz != null && (Buffer.class.isAssignableFrom(this.clazz) || NativeBuffer.class.isAssignableFrom(this.clazz));
    }

    public boolean isNIOByteBuffer() {
        return this.clazz == ByteBuffer.class;
    }

    public boolean isNIOByteBufferArray() {
        return this == nioByteBufferArrayType;
    }

    public boolean isNIOBufferArray() {
        return this.isArray() && Buffer.class.isAssignableFrom(this.clazz.getComponentType());
    }

    public boolean isNIOLongBuffer() {
        return this.clazz == LongBuffer.class;
    }

    public boolean isNIOPointerBuffer() {
        return this.clazz == PointerBuffer.class;
    }

    public boolean isString() {
        return this.clazz == String.class;
    }

    public boolean isPascalStrElem() {
        return null != this.pascalStrElem;
    }

    public boolean isPascalStr() {
        return this.isPascalStrElem() && this.isString();
    }

    public boolean isPascalLen() {
        return this.isPascalStrElem() && !this.isString();
    }

    public boolean isArray() {
        return this.clazz != null && this.clazz.isArray();
    }

    public boolean isFloatArray() {
        return this.clazz != null && this.clazz.isArray() && this.clazz.getComponentType() == Float.TYPE;
    }

    public boolean isDoubleArray() {
        return this.clazz != null && this.clazz.isArray() && this.clazz.getComponentType() == Double.TYPE;
    }

    public boolean isByteArray() {
        return this.clazz != null && this.clazz.isArray() && this.clazz.getComponentType() == Byte.TYPE;
    }

    public boolean isIntArray() {
        return this.clazz != null && this.clazz.isArray() && this.clazz.getComponentType() == Integer.TYPE;
    }

    public boolean isShortArray() {
        return this.clazz != null && this.clazz.isArray() && this.clazz.getComponentType() == Short.TYPE;
    }

    public boolean isLongArray() {
        return this.clazz != null && this.clazz.isArray() && this.clazz.getComponentType() == Long.TYPE;
    }

    public boolean isStringArray() {
        return this.clazz != null && this.clazz.isArray() && this.clazz.getComponentType() == String.class;
    }

    public boolean isPascalStrArray() {
        return this.isPascalStrElem() && this.isStringArray();
    }

    public boolean isPrimitive() {
        return this.clazz != null && !this.isArray() && this.clazz.isPrimitive() && this.clazz != Void.TYPE;
    }

    public boolean isPrimitiveArray() {
        return this.isArray() && this.clazz.getComponentType().isPrimitive();
    }

    public boolean isShort() {
        return this.clazz == Short.TYPE;
    }

    public boolean isFloat() {
        return this.clazz == Float.TYPE;
    }

    public boolean isDouble() {
        return this.clazz == Double.TYPE;
    }

    public boolean isByte() {
        return this.clazz == Byte.TYPE;
    }

    public boolean isLong() {
        return this.clazz == Long.TYPE;
    }

    public boolean isInt() {
        return this.clazz == Integer.TYPE;
    }

    public boolean isVoid() {
        return this.clazz == Void.TYPE;
    }

    public boolean isNamedClass() {
        return this.clazzName != null;
    }

    public boolean isCompoundTypeWrapper() {
        return this.structName != null && !this.isJNIEnv();
    }

    public boolean isArrayOfCompoundTypeWrappers() {
        return this.elementType != null;
    }

    public boolean isCPrimitivePointerType() {
        return this.primitivePointerType != null;
    }

    public boolean isCVoidPointerType() {
        return C_PTR.VOID.equals((Object)this.primitivePointerType);
    }

    public boolean isCCharPointerType() {
        return C_PTR.CHAR.equals((Object)this.primitivePointerType);
    }

    public boolean isCShortPointerType() {
        return C_PTR.SHORT.equals((Object)this.primitivePointerType);
    }

    public boolean isCInt32PointerType() {
        return C_PTR.INT32.equals((Object)this.primitivePointerType);
    }

    public boolean isCInt64PointerType() {
        return C_PTR.INT64.equals((Object)this.primitivePointerType);
    }

    public boolean isCFloatPointerType() {
        return C_PTR.FLOAT.equals((Object)this.primitivePointerType);
    }

    public boolean isCDoublePointerType() {
        return C_PTR.DOUBLE.equals((Object)this.primitivePointerType);
    }

    public boolean isJNIEnv() {
        return "JNIEnv".equals(this.structName);
    }

    public Object clone() {
        return new JavaType(this.primitivePointerType, this.clazz, this.clazzName, this.structName, this.elementType, this.pascalStrElem);
    }

    public String toString() {
        return this.getName();
    }

    private void append(StringBuilder stringBuilder, String string, boolean bl) {
        if (bl) {
            stringBuilder.append(", ");
        }
        stringBuilder.append(string);
    }

    public final StringBuilder getSignature(StringBuilder stringBuilder) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        boolean bl = false;
        String string = this.getName();
        if (null != string) {
            this.append(stringBuilder, string, false);
        } else {
            this.append(stringBuilder, "ANON", false);
        }
        if (null != this.clazz) {
            this.append(stringBuilder, "clazz = " + this.clazz.getName(), bl);
            bl = true;
        }
        if (null != this.clazzName) {
            this.append(stringBuilder, "clazzName = " + this.clazzName, bl);
            bl = true;
        }
        if (null != this.structName) {
            this.append(stringBuilder, "struct = " + this.structName, bl);
            bl = true;
        }
        if (null != this.elementType) {
            this.append(stringBuilder, "elementType = " + this.elementType, bl);
            bl = true;
        }
        if (null != this.primitivePointerType) {
            this.append(stringBuilder, "primitivePointerType = " + (Object)((Object)this.primitivePointerType), bl);
            bl = true;
        }
        this.append(stringBuilder, "is[", bl);
        bl = false;
        if (this.isOpaqued()) {
            this.append(stringBuilder, "opaque", bl);
            bl = true;
        }
        if (this.isPascalStrElem()) {
            stringBuilder.append("pascal ");
        }
        if (this.isString()) {
            this.append(stringBuilder, "string", bl);
            bl = true;
        }
        if (this.isStringArray()) {
            this.append(stringBuilder, "stringArray", bl);
            bl = true;
        } else if (this.isArray()) {
            this.append(stringBuilder, "array", bl);
            bl = true;
        }
        if (this.isArrayOfCompoundTypeWrappers()) {
            this.append(stringBuilder, "compoundArray", bl);
            bl = true;
        }
        if (this.isCompoundTypeWrapper()) {
            this.append(stringBuilder, "compound", bl);
            bl = true;
        }
        if (this.isPrimitive()) {
            this.append(stringBuilder, "primitive", bl);
            bl = true;
        }
        if (this.isPrimitiveArray()) {
            this.append(stringBuilder, "primitiveArray", bl);
            bl = true;
        }
        if (this.isNIOBuffer()) {
            this.append(stringBuilder, "nioBuffer", bl);
            bl = true;
        }
        if (this.isNIOBufferArray()) {
            this.append(stringBuilder, "nioBufferArray", bl);
            bl = true;
        }
        if (this.isCPrimitivePointerType()) {
            this.append(stringBuilder, "C-Primitive-Pointer", bl);
            bl = true;
        }
        this.append(stringBuilder, "], descriptor '" + this.getDescriptor() + "'", false);
        bl = true;
        return stringBuilder;
    }

    public String getDebugString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("JType[");
        this.getSignature(stringBuilder);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private JavaType(Class<?> clazz, boolean bl, PascalStringElem pascalStringElem) {
        if (null == clazz) {
            throw new IllegalArgumentException("null clazz passed");
        }
        this.primitivePointerType = null;
        this.clazz = clazz;
        this.clazzName = null;
        this.structName = null;
        this.elementType = null;
        this.opaqued = bl;
        this.pascalStrElem = pascalStringElem;
    }

    private JavaType(String string, String string2) {
        if (null != string && null != string2) {
            throw new IllegalArgumentException("Both clazzName and structName set");
        }
        if (null != string) {
            this.clazzName = string;
            this.structName = null;
        } else if (null != string2) {
            this.clazzName = null;
            this.structName = string2;
        } else {
            throw new IllegalArgumentException("Neither clazzName nor structName set");
        }
        this.primitivePointerType = null;
        this.clazz = null;
        this.elementType = null;
        this.opaqued = false;
        this.pascalStrElem = null;
    }

    private JavaType(C_PTR c_PTR) {
        if (null == c_PTR) {
            throw new IllegalArgumentException("null primitivePointerType passed");
        }
        this.primitivePointerType = c_PTR;
        this.clazz = null;
        this.clazzName = null;
        this.structName = null;
        this.elementType = null;
        this.opaqued = false;
        this.pascalStrElem = null;
    }

    private JavaType(Type type) {
        if (null == type) {
            throw new IllegalArgumentException("null elementType passed");
        }
        this.primitivePointerType = null;
        this.clazz = null;
        this.clazzName = null;
        this.structName = null;
        this.elementType = type;
        this.opaqued = false;
        this.pascalStrElem = null;
    }

    private JavaType(C_PTR c_PTR, Class<?> clazz, String string, String string2, Type type, PascalStringElem pascalStringElem) {
        this.primitivePointerType = c_PTR;
        this.clazz = clazz;
        this.clazzName = string;
        this.structName = string2;
        this.elementType = type;
        this.opaqued = false;
        this.pascalStrElem = pascalStringElem;
    }

    public JavaType(JavaType javaType) {
        this(javaType.primitivePointerType, javaType.clazz, javaType.clazzName, javaType.structName, javaType.elementType, javaType.pascalStrElem);
    }

    public JavaType(JavaType javaType, PascalStringElem pascalStringElem) {
        this(javaType.primitivePointerType, javaType.clazz, javaType.clazzName, javaType.structName, javaType.elementType, pascalStringElem);
    }

    private static String arrayName(Class<?> clazz) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (clazz.isArray()) {
            ++n;
            clazz = clazz.getComponentType();
        }
        stringBuilder.append(clazz.getName());
        while (--n >= 0) {
            stringBuilder.append("[]");
        }
        return stringBuilder.toString();
    }

    private static String arrayDescriptor(Class<?> clazz) {
        StringBuilder stringBuilder = new StringBuilder();
        while (clazz.isArray()) {
            stringBuilder.append("[");
            clazz = clazz.getComponentType();
        }
        stringBuilder.append(JavaType.descriptor(clazz));
        return stringBuilder.toString();
    }

    private static String descriptor(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                return "Z";
            }
            if (clazz == Byte.TYPE) {
                return "B";
            }
            if (clazz == Double.TYPE) {
                return "D";
            }
            if (clazz == Float.TYPE) {
                return "F";
            }
            if (clazz == Integer.TYPE) {
                return "I";
            }
            if (clazz == Long.TYPE) {
                return "J";
            }
            if (clazz == Short.TYPE) {
                return "S";
            }
            if (clazz == Void.TYPE) {
                return "V";
            }
            throw new RuntimeException("Unexpected primitive type " + clazz.getName());
        }
        if (clazz.isArray()) {
            return JavaType.arrayDescriptor(clazz);
        }
        return JavaType.descriptor(clazz.getName());
    }

    private static String descriptor(String string) {
        return "L" + string.replace('.', '/') + ";";
    }

    private static enum C_PTR {
        VOID,
        CHAR,
        SHORT,
        INT32,
        INT64,
        FLOAT,
        DOUBLE;

    }

    public static class PascalStringElem {
        public final int lengthIdx;
        public final int valueIdx;

        PascalStringElem(int n, int n2) {
            this.lengthIdx = n;
            this.valueIdx = n2;
        }

        public static final List<Integer> pushValueIndex(List<PascalStringElem> list, List<Integer> list2) {
            if (null == list2) {
                list2 = new ArrayList<Integer>(2);
            }
            for (PascalStringElem pascalStringElem : list) {
                list2.add(pascalStringElem.valueIdx);
            }
            return list2;
        }

        public static final List<Integer> pushLengthIndex(List<PascalStringElem> list) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>(2);
            for (PascalStringElem pascalStringElem : list) {
                arrayList.add(pascalStringElem.lengthIdx);
            }
            return arrayList;
        }

        public static PascalStringElem getByValueIdx(List<PascalStringElem> list, int n) {
            if (null != list) {
                for (PascalStringElem pascalStringElem : list) {
                    if (n != pascalStringElem.valueIdx) continue;
                    return pascalStringElem;
                }
            }
            return null;
        }

        public static PascalStringElem getByLengthIdx(List<PascalStringElem> list, int n) {
            if (null != list) {
                for (PascalStringElem pascalStringElem : list) {
                    if (n != pascalStringElem.lengthIdx) continue;
                    return pascalStringElem;
                }
            }
            return null;
        }

        public String toString() {
            return "PascalStr[lenIdx " + this.lengthIdx + ", valIdx " + this.valueIdx + "]";
        }
    }
}

