/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen;

import com.jogamp.gluegen.JavaType;
import com.jogamp.gluegen.cgram.types.FunctionSymbol;
import com.jogamp.gluegen.cgram.types.FunctionType;
import com.jogamp.gluegen.cgram.types.Type;
import java.util.ArrayList;
import java.util.List;

public class MethodBinding {
    private final FunctionSymbol sym;
    private final String delegationImplName;
    private final JavaType containingType;
    private final Type containingCType;
    private String nativeName;
    private JavaType javaReturnType;
    private List<JavaType> javaArgumentTypes;
    private boolean computedSignatureProperties;
    private boolean argumentsUseNIO;
    private boolean signatureUsesNIO;
    private boolean signatureCanUseIndirectNIO;
    private boolean signatureUsesCompoundTypeWrappers;
    private boolean signatureUsesArraysOfCompoundTypeWrappers;
    private boolean signatureUsesCVoidPointers;
    private boolean signatureUsesCPrimitivePointers;
    private boolean signatureUsesCArrays;
    private boolean signatureUsesJavaPrimitiveArrays;
    private int thisPointerIndex = -1;

    public MethodBinding(MethodBinding methodBinding) {
        this.sym = methodBinding.sym;
        this.delegationImplName = methodBinding.delegationImplName;
        this.containingType = methodBinding.containingType;
        this.containingCType = methodBinding.containingCType;
        this.nativeName = methodBinding.nativeName;
        this.javaReturnType = methodBinding.javaReturnType;
        this.javaArgumentTypes = null != methodBinding.javaArgumentTypes ? new ArrayList<JavaType>(methodBinding.javaArgumentTypes) : null;
        this.computedSignatureProperties = methodBinding.computedSignatureProperties;
        this.argumentsUseNIO = methodBinding.argumentsUseNIO;
        this.signatureUsesNIO = methodBinding.signatureUsesNIO;
        this.signatureCanUseIndirectNIO = methodBinding.signatureCanUseIndirectNIO;
        this.signatureUsesCompoundTypeWrappers = methodBinding.signatureUsesCompoundTypeWrappers;
        this.signatureUsesArraysOfCompoundTypeWrappers = methodBinding.signatureUsesArraysOfCompoundTypeWrappers;
        this.signatureUsesCVoidPointers = methodBinding.signatureUsesCVoidPointers;
        this.signatureUsesCPrimitivePointers = methodBinding.signatureUsesCPrimitivePointers;
        this.signatureUsesCArrays = methodBinding.signatureUsesCArrays;
        this.signatureUsesJavaPrimitiveArrays = methodBinding.signatureUsesJavaPrimitiveArrays;
        this.thisPointerIndex = methodBinding.thisPointerIndex;
    }

    public MethodBinding(FunctionSymbol functionSymbol, String string, JavaType javaType, List<JavaType> list, JavaType javaType2, Type type) {
        this.sym = functionSymbol;
        this.delegationImplName = string;
        this.containingType = javaType2;
        this.containingCType = type;
        this.nativeName = null;
        this.javaReturnType = javaType;
        this.javaArgumentTypes = list;
    }

    public void setJavaReturnType(JavaType javaType) {
        this.javaReturnType = javaType;
        this.computedSignatureProperties = false;
    }

    public void addJavaArgumentType(JavaType javaType) {
        if (this.javaArgumentTypes == null) {
            this.javaArgumentTypes = new ArrayList<JavaType>();
        }
        this.javaArgumentTypes.add(javaType);
        this.computedSignatureProperties = false;
    }

    public JavaType getJavaReturnType() {
        return this.javaReturnType;
    }

    public int getNumArguments() {
        return this.sym.getNumArguments();
    }

    public JavaType getJavaArgumentType(int n) {
        return this.javaArgumentTypes.get(n);
    }

    public Type getCReturnType() {
        return this.sym.getReturnType();
    }

    public Type getCArgumentType(int n) {
        return this.sym.getArgumentType(n);
    }

    public StringBuilder getCParameterList(StringBuilder stringBuilder, boolean bl, String string) {
        return this.getCParameterList(stringBuilder, bl, string, null);
    }

    public StringBuilder getCParameterList(StringBuilder stringBuilder, boolean bl, String string, List<Integer> list) {
        this.forEachParameter((n, n2, type, javaType, string2) -> {
            if (!(type.isVoid() || null != list && list.contains(n))) {
                if (0 < n2) {
                    stringBuilder.append(", ");
                }
                if (bl && type.isTypedef()) {
                    stringBuilder.append(type.getName());
                    if (string2 != null) {
                        stringBuilder.append(" ");
                        stringBuilder.append(string2);
                    }
                } else if (type.isFunctionPointer()) {
                    FunctionType functionType = type.getTargetFunction();
                    stringBuilder.append(functionType.toString(string2, string, false, true));
                } else if (type.isArray()) {
                    stringBuilder.append(type.asArray().toString(string2));
                } else {
                    stringBuilder.append(type.getCName(true));
                    if (string2 != null) {
                        stringBuilder.append(" ");
                        stringBuilder.append(string2);
                    }
                }
                return true;
            }
            return false;
        });
        return stringBuilder;
    }

    public StringBuilder getJavaParameterList(StringBuilder stringBuilder) {
        return this.getJavaParameterList(stringBuilder, null);
    }

    public StringBuilder getJavaParameterList(StringBuilder stringBuilder, List<Integer> list) {
        this.forEachParameter((n, n2, type, javaType, string) -> {
            if (!(type.isVoid() || javaType.isPascalLen() || null != list && list.contains(n))) {
                if (0 < n2) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(javaType + " " + string);
                return true;
            }
            return false;
        });
        return stringBuilder;
    }

    public StringBuilder getJavaSelectParameter(StringBuilder stringBuilder, List<Integer> list, boolean bl) {
        this.forEachParameter((n, n2, type, javaType, string) -> {
            if (!type.isVoid() && list.contains(n)) {
                if (0 < n2) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(javaType + " " + string);
                return true;
            }
            return false;
        });
        if (bl && stringBuilder.length() > 0) {
            stringBuilder.append(", ");
        }
        return stringBuilder;
    }

    public StringBuilder getJavaCallArgumentList(StringBuilder stringBuilder, List<Integer> list) {
        this.forEachParameter((n, n2, type, javaType, string) -> {
            if (!(type.isVoid() || null != list && list.contains(n))) {
                if (0 < n2) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(string);
                return true;
            }
            return false;
        });
        return stringBuilder;
    }

    public StringBuilder getJavaCallSelectArguments(StringBuilder stringBuilder, List<Integer> list, boolean bl) {
        this.forEachParameter((n, n2, type, javaType, string) -> {
            if (!type.isVoid() && list.contains(n)) {
                if (0 < n2) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(string);
                return true;
            }
            return false;
        });
        if (bl && stringBuilder.length() > 0) {
            stringBuilder.append(", ");
        }
        return stringBuilder;
    }

    public int forEachParameter(ParameterConsumer parameterConsumer) {
        int n = this.getNumArguments();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (!parameterConsumer.accept(i, n2, this.getCArgumentType(i), this.getJavaArgumentType(i), this.getArgumentName(i))) continue;
            ++n2;
        }
        return n2;
    }

    public final boolean isReturnCompoundByValue() {
        Type type = this.getCReturnType();
        if (type.isVoid()) {
            return false;
        }
        if (this.javaReturnType.isPrimitive()) {
            return false;
        }
        return !type.isPointer() && this.javaReturnType.isCompoundTypeWrapper();
    }

    public FunctionSymbol getCSymbol() {
        return this.sym;
    }

    public String getArgumentName(int n) {
        String string = this.sym.getArgumentName(n);
        if (null != string) {
            return string;
        }
        return "arg" + n;
    }

    public String getName() {
        return this.sym.getName();
    }

    public String getDelegationImplName() {
        return this.delegationImplName;
    }

    public String getInterfaceName() {
        return this.sym.getName();
    }

    public String getImplName() {
        return null != this.delegationImplName ? this.delegationImplName : this.sym.getName();
    }

    public String getNativeName() {
        return null != this.nativeName ? this.nativeName : this.sym.getOrigName();
    }

    public void setNativeName(String string) {
        this.nativeName = string;
    }

    public MethodBinding replaceJavaArgumentType(int n, JavaType javaType) {
        MethodBinding methodBinding = new MethodBinding(this);
        methodBinding.javaArgumentTypes = null;
        if (n < 0) {
            methodBinding.setJavaReturnType(javaType);
        } else {
            methodBinding.setJavaReturnType(this.javaReturnType);
        }
        for (int i = 0; i < this.getNumArguments(); ++i) {
            JavaType javaType2 = this.getJavaArgumentType(i);
            if (i == n) {
                javaType2 = javaType;
            }
            methodBinding.addJavaArgumentType(javaType2);
        }
        return methodBinding;
    }

    public boolean argumentsUseNIO() {
        this.computeSignatureProperties();
        return this.argumentsUseNIO;
    }

    public boolean signatureUsesNIO() {
        this.computeSignatureProperties();
        return this.signatureUsesNIO;
    }

    public boolean signatureCanUseIndirectNIO() {
        this.computeSignatureProperties();
        return this.signatureCanUseIndirectNIO;
    }

    public boolean signatureUsesCompoundTypeWrappers() {
        this.computeSignatureProperties();
        return this.signatureUsesCompoundTypeWrappers;
    }

    public boolean signatureUsesArraysOfCompoundTypeWrappers() {
        this.computeSignatureProperties();
        return this.signatureUsesArraysOfCompoundTypeWrappers;
    }

    public boolean needsNIOWrappingOrUnwrapping() {
        return this.signatureUsesNIO() || this.signatureUsesCompoundTypeWrappers() || this.signatureUsesArraysOfCompoundTypeWrappers();
    }

    public boolean signatureUsesCVoidPointers() {
        this.computeSignatureProperties();
        return this.signatureUsesCVoidPointers;
    }

    public boolean signatureUsesCPrimitivePointers() {
        this.computeSignatureProperties();
        return this.signatureUsesCPrimitivePointers;
    }

    public boolean signatureUsesCArrays() {
        this.computeSignatureProperties();
        return this.signatureUsesCArrays;
    }

    public boolean signatureUsesJavaPrimitiveArrays() {
        this.computeSignatureProperties();
        return this.signatureUsesJavaPrimitiveArrays;
    }

    protected void computeSignatureProperties() {
        Type type;
        if (this.computedSignatureProperties) {
            return;
        }
        this.argumentsUseNIO = false;
        this.signatureUsesNIO = false;
        this.signatureCanUseIndirectNIO = false;
        this.signatureUsesCompoundTypeWrappers = false;
        this.signatureUsesArraysOfCompoundTypeWrappers = false;
        this.signatureUsesCVoidPointers = false;
        this.signatureUsesCPrimitivePointers = false;
        this.signatureUsesCArrays = false;
        this.signatureUsesJavaPrimitiveArrays = false;
        if (this.javaReturnType.isCompoundTypeWrapper()) {
            this.signatureUsesCompoundTypeWrappers = true;
        }
        if (this.javaReturnType.isNIOBuffer() || this.javaReturnType.isArrayOfCompoundTypeWrappers()) {
            this.signatureUsesNIO = true;
        }
        if ((type = this.sym.getReturnType()).isArray()) {
            this.signatureUsesCArrays = true;
            if (type.asArray().getTargetType().isPrimitive()) {
                this.signatureUsesCPrimitivePointers = true;
            }
        }
        if (type.isPointer()) {
            if (type.asPointer().getTargetType().isPrimitive()) {
                this.signatureUsesCPrimitivePointers = true;
            } else if (type.asPointer().getTargetType().isVoid()) {
                this.signatureUsesCVoidPointers = true;
            }
        }
        for (int i = 0; i < this.getNumArguments(); ++i) {
            JavaType javaType = this.getJavaArgumentType(i);
            Type type2 = this.getCArgumentType(i);
            if (javaType.isCompoundTypeWrapper()) {
                this.signatureUsesCompoundTypeWrappers = true;
            }
            if (javaType.isArrayOfCompoundTypeWrappers()) {
                this.signatureUsesArraysOfCompoundTypeWrappers = true;
            }
            if (javaType.isNIOBuffer() || javaType.isNIOBufferArray()) {
                this.signatureUsesNIO = true;
                this.argumentsUseNIO = true;
                if (javaType.isNIOBuffer()) {
                    this.signatureCanUseIndirectNIO = true;
                }
            }
            if (type2.isArray()) {
                this.signatureUsesCArrays = true;
                if (type2.asArray().getTargetType().isPrimitive()) {
                    this.signatureUsesCPrimitivePointers = true;
                }
            }
            if (type2.isPointer()) {
                if (type2.asPointer().getTargetType().isPrimitive() || javaType.isCPrimitivePointerType()) {
                    this.signatureUsesCPrimitivePointers = true;
                } else if (type2.asPointer().getTargetType().isVoid()) {
                    this.signatureUsesCVoidPointers = true;
                }
            }
            if (!javaType.isPrimitiveArray()) continue;
            this.signatureUsesJavaPrimitiveArrays = true;
        }
        this.computedSignatureProperties = true;
    }

    public boolean hasContainingType() {
        return this.getContainingType() != null;
    }

    public JavaType getContainingType() {
        return this.containingType;
    }

    public Type getContainingCType() {
        return this.containingCType;
    }

    public void findThisPointer() {
        this.clearThisPointer();
        for (int i = 0; i < this.getNumArguments(); ++i) {
            JavaType javaType = this.getJavaArgumentType(i);
            if (javaType.equals(this.containingType)) {
                this.thisPointerIndex = i;
                break;
            }
            if (!javaType.isJNIEnv()) break;
        }
    }

    public void clearThisPointer() {
        this.thisPointerIndex = -1;
    }

    public boolean isArgumentThisPointer(int n) {
        return this.thisPointerIndex == n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof MethodBinding)) {
            return false;
        }
        MethodBinding methodBinding = (MethodBinding)object;
        if (!this.getName().equals(methodBinding.getName()) || !this.sym.getType().equals(methodBinding.sym.getType())) {
            return false;
        }
        if (!this.javaReturnType.equals(methodBinding.getJavaReturnType())) {
            return false;
        }
        if (this.containingCType != null && methodBinding.getContainingCType() != null && !this.containingCType.equals(methodBinding.getContainingCType())) {
            return false;
        }
        if (this.javaArgumentTypes.size() != methodBinding.javaArgumentTypes.size()) {
            return false;
        }
        for (int i = 0; i < this.javaArgumentTypes.size(); ++i) {
            JavaType javaType;
            JavaType javaType2 = this.javaArgumentTypes.get(i);
            if (((Object)javaType2).equals(javaType = methodBinding.getJavaArgumentType(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append(this.getName());
        stringBuilder.append(this.sym.getType().getName(true));
        stringBuilder.append(this.getJavaReturnType().getName());
        if (this.containingCType != null) {
            stringBuilder.append(this.containingCType.getName(true));
        }
        for (int i = 0; i < this.getNumArguments(); ++i) {
            JavaType javaType = this.getJavaArgumentType(i);
            if (javaType.isVoid()) {
                assert (this.getNumArguments() == 1);
                continue;
            }
            stringBuilder.append(javaType.getName());
        }
        return stringBuilder.toString().hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append(this.getJavaReturnType().getName());
        stringBuilder.append(' ');
        stringBuilder.append(this.getName());
        stringBuilder.append('(');
        boolean bl = false;
        for (int i = 0; i < this.getNumArguments(); ++i) {
            JavaType javaType = this.getJavaArgumentType(i);
            if (javaType.isVoid()) {
                assert (this.getNumArguments() == 1);
                continue;
            }
            if (javaType.isJNIEnv() || javaType.isPascalLen() || this.isArgumentThisPointer(i)) continue;
            if (bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(javaType.getName());
            stringBuilder.append(' ');
            stringBuilder.append(this.getArgumentName(i));
            bl = true;
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    public String getDescriptor(boolean bl, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        if (bl && this.hasContainingType()) {
            stringBuilder.append("Ljava/nio/ByteBuffer;");
        }
        for (int i = 0; i < this.getNumArguments(); ++i) {
            JavaType javaType = this.getJavaArgumentType(i);
            if (javaType.isVoid()) {
                if (this.getNumArguments() == 1) continue;
                throw new InternalError("\"void\" argument type found in multi-argument function \"" + this + "\"");
            }
            if (javaType.isJNIEnv() || this.isArgumentThisPointer(i)) continue;
            stringBuilder.append(this.erasedTypeDescriptor(javaType, bl2, false));
            if (bl) {
                if (javaType.isNIOBuffer()) {
                    stringBuilder.append('I');
                } else if (javaType.isNIOBufferArray()) {
                    stringBuilder.append("[I");
                }
            }
            if (!javaType.isPrimitiveArray()) continue;
            stringBuilder.append('I');
        }
        stringBuilder.append(')');
        stringBuilder.append(this.erasedTypeDescriptor(this.getJavaReturnType(), bl2, false));
        return stringBuilder.toString();
    }

    protected String erasedTypeDescriptor(JavaType javaType, boolean bl, boolean bl2) {
        if (bl) {
            if (javaType.isNIOBuffer() || javaType.isPrimitiveArray()) {
                if (!bl2) {
                    return "Ljava/lang/Object;";
                }
            } else {
                if (javaType.isCompoundTypeWrapper()) {
                    return "Ljava/nio/ByteBuffer;";
                }
                if (javaType.isArrayOfCompoundTypeWrappers()) {
                    return "Ljava/nio/ByteBuffer;";
                }
            }
        }
        return javaType.getDescriptor();
    }

    public static interface ParameterConsumer {
        public boolean accept(int var1, int var2, Type var3, JavaType var4, String var5);
    }
}

