/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen.cgram.types;

import java.util.HashSet;
import java.util.Set;

public interface AliasedSymbol {
    public void rename(String var1);

    public void addAliasedName(String var1);

    public boolean hasAliases();

    public Set<String> getAliasedNames();

    public String getOrigName();

    public String getName();

    public String getAliasedString();

    public static class NoneAliasedSymbol
    implements AliasedSymbol {
        private final String name;

        public NoneAliasedSymbol(String string) {
            this.name = string;
        }

        @Override
        public void rename(String string) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addAliasedName(String string) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasAliases() {
            return false;
        }

        @Override
        public Set<String> getAliasedNames() {
            return null;
        }

        @Override
        public String getOrigName() {
            return this.name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getAliasedString() {
            return this.toString();
        }
    }

    public static class AliasedSymbolImpl
    implements AliasedSymbol {
        private final String origName;
        private final HashSet<String> aliasedNames;
        private String name;

        public AliasedSymbolImpl(String string) {
            if (null == string) {
                throw new IllegalArgumentException("Null origName not allowed");
            }
            this.origName = string;
            this.aliasedNames = new HashSet();
            this.name = string;
        }

        public AliasedSymbolImpl(AliasedSymbolImpl aliasedSymbolImpl) {
            this.origName = aliasedSymbolImpl.origName;
            this.aliasedNames = new HashSet<String>(aliasedSymbolImpl.aliasedNames);
            this.name = aliasedSymbolImpl.name;
        }

        @Override
        public void rename(String string) {
            if (null != string && !this.name.equals(string)) {
                this.aliasedNames.add(this.name);
                this.aliasedNames.remove(string);
                this.name = string;
            }
        }

        @Override
        public void addAliasedName(String string) {
            if (null != string && !this.name.equals(string)) {
                this.aliasedNames.add(string);
            }
        }

        @Override
        public boolean hasAliases() {
            return this.aliasedNames.size() > 0;
        }

        @Override
        public Set<String> getAliasedNames() {
            return this.aliasedNames;
        }

        @Override
        public String getOrigName() {
            return this.origName;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getAliasedString() {
            return "[" + this.name + ", aliases " + this.aliasedNames.toString() + ", " + this.toString() + "]";
        }
    }
}

