/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen.cgram.types;

import com.jogamp.gluegen.ASTLocusTag;
import com.jogamp.gluegen.cgram.types.MemoryLayoutType;
import com.jogamp.gluegen.cgram.types.SizeThunk;
import com.jogamp.gluegen.cgram.types.Type;
import com.jogamp.gluegen.cgram.types.TypeVisitor;

public class ArrayType
extends MemoryLayoutType
implements Cloneable {
    private final Type elementType;
    private final int length;

    public ArrayType(Type type, SizeThunk sizeThunk, int n, int n2) {
        this(type, sizeThunk, n, n2, null);
    }

    public ArrayType(Type type, SizeThunk sizeThunk, int n, int n2, ASTLocusTag aSTLocusTag) {
        super(type.getName() + " *", sizeThunk, n2, aSTLocusTag);
        this.elementType = type;
        this.length = n;
    }

    private ArrayType(ArrayType arrayType, int n, ASTLocusTag aSTLocusTag) {
        super(arrayType, n, aSTLocusTag);
        this.elementType = arrayType.elementType;
        this.length = arrayType.length;
    }

    @Override
    Type newVariantImpl(boolean bl, int n, ASTLocusTag aSTLocusTag) {
        return new ArrayType(this, n, aSTLocusTag);
    }

    @Override
    protected int hashCodeImpl() {
        int n = this.elementType.hashCode();
        return (n << 5) - n + this.length;
    }

    @Override
    protected boolean equalsImpl(Type type) {
        ArrayType arrayType = (ArrayType)type;
        return this.elementType.equals(arrayType.elementType) && this.length == arrayType.length;
    }

    @Override
    protected int hashCodeSemanticsImpl() {
        int n = this.elementType.hashCodeSemantics();
        return (n << 5) - n + this.length;
    }

    @Override
    protected boolean equalSemanticsImpl(Type type) {
        ArrayType arrayType = (ArrayType)type;
        return this.elementType.equalSemantics(arrayType.elementType) && this.length == arrayType.length;
    }

    @Override
    public boolean isAnon() {
        return this.elementType.isAnon();
    }

    @Override
    public String getName(boolean bl) {
        return this.elementType.getName() + " *";
    }

    @Override
    public final ArrayType asArray() {
        return this;
    }

    @Override
    public final Type getTargetType() {
        return this.elementType;
    }

    public int getLength() {
        return this.length;
    }

    public boolean hasLength() {
        return this.length >= 0;
    }

    @Override
    public final Type getBaseType() {
        return this.elementType.getBaseType();
    }

    @Override
    public Type getArrayBaseOrPointerTargetType() {
        if (this.elementType.isPointer()) {
            return this.getTargetType();
        }
        return this.getBaseType();
    }

    @Override
    public final int arrayDimension() {
        return 1 + this.elementType.arrayDimension();
    }

    void recomputeSize() {
        ArrayType arrayType = this.getTargetType().asArray();
        if (arrayType != null) {
            arrayType.recomputeSize();
        }
        super.setSize(SizeThunk.mul(SizeThunk.constant(this.getLength()), this.elementType.getSize()));
    }

    @Override
    public String toString() {
        return this.toString(null);
    }

    public String toString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.elementType.isConst()) {
            stringBuilder.append("const ");
        }
        stringBuilder.append(this.elementType.getCName());
        if (string != null) {
            stringBuilder.append(" ");
            stringBuilder.append(string);
        }
        stringBuilder.append("[");
        stringBuilder.append(this.length);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public void visit(TypeVisitor typeVisitor) {
        super.visit(typeVisitor);
        this.elementType.visit(typeVisitor);
    }
}

